# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class FixtureVideosteamPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    locale: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, description="The locale of the video"
    )
    platform_provider: Optional[constr(strict=True, max_length=30)] = Field(
        "5STREAM", alias="platformProvider", description="Video Provider platform >- `5STREAM` 5Stream "
    )
    __properties = ["fixtureId", "locale", "platformProvider"]

    @validator("locale")
    def locale_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", v):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return v

    @validator("platform_provider")
    def platform_provider_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("5STREAM"):
            raise ValueError("must validate the enum values ('5STREAM')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureVideosteamPostBody:
        """Create an instance of FixtureVideosteamPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureVideosteamPostBody:
        """Create an instance of FixtureVideosteamPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixtureVideosteamPostBody.parse_obj(obj)

        _obj = FixtureVideosteamPostBody.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "locale": obj.get("locale"),
                "platform_provider": obj.get("platformProvider")
                if obj.get("platformProvider") is not None
                else "5STREAM",
            }
        )
        return _obj
