# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class FixtureRosterPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    position: Optional[constr(strict=True, max_length=100)] = Field(None, description="Playing position")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = ["fixtureId", "entityId", "personId", "bib", "position", "externalId"]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureRosterPostBody:
        """Create an instance of FixtureRosterPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if bib (nullable) is None
        if self.bib is None:
            _dict["bib"] = None

        # set to None if position (nullable) is None
        if self.position is None:
            _dict["position"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureRosterPostBody:
        """Create an instance of FixtureRosterPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixtureRosterPostBody.parse_obj(obj)

        _obj = FixtureRosterPostBody.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "entity_id": obj.get("entityId"),
                "person_id": obj.get("personId"),
                "bib": obj.get("bib"),
                "position": obj.get("position"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
