# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr, constr


class FixturePersonStatisticsPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    person_id: StrictStr = Field(..., alias="personId", description="The unique identifier of the person")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    statistics: Optional[Dict[str, Any]] = None
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    position: Optional[constr(strict=True, max_length=100)] = Field(None, description="Playing position")
    did_not_play_reason: Optional[constr(strict=True, max_length=100)] = Field(
        None, alias="didNotPlayReason", description="The reason the player didn't play"
    )
    starter: Optional[StrictBool] = None
    participated: Optional[StrictBool] = Field(
        None, description="Did the person actually participate in the the fixture"
    )
    is_player: Optional[StrictBool] = Field(None, alias="isPlayer", description="Is this person a player")
    is_team_official: Optional[StrictBool] = Field(
        None, alias="isTeamOfficial", description="Is this person an entity official"
    )
    __properties = [
        "personId",
        "entityId",
        "fixtureId",
        "statistics",
        "bib",
        "position",
        "didNotPlayReason",
        "starter",
        "participated",
        "isPlayer",
        "isTeamOfficial",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePersonStatisticsPostBody:
        """Create an instance of FixturePersonStatisticsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if entity_id (nullable) is None
        if self.entity_id is None:
            _dict["entityId"] = None

        # set to None if bib (nullable) is None
        if self.bib is None:
            _dict["bib"] = None

        # set to None if position (nullable) is None
        if self.position is None:
            _dict["position"] = None

        # set to None if did_not_play_reason (nullable) is None
        if self.did_not_play_reason is None:
            _dict["didNotPlayReason"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePersonStatisticsPostBody:
        """Create an instance of FixturePersonStatisticsPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixturePersonStatisticsPostBody.parse_obj(obj)

        _obj = FixturePersonStatisticsPostBody.parse_obj(
            {
                "person_id": obj.get("personId"),
                "entity_id": obj.get("entityId"),
                "fixture_id": obj.get("fixtureId"),
                "statistics": obj.get("statistics"),
                "bib": obj.get("bib"),
                "position": obj.get("position"),
                "did_not_play_reason": obj.get("didNotPlayReason"),
                "starter": obj.get("starter"),
                "participated": obj.get("participated"),
                "is_player": obj.get("isPlayer"),
                "is_team_official": obj.get("isTeamOfficial"),
            }
        )
        return _obj
