# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr

from atriumsports.datacore.openapi.models.fixture_pbp_model_organization import FixturePbpModelOrganization
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture


class FixturePbpModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixturePbpModelOrganization] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    events: Optional[Dict[str, Any]] = Field(None, description="Event details")
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    __properties = [
        "organizationId",
        "organization",
        "fixtureId",
        "fixture",
        "periodId",
        "section",
        "events",
        "updated",
        "added",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePbpModel:
        """Create an instance of FixturePbpModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # set to None if events (nullable) is None
        if self.events is None:
            _dict["events"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePbpModel:
        """Create an instance of FixturePbpModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixturePbpModel.parse_obj(obj)

        _obj = FixturePbpModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "organization": FixturePbpModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "events": obj.get("events"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
