# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_pbp_event_model_organization import FixturePbpEventModelOrganization
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture


class FixturePbpEventModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixturePbpEventModelOrganization] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    events: Optional[Any] = None
    var_class: Optional[constr(strict=True, max_length=100)] = Field(
        "sport",
        alias="class",
        description="The class of the event >- `sport` A sporting action that relates to the running of the fixture ",
    )
    event_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="eventType",
        description="See [Event Types](http://developer.atriumsports.com/datacore/streaming.html#section/Message-Types/event) for more information",
    )
    event_id: Optional[StrictStr] = Field(None, alias="eventId", description="Unique identifier of this event")
    play_id: Optional[StrictStr] = Field(
        None, alias="playId", description="Unique identifier of this play (group of events)"
    )
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    sub_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="subType",
        description="The Sub Type of event. See <b>Streaming API</b> documenation for more information.",
    )
    options: Optional[Dict[str, Any]] = Field(
        None, description="The options for the event. See <b>Streaming API</b> documenation for more information."
    )
    success: Optional[StrictBool] = Field(None, description="Whether the action was successful")
    x: Optional[StrictFloat] = Field(
        None, description="The x co-ordinate of the event. Represented as percentage from left (0) to right (100)."
    )
    y: Optional[StrictFloat] = Field(
        None, description="The y co-ordinate of the event. Represented as precentage from top (0) to bottom (100)."
    )
    z: Optional[StrictFloat] = Field(
        None, description="The z co-ordinate of the event. Represented as precentage from ground (0) to ceiling (100)."
    )
    clock: Optional[StrictStr] = Field(
        None, description="The time on the clock when the event occurred. ISO 8601 format. PTmmMss.ccS"
    )
    shot_clock: Optional[StrictStr] = Field(
        None,
        alias="shotClock",
        description="The time on the shot clock when the event occurred. ISO 8601 format. PTss.ccS",
    )
    event_time: Optional[datetime] = Field(
        None,
        alias="eventTime",
        description="The date/time (UTC) this event occurred. For inserted actions, this should be the time the action would have occurred, not the time of insertion.",
    )
    official_id: Optional[StrictStr] = Field(
        None, alias="officialId", description="The unique ID of the official making this decision"
    )
    zone: Optional[constr(strict=True, max_length=50)] = Field(
        None, description="See [Event Types]() for more information"
    )
    scores: Optional[Dict[str, constr(strict=True, max_length=50)]] = Field(None, description="The current scores")
    timestamp: Optional[datetime] = Field(None, description="The date/time (UTC) this event was sent.")
    __properties = [
        "organizationId",
        "organization",
        "fixtureId",
        "fixture",
        "periodId",
        "section",
        "events",
        "class",
        "eventType",
        "eventId",
        "playId",
        "entityId",
        "entity",
        "personId",
        "person",
        "subType",
        "options",
        "success",
        "x",
        "y",
        "z",
        "clock",
        "shotClock",
        "eventTime",
        "officialId",
        "zone",
        "scores",
        "timestamp",
    ]

    @validator("var_class")
    def var_class_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("sport"):
            raise ValueError("must validate the enum values ('sport')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePbpEventModel:
        """Create an instance of FixturePbpEventModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # set to None if events (nullable) is None
        if self.events is None:
            _dict["events"] = None

        # set to None if scores (nullable) is None
        if self.scores is None:
            _dict["scores"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePbpEventModel:
        """Create an instance of FixturePbpEventModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixturePbpEventModel.parse_obj(obj)

        _obj = FixturePbpEventModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "organization": FixturePbpEventModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "events": obj.get("events"),
                "var_class": obj.get("class") if obj.get("class") is not None else "sport",
                "event_type": obj.get("eventType"),
                "event_id": obj.get("eventId"),
                "play_id": obj.get("playId"),
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "sub_type": obj.get("subType"),
                "options": obj.get("options"),
                "success": obj.get("success"),
                "x": obj.get("x"),
                "y": obj.get("y"),
                "z": obj.get("z"),
                "clock": obj.get("clock"),
                "shot_clock": obj.get("shotClock"),
                "event_time": obj.get("eventTime"),
                "official_id": obj.get("officialId"),
                "zone": obj.get("zone"),
                "scores": obj.get("scores"),
                "timestamp": obj.get("timestamp"),
            }
        )
        return _obj
