# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, validator


class ErrorListModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    code: Optional[StrictInt] = Field(None, description="HTTP Error code indicating the type of error.")
    reason: Optional[StrictStr] = Field(None, description="A short code indicating the type of error")
    message: Optional[StrictStr] = Field(None, description="A message indicating the reason for the error")
    row_number: Optional[StrictInt] = Field(
        None, alias="rowNumber", description="The row number of the payload that cause the error"
    )
    __properties = ["code", "reason", "message", "rowNumber"]

    @validator("reason")
    def reason_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("INVALID_DATA", "NOT_FOUND", "NOT_AUTHORISED", "ERROR", "DELETE_ERROR"):
            raise ValueError(
                "must validate the enum values ('INVALID_DATA', 'NOT_FOUND', 'NOT_AUTHORISED', 'ERROR', 'DELETE_ERROR')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorListModel:
        """Create an instance of ErrorListModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorListModel:
        """Create an instance of ErrorListModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ErrorListModel.parse_obj(obj)

        _obj = ErrorListModel.parse_obj(
            {
                "code": obj.get("code"),
                "reason": obj.get("reason"),
                "message": obj.get("message"),
                "row_number": obj.get("rowNumber"),
            }
        )
        return _obj
