# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.contact_details import ContactDetails
from atriumsports.datacore.openapi.models.entity_additional_details import EntityAdditionalDetails
from atriumsports.datacore.openapi.models.entity_address import EntityAddress
from atriumsports.datacore.openapi.models.entity_historical_name import EntityHistoricalName
from atriumsports.datacore.openapi.models.entity_post_body_additional_names import EntityPostBodyAdditionalNames
from atriumsports.datacore.openapi.models.entity_post_body_colors import EntityPostBodyColors
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class EntityPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this entity given by the sport governing body",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    name_full_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameFullLocal",
        description="The full name of the entity in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    additional_names: Optional[EntityPostBodyAdditionalNames] = Field(None, alias="additionalNames")
    name_full_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameFullLatin",
        description="The full name of the entity in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    code_local: Optional[constr(strict=True, max_length=5)] = Field(
        None,
        alias="codeLocal",
        description="The code of the entity in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    code_latin: Optional[constr(strict=True, max_length=5)] = Field(
        None,
        alias="codeLatin",
        description="The code of the entity in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    address: Optional[EntityAddress] = None
    social: Optional[SocialMedia] = None
    contacts: Optional[ContactDetails] = None
    details: Optional[EntityAdditionalDetails] = None
    colors: Optional[EntityPostBodyColors] = None
    historical_names: Optional[List[EntityHistoricalName]] = Field(
        None, alias="historicalNames", description="Array of entity historical names"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    age_group: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="ageGroup",
        description="The age group of the entity >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_10` Under 10 >- `UNDER_11` Under 11 >- `UNDER_12` Under 12 >- `UNDER_13` Under 13 >- `UNDER_14` Under 14 >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth ",
    )
    gender: Optional[constr(strict=True, max_length=20)] = Field(
        None,
        description="The gender of the participants in the entity >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown ",
    )
    standard: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        description="The playing standard of the entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship ",
    )
    grade: Optional[constr(strict=True, max_length=50)] = Field(
        None, description="The playing grade of the fixtures for this entity"
    )
    default_venue_id: Optional[StrictStr] = Field(
        None, alias="defaultVenueId", description="The unique identifier of the default venue"
    )
    __properties = [
        "entityGroupId",
        "internationalReference",
        "status",
        "nameFullLocal",
        "additionalNames",
        "nameFullLatin",
        "codeLocal",
        "codeLatin",
        "address",
        "social",
        "contacts",
        "details",
        "colors",
        "historicalNames",
        "externalId",
        "ageGroup",
        "gender",
        "standard",
        "grade",
        "defaultVenueId",
    ]

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must validate the enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    @validator("age_group")
    def age_group_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "JUNIOR",
            "YOUTH",
            "UNDER_10",
            "UNDER_11",
            "UNDER_12",
            "UNDER_13",
            "UNDER_14",
            "UNDER_15",
            "UNDER_16",
            "UNDER_17",
            "UNDER_18",
            "UNDER_19",
            "UNDER_20",
            "UNDER_21",
            "UNDER_22",
            "UNDER_23",
            "SENIOR",
            "MASTERS",
        ):
            raise ValueError(
                "must validate the enum values ('JUNIOR', 'YOUTH', 'UNDER_10', 'UNDER_11', 'UNDER_12', 'UNDER_13', 'UNDER_14', 'UNDER_15', 'UNDER_16', 'UNDER_17', 'UNDER_18', 'UNDER_19', 'UNDER_20', 'UNDER_21', 'UNDER_22', 'UNDER_23', 'SENIOR', 'MASTERS')"
            )
        return v

    @validator("gender")
    def gender_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("FEMALE", "MALE", "MIXED", "UNKNOWN"):
            raise ValueError("must validate the enum values ('FEMALE', 'MALE', 'MIXED', 'UNKNOWN')")
        return v

    @validator("standard")
    def standard_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "ELITE",
            "FRIENDLY",
            "GRASS_ROOT",
            "INTERNATIONAL",
            "NONCONTINENTAL_CHAMPIONSHIP",
            "OLYMPIC",
            "REGION",
            "TIER2",
            "TIER3",
            "WORLD_CHAMPIONSHIP",
            "ZONE_CHAMPIONSHIP",
        ):
            raise ValueError(
                "must validate the enum values ('ELITE', 'FRIENDLY', 'GRASS_ROOT', 'INTERNATIONAL', 'NONCONTINENTAL_CHAMPIONSHIP', 'OLYMPIC', 'REGION', 'TIER2', 'TIER3', 'WORLD_CHAMPIONSHIP', 'ZONE_CHAMPIONSHIP')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityPutBody:
        """Create an instance of EntityPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of additional_names
        if self.additional_names:
            _dict["additionalNames"] = self.additional_names.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contacts
        if self.contacts:
            _dict["contacts"] = self.contacts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of details
        if self.details:
            _dict["details"] = self.details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of colors
        if self.colors:
            _dict["colors"] = self.colors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # set to None if entity_group_id (nullable) is None
        if self.entity_group_id is None:
            _dict["entityGroupId"] = None

        # set to None if international_reference (nullable) is None
        if self.international_reference is None:
            _dict["internationalReference"] = None

        # set to None if name_full_latin (nullable) is None
        if self.name_full_latin is None:
            _dict["nameFullLatin"] = None

        # set to None if code_local (nullable) is None
        if self.code_local is None:
            _dict["codeLocal"] = None

        # set to None if code_latin (nullable) is None
        if self.code_latin is None:
            _dict["codeLatin"] = None

        # set to None if address (nullable) is None
        if self.address is None:
            _dict["address"] = None

        # set to None if social (nullable) is None
        if self.social is None:
            _dict["social"] = None

        # set to None if contacts (nullable) is None
        if self.contacts is None:
            _dict["contacts"] = None

        # set to None if details (nullable) is None
        if self.details is None:
            _dict["details"] = None

        # set to None if historical_names (nullable) is None
        if self.historical_names is None:
            _dict["historicalNames"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        # set to None if grade (nullable) is None
        if self.grade is None:
            _dict["grade"] = None

        # set to None if default_venue_id (nullable) is None
        if self.default_venue_id is None:
            _dict["defaultVenueId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityPutBody:
        """Create an instance of EntityPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityPutBody.parse_obj(obj)

        _obj = EntityPutBody.parse_obj(
            {
                "entity_group_id": obj.get("entityGroupId"),
                "international_reference": obj.get("internationalReference"),
                "status": obj.get("status"),
                "name_full_local": obj.get("nameFullLocal"),
                "additional_names": EntityPostBodyAdditionalNames.from_dict(obj.get("additionalNames"))
                if obj.get("additionalNames") is not None
                else None,
                "name_full_latin": obj.get("nameFullLatin"),
                "code_local": obj.get("codeLocal"),
                "code_latin": obj.get("codeLatin"),
                "address": EntityAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "contacts": ContactDetails.from_dict(obj.get("contacts")) if obj.get("contacts") is not None else None,
                "details": EntityAdditionalDetails.from_dict(obj.get("details"))
                if obj.get("details") is not None
                else None,
                "colors": EntityPostBodyColors.from_dict(obj.get("colors")) if obj.get("colors") is not None else None,
                "historical_names": [EntityHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "external_id": obj.get("externalId"),
                "age_group": obj.get("ageGroup"),
                "gender": obj.get("gender"),
                "standard": obj.get("standard"),
                "grade": obj.get("grade"),
                "default_venue_id": obj.get("defaultVenueId"),
            }
        )
        return _obj
