# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.conduct_penalty_result import ConductPenaltyResult


class ConductPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    location_other: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="locationOther", description="The location where the incident occurred"
    )
    event_id: Optional[StrictStr] = Field(
        None, alias="eventId", description="The ~event~ that this conduct is linked to"
    )
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    fixture_clock: Optional[constr(strict=True, max_length=20)] = Field(
        None, alias="fixtureClock", description="Fixture clock when the incident occurred"
    )
    role: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        description="The role of person >- `CAPTAIN` Captain >- `CAPTAIN_VICE` Vice Captain >- `CEO` CEO >- `COACH` Coach >- `COACH_ASSISTANT` Assistant Coach >- `COACH_ASSISTANT_HEAD` Assistant Head Coach >- `COACH_ASSOCIATE_HEAD` Associate Head Coach >- `COACH_DEVELOPMENT` Development Coach >- `COACH_HEAD` Head Coach >- `COACH_HEAD_INTERIM` Interim Head Coach >- `COACH_OTHER` Other coaching staff >- `COACH_SC` Strengh and Conditioning Coach >- `COACH_SENIOR` Senior Coach >- `COACH_SPECIALIST` Specialist Coach >- `COMMISSIONER` Commissioner >- `COMMITTEE` Committee >- `CREW_CHIEF` Crew Chief >- `DIRECTOR` Director >- `DOCTOR` Doctor >- `GENERAL` General >- `GROUNDSKEEPER` Groundskeeper >- `JUDGE_SCORING` Scoring Judge (SJ) >- `JUDGE_TIMING` Timing Judge (TJ) >- `MANAGER` Manager >- `MATCH_OFFICIAL` Match Official >- `MEDIA_OFFICER` Media Officer >- `MEDICAL_STAFF` Medical Staff >- `OTHER` Other >- `PHYSIOTHERAPIST` Physiotherapist >- `PRESIDENT` President >- `PRESIDENT_VICE` Vice President >- `REFEREE` Referee >- `REFEREE_ASSISTANT` Referee Assistant >- `REFEREE_ASSISTANT_RESERVE` Reserve Assistant Referee >- `REFEREE_RESERVE` Reserve Referee >- `SCOREKEEPER` Scorekeeper >- `SCOREKEEPER_ASSISTANT` Assistant Scorekeeper >- `SECRETARY` Secretary >- `STATISTICIAN` Statistician >- `TECHNICAL_OFFICIAL` Technical Official (TO) >- `TIMEKEEPER` Timekeeper >- `TRAINER` Trainer >- `TRAINER_ASSISTANT` Assitant Trainer >- `TRANSLATOR` Translator >- `TREASURER` Treasurer >- `UMPIRE` Umpire >- `UMPIRE_RESERVE` Reserve Umpire (RU) >- `UMPIRE_VIDEO` Video Umpire (VU) >- `VIDEO_TECHNICIAN` Video Technician (VT) ",
    )
    date_offence_local: Optional[datetime] = Field(
        None, alias="dateOffenceLocal", description="Date & Time of the Offence in the local timezone"
    )
    conduct_type: Optional[conlist(StrictStr, min_items=1)] = Field(None, alias="conductType")
    conduct_notes: Optional[constr(strict=True, max_length=2000)] = Field(
        None, alias="conductNotes", description="Notes of the Conduct incident"
    )
    date_hearing_local: Optional[date] = Field(None, alias="dateHearingLocal", description="Date hearing")
    hearing_notes: Optional[constr(strict=True, max_length=500)] = Field(
        None, alias="hearingNotes", description="Notes from the conduct hearing"
    )
    hearing_status: Optional[StrictStr] = Field(
        None, alias="hearingStatus", description="Conduct hearing status >- `FINALIZED` Finalized >- `PENDING` Pending "
    )
    life_sentence: Optional[StrictBool] = Field(
        None, alias="lifeSentence", description="Was the result of the conduct hearing a life sentence?"
    )
    penalty_results: Optional[List[ConductPenaltyResult]] = Field(None, alias="penaltyResults")
    fine_amount: Optional[StrictFloat] = Field(None, alias="fineAmount", description="Conduct fine amount")
    fine_currency: Optional[constr(strict=True, max_length=20)] = Field(
        None, alias="fineCurrency", description="Fine currency"
    )
    fine_status: Optional[StrictStr] = Field(
        None,
        alias="fineStatus",
        description="Conduct fine due status >- `CANCELLED` Cancelled >- `ISSUED` Issued >- `OTHER` Other >- `PAID` Paid >- `UNPAID` Unpaid ",
    )
    date_suspended_to: Optional[date] = Field(None, alias="dateSuspendedTo", description="Date the suspension ended")
    date_suspended_from: Optional[date] = Field(
        None, alias="dateSuspendedFrom", description="Date the suspension started"
    )
    date_fine_paid_local: Optional[date] = Field(None, alias="dateFinePaidLocal", description="Date the fine was paid")
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        description="Conduct status >- `ACTIVE` Active >- `CLOSED` Closed >- `COMPLETE` Complete >- `INACTIVE` Inactive >- `PENDING` Pending ",
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "personId",
        "entityGroupId",
        "entityId",
        "venueId",
        "fixtureId",
        "seasonId",
        "competitionId",
        "bib",
        "locationOther",
        "eventId",
        "periodId",
        "section",
        "fixtureClock",
        "role",
        "dateOffenceLocal",
        "conductType",
        "conductNotes",
        "dateHearingLocal",
        "hearingNotes",
        "hearingStatus",
        "lifeSentence",
        "penaltyResults",
        "fineAmount",
        "fineCurrency",
        "fineStatus",
        "dateSuspendedTo",
        "dateSuspendedFrom",
        "dateFinePaidLocal",
        "status",
        "externalId",
    ]

    @validator("role")
    def role_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "COACH",
            "COACH_HEAD",
            "COACH_HEAD_INTERIM",
            "COACH_ASSISTANT",
            "COACH_ASSISTANT_HEAD",
            "COACH_ASSOCIATE_HEAD",
            "COACH_SC",
            "COACH_SENIOR",
            "COACH_DEVELOPMENT",
            "COACH_SPECIALIST",
            "COACH_OTHER",
            "CAPTAIN",
            "CAPTAIN_VICE",
            "DOCTOR",
            "PHYSIOTHERAPIST",
            "MEDICAL_STAFF",
            "TRAINER",
            "TRAINER_ASSISTANT",
            "MATCH_OFFICIAL",
            "COMMISSIONER",
            "STATISTICIAN",
            "SCOREKEEPER",
            "SCOREKEEPER_ASSISTANT",
            "TIMEKEEPER",
            "GROUNDSKEEPER",
            "CEO",
            "COMMITTEE",
            "PRESIDENT",
            "DIRECTOR",
            "PRESIDENT_VICE",
            "SECRETARY",
            "TREASURER",
            "MANAGER",
            "GENERAL",
            "OTHER",
            "REFEREE",
            "UMPIRE",
            "REFEREE_ASSISTANT",
            "REFEREE_RESERVE",
            "REFEREE_ASSISTANT_RESERVE",
            "CREW_CHIEF",
            "UMPIRE_RESERVE",
            "UMPIRE_VIDEO",
            "JUDGE_SCORING",
            "JUDGE_TIMING",
            "TECHNICAL_OFFICIAL",
            "VIDEO_TECHNICIAN",
            "TRANSLATOR",
            "MEDIA_OFFICER",
        ):
            raise ValueError(
                "must validate the enum values ('COACH', 'COACH_HEAD', 'COACH_HEAD_INTERIM', 'COACH_ASSISTANT', 'COACH_ASSISTANT_HEAD', 'COACH_ASSOCIATE_HEAD', 'COACH_SC', 'COACH_SENIOR', 'COACH_DEVELOPMENT', 'COACH_SPECIALIST', 'COACH_OTHER', 'CAPTAIN', 'CAPTAIN_VICE', 'DOCTOR', 'PHYSIOTHERAPIST', 'MEDICAL_STAFF', 'TRAINER', 'TRAINER_ASSISTANT', 'MATCH_OFFICIAL', 'COMMISSIONER', 'STATISTICIAN', 'SCOREKEEPER', 'SCOREKEEPER_ASSISTANT', 'TIMEKEEPER', 'GROUNDSKEEPER', 'CEO', 'COMMITTEE', 'PRESIDENT', 'DIRECTOR', 'PRESIDENT_VICE', 'SECRETARY', 'TREASURER', 'MANAGER', 'GENERAL', 'OTHER', 'REFEREE', 'UMPIRE', 'REFEREE_ASSISTANT', 'REFEREE_RESERVE', 'REFEREE_ASSISTANT_RESERVE', 'CREW_CHIEF', 'UMPIRE_RESERVE', 'UMPIRE_VIDEO', 'JUDGE_SCORING', 'JUDGE_TIMING', 'TECHNICAL_OFFICIAL', 'VIDEO_TECHNICIAN', 'TRANSLATOR', 'MEDIA_OFFICER')"
            )
        return v

    @validator("conduct_type")
    def conduct_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "SWEARING",
            "CORRUPTION",
            "VIOLENT_CONDUCT",
            "MATCH_FIXING",
            "CITATION",
            "UNSPORTSMANLIKE_CONDUCT",
            "DOPING",
            "CONCUSSION",
        ):
            raise ValueError(
                "must validate the enum values ('SWEARING', 'CORRUPTION', 'VIOLENT_CONDUCT', 'MATCH_FIXING', 'CITATION', 'UNSPORTSMANLIKE_CONDUCT', 'DOPING', 'CONCUSSION')"
            )
        return v

    @validator("hearing_status")
    def hearing_status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("PENDING", "FINALIZED"):
            raise ValueError("must validate the enum values ('PENDING', 'FINALIZED')")
        return v

    @validator("fine_status")
    def fine_status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ISSUED", "PAID", "UNPAID", "CANCELLED", "OTHER"):
            raise ValueError("must validate the enum values ('ISSUED', 'PAID', 'UNPAID', 'CANCELLED', 'OTHER')")
        return v

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ACTIVE", "INACTIVE", "PENDING", "COMPLETE", "CLOSED"):
            raise ValueError("must validate the enum values ('ACTIVE', 'INACTIVE', 'PENDING', 'COMPLETE', 'CLOSED')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConductPutBody:
        """Create an instance of ConductPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in penalty_results (list)
        _items = []
        if self.penalty_results:
            for _item in self.penalty_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict["penaltyResults"] = _items
        # set to None if bib (nullable) is None
        if self.bib is None:
            _dict["bib"] = None

        # set to None if location_other (nullable) is None
        if self.location_other is None:
            _dict["locationOther"] = None

        # set to None if fixture_clock (nullable) is None
        if self.fixture_clock is None:
            _dict["fixtureClock"] = None

        # set to None if role (nullable) is None
        if self.role is None:
            _dict["role"] = None

        # set to None if date_offence_local (nullable) is None
        if self.date_offence_local is None:
            _dict["dateOffenceLocal"] = None

        # set to None if conduct_notes (nullable) is None
        if self.conduct_notes is None:
            _dict["conductNotes"] = None

        # set to None if date_hearing_local (nullable) is None
        if self.date_hearing_local is None:
            _dict["dateHearingLocal"] = None

        # set to None if hearing_notes (nullable) is None
        if self.hearing_notes is None:
            _dict["hearingNotes"] = None

        # set to None if fine_currency (nullable) is None
        if self.fine_currency is None:
            _dict["fineCurrency"] = None

        # set to None if fine_status (nullable) is None
        if self.fine_status is None:
            _dict["fineStatus"] = None

        # set to None if date_suspended_to (nullable) is None
        if self.date_suspended_to is None:
            _dict["dateSuspendedTo"] = None

        # set to None if date_suspended_from (nullable) is None
        if self.date_suspended_from is None:
            _dict["dateSuspendedFrom"] = None

        # set to None if date_fine_paid_local (nullable) is None
        if self.date_fine_paid_local is None:
            _dict["dateFinePaidLocal"] = None

        # set to None if status (nullable) is None
        if self.status is None:
            _dict["status"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConductPutBody:
        """Create an instance of ConductPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ConductPutBody.parse_obj(obj)

        _obj = ConductPutBody.parse_obj(
            {
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "entity_id": obj.get("entityId"),
                "venue_id": obj.get("venueId"),
                "fixture_id": obj.get("fixtureId"),
                "season_id": obj.get("seasonId"),
                "competition_id": obj.get("competitionId"),
                "bib": obj.get("bib"),
                "location_other": obj.get("locationOther"),
                "event_id": obj.get("eventId"),
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "fixture_clock": obj.get("fixtureClock"),
                "role": obj.get("role"),
                "date_offence_local": obj.get("dateOffenceLocal"),
                "conduct_type": obj.get("conductType"),
                "conduct_notes": obj.get("conductNotes"),
                "date_hearing_local": obj.get("dateHearingLocal"),
                "hearing_notes": obj.get("hearingNotes"),
                "hearing_status": obj.get("hearingStatus"),
                "life_sentence": obj.get("lifeSentence"),
                "penalty_results": [ConductPenaltyResult.from_dict(_item) for _item in obj.get("penaltyResults")]
                if obj.get("penaltyResults") is not None
                else None,
                "fine_amount": obj.get("fineAmount"),
                "fine_currency": obj.get("fineCurrency"),
                "fine_status": obj.get("fineStatus"),
                "date_suspended_to": obj.get("dateSuspendedTo"),
                "date_suspended_from": obj.get("dateSuspendedFrom"),
                "date_fine_paid_local": obj.get("dateFinePaidLocal"),
                "status": obj.get("status"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
