# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, List, Optional

from pydantic import BaseModel

from atriumsports.datacore.openapi.models.included_data import IncludedData
from atriumsports.datacore.openapi.models.response_links import ResponseLinks
from atriumsports.datacore.openapi.models.response_meta_data import ResponseMetaData


class BlankModelResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    meta: Optional[ResponseMetaData] = None
    links: Optional[ResponseLinks] = None
    included: Optional[IncludedData] = None
    data: Optional[List[Dict[str, Any]]] = None
    __properties = ["meta", "links", "included", "data"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BlankModelResponse:
        """Create an instance of BlankModelResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict["meta"] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict["links"] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of included
        if self.included:
            _dict["included"] = self.included.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlankModelResponse:
        """Create an instance of BlankModelResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BlankModelResponse.parse_obj(obj)

        _obj = BlankModelResponse.parse_obj(
            {
                "meta": ResponseMetaData.from_dict(obj.get("meta")) if obj.get("meta") is not None else None,
                "links": ResponseLinks.from_dict(obj.get("links")) if obj.get("links") is not None else None,
                "included": IncludedData.from_dict(obj.get("included")) if obj.get("included") is not None else None,
                "data": obj.get("data"),
            }
        )
        return _obj
