# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.video_stream_inputs_response import VideoStreamInputsResponse

logger = logging.getLogger("openapi")


class VideoStreamInputsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def video_stream_inputs_fixture_list(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_input_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the video input record")
        ] = None,
        **kwargs
    ) -> VideoStreamInputsResponse:  # noqa: E501
        """List available video inputs for a fixture  # noqa: E501

        Display the list of video inputs for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_fixture_list(fixture_id, organization_id, sport, added, external, feed_type, fields, hide_null, include, limit, locale, offset, provider, source_number, tbf, updated, video_input_id, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_input_id: The unique identifier of the video input record
        :type video_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoStreamInputsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.video_stream_inputs_fixture_list_with_http_info(
                fixture_id,
                organization_id,
                sport,
                added,
                external,
                feed_type,
                fields,
                hide_null,
                include,
                limit,
                locale,
                offset,
                provider,
                source_number,
                tbf,
                updated,
                video_input_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling VideoStreamInputsApi->video_stream_inputs_fixture_list: %s\n" % e)
            raise

    @validate_arguments
    def video_stream_inputs_fixture_list_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        video_input_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the video input record")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List available video inputs for a fixture  # noqa: E501

        Display the list of video inputs for a fixture  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_fixture_list_with_http_info(fixture_id, organization_id, sport, added, external, feed_type, fields, hide_null, include, limit, locale, offset, provider, source_number, tbf, updated, video_input_id, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param video_input_id: The unique identifier of the video input record
        :type video_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoStreamInputsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "organization_id",
            "sport",
            "added",
            "external",
            "feed_type",
            "fields",
            "hide_null",
            "include",
            "limit",
            "locale",
            "offset",
            "provider",
            "source_number",
            "tbf",
            "updated",
            "video_input_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method video_stream_inputs_fixture_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("feed_type") is not None:  # noqa: E501
            _query_params.append(("feedType", _params["feed_type"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("locale") is not None:  # noqa: E501
            _query_params.append(("locale", _params["locale"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("provider") is not None:  # noqa: E501
            _query_params.append(("provider", _params["provider"]))
        if _params.get("source_number") is not None:  # noqa: E501
            _query_params.append(("sourceNumber", _params["source_number"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))
        if _params.get("video_input_id") is not None:  # noqa: E501
            _query_params.append(("videoInputId", _params["video_input_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoStreamInputsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/video/streams/inputs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def video_stream_inputs_list(
        self,
        master_venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the master venue")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ) -> VideoStreamInputsResponse:  # noqa: E501
        """List available video inputs for a master venue  # noqa: E501

        Display the list of video stream inputs for a master venue. This will only display inputs for fixtures in the future and from 12 hours in the past that have not been completed/cancelled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_list(master_venue_id, sport, added, competition_id, external, feed_type, fields, fixture_id, from_time_local, from_time_utc, hide_null, include, limit, locale, offset, provider, season_id, source_number, tbf, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param master_venue_id: The unique identifier of the master venue (required)
        :type master_venue_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoStreamInputsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.video_stream_inputs_list_with_http_info(
                master_venue_id,
                sport,
                added,
                competition_id,
                external,
                feed_type,
                fields,
                fixture_id,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                locale,
                offset,
                provider,
                season_id,
                source_number,
                tbf,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling VideoStreamInputsApi->video_stream_inputs_list: %s\n" % e)
            raise

    @validate_arguments
    def video_stream_inputs_list_with_http_info(
        self,
        master_venue_id: Annotated[StrictStr, Field(..., description="The unique identifier of the master venue")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        **kwargs
    ):  # noqa: E501
        """List available video inputs for a master venue  # noqa: E501

        Display the list of video stream inputs for a master venue. This will only display inputs for fixtures in the future and from 12 hours in the past that have not been completed/cancelled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_list_with_http_info(master_venue_id, sport, added, competition_id, external, feed_type, fields, fixture_id, from_time_local, from_time_utc, hide_null, include, limit, locale, offset, provider, season_id, source_number, tbf, to_time_local, to_time_utc, updated, venue_id, async_req=True)
        >>> result = thread.get()

        :param master_venue_id: The unique identifier of the master venue (required)
        :type master_venue_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoStreamInputsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "master_venue_id",
            "sport",
            "added",
            "competition_id",
            "external",
            "feed_type",
            "fields",
            "fixture_id",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "locale",
            "offset",
            "provider",
            "season_id",
            "source_number",
            "tbf",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method video_stream_inputs_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["master_venue_id"]:
            _path_params["masterVenueId"] = _params["master_venue_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("competition_id") is not None:  # noqa: E501
            _query_params.append(("competitionId", _params["competition_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("feed_type") is not None:  # noqa: E501
            _query_params.append(("feedType", _params["feed_type"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_id") is not None:  # noqa: E501
            _query_params.append(("fixtureId", _params["fixture_id"]))
        if _params.get("from_time_local") is not None:  # noqa: E501
            _query_params.append(("fromTimeLocal", _params["from_time_local"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("locale") is not None:  # noqa: E501
            _query_params.append(("locale", _params["locale"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("provider") is not None:  # noqa: E501
            _query_params.append(("provider", _params["provider"]))
        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))
        if _params.get("source_number") is not None:  # noqa: E501
            _query_params.append(("sourceNumber", _params["source_number"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_local") is not None:  # noqa: E501
            _query_params.append(("toTimeLocal", _params["to_time_local"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))
        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoStreamInputsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/masterVenues/{masterVenueId}/video/streams/inputs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def video_stream_inputs_org_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        video_input_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the video input record")
        ] = None,
        **kwargs
    ) -> VideoStreamInputsResponse:  # noqa: E501
        """List available video inputs for an organization  # noqa: E501

        Display the list of video inputs for an organization. This will only display inputs for fixtures in the future and from 12 hours in the past that have not been completed/cancelled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_org_list(organization_id, sport, added, competition_id, external, feed_type, fields, fixture_id, from_time_local, from_time_utc, hide_null, include, limit, locale, offset, provider, season_id, source_number, tbf, to_time_local, to_time_utc, updated, venue_id, video_input_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param video_input_id: The unique identifier of the video input record
        :type video_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoStreamInputsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.video_stream_inputs_org_list_with_http_info(
                organization_id,
                sport,
                added,
                competition_id,
                external,
                feed_type,
                fields,
                fixture_id,
                from_time_local,
                from_time_utc,
                hide_null,
                include,
                limit,
                locale,
                offset,
                provider,
                season_id,
                source_number,
                tbf,
                to_time_local,
                to_time_utc,
                updated,
                venue_id,
                video_input_id,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling VideoStreamInputsApi->video_stream_inputs_org_list: %s\n" % e)
            raise

    @validate_arguments
    def video_stream_inputs_org_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        feed_type: Annotated[
            Optional[constr(strict=True, max_length=30)],
            Field(
                description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary "
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the fixture")] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        locale: Annotated[
            Optional[constr(strict=True, max_length=5, min_length=5)], Field(description="The locale of the video")
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        provider: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The unique code for the video provider")
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        source_number: Annotated[
            Optional[StrictInt], Field(description="Unique identifier for the video source")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        venue_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the venue")] = None,
        video_input_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the video input record")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List available video inputs for an organization  # noqa: E501

        Display the list of video inputs for an organization. This will only display inputs for fixtures in the future and from 12 hours in the past that have not been completed/cancelled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_stream_inputs_org_list_with_http_info(organization_id, sport, added, competition_id, external, feed_type, fields, fixture_id, from_time_local, from_time_utc, hide_null, include, limit, locale, offset, provider, season_id, source_number, tbf, to_time_local, to_time_utc, updated, venue_id, video_input_id, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param feed_type: Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary
        :type feed_type: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_id: The unique identifier of the fixture
        :type fixture_id: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param locale: The locale of the video
        :type locale: str
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param provider: The unique code for the video provider
        :type provider: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param source_number: Unique identifier for the video source
        :type source_number: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param venue_id: The unique identifier of the venue
        :type venue_id: str
        :param video_input_id: The unique identifier of the video input record
        :type video_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoStreamInputsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "added",
            "competition_id",
            "external",
            "feed_type",
            "fields",
            "fixture_id",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "include",
            "limit",
            "locale",
            "offset",
            "provider",
            "season_id",
            "source_number",
            "tbf",
            "to_time_local",
            "to_time_utc",
            "updated",
            "venue_id",
            "video_input_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method video_stream_inputs_org_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("competition_id") is not None:  # noqa: E501
            _query_params.append(("competitionId", _params["competition_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("feed_type") is not None:  # noqa: E501
            _query_params.append(("feedType", _params["feed_type"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_id") is not None:  # noqa: E501
            _query_params.append(("fixtureId", _params["fixture_id"]))
        if _params.get("from_time_local") is not None:  # noqa: E501
            _query_params.append(("fromTimeLocal", _params["from_time_local"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("locale") is not None:  # noqa: E501
            _query_params.append(("locale", _params["locale"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("provider") is not None:  # noqa: E501
            _query_params.append(("provider", _params["provider"]))
        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))
        if _params.get("source_number") is not None:  # noqa: E501
            _query_params.append(("sourceNumber", _params["source_number"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_local") is not None:  # noqa: E501
            _query_params.append(("toTimeLocal", _params["to_time_local"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))
        if _params.get("venue_id") is not None:  # noqa: E501
            _query_params.append(("venueId", _params["venue_id"]))
        if _params.get("video_input_id") is not None:  # noqa: E501
            _query_params.append(("videoInputId", _params["video_input_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "VideoStreamInputsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/video/streams/inputs",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
