# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.pool_post_body import PoolPostBody
from atriumsports.datacore.openapi.models.pool_put_body import PoolPutBody
from atriumsports.datacore.openapi.models.round_post_body import RoundPostBody
from atriumsports.datacore.openapi.models.round_put_body import RoundPutBody
from atriumsports.datacore.openapi.models.season_pools_response import SeasonPoolsResponse
from atriumsports.datacore.openapi.models.season_rounds_response import SeasonRoundsResponse
from atriumsports.datacore.openapi.models.season_stage_post_body import SeasonStagePostBody
from atriumsports.datacore.openapi.models.season_stage_put_body import SeasonStagePutBody
from atriumsports.datacore.openapi.models.season_stages_response import SeasonStagesResponse

logger = logging.getLogger("openapi")


class StagesPoolsRoundsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def season_pool_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPoolsResponse:  # noqa: E501
        """Get a pool  # noqa: E501

        Return detailed information about a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_detail(organization_id, pool_code, season_id, sport, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPoolsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_pool_detail_with_http_info(
                organization_id,
                pool_code,
                season_id,
                sport,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_pool_detail: %s\n" % e)
            raise

    @validate_arguments
    def season_pool_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Get a pool  # noqa: E501

        Return detailed information about a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_detail_with_http_info(organization_id, pool_code, season_id, sport, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPoolsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "pool_code",
            "season_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_pool_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["pool_code"]:
            _path_params["poolCode"] = _params["pool_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPoolsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/pools/{poolCode}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_pool_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        pool_post_body: PoolPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPoolsResponse:  # noqa: E501
        """Create a pool  # noqa: E501

        Add a new pool into a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_insert(organization_id, season_id, sport, pool_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param pool_post_body: (required)
        :type pool_post_body: PoolPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPoolsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_pool_insert_with_http_info(
                organization_id, season_id, sport, pool_post_body, external, fields, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_pool_insert: %s\n" % e)
            raise

    @validate_arguments
    def season_pool_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        pool_post_body: PoolPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Create a pool  # noqa: E501

        Add a new pool into a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_insert_with_http_info(organization_id, season_id, sport, pool_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param pool_post_body: (required)
        :type pool_post_body: PoolPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPoolsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "pool_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_pool_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["pool_post_body"]:
            _body_params = _params["pool_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPoolsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/pools",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_pool_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> SeasonPoolsResponse:  # noqa: E501
        """Get a list of pools  # noqa: E501

        Return a list of the pools for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_list(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, stage_code, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPoolsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_pool_list_with_http_info(
                organization_id,
                season_id,
                sport,
                added,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                stage_code,
                tbf,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_pool_list: %s\n" % e)
            raise

    @validate_arguments
    def season_pool_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get a list of pools  # noqa: E501

        Return a list of the pools for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_list_with_http_info(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, stage_code, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPoolsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "stage_code",
            "tbf",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_pool_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPoolsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/pools",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_pool_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        pool_put_body: PoolPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPoolsResponse:  # noqa: E501
        """Update a pool  # noqa: E501

        Change the information of a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_update(organization_id, pool_code, season_id, sport, pool_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param pool_put_body: (required)
        :type pool_put_body: PoolPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPoolsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_pool_update_with_http_info(
                organization_id,
                pool_code,
                season_id,
                sport,
                pool_put_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_pool_update: %s\n" % e)
            raise

    @validate_arguments
    def season_pool_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        pool_put_body: PoolPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Update a pool  # noqa: E501

        Change the information of a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pool_update_with_http_info(organization_id, pool_code, season_id, sport, pool_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param pool_put_body: (required)
        :type pool_put_body: PoolPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPoolsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "pool_code",
            "season_id",
            "sport",
            "pool_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_pool_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["pool_code"]:
            _path_params["poolCode"] = _params["pool_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["pool_put_body"]:
            _body_params = _params["pool_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPoolsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/pools/{poolCode}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_pools_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPoolsResponse:  # noqa: E501
        """Delete a pool  # noqa: E501

        Delete a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pools_delete(organization_id, pool_code, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPoolsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_pools_delete_with_http_info(
                organization_id,
                pool_code,
                season_id,
                sport,
                external,
                fields,
                force_delete,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_pools_delete: %s\n" % e)
            raise

    @validate_arguments
    def season_pools_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        pool_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The pool identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Delete a pool  # noqa: E501

        Delete a specific pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_pools_delete_with_http_info(organization_id, pool_code, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param pool_code: The pool identifier within a season (required)
        :type pool_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPoolsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "pool_code",
            "season_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_pools_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["pool_code"]:
            _path_params["poolCode"] = _params["pool_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPoolsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/pools/{poolCode}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_round_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Get a round  # noqa: E501

        Return detailed information about a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_detail(organization_id, round_code, season_id, sport, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_round_detail_with_http_info(
                organization_id,
                round_code,
                season_id,
                sport,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_round_detail: %s\n" % e)
            raise

    @validate_arguments
    def season_round_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Get a round  # noqa: E501

        Return detailed information about a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_detail_with_http_info(organization_id, round_code, season_id, sport, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "round_code",
            "season_id",
            "sport",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_round_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["round_code"]:
            _path_params["roundCode"] = _params["round_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds/{roundCode}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_round_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_post_body: RoundPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Create a round  # noqa: E501

        Add a new round in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_insert(organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_post_body: (required)
        :type round_post_body: RoundPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_round_insert_with_http_info(
                organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_round_insert: %s\n" % e)
            raise

    @validate_arguments
    def season_round_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_post_body: RoundPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Create a round  # noqa: E501

        Add a new round in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_insert_with_http_info(organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_post_body: (required)
        :type round_post_body: RoundPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "round_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_round_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["round_post_body"]:
            _body_params = _params["round_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_round_insert_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_post_body: RoundPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Create or Update a round  # noqa: E501

        Depending on primary keys, insert a new round or update an existing one  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_insert_update(organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_post_body: (required)
        :type round_post_body: RoundPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_round_insert_update_with_http_info(
                organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_round_insert_update: %s\n" % e)
            raise

    @validate_arguments
    def season_round_insert_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_post_body: RoundPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Create or Update a round  # noqa: E501

        Depending on primary keys, insert a new round or update an existing one  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_insert_update_with_http_info(organization_id, season_id, sport, round_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_post_body: (required)
        :type round_post_body: RoundPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "round_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_round_insert_update" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["round_post_body"]:
            _body_params = _params["round_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds/force",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_round_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Get a list of rounds  # noqa: E501

        Return a list of rounds in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_list(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, pool_code, stage_code, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_round_list_with_http_info(
                organization_id,
                season_id,
                sport,
                added,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                pool_code,
                stage_code,
                tbf,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_round_list: %s\n" % e)
            raise

    @validate_arguments
    def season_round_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get a list of rounds  # noqa: E501

        Return a list of rounds in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_list_with_http_info(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, pool_code, stage_code, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "pool_code",
            "stage_code",
            "tbf",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_round_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_round_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_put_body: RoundPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Update a round  # noqa: E501

        Change the information of a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_update(organization_id, round_code, season_id, sport, round_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_put_body: (required)
        :type round_put_body: RoundPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_round_update_with_http_info(
                organization_id,
                round_code,
                season_id,
                sport,
                round_put_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_round_update: %s\n" % e)
            raise

    @validate_arguments
    def season_round_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        round_put_body: RoundPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Update a round  # noqa: E501

        Change the information of a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_round_update_with_http_info(organization_id, round_code, season_id, sport, round_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param round_put_body: (required)
        :type round_put_body: RoundPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "round_code",
            "season_id",
            "sport",
            "round_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_round_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["round_code"]:
            _path_params["roundCode"] = _params["round_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["round_put_body"]:
            _body_params = _params["round_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds/{roundCode}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_rounds_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonRoundsResponse:  # noqa: E501
        """Delete a round  # noqa: E501

        Delete a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_rounds_delete(organization_id, round_code, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonRoundsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_rounds_delete_with_http_info(
                organization_id,
                round_code,
                season_id,
                sport,
                external,
                fields,
                force_delete,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_rounds_delete: %s\n" % e)
            raise

    @validate_arguments
    def season_rounds_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        round_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The round identifier within a season")
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Delete a round  # noqa: E501

        Delete a specific round  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_rounds_delete_with_http_info(organization_id, round_code, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param round_code: The round identifier within a season (required)
        :type round_code: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonRoundsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "round_code",
            "season_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_rounds_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["round_code"]:
            _path_params["roundCode"] = _params["round_code"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonRoundsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/rounds/{roundCode}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_stage_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonStagesResponse:  # noqa: E501
        """Get a stage  # noqa: E501

        Return detailed information about a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_detail(organization_id, season_id, sport, stage_code, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStagesResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_stage_detail_with_http_info(
                organization_id,
                season_id,
                sport,
                stage_code,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_stage_detail: %s\n" % e)
            raise

    @validate_arguments
    def season_stage_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Get a stage  # noqa: E501

        Return detailed information about a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_detail_with_http_info(organization_id, season_id, sport, stage_code, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "stage_code",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_stage_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["stage_code"]:
            _path_params["stageCode"] = _params["stage_code"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/stages/{stageCode}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_stage_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_stage_post_body: SeasonStagePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonStagesResponse:  # noqa: E501
        """Create a stage  # noqa: E501

        Add a new stage in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_insert(organization_id, season_id, sport, season_stage_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_stage_post_body: (required)
        :type season_stage_post_body: SeasonStagePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStagesResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_stage_insert_with_http_info(
                organization_id,
                season_id,
                sport,
                season_stage_post_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_stage_insert: %s\n" % e)
            raise

    @validate_arguments
    def season_stage_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        season_stage_post_body: SeasonStagePostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Create a stage  # noqa: E501

        Add a new stage in a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_insert_with_http_info(organization_id, season_id, sport, season_stage_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param season_stage_post_body: (required)
        :type season_stage_post_body: SeasonStagePostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "season_stage_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_stage_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["season_stage_post_body"]:
            _body_params = _params["season_stage_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/stages",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_stage_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> SeasonStagesResponse:  # noqa: E501
        """Get a list of stages  # noqa: E501

        Return a list of stages for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_list(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStagesResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_stage_list_with_http_info(
                organization_id,
                season_id,
                sport,
                added,
                external,
                fields,
                hide_null,
                include,
                limit,
                offset,
                tbf,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_stage_list: %s\n" % e)
            raise

    @validate_arguments
    def season_stage_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get a list of stages  # noqa: E501

        Return a list of stages for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_list_with_http_info(organization_id, season_id, sport, added, external, fields, hide_null, include, limit, offset, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "added",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "tbf",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_stage_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/stages",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_stage_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        season_stage_put_body: SeasonStagePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonStagesResponse:  # noqa: E501
        """Update a stage  # noqa: E501

        Change the information of a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_update(organization_id, season_id, sport, stage_code, season_stage_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param season_stage_put_body: (required)
        :type season_stage_put_body: SeasonStagePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStagesResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_stage_update_with_http_info(
                organization_id,
                season_id,
                sport,
                stage_code,
                season_stage_put_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_stage_update: %s\n" % e)
            raise

    @validate_arguments
    def season_stage_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        season_stage_put_body: SeasonStagePutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Update a stage  # noqa: E501

        Change the information of a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stage_update_with_http_info(organization_id, season_id, sport, stage_code, season_stage_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param season_stage_put_body: (required)
        :type season_stage_put_body: SeasonStagePutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "stage_code",
            "season_stage_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_stage_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["stage_code"]:
            _path_params["stageCode"] = _params["stage_code"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["season_stage_put_body"]:
            _body_params = _params["season_stage_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/stages/{stageCode}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_stages_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonStagesResponse:  # noqa: E501
        """Delete a stage  # noqa: E501

        Delete a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stages_delete(organization_id, season_id, sport, stage_code, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStagesResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_stages_delete_with_http_info(
                organization_id,
                season_id,
                sport,
                stage_code,
                external,
                fields,
                force_delete,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StagesPoolsRoundsApi->season_stages_delete: %s\n" % e)
            raise

    @validate_arguments
    def season_stages_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        stage_code: Annotated[
            constr(strict=True, max_length=30), Field(..., description="The stage identifier within a season")
        ],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Delete a stage  # noqa: E501

        Delete a specific stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_stages_delete_with_http_info(organization_id, season_id, sport, stage_code, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param stage_code: The stage identifier within a season (required)
        :type stage_code: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "stage_code",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_stages_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["stage_code"]:
            _path_params["stageCode"] = _params["stage_code"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStagesResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/stages/{stageCode}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
