# Marching Squares

Marching Squares to generate random contour.

# Install

```python
pip install masq
```

# Usage

## Generate image

A random graph can be generated by using `masq.random()`.

```python
import masq

masq.random(n_row=20, n_col=30, interpolate_value=0.5)
```

<img src="https://raw.githubusercontent.com/MorvanZhou/marchingSquares/master/demo/random.png" alt="drawing" width="450"/>


## A simplex noise image

Use `masq.simplex_noise()` function. You can display all points by set `show_point=True`.

```python
import masq
masq.simplex_noise(n_row=20, n_col=30, interpolate_value=0.5, size=0.8, show_point=False)
```

<img src="https://raw.githubusercontent.com/MorvanZhou/marchingSquares/master/demo/simplex.png" alt="drawing" width="450"/>

## Play movement

Use `masq.loop_simplex_noise()` or `masq.loop_random()` function.

```python
import masq
masq.loop_simplex_noise(20, 30, interpolate_value=0.5, size=0.8, increment=0.01)
```

<img src="https://raw.githubusercontent.com/MorvanZhou/marchingSquares/master/demo/simplex.gif" alt="drawing" width="450"/>


## Display points

Turn on the `show_point=True`.

```python
import masq
masq.simplex_noise(20, 30, interpolate_value=0.5, size=0.8, show_point=True)
```

<img src="https://raw.githubusercontent.com/MorvanZhou/marchingSquares/master/demo/simplex_dot.png" alt="drawing" width="450"/>
