from setuptools import setup, find_packages

VERSION = '0.0.1' 
DESCRIPTION = 'Mokola: stock market, mutual funds, commodities and general investments'
LONG_DESCRIPTION = 'Mokola is a python package that enables users to get data on stock market accross the world'

# Setting up
setup(
       # the name must match the folder name 'verysimplemodule'
        name="mokola", 
        version=VERSION,
        author="Adu Bediako Asare",
        author_email="adu.asare@logiclabent.com",
        description=DESCRIPTION,
        long_description=LONG_DESCRIPTION,
        packages=find_packages(),
        install_requires=["bs4","pandas","numpy","matplotlib"], # add any additional packages that 
        # needs to be installed along with your package. Eg: 'caer'
        
        keywords=['python', 'mokola','stocks','africa','ghana','nigeria','mutual funds','investments','commodities'],
        classifiers= [
            "Development Status :: 3 - Alpha",
            "Intended Audience :: Developers",
            "Intended Audience :: Financial and Insurance Industry",
            "Intended Audience :: Education",
            "Programming Language :: Python :: 3",
            "Operating System :: MacOS :: MacOS X",
            "Operating System :: Microsoft :: Windows",
        ]
)