from django.urls import path

from django_ledger import views

urlpatterns = [

    # BALANCE SHEET Reports...
    # Entities...
    path('entity/<slug:entity_slug>/balance-sheet/',
         views.EntityModelBalanceSheetView.as_view(),
         name='entity-bs'),
    path('entity/<slug:entity_slug>/balance-sheet/year/<int:year>/',
         views.FiscalYearEntityModelBalanceSheetView.as_view(),
         name='entity-bs-year'),
    path('entity/<slug:entity_slug>/balance-sheet/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityModelBalanceSheetView.as_view(),
         name='entity-bs-quarter'),
    path('entity/<slug:entity_slug>/balance-sheet/month/<int:year>/<int:month>/',
         views.MonthlyEntityModelBalanceSheetView.as_view(),
         name='entity-bs-month'),
    path('entity/<slug:entity_slug>/balance-sheet/date/<int:year>/<int:month>/<int:day>/',
         views.DateEntityModelBalanceSheetView.as_view(),
         name='entity-bs-date'),

    # Ledgers....
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/balance-sheet/',
         views.FiscalYearLedgerBalanceSheetView.as_view(),
         name='ledger-bs'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/balance-sheet/year/<int:year>/',
         views.FiscalYearLedgerBalanceSheetView.as_view(),
         name='ledger-bs-year'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/balance-sheet/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyLedgerBalanceSheetView.as_view(),
         name='ledger-bs-quarter'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/balance-sheet/month/<int:year>/<int:month>/',
         views.MonthlyLedgerBalanceSheetView.as_view(),
         name='ledger-bs-month'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/balance-sheet/date/<int:year>/<int:month>/<int:day>/',
         views.DateLedgerBalanceSheetView.as_view(),
         name='ledger-bs-date'),

    # Units...
    path('unit/<slug:entity_slug>/<slug:unit_slug>/balance-sheet/',
         views.EntityUnitModelBalanceSheetView.as_view(),
         name='unit-bs'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/balance-sheet/year/<int:year>/',
         views.FiscalYearEntityUnitModelBalanceSheetView.as_view(),
         name='unit-bs-year'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/balance-sheet/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityUnitModelBalanceSheetView.as_view(),
         name='unit-bs-quarter'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/balance-sheet/month/<int:year>/<int:month>/',
         views.MonthlyEntityUnitModelBalanceSheetView.as_view(),
         name='unit-bs-month'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/balance-sheet/date/<int:year>/<int:month>/<int:day>/',
         views.DateEntityUnitModelBalanceSheetView.as_view(),
         name='unit-bs-date'),

    # INCOME STATEMENT Reports ----
    # Entity .....
    path('entity/<slug:entity_slug>/income-statement/',
         views.EntityModelIncomeStatementView.as_view(),
         name='entity-ic'),
    path('entity/<slug:entity_slug>/income-statement/year/<int:year>/',
         views.FiscalYearEntityModelIncomeStatementView.as_view(),
         name='entity-ic-year'),
    path('entity/<slug:entity_slug>/income-statement/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityModelIncomeStatementView.as_view(),
         name='entity-ic-quarter'),
    path('entity/<slug:entity_slug>/income-statement/month/<int:year>/<int:month>/',
         views.MonthlyEntityModelIncomeStatementView.as_view(),
         name='entity-ic-month'),
    path('entity/<slug:entity_slug>/income-statement/date/<int:year>/<int:month>/<int:day>/',
         views.MonthlyEntityModelIncomeStatementView.as_view(),
         name='entity-ic-date'),

    # Ledgers ....
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/income-statement/',
         views.FiscalYearLedgerIncomeStatementView.as_view(),
         name='ledger-ic'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/income-statement/year/<int:year>/',
         views.FiscalYearLedgerIncomeStatementView.as_view(),
         name='ledger-ic-year'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/income-statement/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyLedgerIncomeStatementView.as_view(),
         name='ledger-ic-quarter'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/income-statement/month/<int:year>/<int:month>/',
         views.MonthlyLedgerIncomeStatementView.as_view(),
         name='ledger-ic-month'),
    path('ledger/<slug:entity_slug>/<uuid:ledger_pk>/income-statement/date/<int:year>/<int:month>/<int:day>/',
         views.DateLedgerIncomeStatementView.as_view(),
         name='ledger-ic-date'),

    # Entity Units...
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/',
         views.EntityUnitModelIncomeStatementView.as_view(),
         name='unit-ic'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/year/<int:year>/',
         views.FiscalYearEntityUnitModelIncomeStatementView.as_view(),
         name='unit-ic-year'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-ic-quarter'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/month/<int:year>/<str:month>/',
         views.MonthlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-ic-month'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/date/<int:year>/<str:month>/<int:day>/',
         views.MonthlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-ic-date'),


    # CASH FLOW STATEMENTS...
    path('entity/<slug:entity_slug>/cash-flow-statement/',
         views.EntityModelCashFlowStatementView.as_view(),
         name='entity-cf'),
    path('entity/<slug:entity_slug>/cash-flow-statement/year/<int:year>/',
         views.FiscalYearEntityModelCashFlowStatementView.as_view(),
         name='entity-cf-year'),
    path('entity/<slug:entity_slug>/cash-flow-statement/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityModelCashFlowStatementView.as_view(),
         name='entity-cf-quarter'),
    path('entity/<slug:entity_slug>/cash-flow-statement/month/<int:year>/<int:month>/',
         views.MonthlyEntityModelCashFlowStatementView.as_view(),
         name='entity-cf-month'),
    path('entity/<slug:entity_slug>/cash-flow-statement/date/<int:year>/<int:month>/<int:day>/',
         views.DateModelCashFlowStatementView.as_view(),
         name='entity-cf-date'),

    # Entity Units...
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/',
         views.EntityUnitModelIncomeStatementView.as_view(),
         name='unit-cf'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/year/<int:year>/',
         views.FiscalYearEntityUnitModelIncomeStatementView.as_view(),
         name='unit-cf-year'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/quarter/<int:year>/<int:quarter>/',
         views.QuarterlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-cf-quarter'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/month/<int:year>/<str:month>/',
         views.MonthlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-cf-month'),
    path('unit/<slug:entity_slug>/<slug:unit_slug>/income-statement/date/<int:year>/<str:month>/<int:day>/',
         views.MonthlyEntityUnitModelIncomeStatementView.as_view(),
         name='unit-cf-date'),

]
