import os

try:
    import graphene_django

    GRAPHENE_SUPPORT = True
except ImportError:
    GRAPHENE_SUPPORT = False

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

SECRET_KEY = os.getenv('SECRET_KEY')
if not SECRET_KEY:
    SECRET_KEY = 'djangoledger1234!DoNotUse!BadIdea!VeryInsecure!'
DEBUG = True

ALLOWED_HOSTS = ['127.0.0.1', '192.168.1.101']

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_ledger',
]

if GRAPHENE_SUPPORT:
    INSTALLED_APPS += [
        'graphene_django',
        'graphql_auth',
    ]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'dev_env.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'dev_env.wsgi.application'

# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'US/Eastern'

USE_I18N = True
USE_L10N = True
USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'
LOGIN_URL = '/auth/login/'

AUTHENTICATION_BACKENDS = [
    'django.contrib.auth.backends.ModelBackend',
]

if GRAPHENE_SUPPORT:
    GRAPHENE = {
        'SCHEMA': 'django_ledger.contrib.django_ledger_graphene.api.schema',
        'SCHEMA_OUTPUT': '../django_ledger/contrib/django_ledger_graphene/schema.graphql',  # defaults to schema.json,
        # 'SCHEMA_INDENT': 2,  # Defaults to None (displays all data on a single line)
        'MIDDLEWARE': [
            'graphql_jwt.middleware.JSONWebTokenMiddleware',
        ],
    }

    AUTHENTICATION_BACKENDS += [
        'graphql_jwt.backends.JSONWebTokenBackend'
    ]

    GRAPHQL_JWT = {
        'JWT_ALLOW_ARGUMENT': True,
        # ...
        "JWT_ALLOW_ANY_CLASSES": [
            "graphql_auth.mutations.Register",
            "graphql_auth.mutations.VerifyAccount",
            "graphql_auth.mutations.ResendActivationEmail",
            "graphql_auth.mutations.SendPasswordResetEmail",
            "graphql_auth.mutations.PasswordReset",
            "graphql_auth.mutations.ObtainJSONWebToken",
            "graphql_auth.mutations.VerifyToken",
            "graphql_auth.mutations.RefreshToken",
            "graphql_auth.mutations.RevokeToken",
            "graphql_auth.mutations.VerifySecondaryEmail",

        ],
    }

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'
