#include <stdint.h>
#include <stddef.h>

typedef enum JISCharacterClass {
    JISCharacterClass_RESERVED = 0,
    JISCharacterClass_KANJI_LEVEL_1 = 1,
    JISCharacterClass_KANJI_LEVEL_2 = 2,
    JISCharacterClass_KANJI_LEVEL_3 = 3,
    JISCharacterClass_KANJI_LEVEL_4 = 4,
    JISCharacterClass_JISX0208_NON_KANJI = 9,
    JISCharacterClass_JISX0213_NON_KANJI = 11
} JISCharacterClass;

typedef struct ShrinkingTransliterationMapping {
    uint16_t jis;
    uint32_t us[2];
    uint32_t sus[2];
    JISCharacterClass class_;
    size_t tx_len:8;
    uint16_t tx_jis[4];
    uint32_t tx_us[4];
} ShrinkingTransliterationMapping;

typedef struct URangeToJISMapping {
    uint32_t start:24, end:24;
    const uint16_t *jis;
} URangeToJISMapping;

static const ShrinkingTransliterationMapping tx_mappings[2 * 94 * 94] = {
    {
        0,
        {12288, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {0},
        {12288}
    },
    {
        1,
        {12289, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {1},
        {12289}
    },
    {
        2,
        {12290, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {2},
        {12290}
    },
    {
        3,
        {65292, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {3},
        {65292}
    },
    {
        4,
        {65294, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {4},
        {65294}
    },
    {
        5,
        {12539, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {5},
        {12539}
    },
    {
        6,
        {65306, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {6},
        {65306}
    },
    {
        7,
        {65307, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {7},
        {65307}
    },
    {
        8,
        {65311, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {8},
        {65311}
    },
    {
        9,
        {65281, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {9},
        {65281}
    },
    {
        10,
        {12443, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {10},
        {12443}
    },
    {
        11,
        {12444, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {11},
        {12444}
    },
    {
        12,
        {180, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {12},
        {180}
    },
    {
        13,
        {65344, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {13},
        {65344}
    },
    {
        14,
        {168, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {14},
        {168}
    },
    {
        15,
        {65342, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {15},
        {65342}
    },
    {
        16,
        {65507, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {16},
        {65507}
    },
    {
        17,
        {65343, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {17},
        {65343}
    },
    {
        18,
        {12541, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {18},
        {12541}
    },
    {
        19,
        {12542, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {19},
        {12542}
    },
    {
        20,
        {12445, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {20},
        {12445}
    },
    {
        21,
        {12446, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {21},
        {12446}
    },
    {
        22,
        {12291, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {22},
        {12291}
    },
    {
        23,
        {20189, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {23},
        {20189}
    },
    {
        24,
        {12293, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {24},
        {12293}
    },
    {
        25,
        {12294, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {25},
        {12294}
    },
    {
        26,
        {12295, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {26},
        {12295}
    },
    {
        27,
        {12540, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {27},
        {12540}
    },
    {
        28,
        {8213, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {28},
        {8213}
    },
    {
        29,
        {8208, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {29},
        {8208}
    },
    {
        30,
        {65295, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {30},
        {65295}
    },
    {
        31,
        {65340, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {31},
        {65340}
    },
    {
        32,
        {65374, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {32},
        {65374}
    },
    {
        33,
        {8741, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {33},
        {8741}
    },
    {
        34,
        {65372, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {34},
        {65372}
    },
    {
        35,
        {8230, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {35},
        {8230}
    },
    {
        36,
        {8229, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {36},
        {8229}
    },
    {
        37,
        {8216, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {37},
        {8216}
    },
    {
        38,
        {8217, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {38},
        {8217}
    },
    {
        39,
        {8220, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {39},
        {8220}
    },
    {
        40,
        {8221, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {40},
        {8221}
    },
    {
        41,
        {65288, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {41},
        {65288}
    },
    {
        42,
        {65289, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {42},
        {65289}
    },
    {
        43,
        {12308, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {43},
        {12308}
    },
    {
        44,
        {12309, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {44},
        {12309}
    },
    {
        45,
        {65339, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {45},
        {65339}
    },
    {
        46,
        {65341, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {46},
        {65341}
    },
    {
        47,
        {65371, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {47},
        {65371}
    },
    {
        48,
        {65373, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {48},
        {65373}
    },
    {
        49,
        {12296, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {49},
        {12296}
    },
    {
        50,
        {12297, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {50},
        {12297}
    },
    {
        51,
        {12298, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {51},
        {12298}
    },
    {
        52,
        {12299, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {52},
        {12299}
    },
    {
        53,
        {12300, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {53},
        {12300}
    },
    {
        54,
        {12301, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {54},
        {12301}
    },
    {
        55,
        {12302, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {55},
        {12302}
    },
    {
        56,
        {12303, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {56},
        {12303}
    },
    {
        57,
        {12304, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {57},
        {12304}
    },
    {
        58,
        {12305, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {58},
        {12305}
    },
    {
        59,
        {65291, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {59},
        {65291}
    },
    {
        60,
        {65293, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {60},
        {65293}
    },
    {
        61,
        {177, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {61},
        {177}
    },
    {
        62,
        {215, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {62},
        {215}
    },
    {
        63,
        {247, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {63},
        {247}
    },
    {
        64,
        {65309, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {64},
        {65309}
    },
    {
        65,
        {8800, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {65},
        {8800}
    },
    {
        66,
        {65308, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {66},
        {65308}
    },
    {
        67,
        {65310, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {67},
        {65310}
    },
    {
        68,
        {8806, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {68},
        {8806}
    },
    {
        69,
        {8807, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {69},
        {8807}
    },
    {
        70,
        {8734, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {70},
        {8734}
    },
    {
        71,
        {8756, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {71},
        {8756}
    },
    {
        72,
        {9794, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {72},
        {9794}
    },
    {
        73,
        {9792, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {73},
        {9792}
    },
    {
        74,
        {176, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {74},
        {176}
    },
    {
        75,
        {8242, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {75},
        {8242}
    },
    {
        76,
        {8243, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {76},
        {8243}
    },
    {
        77,
        {8451, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {77},
        {8451}
    },
    {
        78,
        {65509, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {78},
        {65509}
    },
    {
        79,
        {65284, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {79},
        {65284}
    },
    {
        80,
        {65504, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {80},
        {65504}
    },
    {
        81,
        {65505, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {81},
        {65505}
    },
    {
        82,
        {65285, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {82},
        {65285}
    },
    {
        83,
        {65283, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {83},
        {65283}
    },
    {
        84,
        {65286, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {84},
        {65286}
    },
    {
        85,
        {65290, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {85},
        {65290}
    },
    {
        86,
        {65312, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {86},
        {65312}
    },
    {
        87,
        {167, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {87},
        {167}
    },
    {
        88,
        {9734, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {88},
        {9734}
    },
    {
        89,
        {9733, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {89},
        {9733}
    },
    {
        90,
        {9675, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {90},
        {9675}
    },
    {
        91,
        {9679, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {91},
        {9679}
    },
    {
        92,
        {9678, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {92},
        {9678}
    },
    {
        93,
        {9671, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {93},
        {9671}
    },
    {
        94,
        {9670, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {94},
        {9670}
    },
    {
        95,
        {9633, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {95},
        {9633}
    },
    {
        96,
        {9632, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {96},
        {9632}
    },
    {
        97,
        {9651, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {97},
        {9651}
    },
    {
        98,
        {9650, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {98},
        {9650}
    },
    {
        99,
        {9661, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {99},
        {9661}
    },
    {
        100,
        {9660, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {100},
        {9660}
    },
    {
        101,
        {8251, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {101},
        {8251}
    },
    {
        102,
        {12306, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {102},
        {12306}
    },
    {
        103,
        {8594, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {103},
        {8594}
    },
    {
        104,
        {8592, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {104},
        {8592}
    },
    {
        105,
        {8593, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {105},
        {8593}
    },
    {
        106,
        {8595, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {106},
        {8595}
    },
    {
        107,
        {12307, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {107},
        {12307}
    },
    {
        108,
        {65287, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        109,
        {65282, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        110,
        {12339, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        111,
        {12339, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        112,
        {12339, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        113,
        {12340, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        114,
        {12341, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        115,
        {12347, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        116,
        {12348, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        117,
        {12543, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        118,
        {12447, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        119,
        {8712, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {119},
        {8712}
    },
    {
        120,
        {8715, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {120},
        {8715}
    },
    {
        121,
        {8838, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {121},
        {8838}
    },
    {
        122,
        {8839, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {122},
        {8839}
    },
    {
        123,
        {8834, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {123},
        {8834}
    },
    {
        124,
        {8835, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {124},
        {8835}
    },
    {
        125,
        {8746, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {125},
        {8746}
    },
    {
        126,
        {8745, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {126},
        {8745}
    },
    {
        127,
        {8836, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        128,
        {8837, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        129,
        {8842, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        130,
        {8843, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        131,
        {8713, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        132,
        {8709, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        133,
        {8965, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        134,
        {8966, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        135,
        {8743, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {135},
        {8743}
    },
    {
        136,
        {8744, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {136},
        {8744}
    },
    {
        137,
        {65506, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {137},
        {65506}
    },
    {
        138,
        {8658, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {138},
        {8658}
    },
    {
        139,
        {8660, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {139},
        {8660}
    },
    {
        140,
        {8704, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {140},
        {8704}
    },
    {
        141,
        {8707, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {141},
        {8707}
    },
    {
        142,
        {8853, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        143,
        {8854, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        144,
        {8855, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        145,
        {8742, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        146,
        {8742, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        147,
        {65375, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {41},
        {65288}
    },
    {
        148,
        {65376, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {42},
        {65289}
    },
    {
        149,
        {12312, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {45},
        {65339}
    },
    {
        150,
        {12313, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {46},
        {65341}
    },
    {
        151,
        {12310, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {57},
        {12304}
    },
    {
        152,
        {12311, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {58},
        {12305}
    },
    {
        153,
        {8736, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {153},
        {8736}
    },
    {
        154,
        {8869, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {154},
        {8869}
    },
    {
        155,
        {8978, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {155},
        {8978}
    },
    {
        156,
        {8706, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {156},
        {8706}
    },
    {
        157,
        {8711, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {157},
        {8711}
    },
    {
        158,
        {8801, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {158},
        {8801}
    },
    {
        159,
        {8786, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {159},
        {8786}
    },
    {
        160,
        {8810, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {160},
        {8810}
    },
    {
        161,
        {8811, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {161},
        {8811}
    },
    {
        162,
        {8730, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {162},
        {8730}
    },
    {
        163,
        {8765, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {163},
        {8765}
    },
    {
        164,
        {8733, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {164},
        {8733}
    },
    {
        165,
        {8757, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {165},
        {8757}
    },
    {
        166,
        {8747, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {166},
        {8747}
    },
    {
        167,
        {8748, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {167},
        {8748}
    },
    {
        168,
        {8802, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {65},
        {8800}
    },
    {
        169,
        {8771, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {64},
        {65309}
    },
    {
        170,
        {8773, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        171,
        {8776, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        172,
        {8822, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        173,
        {8823, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        174,
        {8596, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        175,
        {8491, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {175},
        {8491}
    },
    {
        176,
        {8240, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {176},
        {8240}
    },
    {
        177,
        {9839, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {177},
        {9839}
    },
    {
        178,
        {9837, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {178},
        {9837}
    },
    {
        179,
        {9834, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {179},
        {9834}
    },
    {
        180,
        {8224, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {180},
        {8224}
    },
    {
        181,
        {8225, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {181},
        {8225}
    },
    {
        182,
        {182, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {182},
        {182}
    },
    {
        183,
        {9838, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        184,
        {9835, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        185,
        {9836, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        186,
        {9833, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        187,
        {9711, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {187},
        {9711}
    },
    {
        188,
        {9655, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        189,
        {9654, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        190,
        {9665, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        191,
        {9664, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        192,
        {8599, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        193,
        {8600, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        194,
        {8598, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        195,
        {8601, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        196,
        {8644, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        197,
        {8680, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        198,
        {8678, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        199,
        {8679, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        200,
        {8681, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        201,
        {10548, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        202,
        {10549, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        203,
        {65296, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {203},
        {65296}
    },
    {
        204,
        {65297, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {204},
        {65297}
    },
    {
        205,
        {65298, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {205},
        {65298}
    },
    {
        206,
        {65299, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {206},
        {65299}
    },
    {
        207,
        {65300, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {207},
        {65300}
    },
    {
        208,
        {65301, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {208},
        {65301}
    },
    {
        209,
        {65302, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {209},
        {65302}
    },
    {
        210,
        {65303, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {210},
        {65303}
    },
    {
        211,
        {65304, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {211},
        {65304}
    },
    {
        212,
        {65305, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {212},
        {65305}
    },
    {
        213,
        {10687, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        214,
        {9673, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        215,
        {12349, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        216,
        {65094, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        217,
        {65093, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        218,
        {9702, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        219,
        {8226, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        220,
        {65313, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {220},
        {65313}
    },
    {
        221,
        {65314, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {221},
        {65314}
    },
    {
        222,
        {65315, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {222},
        {65315}
    },
    {
        223,
        {65316, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {223},
        {65316}
    },
    {
        224,
        {65317, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {224},
        {65317}
    },
    {
        225,
        {65318, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {225},
        {65318}
    },
    {
        226,
        {65319, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {226},
        {65319}
    },
    {
        227,
        {65320, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {227},
        {65320}
    },
    {
        228,
        {65321, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {228},
        {65321}
    },
    {
        229,
        {65322, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {229},
        {65322}
    },
    {
        230,
        {65323, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {230},
        {65323}
    },
    {
        231,
        {65324, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {231},
        {65324}
    },
    {
        232,
        {65325, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {232},
        {65325}
    },
    {
        233,
        {65326, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {233},
        {65326}
    },
    {
        234,
        {65327, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {234},
        {65327}
    },
    {
        235,
        {65328, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {235},
        {65328}
    },
    {
        236,
        {65329, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {236},
        {65329}
    },
    {
        237,
        {65330, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {237},
        {65330}
    },
    {
        238,
        {65331, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {238},
        {65331}
    },
    {
        239,
        {65332, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {239},
        {65332}
    },
    {
        240,
        {65333, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {240},
        {65333}
    },
    {
        241,
        {65334, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {241},
        {65334}
    },
    {
        242,
        {65335, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {242},
        {65335}
    },
    {
        243,
        {65336, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {243},
        {65336}
    },
    {
        244,
        {65337, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {244},
        {65337}
    },
    {
        245,
        {65338, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {245},
        {65338}
    },
    {
        246,
        {8723, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        247,
        {8501, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        248,
        {8463, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        249,
        {13259, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        250,
        {8467, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        251,
        {8487, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        252,
        {65345, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {252},
        {65345}
    },
    {
        253,
        {65346, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {253},
        {65346}
    },
    {
        254,
        {65347, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {254},
        {65347}
    },
    {
        255,
        {65348, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {255},
        {65348}
    },
    {
        256,
        {65349, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {256},
        {65349}
    },
    {
        257,
        {65350, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {257},
        {65350}
    },
    {
        258,
        {65351, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {258},
        {65351}
    },
    {
        259,
        {65352, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {259},
        {65352}
    },
    {
        260,
        {65353, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {260},
        {65353}
    },
    {
        261,
        {65354, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {261},
        {65354}
    },
    {
        262,
        {65355, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {262},
        {65355}
    },
    {
        263,
        {65356, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {263},
        {65356}
    },
    {
        264,
        {65357, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {264},
        {65357}
    },
    {
        265,
        {65358, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {265},
        {65358}
    },
    {
        266,
        {65359, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {266},
        {65359}
    },
    {
        267,
        {65360, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {267},
        {65360}
    },
    {
        268,
        {65361, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {268},
        {65361}
    },
    {
        269,
        {65362, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {269},
        {65362}
    },
    {
        270,
        {65363, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {270},
        {65363}
    },
    {
        271,
        {65364, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {271},
        {65364}
    },
    {
        272,
        {65365, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {272},
        {65365}
    },
    {
        273,
        {65366, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {273},
        {65366}
    },
    {
        274,
        {65367, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {274},
        {65367}
    },
    {
        275,
        {65368, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {275},
        {65368}
    },
    {
        276,
        {65369, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {276},
        {65369}
    },
    {
        277,
        {65370, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {277},
        {65370}
    },
    {
        278,
        {12448, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        279,
        {8211, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {29},
        {8208}
    },
    {
        280,
        {10746, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        281,
        {10747, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        282,
        {12353, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {282},
        {12353}
    },
    {
        283,
        {12354, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {283},
        {12354}
    },
    {
        284,
        {12355, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {284},
        {12355}
    },
    {
        285,
        {12356, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {285},
        {12356}
    },
    {
        286,
        {12357, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {286},
        {12357}
    },
    {
        287,
        {12358, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {287},
        {12358}
    },
    {
        288,
        {12359, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {288},
        {12359}
    },
    {
        289,
        {12360, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {289},
        {12360}
    },
    {
        290,
        {12361, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {290},
        {12361}
    },
    {
        291,
        {12362, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {291},
        {12362}
    },
    {
        292,
        {12363, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {292},
        {12363}
    },
    {
        293,
        {12364, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {293},
        {12364}
    },
    {
        294,
        {12365, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {294},
        {12365}
    },
    {
        295,
        {12366, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {295},
        {12366}
    },
    {
        296,
        {12367, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {296},
        {12367}
    },
    {
        297,
        {12368, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {297},
        {12368}
    },
    {
        298,
        {12369, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {298},
        {12369}
    },
    {
        299,
        {12370, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {299},
        {12370}
    },
    {
        300,
        {12371, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {300},
        {12371}
    },
    {
        301,
        {12372, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {301},
        {12372}
    },
    {
        302,
        {12373, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {302},
        {12373}
    },
    {
        303,
        {12374, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {303},
        {12374}
    },
    {
        304,
        {12375, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {304},
        {12375}
    },
    {
        305,
        {12376, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {305},
        {12376}
    },
    {
        306,
        {12377, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {306},
        {12377}
    },
    {
        307,
        {12378, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {307},
        {12378}
    },
    {
        308,
        {12379, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {308},
        {12379}
    },
    {
        309,
        {12380, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {309},
        {12380}
    },
    {
        310,
        {12381, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {310},
        {12381}
    },
    {
        311,
        {12382, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {311},
        {12382}
    },
    {
        312,
        {12383, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {312},
        {12383}
    },
    {
        313,
        {12384, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {313},
        {12384}
    },
    {
        314,
        {12385, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {314},
        {12385}
    },
    {
        315,
        {12386, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {315},
        {12386}
    },
    {
        316,
        {12387, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {316},
        {12387}
    },
    {
        317,
        {12388, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {317},
        {12388}
    },
    {
        318,
        {12389, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {318},
        {12389}
    },
    {
        319,
        {12390, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {319},
        {12390}
    },
    {
        320,
        {12391, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {320},
        {12391}
    },
    {
        321,
        {12392, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {321},
        {12392}
    },
    {
        322,
        {12393, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {322},
        {12393}
    },
    {
        323,
        {12394, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {323},
        {12394}
    },
    {
        324,
        {12395, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {324},
        {12395}
    },
    {
        325,
        {12396, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {325},
        {12396}
    },
    {
        326,
        {12397, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {326},
        {12397}
    },
    {
        327,
        {12398, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {327},
        {12398}
    },
    {
        328,
        {12399, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {328},
        {12399}
    },
    {
        329,
        {12400, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {329},
        {12400}
    },
    {
        330,
        {12401, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {330},
        {12401}
    },
    {
        331,
        {12402, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {331},
        {12402}
    },
    {
        332,
        {12403, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {332},
        {12403}
    },
    {
        333,
        {12404, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {333},
        {12404}
    },
    {
        334,
        {12405, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {334},
        {12405}
    },
    {
        335,
        {12406, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {335},
        {12406}
    },
    {
        336,
        {12407, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {336},
        {12407}
    },
    {
        337,
        {12408, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {337},
        {12408}
    },
    {
        338,
        {12409, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {338},
        {12409}
    },
    {
        339,
        {12410, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {339},
        {12410}
    },
    {
        340,
        {12411, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {340},
        {12411}
    },
    {
        341,
        {12412, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {341},
        {12412}
    },
    {
        342,
        {12413, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {342},
        {12413}
    },
    {
        343,
        {12414, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {343},
        {12414}
    },
    {
        344,
        {12415, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {344},
        {12415}
    },
    {
        345,
        {12416, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {345},
        {12416}
    },
    {
        346,
        {12417, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {346},
        {12417}
    },
    {
        347,
        {12418, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {347},
        {12418}
    },
    {
        348,
        {12419, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {348},
        {12419}
    },
    {
        349,
        {12420, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {349},
        {12420}
    },
    {
        350,
        {12421, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {350},
        {12421}
    },
    {
        351,
        {12422, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {351},
        {12422}
    },
    {
        352,
        {12423, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {352},
        {12423}
    },
    {
        353,
        {12424, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {353},
        {12424}
    },
    {
        354,
        {12425, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {354},
        {12425}
    },
    {
        355,
        {12426, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {355},
        {12426}
    },
    {
        356,
        {12427, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {356},
        {12427}
    },
    {
        357,
        {12428, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {357},
        {12428}
    },
    {
        358,
        {12429, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {358},
        {12429}
    },
    {
        359,
        {12430, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {359},
        {12430}
    },
    {
        360,
        {12431, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {360},
        {12431}
    },
    {
        361,
        {12432, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {361},
        {12432}
    },
    {
        362,
        {12433, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {362},
        {12433}
    },
    {
        363,
        {12434, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {363},
        {12434}
    },
    {
        364,
        {12435, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {364},
        {12435}
    },
    {
        365,
        {12436, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {459},
        {12532}
    },
    {
        366,
        {12437, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {460},
        {12533}
    },
    {
        367,
        {12438, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {461},
        {12534}
    },
    {
        368,
        {12363, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        369,
        {12365, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        370,
        {12367, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        371,
        {12369, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        372,
        {12371, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        373,
        {12449, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        374,
        {12449, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        375,
        {12449, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        376,
        {12449, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {376},
        {12449}
    },
    {
        377,
        {12450, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {377},
        {12450}
    },
    {
        378,
        {12451, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {378},
        {12451}
    },
    {
        379,
        {12452, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {379},
        {12452}
    },
    {
        380,
        {12453, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {380},
        {12453}
    },
    {
        381,
        {12454, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {381},
        {12454}
    },
    {
        382,
        {12455, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {382},
        {12455}
    },
    {
        383,
        {12456, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {383},
        {12456}
    },
    {
        384,
        {12457, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {384},
        {12457}
    },
    {
        385,
        {12458, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {385},
        {12458}
    },
    {
        386,
        {12459, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {386},
        {12459}
    },
    {
        387,
        {12460, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {387},
        {12460}
    },
    {
        388,
        {12461, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {388},
        {12461}
    },
    {
        389,
        {12462, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {389},
        {12462}
    },
    {
        390,
        {12463, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {390},
        {12463}
    },
    {
        391,
        {12464, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {391},
        {12464}
    },
    {
        392,
        {12465, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {392},
        {12465}
    },
    {
        393,
        {12466, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {393},
        {12466}
    },
    {
        394,
        {12467, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {394},
        {12467}
    },
    {
        395,
        {12468, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {395},
        {12468}
    },
    {
        396,
        {12469, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {396},
        {12469}
    },
    {
        397,
        {12470, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {397},
        {12470}
    },
    {
        398,
        {12471, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {398},
        {12471}
    },
    {
        399,
        {12472, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {399},
        {12472}
    },
    {
        400,
        {12473, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {400},
        {12473}
    },
    {
        401,
        {12474, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {401},
        {12474}
    },
    {
        402,
        {12475, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {402},
        {12475}
    },
    {
        403,
        {12476, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {403},
        {12476}
    },
    {
        404,
        {12477, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {404},
        {12477}
    },
    {
        405,
        {12478, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {405},
        {12478}
    },
    {
        406,
        {12479, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {406},
        {12479}
    },
    {
        407,
        {12480, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {407},
        {12480}
    },
    {
        408,
        {12481, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {408},
        {12481}
    },
    {
        409,
        {12482, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {409},
        {12482}
    },
    {
        410,
        {12483, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {410},
        {12483}
    },
    {
        411,
        {12484, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {411},
        {12484}
    },
    {
        412,
        {12485, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {412},
        {12485}
    },
    {
        413,
        {12486, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {413},
        {12486}
    },
    {
        414,
        {12487, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {414},
        {12487}
    },
    {
        415,
        {12488, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {415},
        {12488}
    },
    {
        416,
        {12489, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {416},
        {12489}
    },
    {
        417,
        {12490, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {417},
        {12490}
    },
    {
        418,
        {12491, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {418},
        {12491}
    },
    {
        419,
        {12492, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {419},
        {12492}
    },
    {
        420,
        {12493, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {420},
        {12493}
    },
    {
        421,
        {12494, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {421},
        {12494}
    },
    {
        422,
        {12495, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {422},
        {12495}
    },
    {
        423,
        {12496, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {423},
        {12496}
    },
    {
        424,
        {12497, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {424},
        {12497}
    },
    {
        425,
        {12498, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {425},
        {12498}
    },
    {
        426,
        {12499, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {426},
        {12499}
    },
    {
        427,
        {12500, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {427},
        {12500}
    },
    {
        428,
        {12501, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {428},
        {12501}
    },
    {
        429,
        {12502, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {429},
        {12502}
    },
    {
        430,
        {12503, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {430},
        {12503}
    },
    {
        431,
        {12504, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {431},
        {12504}
    },
    {
        432,
        {12505, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {432},
        {12505}
    },
    {
        433,
        {12506, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {433},
        {12506}
    },
    {
        434,
        {12507, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {434},
        {12507}
    },
    {
        435,
        {12508, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {435},
        {12508}
    },
    {
        436,
        {12509, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {436},
        {12509}
    },
    {
        437,
        {12510, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {437},
        {12510}
    },
    {
        438,
        {12511, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {438},
        {12511}
    },
    {
        439,
        {12512, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {439},
        {12512}
    },
    {
        440,
        {12513, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {440},
        {12513}
    },
    {
        441,
        {12514, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {441},
        {12514}
    },
    {
        442,
        {12515, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {442},
        {12515}
    },
    {
        443,
        {12516, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {443},
        {12516}
    },
    {
        444,
        {12517, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {444},
        {12517}
    },
    {
        445,
        {12518, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {445},
        {12518}
    },
    {
        446,
        {12519, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {446},
        {12519}
    },
    {
        447,
        {12520, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {447},
        {12520}
    },
    {
        448,
        {12521, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {448},
        {12521}
    },
    {
        449,
        {12522, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {449},
        {12522}
    },
    {
        450,
        {12523, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {450},
        {12523}
    },
    {
        451,
        {12524, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {451},
        {12524}
    },
    {
        452,
        {12525, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {452},
        {12525}
    },
    {
        453,
        {12526, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {453},
        {12526}
    },
    {
        454,
        {12527, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {454},
        {12527}
    },
    {
        455,
        {12528, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {455},
        {12528}
    },
    {
        456,
        {12529, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {456},
        {12529}
    },
    {
        457,
        {12530, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {457},
        {12530}
    },
    {
        458,
        {12531, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {458},
        {12531}
    },
    {
        459,
        {12532, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {459},
        {12532}
    },
    {
        460,
        {12533, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {460},
        {12533}
    },
    {
        461,
        {12534, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {461},
        {12534}
    },
    {
        462,
        {12459, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        463,
        {12461, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        464,
        {12463, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        465,
        {12465, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        466,
        {12467, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        467,
        {12475, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        468,
        {12484, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        469,
        {12488, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        470,
        {913, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {470},
        {913}
    },
    {
        471,
        {914, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {471},
        {914}
    },
    {
        472,
        {915, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {472},
        {915}
    },
    {
        473,
        {916, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {473},
        {916}
    },
    {
        474,
        {917, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {474},
        {917}
    },
    {
        475,
        {918, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {475},
        {918}
    },
    {
        476,
        {919, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {476},
        {919}
    },
    {
        477,
        {920, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {477},
        {920}
    },
    {
        478,
        {921, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {478},
        {921}
    },
    {
        479,
        {922, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {479},
        {922}
    },
    {
        480,
        {923, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {480},
        {923}
    },
    {
        481,
        {924, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {481},
        {924}
    },
    {
        482,
        {925, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {482},
        {925}
    },
    {
        483,
        {926, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {483},
        {926}
    },
    {
        484,
        {927, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {484},
        {927}
    },
    {
        485,
        {928, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {485},
        {928}
    },
    {
        486,
        {929, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {486},
        {929}
    },
    {
        487,
        {931, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {487},
        {931}
    },
    {
        488,
        {932, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {488},
        {932}
    },
    {
        489,
        {933, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {489},
        {933}
    },
    {
        490,
        {934, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {490},
        {934}
    },
    {
        491,
        {935, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {491},
        {935}
    },
    {
        492,
        {936, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {492},
        {936}
    },
    {
        493,
        {937, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {493},
        {937}
    },
    {
        494,
        {9828, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        495,
        {9824, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        496,
        {9826, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        497,
        {9830, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        498,
        {9825, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        499,
        {9829, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        500,
        {9831, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        501,
        {9827, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        502,
        {945, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {502},
        {945}
    },
    {
        503,
        {946, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {503},
        {946}
    },
    {
        504,
        {947, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {504},
        {947}
    },
    {
        505,
        {948, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {505},
        {948}
    },
    {
        506,
        {949, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {506},
        {949}
    },
    {
        507,
        {950, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {507},
        {950}
    },
    {
        508,
        {951, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {508},
        {951}
    },
    {
        509,
        {952, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {509},
        {952}
    },
    {
        510,
        {953, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {510},
        {953}
    },
    {
        511,
        {954, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {511},
        {954}
    },
    {
        512,
        {955, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {512},
        {955}
    },
    {
        513,
        {956, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {513},
        {956}
    },
    {
        514,
        {957, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {514},
        {957}
    },
    {
        515,
        {958, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {515},
        {958}
    },
    {
        516,
        {959, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {516},
        {959}
    },
    {
        517,
        {960, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {517},
        {960}
    },
    {
        518,
        {961, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {518},
        {961}
    },
    {
        519,
        {963, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {519},
        {963}
    },
    {
        520,
        {964, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {520},
        {964}
    },
    {
        521,
        {965, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {521},
        {965}
    },
    {
        522,
        {966, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {522},
        {966}
    },
    {
        523,
        {967, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {523},
        {967}
    },
    {
        524,
        {968, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {524},
        {968}
    },
    {
        525,
        {969, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {525},
        {969}
    },
    {
        526,
        {962, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        527,
        {9461, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {204},
        {65297}
    },
    {
        528,
        {9462, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {205},
        {65298}
    },
    {
        529,
        {9463, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {206},
        {65299}
    },
    {
        530,
        {9464, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {207},
        {65300}
    },
    {
        531,
        {9465, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {208},
        {65301}
    },
    {
        532,
        {9466, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {209},
        {65302}
    },
    {
        533,
        {9467, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {210},
        {65303}
    },
    {
        534,
        {9468, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {211},
        {65304}
    },
    {
        535,
        {9469, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {212},
        {65305}
    },
    {
        536,
        {9470, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 203},
        {65297, 65296}
    },
    {
        537,
        {9750, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        538,
        {9751, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        539,
        {12320, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        540,
        {9742, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        541,
        {9728, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        542,
        {9729, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        543,
        {9730, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        544,
        {9731, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        545,
        {9832, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        546,
        {9649, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        547,
        {12784, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {390},
        {12463}
    },
    {
        548,
        {12785, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {398},
        {12471}
    },
    {
        549,
        {12786, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {400},
        {12473}
    },
    {
        550,
        {12787, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {415},
        {12488}
    },
    {
        551,
        {12788, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {419},
        {12492}
    },
    {
        552,
        {12789, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {422},
        {12495}
    },
    {
        553,
        {12790, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {425},
        {12498}
    },
    {
        554,
        {12791, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {428},
        {12501}
    },
    {
        555,
        {12792, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {431},
        {12504}
    },
    {
        556,
        {12793, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {434},
        {12507}
    },
    {
        557,
        {12791, 12442},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        558,
        {12794, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {439},
        {12512}
    },
    {
        559,
        {12795, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {448},
        {12521}
    },
    {
        560,
        {12796, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {449},
        {12522}
    },
    {
        561,
        {12797, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {450},
        {12523}
    },
    {
        562,
        {12798, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {451},
        {12524}
    },
    {
        563,
        {12799, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {452},
        {12525}
    },
    {
        564,
        {1040, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {564},
        {1040}
    },
    {
        565,
        {1041, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {565},
        {1041}
    },
    {
        566,
        {1042, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {566},
        {1042}
    },
    {
        567,
        {1043, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {567},
        {1043}
    },
    {
        568,
        {1044, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {568},
        {1044}
    },
    {
        569,
        {1045, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {569},
        {1045}
    },
    {
        570,
        {1025, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {570},
        {1025}
    },
    {
        571,
        {1046, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {571},
        {1046}
    },
    {
        572,
        {1047, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {572},
        {1047}
    },
    {
        573,
        {1048, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {573},
        {1048}
    },
    {
        574,
        {1049, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {574},
        {1049}
    },
    {
        575,
        {1050, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {575},
        {1050}
    },
    {
        576,
        {1051, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {576},
        {1051}
    },
    {
        577,
        {1052, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {577},
        {1052}
    },
    {
        578,
        {1053, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {578},
        {1053}
    },
    {
        579,
        {1054, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {579},
        {1054}
    },
    {
        580,
        {1055, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {580},
        {1055}
    },
    {
        581,
        {1056, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {581},
        {1056}
    },
    {
        582,
        {1057, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {582},
        {1057}
    },
    {
        583,
        {1058, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {583},
        {1058}
    },
    {
        584,
        {1059, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {584},
        {1059}
    },
    {
        585,
        {1060, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {585},
        {1060}
    },
    {
        586,
        {1061, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {586},
        {1061}
    },
    {
        587,
        {1062, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {587},
        {1062}
    },
    {
        588,
        {1063, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {588},
        {1063}
    },
    {
        589,
        {1064, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {589},
        {1064}
    },
    {
        590,
        {1065, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {590},
        {1065}
    },
    {
        591,
        {1066, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {591},
        {1066}
    },
    {
        592,
        {1067, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {592},
        {1067}
    },
    {
        593,
        {1068, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {593},
        {1068}
    },
    {
        594,
        {1069, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {594},
        {1069}
    },
    {
        595,
        {1070, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {595},
        {1070}
    },
    {
        596,
        {1071, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {596},
        {1071}
    },
    {
        597,
        {9150, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        598,
        {9151, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        599,
        {9152, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        600,
        {9153, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        601,
        {9154, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        602,
        {9155, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        603,
        {9156, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        604,
        {9157, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        605,
        {9158, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        606,
        {9159, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        607,
        {9160, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        608,
        {9161, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        609,
        {9162, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        610,
        {9163, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        611,
        {9164, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        612,
        {1072, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {612},
        {1072}
    },
    {
        613,
        {1073, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {613},
        {1073}
    },
    {
        614,
        {1074, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {614},
        {1074}
    },
    {
        615,
        {1075, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {615},
        {1075}
    },
    {
        616,
        {1076, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {616},
        {1076}
    },
    {
        617,
        {1077, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {617},
        {1077}
    },
    {
        618,
        {1105, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {618},
        {1105}
    },
    {
        619,
        {1078, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {619},
        {1078}
    },
    {
        620,
        {1079, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {620},
        {1079}
    },
    {
        621,
        {1080, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {621},
        {1080}
    },
    {
        622,
        {1081, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {622},
        {1081}
    },
    {
        623,
        {1082, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {623},
        {1082}
    },
    {
        624,
        {1083, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {624},
        {1083}
    },
    {
        625,
        {1084, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {625},
        {1084}
    },
    {
        626,
        {1085, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {626},
        {1085}
    },
    {
        627,
        {1086, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {627},
        {1086}
    },
    {
        628,
        {1087, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {628},
        {1087}
    },
    {
        629,
        {1088, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {629},
        {1088}
    },
    {
        630,
        {1089, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {630},
        {1089}
    },
    {
        631,
        {1090, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {631},
        {1090}
    },
    {
        632,
        {1091, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {632},
        {1091}
    },
    {
        633,
        {1092, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {633},
        {1092}
    },
    {
        634,
        {1093, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {634},
        {1093}
    },
    {
        635,
        {1094, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {635},
        {1094}
    },
    {
        636,
        {1095, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {636},
        {1095}
    },
    {
        637,
        {1096, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {637},
        {1096}
    },
    {
        638,
        {1097, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {638},
        {1097}
    },
    {
        639,
        {1098, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {639},
        {1098}
    },
    {
        640,
        {1099, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {640},
        {1099}
    },
    {
        641,
        {1100, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {641},
        {1100}
    },
    {
        642,
        {1101, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {642},
        {1101}
    },
    {
        643,
        {1102, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {643},
        {1102}
    },
    {
        644,
        {1103, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {644},
        {1103}
    },
    {
        645,
        {12535, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {454},
        {12527}
    },
    {
        646,
        {12536, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {455},
        {12528}
    },
    {
        647,
        {12537, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {456},
        {12529}
    },
    {
        648,
        {12538, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {457},
        {12530}
    },
    {
        649,
        {8922, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        650,
        {8923, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        651,
        {8531, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        652,
        {8532, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        653,
        {8533, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        654,
        {10003, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        655,
        {8984, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        656,
        {9251, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        657,
        {9166, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        658,
        {9472, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {658},
        {9472}
    },
    {
        659,
        {9474, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {659},
        {9474}
    },
    {
        660,
        {9484, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {660},
        {9484}
    },
    {
        661,
        {9488, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {661},
        {9488}
    },
    {
        662,
        {9496, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {662},
        {9496}
    },
    {
        663,
        {9492, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {663},
        {9492}
    },
    {
        664,
        {9500, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {664},
        {9500}
    },
    {
        665,
        {9516, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {665},
        {9516}
    },
    {
        666,
        {9508, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {666},
        {9508}
    },
    {
        667,
        {9524, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {667},
        {9524}
    },
    {
        668,
        {9532, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {668},
        {9532}
    },
    {
        669,
        {9473, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {669},
        {9473}
    },
    {
        670,
        {9475, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {670},
        {9475}
    },
    {
        671,
        {9487, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {671},
        {9487}
    },
    {
        672,
        {9491, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {672},
        {9491}
    },
    {
        673,
        {9499, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {673},
        {9499}
    },
    {
        674,
        {9495, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {674},
        {9495}
    },
    {
        675,
        {9507, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {675},
        {9507}
    },
    {
        676,
        {9523, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {676},
        {9523}
    },
    {
        677,
        {9515, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {677},
        {9515}
    },
    {
        678,
        {9531, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {678},
        {9531}
    },
    {
        679,
        {9547, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {679},
        {9547}
    },
    {
        680,
        {9504, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {680},
        {9504}
    },
    {
        681,
        {9519, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {681},
        {9519}
    },
    {
        682,
        {9512, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {682},
        {9512}
    },
    {
        683,
        {9527, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {683},
        {9527}
    },
    {
        684,
        {9535, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {684},
        {9535}
    },
    {
        685,
        {9501, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {685},
        {9501}
    },
    {
        686,
        {9520, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {686},
        {9520}
    },
    {
        687,
        {9509, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {687},
        {9509}
    },
    {
        688,
        {9528, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {688},
        {9528}
    },
    {
        689,
        {9538, -1},
        {-1, -1},
        JISCharacterClass_JISX0208_NON_KANJI,
        1,
        {689},
        {9538}
    },
    {
        690,
        {12881, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 204},
        {65298, 65297}
    },
    {
        691,
        {12882, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 205},
        {65298, 65298}
    },
    {
        692,
        {12883, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 206},
        {65298, 65299}
    },
    {
        693,
        {12884, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 207},
        {65298, 65300}
    },
    {
        694,
        {12885, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 208},
        {65298, 65301}
    },
    {
        695,
        {12886, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 209},
        {65298, 65302}
    },
    {
        696,
        {12887, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 210},
        {65298, 65303}
    },
    {
        697,
        {12888, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 211},
        {65298, 65304}
    },
    {
        698,
        {12889, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 212},
        {65298, 65305}
    },
    {
        699,
        {12890, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 203},
        {65299, 65296}
    },
    {
        700,
        {12891, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 204},
        {65299, 65297}
    },
    {
        701,
        {12892, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 205},
        {65299, 65298}
    },
    {
        702,
        {12893, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 206},
        {65299, 65299}
    },
    {
        703,
        {12894, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 207},
        {65299, 65300}
    },
    {
        704,
        {12895, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 208},
        {65299, 65301}
    },
    {
        705,
        {12977, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 209},
        {65299, 65302}
    },
    {
        706,
        {12978, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 210},
        {65299, 65303}
    },
    {
        707,
        {12979, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 211},
        {65299, 65304}
    },
    {
        708,
        {12980, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {206, 212},
        {65299, 65305}
    },
    {
        709,
        {12981, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 203},
        {65300, 65296}
    },
    {
        710,
        {12982, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 204},
        {65300, 65297}
    },
    {
        711,
        {12983, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 205},
        {65300, 65298}
    },
    {
        712,
        {12984, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 206},
        {65300, 65299}
    },
    {
        713,
        {12985, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 207},
        {65300, 65300}
    },
    {
        714,
        {12986, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 208},
        {65300, 65301}
    },
    {
        715,
        {12987, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 209},
        {65300, 65302}
    },
    {
        716,
        {12988, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 210},
        {65300, 65303}
    },
    {
        717,
        {12989, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 211},
        {65300, 65304}
    },
    {
        718,
        {12990, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {207, 212},
        {65300, 65305}
    },
    {
        719,
        {12991, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {208, 203},
        {65301, 65296}
    },
    {
        720,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        721,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        722,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        723,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        724,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        725,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        726,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        727,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        728,
        {9680, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        729,
        {9681, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        730,
        {9682, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        731,
        {9683, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        732,
        {8252, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {9, 9},
        {65281, 65281}
    },
    {
        733,
        {8263, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {8, 8},
        {65311, 65311}
    },
    {
        734,
        {8264, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {8, 9},
        {65311, 65281}
    },
    {
        735,
        {8265, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {9, 8},
        {65281, 65311}
    },
    {
        736,
        {461, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        737,
        {462, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        738,
        {464, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        739,
        {7742, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        740,
        {7743, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        741,
        {504, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        742,
        {505, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        743,
        {465, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        744,
        {466, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        745,
        {468, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        746,
        {470, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        747,
        {472, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        748,
        {474, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        749,
        {476, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        750,
        {8364, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        751,
        {8364, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        752,
        {8364, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        753,
        {160, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {0},
        {12288}
    },
    {
        754,
        {161, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {9},
        {65281}
    },
    {
        755,
        {164, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        756,
        {166, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        757,
        {169, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        758,
        {170, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        759,
        {171, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        760,
        {173, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {29},
        {8208}
    },
    {
        761,
        {174, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {17},
        {65343}
    },
    {
        762,
        {175, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {16},
        {65507}
    },
    {
        763,
        {178, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        764,
        {179, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        765,
        {183, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {5},
        {12539}
    },
    {
        766,
        {184, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {3},
        {65292}
    },
    {
        767,
        {185, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        768,
        {186, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        769,
        {187, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        770,
        {188, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        771,
        {189, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        772,
        {190, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        773,
        {191, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {8},
        {65311}
    },
    {
        774,
        {192, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        775,
        {193, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        776,
        {194, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        777,
        {195, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        778,
        {196, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        779,
        {197, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        780,
        {198, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        781,
        {199, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        782,
        {200, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        783,
        {201, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        784,
        {202, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        785,
        {203, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        786,
        {204, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        787,
        {205, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        788,
        {206, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        789,
        {207, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        790,
        {208, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        791,
        {209, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        792,
        {210, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        793,
        {211, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        794,
        {212, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        795,
        {213, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        796,
        {214, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        797,
        {216, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        798,
        {217, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        799,
        {218, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        800,
        {219, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        801,
        {220, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        802,
        {221, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        803,
        {222, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        804,
        {223, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        805,
        {224, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        806,
        {225, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        807,
        {226, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        808,
        {227, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        809,
        {228, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        810,
        {229, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        811,
        {230, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        812,
        {231, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        813,
        {232, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        814,
        {233, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {256},
        {65349}
    },
    {
        815,
        {234, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        816,
        {235, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        817,
        {236, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        818,
        {237, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        819,
        {238, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        820,
        {239, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        821,
        {240, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        822,
        {241, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        823,
        {242, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        824,
        {243, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        825,
        {244, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        826,
        {245, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {266},
        {65359}
    },
    {
        827,
        {246, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        828,
        {248, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        829,
        {249, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        830,
        {250, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        831,
        {251, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        832,
        {252, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        833,
        {253, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        834,
        {254, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        835,
        {255, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        836,
        {256, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        837,
        {298, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        838,
        {362, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        839,
        {274, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        840,
        {332, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        841,
        {257, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        842,
        {299, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        843,
        {363, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        844,
        {275, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        845,
        {333, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        846,
        {260, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        847,
        {728, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        848,
        {321, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        849,
        {317, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        850,
        {346, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        851,
        {352, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        852,
        {350, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        853,
        {356, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        854,
        {377, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        855,
        {381, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        856,
        {379, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        857,
        {261, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        858,
        {731, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        859,
        {322, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        860,
        {318, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        861,
        {347, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        862,
        {711, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        863,
        {353, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        864,
        {351, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        865,
        {357, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        866,
        {378, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        867,
        {733, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        868,
        {382, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        869,
        {380, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        870,
        {340, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        871,
        {258, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        872,
        {313, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        873,
        {262, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        874,
        {268, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        875,
        {280, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        876,
        {282, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        877,
        {270, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        878,
        {323, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        879,
        {327, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        880,
        {336, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        881,
        {344, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        882,
        {366, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        883,
        {368, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        884,
        {354, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        885,
        {341, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        886,
        {259, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        887,
        {314, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        888,
        {263, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        889,
        {269, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        890,
        {281, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        891,
        {283, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        892,
        {271, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        893,
        {273, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        894,
        {324, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        895,
        {328, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        896,
        {337, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        897,
        {345, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        898,
        {367, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        899,
        {369, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        900,
        {355, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        901,
        {729, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        902,
        {264, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        903,
        {284, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        904,
        {292, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        905,
        {308, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        906,
        {348, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        907,
        {364, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        908,
        {265, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        909,
        {285, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        910,
        {293, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        911,
        {309, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        912,
        {349, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        913,
        {365, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        914,
        {625, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        915,
        {651, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        916,
        {638, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        917,
        {643, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        918,
        {658, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        919,
        {620, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        920,
        {622, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        921,
        {633, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        922,
        {648, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        923,
        {598, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        924,
        {627, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        925,
        {637, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        926,
        {642, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        927,
        {656, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        928,
        {635, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        929,
        {621, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        930,
        {607, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        931,
        {626, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        932,
        {669, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        933,
        {654, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        934,
        {609, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        935,
        {331, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        936,
        {624, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        937,
        {641, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        938,
        {295, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        939,
        {661, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        940,
        {660, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        941,
        {614, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        942,
        {664, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        943,
        {450, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        944,
        {595, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        945,
        {599, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        946,
        {644, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        947,
        {608, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        948,
        {403, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        949,
        {339, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        950,
        {338, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        951,
        {616, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        952,
        {649, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        953,
        {600, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        954,
        {629, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        955,
        {601, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        956,
        {604, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        957,
        {606, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        958,
        {592, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        959,
        {623, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        960,
        {650, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        961,
        {612, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        962,
        {652, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        963,
        {596, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        964,
        {593, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        965,
        {594, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        966,
        {653, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        967,
        {613, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        968,
        {674, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        969,
        {673, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        970,
        {597, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        971,
        {657, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        972,
        {634, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        973,
        {615, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        974,
        {602, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        975,
        {230, 768},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        976,
        {509, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        977,
        {8048, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        978,
        {8049, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        979,
        {596, 768},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        980,
        {596, 769},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        981,
        {652, 768},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        982,
        {652, 769},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        983,
        {601, 768},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        984,
        {601, 769},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        985,
        {602, 768},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        986,
        {602, 769},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        987,
        {8050, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        988,
        {8051, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        989,
        {865, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        990,
        {712, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        991,
        {716, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        992,
        {720, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        993,
        {721, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        994,
        {774, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        995,
        {8255, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        996,
        {779, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        997,
        {769, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        998,
        {772, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        999,
        {768, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1000,
        {783, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1001,
        {780, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1002,
        {770, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1003,
        {741, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1004,
        {742, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1005,
        {743, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1006,
        {744, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1007,
        {745, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1008,
        {745, 741},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1009,
        {741, 745},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1010,
        {805, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1011,
        {812, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1012,
        {825, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1013,
        {796, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1014,
        {799, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1015,
        {800, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1016,
        {776, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1017,
        {829, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1018,
        {809, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1019,
        {815, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1020,
        {734, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1021,
        {804, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1022,
        {816, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {32},
        {65374}
    },
    {
        1023,
        {828, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1024,
        {820, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {32},
        {65374}
    },
    {
        1025,
        {797, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1026,
        {798, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1027,
        {792, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1028,
        {793, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1029,
        {810, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1030,
        {826, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1031,
        {827, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1032,
        {771, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {32},
        {65374}
    },
    {
        1033,
        {794, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1034,
        {10102, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {204},
        {65297}
    },
    {
        1035,
        {10103, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {205},
        {65298}
    },
    {
        1036,
        {10104, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {206},
        {65299}
    },
    {
        1037,
        {10105, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {207},
        {65300}
    },
    {
        1038,
        {10106, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {208},
        {65301}
    },
    {
        1039,
        {10107, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {209},
        {65302}
    },
    {
        1040,
        {10108, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {210},
        {65303}
    },
    {
        1041,
        {10109, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {211},
        {65304}
    },
    {
        1042,
        {10110, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {212},
        {65305}
    },
    {
        1043,
        {10111, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 203},
        {65297, 65296}
    },
    {
        1044,
        {9451, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 204},
        {65297, 65297}
    },
    {
        1045,
        {9452, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 205},
        {65297, 65298}
    },
    {
        1046,
        {9453, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 206},
        {65297, 65299}
    },
    {
        1047,
        {9454, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 207},
        {65297, 65300}
    },
    {
        1048,
        {9455, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 208},
        {65297, 65301}
    },
    {
        1049,
        {9456, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 209},
        {65297, 65302}
    },
    {
        1050,
        {9457, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 210},
        {65297, 65303}
    },
    {
        1051,
        {9458, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 211},
        {65297, 65304}
    },
    {
        1052,
        {9459, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 212},
        {65297, 65305}
    },
    {
        1053,
        {9460, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 203},
        {65298, 65296}
    },
    {
        1054,
        {8560, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {260},
        {65353}
    },
    {
        1055,
        {8561, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {260, 260},
        {65353, 65353}
    },
    {
        1056,
        {8562, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {260, 260, 260},
        {65353, 65353, 65353}
    },
    {
        1057,
        {8563, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {260, 273},
        {65353, 65366}
    },
    {
        1058,
        {8564, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {273},
        {65366}
    },
    {
        1059,
        {8565, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {273, 260},
        {65366, 65353}
    },
    {
        1060,
        {8566, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {273, 260, 260},
        {65366, 65353, 65353}
    },
    {
        1061,
        {8567, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        4,
        {273, 260, 260, 260},
        {65366, 65353, 65353, 65353}
    },
    {
        1062,
        {8568, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {260, 275},
        {65353, 65368}
    },
    {
        1063,
        {8569, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {275},
        {65368}
    },
    {
        1064,
        {8570, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {275, 260},
        {65368, 65353}
    },
    {
        1065,
        {8571, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {275, 260, 260},
        {65368, 65353, 65353}
    },
    {
        1066,
        {9424, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {252},
        {65345}
    },
    {
        1067,
        {9425, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {253},
        {65346}
    },
    {
        1068,
        {9426, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {254},
        {65347}
    },
    {
        1069,
        {9427, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {255},
        {65348}
    },
    {
        1070,
        {9428, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {256},
        {65349}
    },
    {
        1071,
        {9429, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {257},
        {65350}
    },
    {
        1072,
        {9430, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {258},
        {65351}
    },
    {
        1073,
        {9431, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {259},
        {65352}
    },
    {
        1074,
        {9432, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {260},
        {65353}
    },
    {
        1075,
        {9433, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {261},
        {65354}
    },
    {
        1076,
        {9434, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {262},
        {65355}
    },
    {
        1077,
        {9435, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {263},
        {65356}
    },
    {
        1078,
        {9436, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {264},
        {65357}
    },
    {
        1079,
        {9437, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {265},
        {65358}
    },
    {
        1080,
        {9438, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {266},
        {65359}
    },
    {
        1081,
        {9439, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {267},
        {65360}
    },
    {
        1082,
        {9440, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {268},
        {65361}
    },
    {
        1083,
        {9441, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {269},
        {65362}
    },
    {
        1084,
        {9442, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {270},
        {65363}
    },
    {
        1085,
        {9443, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {271},
        {65364}
    },
    {
        1086,
        {9444, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {272},
        {65365}
    },
    {
        1087,
        {9445, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {273},
        {65366}
    },
    {
        1088,
        {9446, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {274},
        {65367}
    },
    {
        1089,
        {9447, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {275},
        {65368}
    },
    {
        1090,
        {9448, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {276},
        {65369}
    },
    {
        1091,
        {9449, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {277},
        {65370}
    },
    {
        1092,
        {13008, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {377},
        {12450}
    },
    {
        1093,
        {13009, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {379},
        {12452}
    },
    {
        1094,
        {13010, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {381},
        {12454}
    },
    {
        1095,
        {13011, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {383},
        {12456}
    },
    {
        1096,
        {13012, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {385},
        {12458}
    },
    {
        1097,
        {13013, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {386},
        {12459}
    },
    {
        1098,
        {13014, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {388},
        {12461}
    },
    {
        1099,
        {13015, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {390},
        {12463}
    },
    {
        1100,
        {13016, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {392},
        {12465}
    },
    {
        1101,
        {13017, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {394},
        {12467}
    },
    {
        1102,
        {13018, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {396},
        {12469}
    },
    {
        1103,
        {13019, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {398},
        {12471}
    },
    {
        1104,
        {13020, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {400},
        {12473}
    },
    {
        1105,
        {13021, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {402},
        {12475}
    },
    {
        1106,
        {13022, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {404},
        {12477}
    },
    {
        1107,
        {13023, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {406},
        {12479}
    },
    {
        1108,
        {13024, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {408},
        {12481}
    },
    {
        1109,
        {13025, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {411},
        {12484}
    },
    {
        1110,
        {13026, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {413},
        {12486}
    },
    {
        1111,
        {13027, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {415},
        {12488}
    },
    {
        1112,
        {13050, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {452},
        {12525}
    },
    {
        1113,
        {13033, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {422},
        {12495}
    },
    {
        1114,
        {13029, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {418},
        {12491}
    },
    {
        1115,
        {13037, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {434},
        {12507}
    },
    {
        1116,
        {13036, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {431},
        {12504}
    },
    {
        1117,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1118,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1119,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1120,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1121,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1122,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1123,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1124,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1125,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1126,
        {8273, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1127,
        {8258, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1128,
        {9312, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {204},
        {65297}
    },
    {
        1129,
        {9313, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {205},
        {65298}
    },
    {
        1130,
        {9314, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {206},
        {65299}
    },
    {
        1131,
        {9315, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {207},
        {65300}
    },
    {
        1132,
        {9316, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {208},
        {65301}
    },
    {
        1133,
        {9317, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {209},
        {65302}
    },
    {
        1134,
        {9318, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {210},
        {65303}
    },
    {
        1135,
        {9319, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {211},
        {65304}
    },
    {
        1136,
        {9320, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {212},
        {65305}
    },
    {
        1137,
        {9321, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 203},
        {65297, 65296}
    },
    {
        1138,
        {9322, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 204},
        {65297, 65297}
    },
    {
        1139,
        {9323, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 205},
        {65297, 65298}
    },
    {
        1140,
        {9324, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 206},
        {65297, 65299}
    },
    {
        1141,
        {9325, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 207},
        {65297, 65300}
    },
    {
        1142,
        {9326, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 208},
        {65297, 65301}
    },
    {
        1143,
        {9327, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 209},
        {65297, 65302}
    },
    {
        1144,
        {9328, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 210},
        {65297, 65303}
    },
    {
        1145,
        {9329, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 211},
        {65297, 65304}
    },
    {
        1146,
        {9330, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {204, 212},
        {65297, 65305}
    },
    {
        1147,
        {9331, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {205, 203},
        {65298, 65296}
    },
    {
        1148,
        {8544, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {228},
        {65321}
    },
    {
        1149,
        {8545, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {228, 228},
        {65321, 65321}
    },
    {
        1150,
        {8546, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {228, 228, 228},
        {65321, 65321, 65321}
    },
    {
        1151,
        {8547, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {228, 241},
        {65321, 65334}
    },
    {
        1152,
        {8548, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {241},
        {65334}
    },
    {
        1153,
        {8549, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {241, 228},
        {65334, 65321}
    },
    {
        1154,
        {8550, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {241, 228, 228},
        {65334, 65321, 65321}
    },
    {
        1155,
        {8551, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        4,
        {241, 228, 228, 228},
        {65334, 65321, 65321, 65321}
    },
    {
        1156,
        {8552, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {228, 243},
        {65321, 65336}
    },
    {
        1157,
        {8553, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {243},
        {65336}
    },
    {
        1158,
        {8554, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        2,
        {243, 228},
        {65336, 65321}
    },
    {
        1159,
        {13129, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1160,
        {13076, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1161,
        {13090, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1162,
        {13133, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1163,
        {13080, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1164,
        {13095, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1165,
        {13059, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1166,
        {13110, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1167,
        {13137, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1168,
        {13143, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1169,
        {13069, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1170,
        {13094, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1171,
        {13091, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1172,
        {13099, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1173,
        {13130, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1174,
        {13115, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1175,
        {13212, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1176,
        {13213, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1177,
        {13214, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1178,
        {13198, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1179,
        {13199, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1180,
        {13252, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1181,
        {13217, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1182,
        {8555, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {243, 228, 228},
        {65336, 65321, 65321}
    },
    {
        1183,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1184,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1185,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1186,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1187,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1188,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1189,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1190,
        {13179, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1191,
        {12317, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {39},
        {8220}
    },
    {
        1192,
        {12319, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        1,
        {40},
        {8221}
    },
    {
        1193,
        {8470, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {233, 266, 4},
        {65326, 65359, 65294}
    },
    {
        1194,
        {13261, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1195,
        {8481, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1196,
        {12964, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1197,
        {12965, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1198,
        {12966, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1199,
        {12967, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1200,
        {12968, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1201,
        {12849, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {41, 1775, 42},
        {65288, 26666, 65289}
    },
    {
        1202,
        {12850, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {41, 4148, 42},
        {65288, 26377, 65289}
    },
    {
        1203,
        {12857, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        3,
        {41, 3170, 42},
        {65288, 20195, 65289}
    },
    {
        1204,
        {13182, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1205,
        {13181, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1206,
        {13180, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1207,
        {8750, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1208,
        {8750, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1209,
        {8750, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1210,
        {8750, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1211,
        {8735, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1212,
        {8735, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1213,
        {8735, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1214,
        {8735, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1215,
        {8735, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1216,
        {8895, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1217,
        {10070, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1218,
        {10070, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1219,
        {10070, -1},
        {-1, -1},
        JISCharacterClass_RESERVED,
        0,
        {0},
        {0}
    },
    {
        1220,
        {10070, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1221,
        {9758, -1},
        {-1, -1},
        JISCharacterClass_JISX0213_NON_KANJI,
        0,
        {0},
        {0}
    },
    {
        1222,
        {20465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2043},
        {20534}
    },
    {
        1223,
        {131083, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2795},
        {19976}
    },
    {
        1224,
        {13314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1863},
        {21916}
    },
    {
        1225,
        {20008, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1226,
        {20015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1227,
        {20016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1228,
        {20109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1229,
        {20193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1230,
        {20221, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3803},
        {25996}
    },
    {
        1231,
        {20223, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1232,
        {20227, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1233,
        {20235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1234,
        {20320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4972},
        {23571}
    },
    {
        1235,
        {20296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1236,
        {20297, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1237,
        {20310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1238,
        {20319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1239,
        {20330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1240,
        {20332, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1241,
        {20350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1242,
        {20362, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1243,
        {20372, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1244,
        {20375, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1245,
        {64048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3837},
        {20398}
    },
    {
        1246,
        {20425, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1247,
        {20448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1975},
        {20384}
    },
    {
        1248,
        {20481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1249,
        {20482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3880},
        {20341}
    },
    {
        1250,
        {20494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1251,
        {20504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1252,
        {20519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1253,
        {20526, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1254,
        {20544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1552},
        {33521}
    },
    {
        1255,
        {20539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1256,
        {20545, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {6245},
        {31281}
    },
    {
        1257,
        {20628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1258,
        {20684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1259,
        {20722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4513},
        {20682}
    },
    {
        1260,
        {20688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1261,
        {20710, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1262,
        {64049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3053},
        {20711}
    },
    {
        1263,
        {20742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1264,
        {20739, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1265,
        {20747, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1266,
        {20766, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2541},
        {29246}
    },
    {
        1267,
        {20789, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1268,
        {20810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4539},
        {20812}
    },
    {
        1269,
        {64050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4081},
        {20813}
    },
    {
        1270,
        {20821, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1271,
        {20823, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1272,
        {13493, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {6115},
        {30339}
    },
    {
        1273,
        {20893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1904},
        {23452}
    },
    {
        1274,
        {20931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1275,
        {20938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1276,
        {20958, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5898},
        {29064}
    },
    {
        1277,
        {20962, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4009},
        {20961}
    },
    {
        1278,
        {20974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3846},
        {39080}
    },
    {
        1279,
        {20993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1280,
        {13531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2250},
        {21151}
    },
    {
        1281,
        {21011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1282,
        {21013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1283,
        {21065, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1284,
        {21079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1285,
        {21089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1286,
        {21139, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1287,
        {21192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4141},
        {21191}
    },
    {
        1288,
        {64051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3910},
        {21193}
    },
    {
        1289,
        {21196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1290,
        {21200, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4093},
        {29467}
    },
    {
        1291,
        {21206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4613},
        {21207}
    },
    {
        1292,
        {21211, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4619},
        {21235}
    },
    {
        1293,
        {64052, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2021},
        {21220}
    },
    {
        1294,
        {21232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1295,
        {21243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1296,
        {21248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1297,
        {21255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4623},
        {21254}
    },
    {
        1298,
        {21276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1299,
        {64053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3725},
        {21329}
    },
    {
        1300,
        {21345, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1301,
        {21347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1302,
        {21373, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3109},
        {21363}
    },
    {
        1303,
        {21395, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1304,
        {21405, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1305,
        {21426, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1306,
        {21522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4702},
        {21668}
    },
    {
        1307,
        {21543, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1308,
        {21581, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4668},
        {21565}
    },
    {
        1309,
        {21660, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4702},
        {21668}
    },
    {
        1310,
        {21611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1311,
        {21620, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1312,
        {21631, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1313,
        {21640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1314,
        {21654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1315,
        {21665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1316,
        {21673, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1317,
        {21702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1318,
        {21759, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1319,
        {21774, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1320,
        {21803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1321,
        {21813, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1322,
        {21840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1323,
        {21854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1411},
        {21782}
    },
    {
        1324,
        {21889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1325,
        {21894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3398},
        {21746}
    },
    {
        1326,
        {21902, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4704},
        {21692}
    },
    {
        1327,
        {64054, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1760},
        {21917}
    },
    {
        1328,
        {21933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1329,
        {21966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3616},
        {32629}
    },
    {
        1330,
        {64055, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3213},
        {22022}
    },
    {
        1331,
        {22024, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1332,
        {22030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1333,
        {22075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1334,
        {22089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4722},
        {21846}
    },
    {
        1335,
        {22134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1336,
        {22118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1337,
        {64056, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1864},
        {22120}
    },
    {
        1338,
        {22127, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1339,
        {22129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1340,
        {22130, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1341,
        {22169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1781},
        {22107}
    },
    {
        1342,
        {22174, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3398},
        {21746}
    },
    {
        1343,
        {22185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1344,
        {22188, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1345,
        {22195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1346,
        {22217, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1347,
        {22218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3596},
        {22178}
    },
    {
        1348,
        {22282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1349,
        {135741, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3441},
        {22303}
    },
    {
        1350,
        {22305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3441},
        {22303}
    },
    {
        1351,
        {22319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1352,
        {22323, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1353,
        {22324, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1354,
        {22384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1355,
        {22391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1356,
        {22396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1357,
        {22428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1358,
        {64015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1359,
        {135963, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4119},
        {37326}
    },
    {
        1360,
        {22456, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1361,
        {22471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1362,
        {22472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1363,
        {22479, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1364,
        {22500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1365,
        {22509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1366,
        {22517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1367,
        {22518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1368,
        {22527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3388},
        {27877}
    },
    {
        1369,
        {22537, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1370,
        {64016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3334},
        {22618}
    },
    {
        1371,
        {22625, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3405},
        {22635}
    },
    {
        1372,
        {22628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1373,
        {64057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3882},
        {22592}
    },
    {
        1374,
        {22652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1375,
        {22665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1376,
        {22686, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3100},
        {22679}
    },
    {
        1377,
        {64058, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3994},
        {22696}
    },
    {
        1378,
        {22697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1379,
        {136302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1380,
        {22738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1381,
        {22734, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1382,
        {22740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1383,
        {22746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1384,
        {22752, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4859},
        {22751}
    },
    {
        1385,
        {22761, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1386,
        {22796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1387,
        {34369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1388,
        {22877, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1389,
        {22893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1390,
        {22923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1391,
        {22930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3425},
        {22956}
    },
    {
        1392,
        {22948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1393,
        {22979, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1394,
        {22994, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1395,
        {23005, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1396,
        {23059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1397,
        {23075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1398,
        {23143, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1399,
        {23149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1400,
        {23159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1401,
        {23166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1402,
        {23172, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1403,
        {23198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1404,
        {23207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1405,
        {23236, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1406,
        {137405, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1407,
        {23321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1408,
        {23333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        1409,
        {21085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3648},
        {21093}
    },
    {
        1410,
        {20124, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1410},
        {20124}
    },
    {
        1411,
        {21782, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1411},
        {21782}
    },
    {
        1412,
        {23043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1412},
        {23043}
    },
    {
        1413,
        {38463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1413},
        {38463}
    },
    {
        1414,
        {21696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1414},
        {21696}
    },
    {
        1415,
        {24859, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1415},
        {24859}
    },
    {
        1416,
        {25384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1416},
        {25384}
    },
    {
        1417,
        {23030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1417},
        {23030}
    },
    {
        1418,
        {36898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1418},
        {36898}
    },
    {
        1419,
        {33909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1419},
        {33909}
    },
    {
        1420,
        {33564, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1420},
        {33564}
    },
    {
        1421,
        {31312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1421},
        {31312}
    },
    {
        1422,
        {24746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1422},
        {24746}
    },
    {
        1423,
        {25569, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1423},
        {25569}
    },
    {
        1424,
        {28197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1424},
        {28197}
    },
    {
        1425,
        {26093, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1425},
        {26093}
    },
    {
        1426,
        {33894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1426},
        {33894}
    },
    {
        1427,
        {33446, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1427},
        {33446}
    },
    {
        1428,
        {39925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1428},
        {39925}
    },
    {
        1429,
        {26771, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1429},
        {26771}
    },
    {
        1430,
        {22311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1430},
        {22311}
    },
    {
        1431,
        {26017, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1431},
        {26017}
    },
    {
        1432,
        {25201, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1432},
        {25201}
    },
    {
        1433,
        {23451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1433},
        {23451}
    },
    {
        1434,
        {22992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1434},
        {22992}
    },
    {
        1435,
        {34427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1435},
        {34427}
    },
    {
        1436,
        {39156, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1436},
        {39156}
    },
    {
        1437,
        {32098, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1437},
        {32098}
    },
    {
        1438,
        {32190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1438},
        {32190}
    },
    {
        1439,
        {39822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1439},
        {39822}
    },
    {
        1440,
        {25110, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1440},
        {25110}
    },
    {
        1441,
        {31903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1441},
        {31903}
    },
    {
        1442,
        {34999, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1442},
        {34999}
    },
    {
        1443,
        {23433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1443},
        {23433}
    },
    {
        1444,
        {24245, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1444},
        {24245}
    },
    {
        1445,
        {25353, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1445},
        {25353}
    },
    {
        1446,
        {26263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1446},
        {26263}
    },
    {
        1447,
        {26696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1447},
        {26696}
    },
    {
        1448,
        {38343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1448},
        {38343}
    },
    {
        1449,
        {38797, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1449},
        {38797}
    },
    {
        1450,
        {26447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1450},
        {26447}
    },
    {
        1451,
        {20197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1451},
        {20197}
    },
    {
        1452,
        {20234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1452},
        {20234}
    },
    {
        1453,
        {20301, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1453},
        {20301}
    },
    {
        1454,
        {20381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1454},
        {20381}
    },
    {
        1455,
        {20553, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1455},
        {20553}
    },
    {
        1456,
        {22258, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1456},
        {22258}
    },
    {
        1457,
        {22839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1457},
        {22839}
    },
    {
        1458,
        {22996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1458},
        {22996}
    },
    {
        1459,
        {23041, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1459},
        {23041}
    },
    {
        1460,
        {23561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1460},
        {23561}
    },
    {
        1461,
        {24799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1461},
        {24799}
    },
    {
        1462,
        {24847, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1462},
        {24847}
    },
    {
        1463,
        {24944, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1463},
        {24944}
    },
    {
        1464,
        {26131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1464},
        {26131}
    },
    {
        1465,
        {26885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1465},
        {26885}
    },
    {
        1466,
        {28858, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1466},
        {28858}
    },
    {
        1467,
        {30031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1467},
        {30031}
    },
    {
        1468,
        {30064, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1468},
        {30064}
    },
    {
        1469,
        {31227, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1469},
        {31227}
    },
    {
        1470,
        {32173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1470},
        {32173}
    },
    {
        1471,
        {32239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1471},
        {32239}
    },
    {
        1472,
        {32963, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1472},
        {32963}
    },
    {
        1473,
        {33806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1473},
        {33806}
    },
    {
        1474,
        {34915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1474},
        {34915}
    },
    {
        1475,
        {35586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1475},
        {35586}
    },
    {
        1476,
        {36949, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1476},
        {36949}
    },
    {
        1477,
        {36986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1477},
        {36986}
    },
    {
        1478,
        {21307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1478},
        {21307}
    },
    {
        1479,
        {20117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1479},
        {20117}
    },
    {
        1480,
        {20133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1480},
        {20133}
    },
    {
        1481,
        {22495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1481},
        {22495}
    },
    {
        1482,
        {32946, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1482},
        {32946}
    },
    {
        1483,
        {37057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1483},
        {37057}
    },
    {
        1484,
        {30959, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1484},
        {30959}
    },
    {
        1485,
        {19968, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1485},
        {19968}
    },
    {
        1486,
        {22769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1486},
        {22769}
    },
    {
        1487,
        {28322, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1487},
        {28322}
    },
    {
        1488,
        {36920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1488},
        {36920}
    },
    {
        1489,
        {31282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1489},
        {31282}
    },
    {
        1490,
        {33576, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1490},
        {33576}
    },
    {
        1491,
        {33419, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1491},
        {33419}
    },
    {
        1492,
        {39983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1492},
        {39983}
    },
    {
        1493,
        {20801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1493},
        {20801}
    },
    {
        1494,
        {21360, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1494},
        {21360}
    },
    {
        1495,
        {21693, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1495},
        {21693}
    },
    {
        1496,
        {21729, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1496},
        {21729}
    },
    {
        1497,
        {22240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1497},
        {22240}
    },
    {
        1498,
        {23035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1498},
        {23035}
    },
    {
        1499,
        {24341, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1499},
        {24341}
    },
    {
        1500,
        {39154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1500},
        {39154}
    },
    {
        1501,
        {28139, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1501},
        {28139}
    },
    {
        1502,
        {32996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1502},
        {32996}
    },
    {
        1503,
        {34093, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1503},
        {34093}
    },
    {
        1504,
        {38498, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1504},
        {38498}
    },
    {
        1505,
        {38512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1505},
        {38512}
    },
    {
        1506,
        {38560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1506},
        {38560}
    },
    {
        1507,
        {38907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1507},
        {38907}
    },
    {
        1508,
        {21515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1508},
        {21515}
    },
    {
        1509,
        {21491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1509},
        {21491}
    },
    {
        1510,
        {23431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1510},
        {23431}
    },
    {
        1511,
        {28879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1511},
        {28879}
    },
    {
        1512,
        {32701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1512},
        {32701}
    },
    {
        1513,
        {36802, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1513},
        {36802}
    },
    {
        1514,
        {38632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1514},
        {38632}
    },
    {
        1515,
        {21359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1515},
        {21359}
    },
    {
        1516,
        {40284, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1516},
        {40284}
    },
    {
        1517,
        {31418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1517},
        {31418}
    },
    {
        1518,
        {19985, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1518},
        {19985}
    },
    {
        1519,
        {30867, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1519},
        {30867}
    },
    {
        1520,
        {33276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1520},
        {33276}
    },
    {
        1521,
        {28198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1521},
        {28198}
    },
    {
        1522,
        {22040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1522},
        {22040}
    },
    {
        1523,
        {21764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1523},
        {21764}
    },
    {
        1524,
        {27421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1524},
        {27421}
    },
    {
        1525,
        {34074, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1525},
        {34074}
    },
    {
        1526,
        {39995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1526},
        {39995}
    },
    {
        1527,
        {23013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1527},
        {23013}
    },
    {
        1528,
        {21417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1528},
        {21417}
    },
    {
        1529,
        {28006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1529},
        {28006}
    },
    {
        1530,
        {29916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1530},
        {29916}
    },
    {
        1531,
        {38287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1531},
        {38287}
    },
    {
        1532,
        {22082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1532},
        {22082}
    },
    {
        1533,
        {20113, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1533},
        {20113}
    },
    {
        1534,
        {36939, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1534},
        {36939}
    },
    {
        1535,
        {38642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1535},
        {38642}
    },
    {
        1536,
        {33615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1536},
        {33615}
    },
    {
        1537,
        {39180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1537},
        {39180}
    },
    {
        1538,
        {21473, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1538},
        {21473}
    },
    {
        1539,
        {21942, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1539},
        {21942}
    },
    {
        1540,
        {23344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1540},
        {23344}
    },
    {
        1541,
        {24433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1541},
        {24433}
    },
    {
        1542,
        {26144, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1542},
        {26144}
    },
    {
        1543,
        {26355, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1543},
        {26355}
    },
    {
        1544,
        {26628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1544},
        {26628}
    },
    {
        1545,
        {27704, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1545},
        {27704}
    },
    {
        1546,
        {27891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1546},
        {27891}
    },
    {
        1547,
        {27945, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1547},
        {27945}
    },
    {
        1548,
        {29787, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1548},
        {29787}
    },
    {
        1549,
        {30408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1549},
        {30408}
    },
    {
        1550,
        {31310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1550},
        {31310}
    },
    {
        1551,
        {38964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1551},
        {38964}
    },
    {
        1552,
        {33521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1552},
        {33521}
    },
    {
        1553,
        {34907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1553},
        {34907}
    },
    {
        1554,
        {35424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1554},
        {35424}
    },
    {
        1555,
        {37613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1555},
        {37613}
    },
    {
        1556,
        {28082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1556},
        {28082}
    },
    {
        1557,
        {30123, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1557},
        {30123}
    },
    {
        1558,
        {30410, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1558},
        {30410}
    },
    {
        1559,
        {39365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1559},
        {39365}
    },
    {
        1560,
        {24742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1560},
        {24742}
    },
    {
        1561,
        {35585, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1561},
        {35585}
    },
    {
        1562,
        {36234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1562},
        {36234}
    },
    {
        1563,
        {38322, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1563},
        {38322}
    },
    {
        1564,
        {27022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1564},
        {27022}
    },
    {
        1565,
        {21421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1565},
        {21421}
    },
    {
        1566,
        {20870, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1566},
        {20870}
    },
    {
        1567,
        {22290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1567},
        {22290}
    },
    {
        1568,
        {22576, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1568},
        {22576}
    },
    {
        1569,
        {22852, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1569},
        {22852}
    },
    {
        1570,
        {23476, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1570},
        {23476}
    },
    {
        1571,
        {24310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1571},
        {24310}
    },
    {
        1572,
        {24616, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1572},
        {24616}
    },
    {
        1573,
        {25513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1573},
        {25513}
    },
    {
        1574,
        {25588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1574},
        {25588}
    },
    {
        1575,
        {27839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1575},
        {27839}
    },
    {
        1576,
        {28436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1576},
        {28436}
    },
    {
        1577,
        {28814, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1577},
        {28814}
    },
    {
        1578,
        {28948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1578},
        {28948}
    },
    {
        1579,
        {29017, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1579},
        {29017}
    },
    {
        1580,
        {29141, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1580},
        {29141}
    },
    {
        1581,
        {29503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1581},
        {29503}
    },
    {
        1582,
        {32257, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1582},
        {32257}
    },
    {
        1583,
        {33398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1583},
        {33398}
    },
    {
        1584,
        {33489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1584},
        {33489}
    },
    {
        1585,
        {34199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1585},
        {34199}
    },
    {
        1586,
        {36960, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1586},
        {36960}
    },
    {
        1587,
        {37467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1587},
        {37467}
    },
    {
        1588,
        {40219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1588},
        {40219}
    },
    {
        1589,
        {22633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1589},
        {22633}
    },
    {
        1590,
        {26044, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1590},
        {26044}
    },
    {
        1591,
        {27738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1591},
        {27738}
    },
    {
        1592,
        {29989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1592},
        {29989}
    },
    {
        1593,
        {20985, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1593},
        {20985}
    },
    {
        1594,
        {22830, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1594},
        {22830}
    },
    {
        1595,
        {22885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1595},
        {22885}
    },
    {
        1596,
        {24448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1596},
        {24448}
    },
    {
        1597,
        {24540, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1597},
        {24540}
    },
    {
        1598,
        {25276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1598},
        {25276}
    },
    {
        1599,
        {26106, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1599},
        {26106}
    },
    {
        1600,
        {27178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1600},
        {27178}
    },
    {
        1601,
        {27431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1601},
        {27431}
    },
    {
        1602,
        {27572, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1602},
        {27572}
    },
    {
        1603,
        {29579, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1603},
        {29579}
    },
    {
        1604,
        {32705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1604},
        {32705}
    },
    {
        1605,
        {35158, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1605},
        {35158}
    },
    {
        1606,
        {40236, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1606},
        {40236}
    },
    {
        1607,
        {40206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1607},
        {40206}
    },
    {
        1608,
        {40644, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1608},
        {40644}
    },
    {
        1609,
        {23713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1609},
        {23713}
    },
    {
        1610,
        {27798, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1610},
        {27798}
    },
    {
        1611,
        {33659, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1611},
        {33659}
    },
    {
        1612,
        {20740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1612},
        {20740}
    },
    {
        1613,
        {23627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1613},
        {23627}
    },
    {
        1614,
        {25014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1614},
        {25014}
    },
    {
        1615,
        {33222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1615},
        {33222}
    },
    {
        1616,
        {26742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1616},
        {26742}
    },
    {
        1617,
        {29281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1617},
        {29281}
    },
    {
        1618,
        {20057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1618},
        {20057}
    },
    {
        1619,
        {20474, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1619},
        {20474}
    },
    {
        1620,
        {21368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1620},
        {21368}
    },
    {
        1621,
        {24681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1621},
        {24681}
    },
    {
        1622,
        {28201, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1622},
        {28201}
    },
    {
        1623,
        {31311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1623},
        {31311}
    },
    {
        1624,
        {38899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1624},
        {38899}
    },
    {
        1625,
        {19979, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1625},
        {19979}
    },
    {
        1626,
        {21270, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1626},
        {21270}
    },
    {
        1627,
        {20206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1627},
        {20206}
    },
    {
        1628,
        {20309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1628},
        {20309}
    },
    {
        1629,
        {20285, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1629},
        {20285}
    },
    {
        1630,
        {20385, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1630},
        {20385}
    },
    {
        1631,
        {20339, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1631},
        {20339}
    },
    {
        1632,
        {21152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1632},
        {21152}
    },
    {
        1633,
        {21487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1633},
        {21487}
    },
    {
        1634,
        {22025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1634},
        {22025}
    },
    {
        1635,
        {22799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1635},
        {22799}
    },
    {
        1636,
        {23233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1636},
        {23233}
    },
    {
        1637,
        {23478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1637},
        {23478}
    },
    {
        1638,
        {23521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1638},
        {23521}
    },
    {
        1639,
        {31185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1639},
        {31185}
    },
    {
        1640,
        {26247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1640},
        {26247}
    },
    {
        1641,
        {26524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1641},
        {26524}
    },
    {
        1642,
        {26550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1642},
        {26550}
    },
    {
        1643,
        {27468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1643},
        {27468}
    },
    {
        1644,
        {27827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1644},
        {27827}
    },
    {
        1645,
        {28779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1645},
        {28779}
    },
    {
        1646,
        {29634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1646},
        {29634}
    },
    {
        1647,
        {31117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1647},
        {31117}
    },
    {
        1648,
        {31166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1648},
        {31166}
    },
    {
        1649,
        {31292, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1649},
        {31292}
    },
    {
        1650,
        {31623, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1650},
        {31623}
    },
    {
        1651,
        {33457, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1651},
        {33457}
    },
    {
        1652,
        {33499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1652},
        {33499}
    },
    {
        1653,
        {33540, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1653},
        {33540}
    },
    {
        1654,
        {33655, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1654},
        {33655}
    },
    {
        1655,
        {33775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1655},
        {33775}
    },
    {
        1656,
        {33747, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1656},
        {33747}
    },
    {
        1657,
        {34662, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1657},
        {34662}
    },
    {
        1658,
        {35506, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1658},
        {35506}
    },
    {
        1659,
        {22057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1659},
        {22057}
    },
    {
        1660,
        {36008, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1660},
        {36008}
    },
    {
        1661,
        {36838, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1661},
        {36838}
    },
    {
        1662,
        {36942, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1662},
        {36942}
    },
    {
        1663,
        {38686, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1663},
        {38686}
    },
    {
        1664,
        {34442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1664},
        {34442}
    },
    {
        1665,
        {20420, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1665},
        {20420}
    },
    {
        1666,
        {23784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1666},
        {23784}
    },
    {
        1667,
        {25105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1667},
        {25105}
    },
    {
        1668,
        {29273, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1668},
        {29273}
    },
    {
        1669,
        {30011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1669},
        {30011}
    },
    {
        1670,
        {33253, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1670},
        {33253}
    },
    {
        1671,
        {33469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1671},
        {33469}
    },
    {
        1672,
        {34558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1672},
        {34558}
    },
    {
        1673,
        {36032, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1673},
        {36032}
    },
    {
        1674,
        {38597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1674},
        {38597}
    },
    {
        1675,
        {39187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1675},
        {39187}
    },
    {
        1676,
        {39381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1676},
        {39381}
    },
    {
        1677,
        {20171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1677},
        {20171}
    },
    {
        1678,
        {20250, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1678},
        {20250}
    },
    {
        1679,
        {35299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1679},
        {35299}
    },
    {
        1680,
        {22238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1680},
        {22238}
    },
    {
        1681,
        {22602, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1681},
        {22602}
    },
    {
        1682,
        {22730, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1682},
        {22730}
    },
    {
        1683,
        {24315, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1683},
        {24315}
    },
    {
        1684,
        {24555, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1684},
        {24555}
    },
    {
        1685,
        {24618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1685},
        {24618}
    },
    {
        1686,
        {24724, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1686},
        {24724}
    },
    {
        1687,
        {24674, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1687},
        {24674}
    },
    {
        1688,
        {25040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1688},
        {25040}
    },
    {
        1689,
        {25106, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1689},
        {25106}
    },
    {
        1690,
        {25296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1690},
        {25296}
    },
    {
        1691,
        {25913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1691},
        {25913}
    },
    {
        1692,
        {39745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1692},
        {39745}
    },
    {
        1693,
        {26214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1693},
        {26214}
    },
    {
        1694,
        {26800, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1694},
        {26800}
    },
    {
        1695,
        {28023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1695},
        {28023}
    },
    {
        1696,
        {28784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1696},
        {28784}
    },
    {
        1697,
        {30028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1697},
        {30028}
    },
    {
        1698,
        {30342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1698},
        {30342}
    },
    {
        1699,
        {32117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1699},
        {32117}
    },
    {
        1700,
        {33445, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1700},
        {33445}
    },
    {
        1701,
        {34809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1701},
        {34809}
    },
    {
        1702,
        {38283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1702},
        {38283}
    },
    {
        1703,
        {38542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1703},
        {38542}
    },
    {
        1704,
        {35997, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1704},
        {35997}
    },
    {
        1705,
        {20977, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1705},
        {20977}
    },
    {
        1706,
        {21182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1706},
        {21182}
    },
    {
        1707,
        {22806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1707},
        {22806}
    },
    {
        1708,
        {21683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1708},
        {21683}
    },
    {
        1709,
        {23475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1709},
        {23475}
    },
    {
        1710,
        {23830, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1710},
        {23830}
    },
    {
        1711,
        {24936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1711},
        {24936}
    },
    {
        1712,
        {27010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1712},
        {27010}
    },
    {
        1713,
        {28079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1713},
        {28079}
    },
    {
        1714,
        {30861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1714},
        {30861}
    },
    {
        1715,
        {33995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1715},
        {33995}
    },
    {
        1716,
        {34903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1716},
        {34903}
    },
    {
        1717,
        {35442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1717},
        {35442}
    },
    {
        1718,
        {37799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1718},
        {37799}
    },
    {
        1719,
        {39608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1719},
        {39608}
    },
    {
        1720,
        {28012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1720},
        {28012}
    },
    {
        1721,
        {39336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1721},
        {39336}
    },
    {
        1722,
        {34521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1722},
        {34521}
    },
    {
        1723,
        {22435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1723},
        {22435}
    },
    {
        1724,
        {26623, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1724},
        {26623}
    },
    {
        1725,
        {34510, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1725},
        {34510}
    },
    {
        1726,
        {37390, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1726},
        {37390}
    },
    {
        1727,
        {21123, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1727},
        {21123}
    },
    {
        1728,
        {22151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1728},
        {22151}
    },
    {
        1729,
        {21508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1729},
        {21508}
    },
    {
        1730,
        {24275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1730},
        {24275}
    },
    {
        1731,
        {25313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1731},
        {25313}
    },
    {
        1732,
        {25785, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1732},
        {25785}
    },
    {
        1733,
        {26684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1733},
        {26684}
    },
    {
        1734,
        {26680, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1734},
        {26680}
    },
    {
        1735,
        {27579, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1735},
        {27579}
    },
    {
        1736,
        {29554, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1736},
        {29554}
    },
    {
        1737,
        {30906, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1737},
        {30906}
    },
    {
        1738,
        {31339, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1738},
        {31339}
    },
    {
        1739,
        {35226, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1739},
        {35226}
    },
    {
        1740,
        {35282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1740},
        {35282}
    },
    {
        1741,
        {36203, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1741},
        {36203}
    },
    {
        1742,
        {36611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1742},
        {36611}
    },
    {
        1743,
        {37101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1743},
        {37101}
    },
    {
        1744,
        {38307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1744},
        {38307}
    },
    {
        1745,
        {38548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1745},
        {38548}
    },
    {
        1746,
        {38761, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1746},
        {38761}
    },
    {
        1747,
        {23398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1747},
        {23398}
    },
    {
        1748,
        {23731, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1748},
        {23731}
    },
    {
        1749,
        {27005, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1749},
        {27005}
    },
    {
        1750,
        {38989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1750},
        {38989}
    },
    {
        1751,
        {38990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1751},
        {38990}
    },
    {
        1752,
        {25499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1752},
        {25499}
    },
    {
        1753,
        {31520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1753},
        {31520}
    },
    {
        1754,
        {27179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1754},
        {27179}
    },
    {
        1755,
        {27263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1755},
        {27263}
    },
    {
        1756,
        {26806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1756},
        {26806}
    },
    {
        1757,
        {39949, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1757},
        {39949}
    },
    {
        1758,
        {28511, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1758},
        {28511}
    },
    {
        1759,
        {21106, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1759},
        {21106}
    },
    {
        1760,
        {21917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1760},
        {21917}
    },
    {
        1761,
        {24688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1761},
        {24688}
    },
    {
        1762,
        {25324, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1762},
        {25324}
    },
    {
        1763,
        {27963, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1763},
        {27963}
    },
    {
        1764,
        {28167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1764},
        {28167}
    },
    {
        1765,
        {28369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1765},
        {28369}
    },
    {
        1766,
        {33883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1766},
        {33883}
    },
    {
        1767,
        {35088, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1767},
        {35088}
    },
    {
        1768,
        {36676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1768},
        {36676}
    },
    {
        1769,
        {19988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1769},
        {19988}
    },
    {
        1770,
        {39993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1770},
        {39993}
    },
    {
        1771,
        {21494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1771},
        {21494}
    },
    {
        1772,
        {26907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1772},
        {26907}
    },
    {
        1773,
        {27194, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1773},
        {27194}
    },
    {
        1774,
        {38788, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1774},
        {38788}
    },
    {
        1775,
        {26666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1775},
        {26666}
    },
    {
        1776,
        {20828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1776},
        {20828}
    },
    {
        1777,
        {31427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1777},
        {31427}
    },
    {
        1778,
        {33970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1778},
        {33970}
    },
    {
        1779,
        {37340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1779},
        {37340}
    },
    {
        1780,
        {37772, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1780},
        {37772}
    },
    {
        1781,
        {22107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1781},
        {22107}
    },
    {
        1782,
        {40232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1782},
        {40232}
    },
    {
        1783,
        {26658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1783},
        {26658}
    },
    {
        1784,
        {33541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1784},
        {33541}
    },
    {
        1785,
        {33841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1785},
        {33841}
    },
    {
        1786,
        {31909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1786},
        {31909}
    },
    {
        1787,
        {21000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1787},
        {21000}
    },
    {
        1788,
        {33477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1788},
        {33477}
    },
    {
        1789,
        {29926, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1789},
        {29926}
    },
    {
        1790,
        {20094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1790},
        {20094}
    },
    {
        1791,
        {20355, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1791},
        {20355}
    },
    {
        1792,
        {20896, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1792},
        {20896}
    },
    {
        1793,
        {23506, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1793},
        {23506}
    },
    {
        1794,
        {21002, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1794},
        {21002}
    },
    {
        1795,
        {21208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1795},
        {21208}
    },
    {
        1796,
        {21223, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1796},
        {21223}
    },
    {
        1797,
        {24059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1797},
        {24059}
    },
    {
        1798,
        {21914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1798},
        {21914}
    },
    {
        1799,
        {22570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1799},
        {22570}
    },
    {
        1800,
        {23014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1800},
        {23014}
    },
    {
        1801,
        {23436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1801},
        {23436}
    },
    {
        1802,
        {23448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1802},
        {23448}
    },
    {
        1803,
        {23515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1803},
        {23515}
    },
    {
        1804,
        {24178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1804},
        {24178}
    },
    {
        1805,
        {24185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1805},
        {24185}
    },
    {
        1806,
        {24739, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1806},
        {24739}
    },
    {
        1807,
        {24863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1807},
        {24863}
    },
    {
        1808,
        {24931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1808},
        {24931}
    },
    {
        1809,
        {25022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1809},
        {25022}
    },
    {
        1810,
        {25563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1810},
        {25563}
    },
    {
        1811,
        {25954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1811},
        {25954}
    },
    {
        1812,
        {26577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1812},
        {26577}
    },
    {
        1813,
        {26707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1813},
        {26707}
    },
    {
        1814,
        {26874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1814},
        {26874}
    },
    {
        1815,
        {27454, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1815},
        {27454}
    },
    {
        1816,
        {27475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1816},
        {27475}
    },
    {
        1817,
        {27735, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1817},
        {27735}
    },
    {
        1818,
        {28450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1818},
        {28450}
    },
    {
        1819,
        {28567, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1819},
        {28567}
    },
    {
        1820,
        {28485, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1820},
        {28485}
    },
    {
        1821,
        {29872, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1821},
        {29872}
    },
    {
        1822,
        {29976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1822},
        {29976}
    },
    {
        1823,
        {30435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1823},
        {30435}
    },
    {
        1824,
        {30475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1824},
        {30475}
    },
    {
        1825,
        {31487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1825},
        {31487}
    },
    {
        1826,
        {31649, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1826},
        {31649}
    },
    {
        1827,
        {31777, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1827},
        {31777}
    },
    {
        1828,
        {32233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1828},
        {32233}
    },
    {
        1829,
        {32566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1829},
        {32566}
    },
    {
        1830,
        {32752, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1830},
        {32752}
    },
    {
        1831,
        {32925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1831},
        {32925}
    },
    {
        1832,
        {33382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1832},
        {33382}
    },
    {
        1833,
        {33694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1833},
        {33694}
    },
    {
        1834,
        {35251, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1834},
        {35251}
    },
    {
        1835,
        {35532, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1835},
        {35532}
    },
    {
        1836,
        {36011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1836},
        {36011}
    },
    {
        1837,
        {36996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1837},
        {36996}
    },
    {
        1838,
        {37969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1838},
        {37969}
    },
    {
        1839,
        {38291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1839},
        {38291}
    },
    {
        1840,
        {38289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1840},
        {38289}
    },
    {
        1841,
        {38306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1841},
        {38306}
    },
    {
        1842,
        {38501, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1842},
        {38501}
    },
    {
        1843,
        {38867, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1843},
        {38867}
    },
    {
        1844,
        {39208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1844},
        {39208}
    },
    {
        1845,
        {33304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1845},
        {33304}
    },
    {
        1846,
        {20024, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1846},
        {20024}
    },
    {
        1847,
        {21547, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1847},
        {21547}
    },
    {
        1848,
        {23736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1848},
        {23736}
    },
    {
        1849,
        {24012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1849},
        {24012}
    },
    {
        1850,
        {29609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1850},
        {29609}
    },
    {
        1851,
        {30284, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1851},
        {30284}
    },
    {
        1852,
        {30524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1852},
        {30524}
    },
    {
        1853,
        {23721, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1853},
        {23721}
    },
    {
        1854,
        {32747, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1854},
        {32747}
    },
    {
        1855,
        {36107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1855},
        {36107}
    },
    {
        1856,
        {38593, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1856},
        {38593}
    },
    {
        1857,
        {38929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1857},
        {38929}
    },
    {
        1858,
        {38996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1858},
        {38996}
    },
    {
        1859,
        {39000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1859},
        {39000}
    },
    {
        1860,
        {20225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1860},
        {20225}
    },
    {
        1861,
        {20238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1861},
        {20238}
    },
    {
        1862,
        {21361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1862},
        {21361}
    },
    {
        1863,
        {21916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1863},
        {21916}
    },
    {
        1864,
        {22120, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1864},
        {22120}
    },
    {
        1865,
        {22522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1865},
        {22522}
    },
    {
        1866,
        {22855, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1866},
        {22855}
    },
    {
        1867,
        {23305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1867},
        {23305}
    },
    {
        1868,
        {23492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1868},
        {23492}
    },
    {
        1869,
        {23696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1869},
        {23696}
    },
    {
        1870,
        {24076, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1870},
        {24076}
    },
    {
        1871,
        {24190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1871},
        {24190}
    },
    {
        1872,
        {24524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1872},
        {24524}
    },
    {
        1873,
        {25582, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1873},
        {25582}
    },
    {
        1874,
        {26426, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1874},
        {26426}
    },
    {
        1875,
        {26071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1875},
        {26071}
    },
    {
        1876,
        {26082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1876},
        {26082}
    },
    {
        1877,
        {26399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1877},
        {26399}
    },
    {
        1878,
        {26827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1878},
        {26827}
    },
    {
        1879,
        {26820, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1879},
        {26820}
    },
    {
        1880,
        {27231, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1880},
        {27231}
    },
    {
        1881,
        {24112, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1881},
        {24112}
    },
    {
        1882,
        {27589, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1882},
        {27589}
    },
    {
        1883,
        {27671, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1883},
        {27671}
    },
    {
        1884,
        {27773, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1884},
        {27773}
    },
    {
        1885,
        {30079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1885},
        {30079}
    },
    {
        1886,
        {31048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1886},
        {31048}
    },
    {
        1887,
        {23395, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1887},
        {23395}
    },
    {
        1888,
        {31232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1888},
        {31232}
    },
    {
        1889,
        {32000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1889},
        {32000}
    },
    {
        1890,
        {24509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1890},
        {24509}
    },
    {
        1891,
        {35215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1891},
        {35215}
    },
    {
        1892,
        {35352, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1892},
        {35352}
    },
    {
        1893,
        {36020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1893},
        {36020}
    },
    {
        1894,
        {36215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1894},
        {36215}
    },
    {
        1895,
        {36556, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1895},
        {36556}
    },
    {
        1896,
        {36637, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1896},
        {36637}
    },
    {
        1897,
        {39138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1897},
        {39138}
    },
    {
        1898,
        {39438, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1898},
        {39438}
    },
    {
        1899,
        {39740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1899},
        {39740}
    },
    {
        1900,
        {20096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1900},
        {20096}
    },
    {
        1901,
        {20605, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1901},
        {20605}
    },
    {
        1902,
        {20736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1902},
        {20736}
    },
    {
        1903,
        {22931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1903},
        {22931}
    },
    {
        1904,
        {23452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1904},
        {23452}
    },
    {
        1905,
        {25135, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1905},
        {25135}
    },
    {
        1906,
        {25216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1906},
        {25216}
    },
    {
        1907,
        {25836, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1907},
        {25836}
    },
    {
        1908,
        {27450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1908},
        {27450}
    },
    {
        1909,
        {29344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1909},
        {29344}
    },
    {
        1910,
        {30097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1910},
        {30097}
    },
    {
        1911,
        {31047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1911},
        {31047}
    },
    {
        1912,
        {32681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1912},
        {32681}
    },
    {
        1913,
        {34811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1913},
        {34811}
    },
    {
        1914,
        {35516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1914},
        {35516}
    },
    {
        1915,
        {35696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1915},
        {35696}
    },
    {
        1916,
        {25516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1916},
        {25516}
    },
    {
        1917,
        {33738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1917},
        {33738}
    },
    {
        1918,
        {38816, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1918},
        {38816}
    },
    {
        1919,
        {21513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1919},
        {21513}
    },
    {
        1920,
        {21507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1920},
        {21507}
    },
    {
        1921,
        {21931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1921},
        {21931}
    },
    {
        1922,
        {26708, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1922},
        {26708}
    },
    {
        1923,
        {27224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1923},
        {27224}
    },
    {
        1924,
        {35440, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1924},
        {35440}
    },
    {
        1925,
        {30759, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1925},
        {30759}
    },
    {
        1926,
        {26485, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1926},
        {26485}
    },
    {
        1927,
        {40653, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1927},
        {40653}
    },
    {
        1928,
        {21364, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1928},
        {21364}
    },
    {
        1929,
        {23458, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1929},
        {23458}
    },
    {
        1930,
        {33050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1930},
        {33050}
    },
    {
        1931,
        {34384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1931},
        {34384}
    },
    {
        1932,
        {36870, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1932},
        {36870}
    },
    {
        1933,
        {19992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1933},
        {19992}
    },
    {
        1934,
        {20037, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1934},
        {20037}
    },
    {
        1935,
        {20167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1935},
        {20167}
    },
    {
        1936,
        {20241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1936},
        {20241}
    },
    {
        1937,
        {21450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1937},
        {21450}
    },
    {
        1938,
        {21560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1938},
        {21560}
    },
    {
        1939,
        {23470, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1939},
        {23470}
    },
    {
        1940,
        {24339, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1940},
        {24339}
    },
    {
        1941,
        {24613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1941},
        {24613}
    },
    {
        1942,
        {25937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1942},
        {25937}
    },
    {
        1943,
        {26429, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1943},
        {26429}
    },
    {
        1944,
        {27714, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1944},
        {27714}
    },
    {
        1945,
        {27762, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1945},
        {27762}
    },
    {
        1946,
        {27875, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1946},
        {27875}
    },
    {
        1947,
        {28792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1947},
        {28792}
    },
    {
        1948,
        {29699, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1948},
        {29699}
    },
    {
        1949,
        {31350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1949},
        {31350}
    },
    {
        1950,
        {31406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1950},
        {31406}
    },
    {
        1951,
        {31496, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1951},
        {31496}
    },
    {
        1952,
        {32026, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1952},
        {32026}
    },
    {
        1953,
        {31998, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1953},
        {31998}
    },
    {
        1954,
        {32102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1954},
        {32102}
    },
    {
        1955,
        {26087, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1955},
        {26087}
    },
    {
        1956,
        {29275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1956},
        {29275}
    },
    {
        1957,
        {21435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1957},
        {21435}
    },
    {
        1958,
        {23621, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1958},
        {23621}
    },
    {
        1959,
        {24040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1959},
        {24040}
    },
    {
        1960,
        {25298, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1960},
        {25298}
    },
    {
        1961,
        {25312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1961},
        {25312}
    },
    {
        1962,
        {25369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1962},
        {25369}
    },
    {
        1963,
        {28192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1963},
        {28192}
    },
    {
        1964,
        {34394, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1964},
        {34394}
    },
    {
        1965,
        {35377, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1965},
        {35377}
    },
    {
        1966,
        {36317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1966},
        {36317}
    },
    {
        1967,
        {37624, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1967},
        {37624}
    },
    {
        1968,
        {28417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1968},
        {28417}
    },
    {
        1969,
        {31142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1969},
        {31142}
    },
    {
        1970,
        {39770, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1970},
        {39770}
    },
    {
        1971,
        {20136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1971},
        {20136}
    },
    {
        1972,
        {20139, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1972},
        {20139}
    },
    {
        1973,
        {20140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1973},
        {20140}
    },
    {
        1974,
        {20379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1974},
        {20379}
    },
    {
        1975,
        {20384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1975},
        {20384}
    },
    {
        1976,
        {20689, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1976},
        {20689}
    },
    {
        1977,
        {20807, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1977},
        {20807}
    },
    {
        1978,
        {31478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1978},
        {31478}
    },
    {
        1979,
        {20849, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1979},
        {20849}
    },
    {
        1980,
        {20982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1980},
        {20982}
    },
    {
        1981,
        {21332, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1981},
        {21332}
    },
    {
        1982,
        {21281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1982},
        {21281}
    },
    {
        1983,
        {21375, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1983},
        {21375}
    },
    {
        1984,
        {21483, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1984},
        {21483}
    },
    {
        1985,
        {21932, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1985},
        {21932}
    },
    {
        1986,
        {22659, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1986},
        {22659}
    },
    {
        1987,
        {23777, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1987},
        {23777}
    },
    {
        1988,
        {24375, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1988},
        {24375}
    },
    {
        1989,
        {24394, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1989},
        {24394}
    },
    {
        1990,
        {24623, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1990},
        {24623}
    },
    {
        1991,
        {24656, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1991},
        {24656}
    },
    {
        1992,
        {24685, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1992},
        {24685}
    },
    {
        1993,
        {25375, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1993},
        {25375}
    },
    {
        1994,
        {25945, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1994},
        {25945}
    },
    {
        1995,
        {27211, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1995},
        {27211}
    },
    {
        1996,
        {27841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1996},
        {27841}
    },
    {
        1997,
        {29378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1997},
        {29378}
    },
    {
        1998,
        {29421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1998},
        {29421}
    },
    {
        1999,
        {30703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {1999},
        {30703}
    },
    {
        2000,
        {33016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2000},
        {33016}
    },
    {
        2001,
        {33029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2001},
        {33029}
    },
    {
        2002,
        {33288, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2002},
        {33288}
    },
    {
        2003,
        {34126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2003},
        {34126}
    },
    {
        2004,
        {37111, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2004},
        {37111}
    },
    {
        2005,
        {37857, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2005},
        {37857}
    },
    {
        2006,
        {38911, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2006},
        {38911}
    },
    {
        2007,
        {39255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2007},
        {39255}
    },
    {
        2008,
        {39514, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2008},
        {39514}
    },
    {
        2009,
        {20208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2009},
        {20208}
    },
    {
        2010,
        {20957, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2010},
        {20957}
    },
    {
        2011,
        {23597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2011},
        {23597}
    },
    {
        2012,
        {26241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2012},
        {26241}
    },
    {
        2013,
        {26989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2013},
        {26989}
    },
    {
        2014,
        {23616, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2014},
        {23616}
    },
    {
        2015,
        {26354, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2015},
        {26354}
    },
    {
        2016,
        {26997, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2016},
        {26997}
    },
    {
        2017,
        {29577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2017},
        {29577}
    },
    {
        2018,
        {26704, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2018},
        {26704}
    },
    {
        2019,
        {31873, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2019},
        {31873}
    },
    {
        2020,
        {20677, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2020},
        {20677}
    },
    {
        2021,
        {21220, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2021},
        {21220}
    },
    {
        2022,
        {22343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2022},
        {22343}
    },
    {
        2023,
        {24062, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2023},
        {24062}
    },
    {
        2024,
        {37670, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2024},
        {37670}
    },
    {
        2025,
        {26020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2025},
        {26020}
    },
    {
        2026,
        {27427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2026},
        {27427}
    },
    {
        2027,
        {27453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2027},
        {27453}
    },
    {
        2028,
        {29748, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2028},
        {29748}
    },
    {
        2029,
        {31105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2029},
        {31105}
    },
    {
        2030,
        {31165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2030},
        {31165}
    },
    {
        2031,
        {31563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2031},
        {31563}
    },
    {
        2032,
        {32202, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2032},
        {32202}
    },
    {
        2033,
        {33465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2033},
        {33465}
    },
    {
        2034,
        {33740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2034},
        {33740}
    },
    {
        2035,
        {34943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2035},
        {34943}
    },
    {
        2036,
        {35167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2036},
        {35167}
    },
    {
        2037,
        {35641, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2037},
        {35641}
    },
    {
        2038,
        {36817, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2038},
        {36817}
    },
    {
        2039,
        {37329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2039},
        {37329}
    },
    {
        2040,
        {21535, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2040},
        {21535}
    },
    {
        2041,
        {37504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2041},
        {37504}
    },
    {
        2042,
        {20061, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2042},
        {20061}
    },
    {
        2043,
        {20534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2043},
        {20534}
    },
    {
        2044,
        {21477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2044},
        {21477}
    },
    {
        2045,
        {21306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2045},
        {21306}
    },
    {
        2046,
        {29399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2046},
        {29399}
    },
    {
        2047,
        {29590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2047},
        {29590}
    },
    {
        2048,
        {30697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2048},
        {30697}
    },
    {
        2049,
        {33510, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2049},
        {33510}
    },
    {
        2050,
        {36527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2050},
        {36527}
    },
    {
        2051,
        {39366, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2051},
        {39366}
    },
    {
        2052,
        {39368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2052},
        {39368}
    },
    {
        2053,
        {39378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2053},
        {39378}
    },
    {
        2054,
        {20855, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2054},
        {20855}
    },
    {
        2055,
        {24858, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2055},
        {24858}
    },
    {
        2056,
        {34398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2056},
        {34398}
    },
    {
        2057,
        {21936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2057},
        {21936}
    },
    {
        2058,
        {31354, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2058},
        {31354}
    },
    {
        2059,
        {20598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2059},
        {20598}
    },
    {
        2060,
        {23507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2060},
        {23507}
    },
    {
        2061,
        {36935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2061},
        {36935}
    },
    {
        2062,
        {38533, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2062},
        {38533}
    },
    {
        2063,
        {20018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2063},
        {20018}
    },
    {
        2064,
        {27355, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2064},
        {27355}
    },
    {
        2065,
        {37351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2065},
        {37351}
    },
    {
        2066,
        {23633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2066},
        {23633}
    },
    {
        2067,
        {23624, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2067},
        {23624}
    },
    {
        2068,
        {25496, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2068},
        {25496}
    },
    {
        2069,
        {31391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2069},
        {31391}
    },
    {
        2070,
        {27795, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2070},
        {27795}
    },
    {
        2071,
        {38772, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2071},
        {38772}
    },
    {
        2072,
        {36705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2072},
        {36705}
    },
    {
        2073,
        {31402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2073},
        {31402}
    },
    {
        2074,
        {29066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2074},
        {29066}
    },
    {
        2075,
        {38536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2075},
        {38536}
    },
    {
        2076,
        {31874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2076},
        {31874}
    },
    {
        2077,
        {26647, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2077},
        {26647}
    },
    {
        2078,
        {32368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2078},
        {32368}
    },
    {
        2079,
        {26705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2079},
        {26705}
    },
    {
        2080,
        {37740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2080},
        {37740}
    },
    {
        2081,
        {21234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2081},
        {21234}
    },
    {
        2082,
        {21531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2082},
        {21531}
    },
    {
        2083,
        {34219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2083},
        {34219}
    },
    {
        2084,
        {35347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2084},
        {35347}
    },
    {
        2085,
        {32676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2085},
        {32676}
    },
    {
        2086,
        {36557, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2086},
        {36557}
    },
    {
        2087,
        {37089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2087},
        {37089}
    },
    {
        2088,
        {21350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2088},
        {21350}
    },
    {
        2089,
        {34952, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2089},
        {34952}
    },
    {
        2090,
        {31041, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2090},
        {31041}
    },
    {
        2091,
        {20418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2091},
        {20418}
    },
    {
        2092,
        {20670, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2092},
        {20670}
    },
    {
        2093,
        {21009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2093},
        {21009}
    },
    {
        2094,
        {20804, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2094},
        {20804}
    },
    {
        2095,
        {21843, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2095},
        {21843}
    },
    {
        2096,
        {22317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2096},
        {22317}
    },
    {
        2097,
        {29674, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2097},
        {29674}
    },
    {
        2098,
        {22411, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2098},
        {22411}
    },
    {
        2099,
        {22865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2099},
        {22865}
    },
    {
        2100,
        {24418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2100},
        {24418}
    },
    {
        2101,
        {24452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2101},
        {24452}
    },
    {
        2102,
        {24693, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2102},
        {24693}
    },
    {
        2103,
        {24950, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2103},
        {24950}
    },
    {
        2104,
        {24935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2104},
        {24935}
    },
    {
        2105,
        {25001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2105},
        {25001}
    },
    {
        2106,
        {25522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2106},
        {25522}
    },
    {
        2107,
        {25658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2107},
        {25658}
    },
    {
        2108,
        {25964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2108},
        {25964}
    },
    {
        2109,
        {26223, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2109},
        {26223}
    },
    {
        2110,
        {26690, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2110},
        {26690}
    },
    {
        2111,
        {28179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2111},
        {28179}
    },
    {
        2112,
        {30054, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2112},
        {30054}
    },
    {
        2113,
        {31293, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2113},
        {31293}
    },
    {
        2114,
        {31995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2114},
        {31995}
    },
    {
        2115,
        {32076, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2115},
        {32076}
    },
    {
        2116,
        {32153, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2116},
        {32153}
    },
    {
        2117,
        {32331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2117},
        {32331}
    },
    {
        2118,
        {32619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2118},
        {32619}
    },
    {
        2119,
        {33550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2119},
        {33550}
    },
    {
        2120,
        {33610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2120},
        {33610}
    },
    {
        2121,
        {34509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2121},
        {34509}
    },
    {
        2122,
        {35336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2122},
        {35336}
    },
    {
        2123,
        {35427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2123},
        {35427}
    },
    {
        2124,
        {35686, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2124},
        {35686}
    },
    {
        2125,
        {36605, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2125},
        {36605}
    },
    {
        2126,
        {38938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2126},
        {38938}
    },
    {
        2127,
        {40335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2127},
        {40335}
    },
    {
        2128,
        {33464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2128},
        {33464}
    },
    {
        2129,
        {36814, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2129},
        {36814}
    },
    {
        2130,
        {39912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2130},
        {39912}
    },
    {
        2131,
        {21127, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2131},
        {21127}
    },
    {
        2132,
        {25119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2132},
        {25119}
    },
    {
        2133,
        {25731, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2133},
        {25731}
    },
    {
        2134,
        {28608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2134},
        {28608}
    },
    {
        2135,
        {38553, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2135},
        {38553}
    },
    {
        2136,
        {26689, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2136},
        {26689}
    },
    {
        2137,
        {20625, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2137},
        {20625}
    },
    {
        2138,
        {27424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2138},
        {27424}
    },
    {
        2139,
        {27770, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2139},
        {27770}
    },
    {
        2140,
        {28500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2140},
        {28500}
    },
    {
        2141,
        {31348, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2141},
        {31348}
    },
    {
        2142,
        {32080, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2142},
        {32080}
    },
    {
        2143,
        {34880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2143},
        {34880}
    },
    {
        2144,
        {35363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2144},
        {35363}
    },
    {
        2145,
        {26376, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2145},
        {26376}
    },
    {
        2146,
        {20214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2146},
        {20214}
    },
    {
        2147,
        {20537, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2147},
        {20537}
    },
    {
        2148,
        {20518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2148},
        {20518}
    },
    {
        2149,
        {20581, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2149},
        {20581}
    },
    {
        2150,
        {20860, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2150},
        {20860}
    },
    {
        2151,
        {21048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2151},
        {21048}
    },
    {
        2152,
        {21091, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2152},
        {21091}
    },
    {
        2153,
        {21927, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2153},
        {21927}
    },
    {
        2154,
        {22287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2154},
        {22287}
    },
    {
        2155,
        {22533, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2155},
        {22533}
    },
    {
        2156,
        {23244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2156},
        {23244}
    },
    {
        2157,
        {24314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2157},
        {24314}
    },
    {
        2158,
        {25010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2158},
        {25010}
    },
    {
        2159,
        {25080, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2159},
        {25080}
    },
    {
        2160,
        {25331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2160},
        {25331}
    },
    {
        2161,
        {25458, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2161},
        {25458}
    },
    {
        2162,
        {26908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2162},
        {26908}
    },
    {
        2163,
        {27177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2163},
        {27177}
    },
    {
        2164,
        {29309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2164},
        {29309}
    },
    {
        2165,
        {29356, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2165},
        {29356}
    },
    {
        2166,
        {29486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2166},
        {29486}
    },
    {
        2167,
        {30740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2167},
        {30740}
    },
    {
        2168,
        {30831, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2168},
        {30831}
    },
    {
        2169,
        {32121, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2169},
        {32121}
    },
    {
        2170,
        {30476, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2170},
        {30476}
    },
    {
        2171,
        {32937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2171},
        {32937}
    },
    {
        2172,
        {35211, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2172},
        {35211}
    },
    {
        2173,
        {35609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2173},
        {35609}
    },
    {
        2174,
        {36066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2174},
        {36066}
    },
    {
        2175,
        {36562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2175},
        {36562}
    },
    {
        2176,
        {36963, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2176},
        {36963}
    },
    {
        2177,
        {37749, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2177},
        {37749}
    },
    {
        2178,
        {38522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2178},
        {38522}
    },
    {
        2179,
        {38997, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2179},
        {38997}
    },
    {
        2180,
        {39443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2180},
        {39443}
    },
    {
        2181,
        {40568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2181},
        {40568}
    },
    {
        2182,
        {20803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2182},
        {20803}
    },
    {
        2183,
        {21407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2183},
        {21407}
    },
    {
        2184,
        {21427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2184},
        {21427}
    },
    {
        2185,
        {24187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2185},
        {24187}
    },
    {
        2186,
        {24358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2186},
        {24358}
    },
    {
        2187,
        {28187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2187},
        {28187}
    },
    {
        2188,
        {28304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2188},
        {28304}
    },
    {
        2189,
        {29572, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2189},
        {29572}
    },
    {
        2190,
        {29694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2190},
        {29694}
    },
    {
        2191,
        {32067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2191},
        {32067}
    },
    {
        2192,
        {33335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2192},
        {33335}
    },
    {
        2193,
        {35328, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2193},
        {35328}
    },
    {
        2194,
        {35578, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2194},
        {35578}
    },
    {
        2195,
        {38480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2195},
        {38480}
    },
    {
        2196,
        {20046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2196},
        {20046}
    },
    {
        2197,
        {20491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2197},
        {20491}
    },
    {
        2198,
        {21476, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2198},
        {21476}
    },
    {
        2199,
        {21628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2199},
        {21628}
    },
    {
        2200,
        {22266, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2200},
        {22266}
    },
    {
        2201,
        {22993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2201},
        {22993}
    },
    {
        2202,
        {23396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2202},
        {23396}
    },
    {
        2203,
        {24049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2203},
        {24049}
    },
    {
        2204,
        {24235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2204},
        {24235}
    },
    {
        2205,
        {24359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2205},
        {24359}
    },
    {
        2206,
        {25144, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2206},
        {25144}
    },
    {
        2207,
        {25925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2207},
        {25925}
    },
    {
        2208,
        {26543, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2208},
        {26543}
    },
    {
        2209,
        {28246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2209},
        {28246}
    },
    {
        2210,
        {29392, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2210},
        {29392}
    },
    {
        2211,
        {31946, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2211},
        {31946}
    },
    {
        2212,
        {34996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2212},
        {34996}
    },
    {
        2213,
        {32929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2213},
        {32929}
    },
    {
        2214,
        {32993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2214},
        {32993}
    },
    {
        2215,
        {33776, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2215},
        {33776}
    },
    {
        2216,
        {34382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2216},
        {34382}
    },
    {
        2217,
        {35463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2217},
        {35463}
    },
    {
        2218,
        {36328, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2218},
        {36328}
    },
    {
        2219,
        {37431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2219},
        {37431}
    },
    {
        2220,
        {38599, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2220},
        {38599}
    },
    {
        2221,
        {39015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2221},
        {39015}
    },
    {
        2222,
        {40723, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2222},
        {40723}
    },
    {
        2223,
        {20116, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2223},
        {20116}
    },
    {
        2224,
        {20114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2224},
        {20114}
    },
    {
        2225,
        {20237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2225},
        {20237}
    },
    {
        2226,
        {21320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2226},
        {21320}
    },
    {
        2227,
        {21577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2227},
        {21577}
    },
    {
        2228,
        {21566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2228},
        {21566}
    },
    {
        2229,
        {23087, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2229},
        {23087}
    },
    {
        2230,
        {24460, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2230},
        {24460}
    },
    {
        2231,
        {24481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2231},
        {24481}
    },
    {
        2232,
        {24735, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2232},
        {24735}
    },
    {
        2233,
        {26791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2233},
        {26791}
    },
    {
        2234,
        {27278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2234},
        {27278}
    },
    {
        2235,
        {29786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2235},
        {29786}
    },
    {
        2236,
        {30849, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2236},
        {30849}
    },
    {
        2237,
        {35486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2237},
        {35486}
    },
    {
        2238,
        {35492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2238},
        {35492}
    },
    {
        2239,
        {35703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2239},
        {35703}
    },
    {
        2240,
        {37264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2240},
        {37264}
    },
    {
        2241,
        {20062, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2241},
        {20062}
    },
    {
        2242,
        {39881, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2242},
        {39881}
    },
    {
        2243,
        {20132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2243},
        {20132}
    },
    {
        2244,
        {20348, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2244},
        {20348}
    },
    {
        2245,
        {20399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2245},
        {20399}
    },
    {
        2246,
        {20505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2246},
        {20505}
    },
    {
        2247,
        {20502, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2247},
        {20502}
    },
    {
        2248,
        {20809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2248},
        {20809}
    },
    {
        2249,
        {20844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2249},
        {20844}
    },
    {
        2250,
        {21151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2250},
        {21151}
    },
    {
        2251,
        {21177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2251},
        {21177}
    },
    {
        2252,
        {21246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2252},
        {21246}
    },
    {
        2253,
        {21402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2253},
        {21402}
    },
    {
        2254,
        {21475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2254},
        {21475}
    },
    {
        2255,
        {21521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2255},
        {21521}
    },
    {
        2256,
        {21518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2256},
        {21518}
    },
    {
        2257,
        {21897, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2257},
        {21897}
    },
    {
        2258,
        {22353, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2258},
        {22353}
    },
    {
        2259,
        {22434, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2259},
        {22434}
    },
    {
        2260,
        {22909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2260},
        {22909}
    },
    {
        2261,
        {23380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2261},
        {23380}
    },
    {
        2262,
        {23389, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2262},
        {23389}
    },
    {
        2263,
        {23439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2263},
        {23439}
    },
    {
        2264,
        {24037, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2264},
        {24037}
    },
    {
        2265,
        {24039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2265},
        {24039}
    },
    {
        2266,
        {24055, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2266},
        {24055}
    },
    {
        2267,
        {24184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2267},
        {24184}
    },
    {
        2268,
        {24195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2268},
        {24195}
    },
    {
        2269,
        {24218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2269},
        {24218}
    },
    {
        2270,
        {24247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2270},
        {24247}
    },
    {
        2271,
        {24344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2271},
        {24344}
    },
    {
        2272,
        {24658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2272},
        {24658}
    },
    {
        2273,
        {24908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2273},
        {24908}
    },
    {
        2274,
        {25239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2274},
        {25239}
    },
    {
        2275,
        {25304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2275},
        {25304}
    },
    {
        2276,
        {25511, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2276},
        {25511}
    },
    {
        2277,
        {25915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2277},
        {25915}
    },
    {
        2278,
        {26114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2278},
        {26114}
    },
    {
        2279,
        {26179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2279},
        {26179}
    },
    {
        2280,
        {26356, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2280},
        {26356}
    },
    {
        2281,
        {26477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2281},
        {26477}
    },
    {
        2282,
        {26657, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2282},
        {26657}
    },
    {
        2283,
        {26775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2283},
        {26775}
    },
    {
        2284,
        {27083, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2284},
        {27083}
    },
    {
        2285,
        {27743, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2285},
        {27743}
    },
    {
        2286,
        {27946, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2286},
        {27946}
    },
    {
        2287,
        {28009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2287},
        {28009}
    },
    {
        2288,
        {28207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2288},
        {28207}
    },
    {
        2289,
        {28317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2289},
        {28317}
    },
    {
        2290,
        {30002, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2290},
        {30002}
    },
    {
        2291,
        {30343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2291},
        {30343}
    },
    {
        2292,
        {30828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2292},
        {30828}
    },
    {
        2293,
        {31295, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2293},
        {31295}
    },
    {
        2294,
        {31968, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2294},
        {31968}
    },
    {
        2295,
        {32005, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2295},
        {32005}
    },
    {
        2296,
        {32024, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2296},
        {32024}
    },
    {
        2297,
        {32094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2297},
        {32094}
    },
    {
        2298,
        {32177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2298},
        {32177}
    },
    {
        2299,
        {32789, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2299},
        {32789}
    },
    {
        2300,
        {32771, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2300},
        {32771}
    },
    {
        2301,
        {32943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2301},
        {32943}
    },
    {
        2302,
        {32945, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2302},
        {32945}
    },
    {
        2303,
        {33108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2303},
        {33108}
    },
    {
        2304,
        {33167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2304},
        {33167}
    },
    {
        2305,
        {33322, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2305},
        {33322}
    },
    {
        2306,
        {33618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2306},
        {33618}
    },
    {
        2307,
        {34892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2307},
        {34892}
    },
    {
        2308,
        {34913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2308},
        {34913}
    },
    {
        2309,
        {35611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2309},
        {35611}
    },
    {
        2310,
        {36002, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2310},
        {36002}
    },
    {
        2311,
        {36092, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2311},
        {36092}
    },
    {
        2312,
        {37066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2312},
        {37066}
    },
    {
        2313,
        {37237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2313},
        {37237}
    },
    {
        2314,
        {37489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2314},
        {37489}
    },
    {
        2315,
        {30783, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2315},
        {30783}
    },
    {
        2316,
        {37628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2316},
        {37628}
    },
    {
        2317,
        {38308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2317},
        {38308}
    },
    {
        2318,
        {38477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2318},
        {38477}
    },
    {
        2319,
        {38917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2319},
        {38917}
    },
    {
        2320,
        {39321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2320},
        {39321}
    },
    {
        2321,
        {39640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2321},
        {39640}
    },
    {
        2322,
        {40251, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2322},
        {40251}
    },
    {
        2323,
        {21083, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2323},
        {21083}
    },
    {
        2324,
        {21163, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2324},
        {21163}
    },
    {
        2325,
        {21495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2325},
        {21495}
    },
    {
        2326,
        {21512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2326},
        {21512}
    },
    {
        2327,
        {22741, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2327},
        {22741}
    },
    {
        2328,
        {25335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2328},
        {25335}
    },
    {
        2329,
        {28640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2329},
        {28640}
    },
    {
        2330,
        {35946, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2330},
        {35946}
    },
    {
        2331,
        {36703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2331},
        {36703}
    },
    {
        2332,
        {40633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2332},
        {40633}
    },
    {
        2333,
        {20811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2333},
        {20811}
    },
    {
        2334,
        {21051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2334},
        {21051}
    },
    {
        2335,
        {21578, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2335},
        {21578}
    },
    {
        2336,
        {22269, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2336},
        {22269}
    },
    {
        2337,
        {31296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2337},
        {31296}
    },
    {
        2338,
        {37239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2338},
        {37239}
    },
    {
        2339,
        {40288, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2339},
        {40288}
    },
    {
        2340,
        {40658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2340},
        {40658}
    },
    {
        2341,
        {29508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2341},
        {29508}
    },
    {
        2342,
        {28425, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2342},
        {28425}
    },
    {
        2343,
        {33136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2343},
        {33136}
    },
    {
        2344,
        {29969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2344},
        {29969}
    },
    {
        2345,
        {24573, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2345},
        {24573}
    },
    {
        2346,
        {24794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2346},
        {24794}
    },
    {
        2347,
        {39592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2347},
        {39592}
    },
    {
        2348,
        {29403, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2348},
        {29403}
    },
    {
        2349,
        {36796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2349},
        {36796}
    },
    {
        2350,
        {27492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2350},
        {27492}
    },
    {
        2351,
        {38915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2351},
        {38915}
    },
    {
        2352,
        {20170, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2352},
        {20170}
    },
    {
        2353,
        {22256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2353},
        {22256}
    },
    {
        2354,
        {22372, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2354},
        {22372}
    },
    {
        2355,
        {22718, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2355},
        {22718}
    },
    {
        2356,
        {23130, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2356},
        {23130}
    },
    {
        2357,
        {24680, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2357},
        {24680}
    },
    {
        2358,
        {25031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2358},
        {25031}
    },
    {
        2359,
        {26127, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2359},
        {26127}
    },
    {
        2360,
        {26118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2360},
        {26118}
    },
    {
        2361,
        {26681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2361},
        {26681}
    },
    {
        2362,
        {26801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2362},
        {26801}
    },
    {
        2363,
        {28151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2363},
        {28151}
    },
    {
        2364,
        {30165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2364},
        {30165}
    },
    {
        2365,
        {32058, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2365},
        {32058}
    },
    {
        2366,
        {33390, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2366},
        {33390}
    },
    {
        2367,
        {39746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2367},
        {39746}
    },
    {
        2368,
        {20123, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2368},
        {20123}
    },
    {
        2369,
        {20304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2369},
        {20304}
    },
    {
        2370,
        {21449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2370},
        {21449}
    },
    {
        2371,
        {21766, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2371},
        {21766}
    },
    {
        2372,
        {23919, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2372},
        {23919}
    },
    {
        2373,
        {24038, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2373},
        {24038}
    },
    {
        2374,
        {24046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2374},
        {24046}
    },
    {
        2375,
        {26619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2375},
        {26619}
    },
    {
        2376,
        {27801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2376},
        {27801}
    },
    {
        2377,
        {29811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2377},
        {29811}
    },
    {
        2378,
        {30722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2378},
        {30722}
    },
    {
        2379,
        {35408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2379},
        {35408}
    },
    {
        2380,
        {37782, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2380},
        {37782}
    },
    {
        2381,
        {35039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2381},
        {35039}
    },
    {
        2382,
        {22352, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2382},
        {22352}
    },
    {
        2383,
        {24231, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2383},
        {24231}
    },
    {
        2384,
        {25387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2384},
        {25387}
    },
    {
        2385,
        {20661, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2385},
        {20661}
    },
    {
        2386,
        {20652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2386},
        {20652}
    },
    {
        2387,
        {20877, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2387},
        {20877}
    },
    {
        2388,
        {26368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2388},
        {26368}
    },
    {
        2389,
        {21705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2389},
        {21705}
    },
    {
        2390,
        {22622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2390},
        {22622}
    },
    {
        2391,
        {22971, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2391},
        {22971}
    },
    {
        2392,
        {23472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2392},
        {23472}
    },
    {
        2393,
        {24425, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2393},
        {24425}
    },
    {
        2394,
        {25165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2394},
        {25165}
    },
    {
        2395,
        {25505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2395},
        {25505}
    },
    {
        2396,
        {26685, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2396},
        {26685}
    },
    {
        2397,
        {27507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2397},
        {27507}
    },
    {
        2398,
        {28168, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2398},
        {28168}
    },
    {
        2399,
        {28797, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2399},
        {28797}
    },
    {
        2400,
        {37319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2400},
        {37319}
    },
    {
        2401,
        {29312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2401},
        {29312}
    },
    {
        2402,
        {30741, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2402},
        {30741}
    },
    {
        2403,
        {30758, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2403},
        {30758}
    },
    {
        2404,
        {31085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2404},
        {31085}
    },
    {
        2405,
        {25998, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2405},
        {25998}
    },
    {
        2406,
        {32048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2406},
        {32048}
    },
    {
        2407,
        {33756, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2407},
        {33756}
    },
    {
        2408,
        {35009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2408},
        {35009}
    },
    {
        2409,
        {36617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2409},
        {36617}
    },
    {
        2410,
        {38555, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2410},
        {38555}
    },
    {
        2411,
        {21092, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2411},
        {21092}
    },
    {
        2412,
        {22312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2412},
        {22312}
    },
    {
        2413,
        {26448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2413},
        {26448}
    },
    {
        2414,
        {32618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2414},
        {32618}
    },
    {
        2415,
        {36001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2415},
        {36001}
    },
    {
        2416,
        {20916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2416},
        {20916}
    },
    {
        2417,
        {22338, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2417},
        {22338}
    },
    {
        2418,
        {38442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2418},
        {38442}
    },
    {
        2419,
        {22586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2419},
        {22586}
    },
    {
        2420,
        {27018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2420},
        {27018}
    },
    {
        2421,
        {32948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2421},
        {32948}
    },
    {
        2422,
        {21682, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2422},
        {21682}
    },
    {
        2423,
        {23822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2423},
        {23822}
    },
    {
        2424,
        {22524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2424},
        {22524}
    },
    {
        2425,
        {30869, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2425},
        {30869}
    },
    {
        2426,
        {40442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2426},
        {40442}
    },
    {
        2427,
        {20316, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2427},
        {20316}
    },
    {
        2428,
        {21066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2428},
        {21066}
    },
    {
        2429,
        {21643, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2429},
        {21643}
    },
    {
        2430,
        {25662, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2430},
        {25662}
    },
    {
        2431,
        {26152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2431},
        {26152}
    },
    {
        2432,
        {26388, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2432},
        {26388}
    },
    {
        2433,
        {26613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2433},
        {26613}
    },
    {
        2434,
        {31364, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2434},
        {31364}
    },
    {
        2435,
        {31574, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2435},
        {31574}
    },
    {
        2436,
        {32034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2436},
        {32034}
    },
    {
        2437,
        {37679, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2437},
        {37679}
    },
    {
        2438,
        {26716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2438},
        {26716}
    },
    {
        2439,
        {39853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2439},
        {39853}
    },
    {
        2440,
        {31545, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2440},
        {31545}
    },
    {
        2441,
        {21273, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2441},
        {21273}
    },
    {
        2442,
        {20874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2442},
        {20874}
    },
    {
        2443,
        {21047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2443},
        {21047}
    },
    {
        2444,
        {23519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2444},
        {23519}
    },
    {
        2445,
        {25334, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2445},
        {25334}
    },
    {
        2446,
        {25774, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2446},
        {25774}
    },
    {
        2447,
        {25830, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2447},
        {25830}
    },
    {
        2448,
        {26413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2448},
        {26413}
    },
    {
        2449,
        {27578, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2449},
        {27578}
    },
    {
        2450,
        {34217, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2450},
        {34217}
    },
    {
        2451,
        {38609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2451},
        {38609}
    },
    {
        2452,
        {30352, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2452},
        {30352}
    },
    {
        2453,
        {39894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2453},
        {39894}
    },
    {
        2454,
        {25420, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2454},
        {25420}
    },
    {
        2455,
        {37638, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2455},
        {37638}
    },
    {
        2456,
        {39851, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2456},
        {39851}
    },
    {
        2457,
        {30399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2457},
        {30399}
    },
    {
        2458,
        {26194, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2458},
        {26194}
    },
    {
        2459,
        {19977, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2459},
        {19977}
    },
    {
        2460,
        {20632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2460},
        {20632}
    },
    {
        2461,
        {21442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2461},
        {21442}
    },
    {
        2462,
        {23665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2462},
        {23665}
    },
    {
        2463,
        {24808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2463},
        {24808}
    },
    {
        2464,
        {25746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2464},
        {25746}
    },
    {
        2465,
        {25955, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2465},
        {25955}
    },
    {
        2466,
        {26719, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2466},
        {26719}
    },
    {
        2467,
        {29158, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2467},
        {29158}
    },
    {
        2468,
        {29642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2468},
        {29642}
    },
    {
        2469,
        {29987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2469},
        {29987}
    },
    {
        2470,
        {31639, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2470},
        {31639}
    },
    {
        2471,
        {32386, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2471},
        {32386}
    },
    {
        2472,
        {34453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2472},
        {34453}
    },
    {
        2473,
        {35715, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2473},
        {35715}
    },
    {
        2474,
        {36059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2474},
        {36059}
    },
    {
        2475,
        {37240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2475},
        {37240}
    },
    {
        2476,
        {39184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2476},
        {39184}
    },
    {
        2477,
        {26028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2477},
        {26028}
    },
    {
        2478,
        {26283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2478},
        {26283}
    },
    {
        2479,
        {27531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2479},
        {27531}
    },
    {
        2480,
        {20181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2480},
        {20181}
    },
    {
        2481,
        {20180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2481},
        {20180}
    },
    {
        2482,
        {20282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2482},
        {20282}
    },
    {
        2483,
        {20351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2483},
        {20351}
    },
    {
        2484,
        {21050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2484},
        {21050}
    },
    {
        2485,
        {21496, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2485},
        {21496}
    },
    {
        2486,
        {21490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2486},
        {21490}
    },
    {
        2487,
        {21987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2487},
        {21987}
    },
    {
        2488,
        {22235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2488},
        {22235}
    },
    {
        2489,
        {22763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2489},
        {22763}
    },
    {
        2490,
        {22987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2490},
        {22987}
    },
    {
        2491,
        {22985, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2491},
        {22985}
    },
    {
        2492,
        {23039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2492},
        {23039}
    },
    {
        2493,
        {23376, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2493},
        {23376}
    },
    {
        2494,
        {23629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2494},
        {23629}
    },
    {
        2495,
        {24066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2495},
        {24066}
    },
    {
        2496,
        {24107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2496},
        {24107}
    },
    {
        2497,
        {24535, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2497},
        {24535}
    },
    {
        2498,
        {24605, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2498},
        {24605}
    },
    {
        2499,
        {25351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2499},
        {25351}
    },
    {
        2500,
        {25903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2500},
        {25903}
    },
    {
        2501,
        {23388, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2501},
        {23388}
    },
    {
        2502,
        {26031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2502},
        {26031}
    },
    {
        2503,
        {26045, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2503},
        {26045}
    },
    {
        2504,
        {26088, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2504},
        {26088}
    },
    {
        2505,
        {26525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2505},
        {26525}
    },
    {
        2506,
        {27490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2506},
        {27490}
    },
    {
        2507,
        {27515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2507},
        {27515}
    },
    {
        2508,
        {27663, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2508},
        {27663}
    },
    {
        2509,
        {29509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2509},
        {29509}
    },
    {
        2510,
        {31049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2510},
        {31049}
    },
    {
        2511,
        {31169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2511},
        {31169}
    },
    {
        2512,
        {31992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2512},
        {31992}
    },
    {
        2513,
        {32025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2513},
        {32025}
    },
    {
        2514,
        {32043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2514},
        {32043}
    },
    {
        2515,
        {32930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2515},
        {32930}
    },
    {
        2516,
        {33026, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2516},
        {33026}
    },
    {
        2517,
        {33267, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2517},
        {33267}
    },
    {
        2518,
        {35222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2518},
        {35222}
    },
    {
        2519,
        {35422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2519},
        {35422}
    },
    {
        2520,
        {35433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2520},
        {35433}
    },
    {
        2521,
        {35430, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2521},
        {35430}
    },
    {
        2522,
        {35468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2522},
        {35468}
    },
    {
        2523,
        {35566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2523},
        {35566}
    },
    {
        2524,
        {36039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2524},
        {36039}
    },
    {
        2525,
        {36060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2525},
        {36060}
    },
    {
        2526,
        {38604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2526},
        {38604}
    },
    {
        2527,
        {39164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2527},
        {39164}
    },
    {
        2528,
        {27503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2528},
        {27503}
    },
    {
        2529,
        {20107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2529},
        {20107}
    },
    {
        2530,
        {20284, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2530},
        {20284}
    },
    {
        2531,
        {20365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2531},
        {20365}
    },
    {
        2532,
        {20816, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2532},
        {20816}
    },
    {
        2533,
        {23383, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2533},
        {23383}
    },
    {
        2534,
        {23546, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2534},
        {23546}
    },
    {
        2535,
        {24904, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2535},
        {24904}
    },
    {
        2536,
        {25345, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2536},
        {25345}
    },
    {
        2537,
        {26178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2537},
        {26178}
    },
    {
        2538,
        {27425, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2538},
        {27425}
    },
    {
        2539,
        {28363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2539},
        {28363}
    },
    {
        2540,
        {27835, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2540},
        {27835}
    },
    {
        2541,
        {29246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2541},
        {29246}
    },
    {
        2542,
        {29885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2542},
        {29885}
    },
    {
        2543,
        {30164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2543},
        {30164}
    },
    {
        2544,
        {30913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2544},
        {30913}
    },
    {
        2545,
        {31034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2545},
        {31034}
    },
    {
        2546,
        {32780, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2546},
        {32780}
    },
    {
        2547,
        {32819, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2547},
        {32819}
    },
    {
        2548,
        {33258, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2548},
        {33258}
    },
    {
        2549,
        {33940, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2549},
        {33940}
    },
    {
        2550,
        {36766, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2550},
        {36766}
    },
    {
        2551,
        {27728, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2551},
        {27728}
    },
    {
        2552,
        {40575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2552},
        {40575}
    },
    {
        2553,
        {24335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2553},
        {24335}
    },
    {
        2554,
        {35672, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2554},
        {35672}
    },
    {
        2555,
        {40235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2555},
        {40235}
    },
    {
        2556,
        {31482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2556},
        {31482}
    },
    {
        2557,
        {36600, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2557},
        {36600}
    },
    {
        2558,
        {23437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2558},
        {23437}
    },
    {
        2559,
        {38635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2559},
        {38635}
    },
    {
        2560,
        {19971, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2560},
        {19971}
    },
    {
        2561,
        {21489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2561},
        {21489}
    },
    {
        2562,
        {22519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2562},
        {22519}
    },
    {
        2563,
        {22833, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2563},
        {22833}
    },
    {
        2564,
        {23241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2564},
        {23241}
    },
    {
        2565,
        {23460, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2565},
        {23460}
    },
    {
        2566,
        {24713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2566},
        {24713}
    },
    {
        2567,
        {28287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2567},
        {28287}
    },
    {
        2568,
        {28422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2568},
        {28422}
    },
    {
        2569,
        {30142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2569},
        {30142}
    },
    {
        2570,
        {36074, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2570},
        {36074}
    },
    {
        2571,
        {23455, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2571},
        {23455}
    },
    {
        2572,
        {34048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2572},
        {34048}
    },
    {
        2573,
        {31712, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2573},
        {31712}
    },
    {
        2574,
        {20594, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2574},
        {20594}
    },
    {
        2575,
        {26612, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2575},
        {26612}
    },
    {
        2576,
        {33437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2576},
        {33437}
    },
    {
        2577,
        {23649, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2577},
        {23649}
    },
    {
        2578,
        {34122, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2578},
        {34122}
    },
    {
        2579,
        {32286, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2579},
        {32286}
    },
    {
        2580,
        {33294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2580},
        {33294}
    },
    {
        2581,
        {20889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2581},
        {20889}
    },
    {
        2582,
        {23556, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2582},
        {23556}
    },
    {
        2583,
        {25448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2583},
        {25448}
    },
    {
        2584,
        {36198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2584},
        {36198}
    },
    {
        2585,
        {26012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2585},
        {26012}
    },
    {
        2586,
        {29038, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2586},
        {29038}
    },
    {
        2587,
        {31038, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2587},
        {31038}
    },
    {
        2588,
        {32023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2588},
        {32023}
    },
    {
        2589,
        {32773, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2589},
        {32773}
    },
    {
        2590,
        {35613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2590},
        {35613}
    },
    {
        2591,
        {36554, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2591},
        {36554}
    },
    {
        2592,
        {36974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2592},
        {36974}
    },
    {
        2593,
        {34503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2593},
        {34503}
    },
    {
        2594,
        {37034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2594},
        {37034}
    },
    {
        2595,
        {20511, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2595},
        {20511}
    },
    {
        2596,
        {21242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2596},
        {21242}
    },
    {
        2597,
        {23610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2597},
        {23610}
    },
    {
        2598,
        {26451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2598},
        {26451}
    },
    {
        2599,
        {28796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2599},
        {28796}
    },
    {
        2600,
        {29237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2600},
        {29237}
    },
    {
        2601,
        {37196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2601},
        {37196}
    },
    {
        2602,
        {37320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2602},
        {37320}
    },
    {
        2603,
        {37675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2603},
        {37675}
    },
    {
        2604,
        {33509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2604},
        {33509}
    },
    {
        2605,
        {23490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2605},
        {23490}
    },
    {
        2606,
        {24369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2606},
        {24369}
    },
    {
        2607,
        {24825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2607},
        {24825}
    },
    {
        2608,
        {20027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2608},
        {20027}
    },
    {
        2609,
        {21462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2609},
        {21462}
    },
    {
        2610,
        {23432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2610},
        {23432}
    },
    {
        2611,
        {25163, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2611},
        {25163}
    },
    {
        2612,
        {26417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2612},
        {26417}
    },
    {
        2613,
        {27530, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2613},
        {27530}
    },
    {
        2614,
        {29417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2614},
        {29417}
    },
    {
        2615,
        {29664, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2615},
        {29664}
    },
    {
        2616,
        {31278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2616},
        {31278}
    },
    {
        2617,
        {33131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2617},
        {33131}
    },
    {
        2618,
        {36259, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2618},
        {36259}
    },
    {
        2619,
        {37202, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2619},
        {37202}
    },
    {
        2620,
        {39318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2620},
        {39318}
    },
    {
        2621,
        {20754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2621},
        {20754}
    },
    {
        2622,
        {21463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2622},
        {21463}
    },
    {
        2623,
        {21610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2623},
        {21610}
    },
    {
        2624,
        {23551, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2624},
        {23551}
    },
    {
        2625,
        {25480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2625},
        {25480}
    },
    {
        2626,
        {27193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2626},
        {27193}
    },
    {
        2627,
        {32172, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2627},
        {32172}
    },
    {
        2628,
        {38656, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2628},
        {38656}
    },
    {
        2629,
        {22234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2629},
        {22234}
    },
    {
        2630,
        {21454, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2630},
        {21454}
    },
    {
        2631,
        {21608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2631},
        {21608}
    },
    {
        2632,
        {23447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2632},
        {23447}
    },
    {
        2633,
        {23601, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2633},
        {23601}
    },
    {
        2634,
        {24030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2634},
        {24030}
    },
    {
        2635,
        {20462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2635},
        {20462}
    },
    {
        2636,
        {24833, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2636},
        {24833}
    },
    {
        2637,
        {25342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2637},
        {25342}
    },
    {
        2638,
        {27954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2638},
        {27954}
    },
    {
        2639,
        {31168, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2639},
        {31168}
    },
    {
        2640,
        {31179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2640},
        {31179}
    },
    {
        2641,
        {32066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2641},
        {32066}
    },
    {
        2642,
        {32333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2642},
        {32333}
    },
    {
        2643,
        {32722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2643},
        {32722}
    },
    {
        2644,
        {33261, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2644},
        {33261}
    },
    {
        2645,
        {33311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2645},
        {33311}
    },
    {
        2646,
        {33936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2646},
        {33936}
    },
    {
        2647,
        {34886, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2647},
        {34886}
    },
    {
        2648,
        {35186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2648},
        {35186}
    },
    {
        2649,
        {35728, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2649},
        {35728}
    },
    {
        2650,
        {36468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2650},
        {36468}
    },
    {
        2651,
        {36655, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2651},
        {36655}
    },
    {
        2652,
        {36913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2652},
        {36913}
    },
    {
        2653,
        {37195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2653},
        {37195}
    },
    {
        2654,
        {37228, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2654},
        {37228}
    },
    {
        2655,
        {38598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2655},
        {38598}
    },
    {
        2656,
        {37276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2656},
        {37276}
    },
    {
        2657,
        {20160, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2657},
        {20160}
    },
    {
        2658,
        {20303, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2658},
        {20303}
    },
    {
        2659,
        {20805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2659},
        {20805}
    },
    {
        2660,
        {21313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2660},
        {21313}
    },
    {
        2661,
        {24467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2661},
        {24467}
    },
    {
        2662,
        {25102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2662},
        {25102}
    },
    {
        2663,
        {26580, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2663},
        {26580}
    },
    {
        2664,
        {27713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2664},
        {27713}
    },
    {
        2665,
        {28171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2665},
        {28171}
    },
    {
        2666,
        {29539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2666},
        {29539}
    },
    {
        2667,
        {32294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2667},
        {32294}
    },
    {
        2668,
        {37325, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2668},
        {37325}
    },
    {
        2669,
        {37507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2669},
        {37507}
    },
    {
        2670,
        {21460, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2670},
        {21460}
    },
    {
        2671,
        {22809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2671},
        {22809}
    },
    {
        2672,
        {23487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2672},
        {23487}
    },
    {
        2673,
        {28113, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2673},
        {28113}
    },
    {
        2674,
        {31069, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2674},
        {31069}
    },
    {
        2675,
        {32302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2675},
        {32302}
    },
    {
        2676,
        {31899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2676},
        {31899}
    },
    {
        2677,
        {22654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2677},
        {22654}
    },
    {
        2678,
        {29087, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2678},
        {29087}
    },
    {
        2679,
        {20986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2679},
        {20986}
    },
    {
        2680,
        {34899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2680},
        {34899}
    },
    {
        2681,
        {36848, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2681},
        {36848}
    },
    {
        2682,
        {20426, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2682},
        {20426}
    },
    {
        2683,
        {23803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2683},
        {23803}
    },
    {
        2684,
        {26149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2684},
        {26149}
    },
    {
        2685,
        {30636, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2685},
        {30636}
    },
    {
        2686,
        {31459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2686},
        {31459}
    },
    {
        2687,
        {33308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2687},
        {33308}
    },
    {
        2688,
        {39423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2688},
        {39423}
    },
    {
        2689,
        {20934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2689},
        {20934}
    },
    {
        2690,
        {24490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2690},
        {24490}
    },
    {
        2691,
        {26092, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2691},
        {26092}
    },
    {
        2692,
        {26991, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2692},
        {26991}
    },
    {
        2693,
        {27529, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2693},
        {27529}
    },
    {
        2694,
        {28147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2694},
        {28147}
    },
    {
        2695,
        {28310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2695},
        {28310}
    },
    {
        2696,
        {28516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2696},
        {28516}
    },
    {
        2697,
        {30462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2697},
        {30462}
    },
    {
        2698,
        {32020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2698},
        {32020}
    },
    {
        2699,
        {24033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2699},
        {24033}
    },
    {
        2700,
        {36981, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2700},
        {36981}
    },
    {
        2701,
        {37255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2701},
        {37255}
    },
    {
        2702,
        {38918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2702},
        {38918}
    },
    {
        2703,
        {20966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2703},
        {20966}
    },
    {
        2704,
        {21021, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2704},
        {21021}
    },
    {
        2705,
        {25152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2705},
        {25152}
    },
    {
        2706,
        {26257, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2706},
        {26257}
    },
    {
        2707,
        {26329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2707},
        {26329}
    },
    {
        2708,
        {28186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2708},
        {28186}
    },
    {
        2709,
        {24246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2709},
        {24246}
    },
    {
        2710,
        {32210, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2710},
        {32210}
    },
    {
        2711,
        {32626, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2711},
        {32626}
    },
    {
        2712,
        {26360, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2712},
        {26360}
    },
    {
        2713,
        {34223, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2713},
        {34223}
    },
    {
        2714,
        {34295, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2714},
        {34295}
    },
    {
        2715,
        {35576, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2715},
        {35576}
    },
    {
        2716,
        {21161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2716},
        {21161}
    },
    {
        2717,
        {21465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2717},
        {21465}
    },
    {
        2718,
        {22899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2718},
        {22899}
    },
    {
        2719,
        {24207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2719},
        {24207}
    },
    {
        2720,
        {24464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2720},
        {24464}
    },
    {
        2721,
        {24661, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2721},
        {24661}
    },
    {
        2722,
        {37604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2722},
        {37604}
    },
    {
        2723,
        {38500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2723},
        {38500}
    },
    {
        2724,
        {20663, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2724},
        {20663}
    },
    {
        2725,
        {20767, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2725},
        {20767}
    },
    {
        2726,
        {21213, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2726},
        {21213}
    },
    {
        2727,
        {21280, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2727},
        {21280}
    },
    {
        2728,
        {21319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2728},
        {21319}
    },
    {
        2729,
        {21484, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2729},
        {21484}
    },
    {
        2730,
        {21736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2730},
        {21736}
    },
    {
        2731,
        {21830, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2731},
        {21830}
    },
    {
        2732,
        {21809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2732},
        {21809}
    },
    {
        2733,
        {22039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2733},
        {22039}
    },
    {
        2734,
        {22888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2734},
        {22888}
    },
    {
        2735,
        {22974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2735},
        {22974}
    },
    {
        2736,
        {23100, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2736},
        {23100}
    },
    {
        2737,
        {23477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2737},
        {23477}
    },
    {
        2738,
        {23558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2738},
        {23558}
    },
    {
        2739,
        {23567, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2739},
        {23567}
    },
    {
        2740,
        {23569, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2740},
        {23569}
    },
    {
        2741,
        {23578, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2741},
        {23578}
    },
    {
        2742,
        {24196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2742},
        {24196}
    },
    {
        2743,
        {24202, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2743},
        {24202}
    },
    {
        2744,
        {24288, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2744},
        {24288}
    },
    {
        2745,
        {24432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2745},
        {24432}
    },
    {
        2746,
        {25215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2746},
        {25215}
    },
    {
        2747,
        {25220, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2747},
        {25220}
    },
    {
        2748,
        {25307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2748},
        {25307}
    },
    {
        2749,
        {25484, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2749},
        {25484}
    },
    {
        2750,
        {25463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2750},
        {25463}
    },
    {
        2751,
        {26119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2751},
        {26119}
    },
    {
        2752,
        {26124, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2752},
        {26124}
    },
    {
        2753,
        {26157, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2753},
        {26157}
    },
    {
        2754,
        {26230, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2754},
        {26230}
    },
    {
        2755,
        {26494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2755},
        {26494}
    },
    {
        2756,
        {26786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2756},
        {26786}
    },
    {
        2757,
        {27167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2757},
        {27167}
    },
    {
        2758,
        {27189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2758},
        {27189}
    },
    {
        2759,
        {27836, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2759},
        {27836}
    },
    {
        2760,
        {28040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2760},
        {28040}
    },
    {
        2761,
        {28169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2761},
        {28169}
    },
    {
        2762,
        {28248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2762},
        {28248}
    },
    {
        2763,
        {28988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2763},
        {28988}
    },
    {
        2764,
        {28966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2764},
        {28966}
    },
    {
        2765,
        {29031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2765},
        {29031}
    },
    {
        2766,
        {30151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2766},
        {30151}
    },
    {
        2767,
        {30465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2767},
        {30465}
    },
    {
        2768,
        {30813, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2768},
        {30813}
    },
    {
        2769,
        {30977, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2769},
        {30977}
    },
    {
        2770,
        {31077, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2770},
        {31077}
    },
    {
        2771,
        {31216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2771},
        {31216}
    },
    {
        2772,
        {31456, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2772},
        {31456}
    },
    {
        2773,
        {31505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2773},
        {31505}
    },
    {
        2774,
        {31911, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2774},
        {31911}
    },
    {
        2775,
        {32057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2775},
        {32057}
    },
    {
        2776,
        {32918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2776},
        {32918}
    },
    {
        2777,
        {33750, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2777},
        {33750}
    },
    {
        2778,
        {33931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2778},
        {33931}
    },
    {
        2779,
        {34121, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2779},
        {34121}
    },
    {
        2780,
        {34909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2780},
        {34909}
    },
    {
        2781,
        {35059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2781},
        {35059}
    },
    {
        2782,
        {35359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2782},
        {35359}
    },
    {
        2783,
        {35388, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2783},
        {35388}
    },
    {
        2784,
        {35412, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2784},
        {35412}
    },
    {
        2785,
        {35443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2785},
        {35443}
    },
    {
        2786,
        {35937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2786},
        {35937}
    },
    {
        2787,
        {36062, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2787},
        {36062}
    },
    {
        2788,
        {37284, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2788},
        {37284}
    },
    {
        2789,
        {37478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2789},
        {37478}
    },
    {
        2790,
        {37758, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2790},
        {37758}
    },
    {
        2791,
        {37912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2791},
        {37912}
    },
    {
        2792,
        {38556, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2792},
        {38556}
    },
    {
        2793,
        {38808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2793},
        {38808}
    },
    {
        2794,
        {19978, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2794},
        {19978}
    },
    {
        2795,
        {19976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2795},
        {19976}
    },
    {
        2796,
        {19998, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2796},
        {19998}
    },
    {
        2797,
        {20055, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2797},
        {20055}
    },
    {
        2798,
        {20887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2798},
        {20887}
    },
    {
        2799,
        {21104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2799},
        {21104}
    },
    {
        2800,
        {22478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2800},
        {22478}
    },
    {
        2801,
        {22580, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2801},
        {22580}
    },
    {
        2802,
        {22732, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2802},
        {22732}
    },
    {
        2803,
        {23330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2803},
        {23330}
    },
    {
        2804,
        {24120, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2804},
        {24120}
    },
    {
        2805,
        {24773, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2805},
        {24773}
    },
    {
        2806,
        {25854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2806},
        {25854}
    },
    {
        2807,
        {26465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2807},
        {26465}
    },
    {
        2808,
        {26454, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2808},
        {26454}
    },
    {
        2809,
        {27972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2809},
        {27972}
    },
    {
        2810,
        {29366, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2810},
        {29366}
    },
    {
        2811,
        {30067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2811},
        {30067}
    },
    {
        2812,
        {31331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2812},
        {31331}
    },
    {
        2813,
        {33976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2813},
        {33976}
    },
    {
        2814,
        {35698, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2814},
        {35698}
    },
    {
        2815,
        {37304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2815},
        {37304}
    },
    {
        2816,
        {37664, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2816},
        {37664}
    },
    {
        2817,
        {22065, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2817},
        {22065}
    },
    {
        2818,
        {22516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2818},
        {22516}
    },
    {
        2819,
        {39166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2819},
        {39166}
    },
    {
        2820,
        {25325, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2820},
        {25325}
    },
    {
        2821,
        {26893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2821},
        {26893}
    },
    {
        2822,
        {27542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2822},
        {27542}
    },
    {
        2823,
        {29165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2823},
        {29165}
    },
    {
        2824,
        {32340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2824},
        {32340}
    },
    {
        2825,
        {32887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2825},
        {32887}
    },
    {
        2826,
        {33394, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2826},
        {33394}
    },
    {
        2827,
        {35302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2827},
        {35302}
    },
    {
        2828,
        {39135, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2828},
        {39135}
    },
    {
        2829,
        {34645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2829},
        {34645}
    },
    {
        2830,
        {36785, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2830},
        {36785}
    },
    {
        2831,
        {23611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2831},
        {23611}
    },
    {
        2832,
        {20280, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2832},
        {20280}
    },
    {
        2833,
        {20449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2833},
        {20449}
    },
    {
        2834,
        {20405, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2834},
        {20405}
    },
    {
        2835,
        {21767, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2835},
        {21767}
    },
    {
        2836,
        {23072, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2836},
        {23072}
    },
    {
        2837,
        {23517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2837},
        {23517}
    },
    {
        2838,
        {23529, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2838},
        {23529}
    },
    {
        2839,
        {24515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2839},
        {24515}
    },
    {
        2840,
        {24910, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2840},
        {24910}
    },
    {
        2841,
        {25391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2841},
        {25391}
    },
    {
        2842,
        {26032, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2842},
        {26032}
    },
    {
        2843,
        {26187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2843},
        {26187}
    },
    {
        2844,
        {26862, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2844},
        {26862}
    },
    {
        2845,
        {27035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2845},
        {27035}
    },
    {
        2846,
        {28024, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2846},
        {28024}
    },
    {
        2847,
        {28145, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2847},
        {28145}
    },
    {
        2848,
        {30003, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2848},
        {30003}
    },
    {
        2849,
        {30137, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2849},
        {30137}
    },
    {
        2850,
        {30495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2850},
        {30495}
    },
    {
        2851,
        {31070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2851},
        {31070}
    },
    {
        2852,
        {31206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2852},
        {31206}
    },
    {
        2853,
        {32051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2853},
        {32051}
    },
    {
        2854,
        {33251, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2854},
        {33251}
    },
    {
        2855,
        {33455, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2855},
        {33455}
    },
    {
        2856,
        {34218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2856},
        {34218}
    },
    {
        2857,
        {35242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2857},
        {35242}
    },
    {
        2858,
        {35386, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2858},
        {35386}
    },
    {
        2859,
        {36523, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2859},
        {36523}
    },
    {
        2860,
        {36763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2860},
        {36763}
    },
    {
        2861,
        {36914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2861},
        {36914}
    },
    {
        2862,
        {37341, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2862},
        {37341}
    },
    {
        2863,
        {38663, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2863},
        {38663}
    },
    {
        2864,
        {20154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2864},
        {20154}
    },
    {
        2865,
        {20161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2865},
        {20161}
    },
    {
        2866,
        {20995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2866},
        {20995}
    },
    {
        2867,
        {22645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2867},
        {22645}
    },
    {
        2868,
        {22764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2868},
        {22764}
    },
    {
        2869,
        {23563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2869},
        {23563}
    },
    {
        2870,
        {29978, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2870},
        {29978}
    },
    {
        2871,
        {23613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2871},
        {23613}
    },
    {
        2872,
        {33102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2872},
        {33102}
    },
    {
        2873,
        {35338, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2873},
        {35338}
    },
    {
        2874,
        {36805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2874},
        {36805}
    },
    {
        2875,
        {38499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2875},
        {38499}
    },
    {
        2876,
        {38765, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2876},
        {38765}
    },
    {
        2877,
        {31525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2877},
        {31525}
    },
    {
        2878,
        {35535, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2878},
        {35535}
    },
    {
        2879,
        {38920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2879},
        {38920}
    },
    {
        2880,
        {37218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2880},
        {37218}
    },
    {
        2881,
        {22259, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2881},
        {22259}
    },
    {
        2882,
        {21416, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2882},
        {21416}
    },
    {
        2883,
        {36887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2883},
        {36887}
    },
    {
        2884,
        {21561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2884},
        {21561}
    },
    {
        2885,
        {22402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2885},
        {22402}
    },
    {
        2886,
        {24101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2886},
        {24101}
    },
    {
        2887,
        {25512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2887},
        {25512}
    },
    {
        2888,
        {27700, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2888},
        {27700}
    },
    {
        2889,
        {28810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2889},
        {28810}
    },
    {
        2890,
        {30561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2890},
        {30561}
    },
    {
        2891,
        {31883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2891},
        {31883}
    },
    {
        2892,
        {32736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2892},
        {32736}
    },
    {
        2893,
        {34928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2893},
        {34928}
    },
    {
        2894,
        {36930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2894},
        {36930}
    },
    {
        2895,
        {37204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2895},
        {37204}
    },
    {
        2896,
        {37648, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2896},
        {37648}
    },
    {
        2897,
        {37656, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2897},
        {37656}
    },
    {
        2898,
        {38543, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2898},
        {38543}
    },
    {
        2899,
        {29790, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2899},
        {29790}
    },
    {
        2900,
        {39620, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2900},
        {39620}
    },
    {
        2901,
        {23815, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2901},
        {23815}
    },
    {
        2902,
        {23913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2902},
        {23913}
    },
    {
        2903,
        {25968, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2903},
        {25968}
    },
    {
        2904,
        {26530, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2904},
        {26530}
    },
    {
        2905,
        {36264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2905},
        {36264}
    },
    {
        2906,
        {38619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2906},
        {38619}
    },
    {
        2907,
        {25454, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2907},
        {25454}
    },
    {
        2908,
        {26441, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2908},
        {26441}
    },
    {
        2909,
        {26905, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2909},
        {26905}
    },
    {
        2910,
        {33733, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2910},
        {33733}
    },
    {
        2911,
        {38935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2911},
        {38935}
    },
    {
        2912,
        {38592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2912},
        {38592}
    },
    {
        2913,
        {35070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2913},
        {35070}
    },
    {
        2914,
        {28548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2914},
        {28548}
    },
    {
        2915,
        {25722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2915},
        {25722}
    },
    {
        2916,
        {23544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2916},
        {23544}
    },
    {
        2917,
        {19990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2917},
        {19990}
    },
    {
        2918,
        {28716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2918},
        {28716}
    },
    {
        2919,
        {30045, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2919},
        {30045}
    },
    {
        2920,
        {26159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2920},
        {26159}
    },
    {
        2921,
        {20932, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2921},
        {20932}
    },
    {
        2922,
        {21046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2922},
        {21046}
    },
    {
        2923,
        {21218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2923},
        {21218}
    },
    {
        2924,
        {22995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2924},
        {22995}
    },
    {
        2925,
        {24449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2925},
        {24449}
    },
    {
        2926,
        {24615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2926},
        {24615}
    },
    {
        2927,
        {25104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2927},
        {25104}
    },
    {
        2928,
        {25919, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2928},
        {25919}
    },
    {
        2929,
        {25972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2929},
        {25972}
    },
    {
        2930,
        {26143, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2930},
        {26143}
    },
    {
        2931,
        {26228, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2931},
        {26228}
    },
    {
        2932,
        {26866, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2932},
        {26866}
    },
    {
        2933,
        {26646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2933},
        {26646}
    },
    {
        2934,
        {27491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2934},
        {27491}
    },
    {
        2935,
        {28165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2935},
        {28165}
    },
    {
        2936,
        {29298, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2936},
        {29298}
    },
    {
        2937,
        {29983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2937},
        {29983}
    },
    {
        2938,
        {30427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2938},
        {30427}
    },
    {
        2939,
        {31934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2939},
        {31934}
    },
    {
        2940,
        {32854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2940},
        {32854}
    },
    {
        2941,
        {22768, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2941},
        {22768}
    },
    {
        2942,
        {35069, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2942},
        {35069}
    },
    {
        2943,
        {35199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2943},
        {35199}
    },
    {
        2944,
        {35488, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2944},
        {35488}
    },
    {
        2945,
        {35475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2945},
        {35475}
    },
    {
        2946,
        {35531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2946},
        {35531}
    },
    {
        2947,
        {36893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2947},
        {36893}
    },
    {
        2948,
        {37266, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2948},
        {37266}
    },
    {
        2949,
        {38738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2949},
        {38738}
    },
    {
        2950,
        {38745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2950},
        {38745}
    },
    {
        2951,
        {25993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2951},
        {25993}
    },
    {
        2952,
        {31246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2952},
        {31246}
    },
    {
        2953,
        {33030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2953},
        {33030}
    },
    {
        2954,
        {38587, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2954},
        {38587}
    },
    {
        2955,
        {24109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2955},
        {24109}
    },
    {
        2956,
        {24796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2956},
        {24796}
    },
    {
        2957,
        {25114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2957},
        {25114}
    },
    {
        2958,
        {26021, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2958},
        {26021}
    },
    {
        2959,
        {26132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2959},
        {26132}
    },
    {
        2960,
        {26512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2960},
        {26512}
    },
    {
        2961,
        {30707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2961},
        {30707}
    },
    {
        2962,
        {31309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2962},
        {31309}
    },
    {
        2963,
        {31821, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2963},
        {31821}
    },
    {
        2964,
        {32318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2964},
        {32318}
    },
    {
        2965,
        {33034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2965},
        {33034}
    },
    {
        2966,
        {36012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2966},
        {36012}
    },
    {
        2967,
        {36196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2967},
        {36196}
    },
    {
        2968,
        {36321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2968},
        {36321}
    },
    {
        2969,
        {36447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2969},
        {36447}
    },
    {
        2970,
        {30889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2970},
        {30889}
    },
    {
        2971,
        {20999, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2971},
        {20999}
    },
    {
        2972,
        {25305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2972},
        {25305}
    },
    {
        2973,
        {25509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2973},
        {25509}
    },
    {
        2974,
        {25666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2974},
        {25666}
    },
    {
        2975,
        {25240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2975},
        {25240}
    },
    {
        2976,
        {35373, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2976},
        {35373}
    },
    {
        2977,
        {31363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2977},
        {31363}
    },
    {
        2978,
        {31680, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2978},
        {31680}
    },
    {
        2979,
        {35500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2979},
        {35500}
    },
    {
        2980,
        {38634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2980},
        {38634}
    },
    {
        2981,
        {32118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2981},
        {32118}
    },
    {
        2982,
        {33292, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2982},
        {33292}
    },
    {
        2983,
        {34633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2983},
        {34633}
    },
    {
        2984,
        {20185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2984},
        {20185}
    },
    {
        2985,
        {20808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2985},
        {20808}
    },
    {
        2986,
        {21315, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2986},
        {21315}
    },
    {
        2987,
        {21344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2987},
        {21344}
    },
    {
        2988,
        {23459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2988},
        {23459}
    },
    {
        2989,
        {23554, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2989},
        {23554}
    },
    {
        2990,
        {23574, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2990},
        {23574}
    },
    {
        2991,
        {24029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2991},
        {24029}
    },
    {
        2992,
        {25126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2992},
        {25126}
    },
    {
        2993,
        {25159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2993},
        {25159}
    },
    {
        2994,
        {25776, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2994},
        {25776}
    },
    {
        2995,
        {26643, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2995},
        {26643}
    },
    {
        2996,
        {26676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2996},
        {26676}
    },
    {
        2997,
        {27849, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2997},
        {27849}
    },
    {
        2998,
        {27973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2998},
        {27973}
    },
    {
        2999,
        {27927, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {2999},
        {27927}
    },
    {
        3000,
        {26579, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3000},
        {26579}
    },
    {
        3001,
        {28508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3001},
        {28508}
    },
    {
        3002,
        {29006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3002},
        {29006}
    },
    {
        3003,
        {29053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3003},
        {29053}
    },
    {
        3004,
        {26059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3004},
        {26059}
    },
    {
        3005,
        {31359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3005},
        {31359}
    },
    {
        3006,
        {31661, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3006},
        {31661}
    },
    {
        3007,
        {32218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3007},
        {32218}
    },
    {
        3008,
        {32330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3008},
        {32330}
    },
    {
        3009,
        {32680, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3009},
        {32680}
    },
    {
        3010,
        {33146, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3010},
        {33146}
    },
    {
        3011,
        {33307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3011},
        {33307}
    },
    {
        3012,
        {33337, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3012},
        {33337}
    },
    {
        3013,
        {34214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3013},
        {34214}
    },
    {
        3014,
        {35438, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3014},
        {35438}
    },
    {
        3015,
        {36046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3015},
        {36046}
    },
    {
        3016,
        {36341, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3016},
        {36341}
    },
    {
        3017,
        {36984, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3017},
        {36984}
    },
    {
        3018,
        {36983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3018},
        {36983}
    },
    {
        3019,
        {37549, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3019},
        {37549}
    },
    {
        3020,
        {37521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3020},
        {37521}
    },
    {
        3021,
        {38275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3021},
        {38275}
    },
    {
        3022,
        {39854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3022},
        {39854}
    },
    {
        3023,
        {21069, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3023},
        {21069}
    },
    {
        3024,
        {21892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3024},
        {21892}
    },
    {
        3025,
        {28472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3025},
        {28472}
    },
    {
        3026,
        {28982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3026},
        {28982}
    },
    {
        3027,
        {20840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3027},
        {20840}
    },
    {
        3028,
        {31109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3028},
        {31109}
    },
    {
        3029,
        {32341, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3029},
        {32341}
    },
    {
        3030,
        {33203, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3030},
        {33203}
    },
    {
        3031,
        {31950, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3031},
        {31950}
    },
    {
        3032,
        {22092, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3032},
        {22092}
    },
    {
        3033,
        {22609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3033},
        {22609}
    },
    {
        3034,
        {23720, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3034},
        {23720}
    },
    {
        3035,
        {25514, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3035},
        {25514}
    },
    {
        3036,
        {26366, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3036},
        {26366}
    },
    {
        3037,
        {26365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3037},
        {26365}
    },
    {
        3038,
        {26970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3038},
        {26970}
    },
    {
        3039,
        {29401, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3039},
        {29401}
    },
    {
        3040,
        {30095, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3040},
        {30095}
    },
    {
        3041,
        {30094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3041},
        {30094}
    },
    {
        3042,
        {30990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3042},
        {30990}
    },
    {
        3043,
        {31062, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3043},
        {31062}
    },
    {
        3044,
        {31199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3044},
        {31199}
    },
    {
        3045,
        {31895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3045},
        {31895}
    },
    {
        3046,
        {32032, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3046},
        {32032}
    },
    {
        3047,
        {32068, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3047},
        {32068}
    },
    {
        3048,
        {34311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3048},
        {34311}
    },
    {
        3049,
        {35380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3049},
        {35380}
    },
    {
        3050,
        {38459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3050},
        {38459}
    },
    {
        3051,
        {36961, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3051},
        {36961}
    },
    {
        3052,
        {40736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3052},
        {40736}
    },
    {
        3053,
        {20711, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3053},
        {20711}
    },
    {
        3054,
        {21109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3054},
        {21109}
    },
    {
        3055,
        {21452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3055},
        {21452}
    },
    {
        3056,
        {21474, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3056},
        {21474}
    },
    {
        3057,
        {20489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3057},
        {20489}
    },
    {
        3058,
        {21930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3058},
        {21930}
    },
    {
        3059,
        {22766, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3059},
        {22766}
    },
    {
        3060,
        {22863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3060},
        {22863}
    },
    {
        3061,
        {29245, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3061},
        {29245}
    },
    {
        3062,
        {23435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3062},
        {23435}
    },
    {
        3063,
        {23652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3063},
        {23652}
    },
    {
        3064,
        {21277, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3064},
        {21277}
    },
    {
        3065,
        {24803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3065},
        {24803}
    },
    {
        3066,
        {24819, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3066},
        {24819}
    },
    {
        3067,
        {25436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3067},
        {25436}
    },
    {
        3068,
        {25475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3068},
        {25475}
    },
    {
        3069,
        {25407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3069},
        {25407}
    },
    {
        3070,
        {25531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3070},
        {25531}
    },
    {
        3071,
        {25805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3071},
        {25805}
    },
    {
        3072,
        {26089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3072},
        {26089}
    },
    {
        3073,
        {26361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3073},
        {26361}
    },
    {
        3074,
        {24035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3074},
        {24035}
    },
    {
        3075,
        {27085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3075},
        {27085}
    },
    {
        3076,
        {27133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3076},
        {27133}
    },
    {
        3077,
        {28437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3077},
        {28437}
    },
    {
        3078,
        {29157, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3078},
        {29157}
    },
    {
        3079,
        {20105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3079},
        {20105}
    },
    {
        3080,
        {30185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3080},
        {30185}
    },
    {
        3081,
        {30456, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3081},
        {30456}
    },
    {
        3082,
        {31379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3082},
        {31379}
    },
    {
        3083,
        {31967, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3083},
        {31967}
    },
    {
        3084,
        {32207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3084},
        {32207}
    },
    {
        3085,
        {32156, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3085},
        {32156}
    },
    {
        3086,
        {32865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3086},
        {32865}
    },
    {
        3087,
        {33609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3087},
        {33609}
    },
    {
        3088,
        {33624, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3088},
        {33624}
    },
    {
        3089,
        {33900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3089},
        {33900}
    },
    {
        3090,
        {33980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3090},
        {33980}
    },
    {
        3091,
        {34299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3091},
        {34299}
    },
    {
        3092,
        {35013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3092},
        {35013}
    },
    {
        3093,
        {36208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3093},
        {36208}
    },
    {
        3094,
        {36865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3094},
        {36865}
    },
    {
        3095,
        {36973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3095},
        {36973}
    },
    {
        3096,
        {37783, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3096},
        {37783}
    },
    {
        3097,
        {38684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3097},
        {38684}
    },
    {
        3098,
        {39442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3098},
        {39442}
    },
    {
        3099,
        {20687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3099},
        {20687}
    },
    {
        3100,
        {22679, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3100},
        {22679}
    },
    {
        3101,
        {24974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3101},
        {24974}
    },
    {
        3102,
        {33235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3102},
        {33235}
    },
    {
        3103,
        {34101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3103},
        {34101}
    },
    {
        3104,
        {36104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3104},
        {36104}
    },
    {
        3105,
        {36896, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3105},
        {36896}
    },
    {
        3106,
        {20419, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3106},
        {20419}
    },
    {
        3107,
        {20596, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3107},
        {20596}
    },
    {
        3108,
        {21063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3108},
        {21063}
    },
    {
        3109,
        {21363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3109},
        {21363}
    },
    {
        3110,
        {24687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3110},
        {24687}
    },
    {
        3111,
        {25417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3111},
        {25417}
    },
    {
        3112,
        {26463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3112},
        {26463}
    },
    {
        3113,
        {28204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3113},
        {28204}
    },
    {
        3114,
        {36275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3114},
        {36275}
    },
    {
        3115,
        {36895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3115},
        {36895}
    },
    {
        3116,
        {20439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3116},
        {20439}
    },
    {
        3117,
        {23646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3117},
        {23646}
    },
    {
        3118,
        {36042, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3118},
        {36042}
    },
    {
        3119,
        {26063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3119},
        {26063}
    },
    {
        3120,
        {32154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3120},
        {32154}
    },
    {
        3121,
        {21330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3121},
        {21330}
    },
    {
        3122,
        {34966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3122},
        {34966}
    },
    {
        3123,
        {20854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3123},
        {20854}
    },
    {
        3124,
        {25539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3124},
        {25539}
    },
    {
        3125,
        {23384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3125},
        {23384}
    },
    {
        3126,
        {23403, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3126},
        {23403}
    },
    {
        3127,
        {23562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3127},
        {23562}
    },
    {
        3128,
        {25613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3128},
        {25613}
    },
    {
        3129,
        {26449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3129},
        {26449}
    },
    {
        3130,
        {36956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3130},
        {36956}
    },
    {
        3131,
        {20182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3131},
        {20182}
    },
    {
        3132,
        {22810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3132},
        {22810}
    },
    {
        3133,
        {22826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3133},
        {22826}
    },
    {
        3134,
        {27760, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3134},
        {27760}
    },
    {
        3135,
        {35409, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3135},
        {35409}
    },
    {
        3136,
        {21822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3136},
        {21822}
    },
    {
        3137,
        {22549, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3137},
        {22549}
    },
    {
        3138,
        {22949, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3138},
        {22949}
    },
    {
        3139,
        {24816, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3139},
        {24816}
    },
    {
        3140,
        {25171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3140},
        {25171}
    },
    {
        3141,
        {26561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3141},
        {26561}
    },
    {
        3142,
        {33333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3142},
        {33333}
    },
    {
        3143,
        {26965, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3143},
        {26965}
    },
    {
        3144,
        {38464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3144},
        {38464}
    },
    {
        3145,
        {39364, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3145},
        {39364}
    },
    {
        3146,
        {39464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3146},
        {39464}
    },
    {
        3147,
        {20307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3147},
        {20307}
    },
    {
        3148,
        {22534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3148},
        {22534}
    },
    {
        3149,
        {23550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3149},
        {23550}
    },
    {
        3150,
        {32784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3150},
        {32784}
    },
    {
        3151,
        {23729, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3151},
        {23729}
    },
    {
        3152,
        {24111, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3152},
        {24111}
    },
    {
        3153,
        {24453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3153},
        {24453}
    },
    {
        3154,
        {24608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3154},
        {24608}
    },
    {
        3155,
        {24907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3155},
        {24907}
    },
    {
        3156,
        {25140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3156},
        {25140}
    },
    {
        3157,
        {26367, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3157},
        {26367}
    },
    {
        3158,
        {27888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3158},
        {27888}
    },
    {
        3159,
        {28382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3159},
        {28382}
    },
    {
        3160,
        {32974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3160},
        {32974}
    },
    {
        3161,
        {33151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3161},
        {33151}
    },
    {
        3162,
        {33492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3162},
        {33492}
    },
    {
        3163,
        {34955, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3163},
        {34955}
    },
    {
        3164,
        {36024, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3164},
        {36024}
    },
    {
        3165,
        {36864, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3165},
        {36864}
    },
    {
        3166,
        {36910, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3166},
        {36910}
    },
    {
        3167,
        {38538, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3167},
        {38538}
    },
    {
        3168,
        {40667, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3168},
        {40667}
    },
    {
        3169,
        {39899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3169},
        {39899}
    },
    {
        3170,
        {20195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3170},
        {20195}
    },
    {
        3171,
        {21488, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3171},
        {21488}
    },
    {
        3172,
        {22823, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3172},
        {22823}
    },
    {
        3173,
        {31532, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3173},
        {31532}
    },
    {
        3174,
        {37261, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3174},
        {37261}
    },
    {
        3175,
        {38988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3175},
        {38988}
    },
    {
        3176,
        {40441, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3176},
        {40441}
    },
    {
        3177,
        {28381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3177},
        {28381}
    },
    {
        3178,
        {28711, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3178},
        {28711}
    },
    {
        3179,
        {21331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3179},
        {21331}
    },
    {
        3180,
        {21828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3180},
        {21828}
    },
    {
        3181,
        {23429, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3181},
        {23429}
    },
    {
        3182,
        {25176, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3182},
        {25176}
    },
    {
        3183,
        {25246, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3183},
        {25246}
    },
    {
        3184,
        {25299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3184},
        {25299}
    },
    {
        3185,
        {27810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3185},
        {27810}
    },
    {
        3186,
        {28655, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3186},
        {28655}
    },
    {
        3187,
        {29730, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3187},
        {29730}
    },
    {
        3188,
        {35351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3188},
        {35351}
    },
    {
        3189,
        {37944, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3189},
        {37944}
    },
    {
        3190,
        {28609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3190},
        {28609}
    },
    {
        3191,
        {35582, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3191},
        {35582}
    },
    {
        3192,
        {33592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3192},
        {33592}
    },
    {
        3193,
        {20967, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3193},
        {20967}
    },
    {
        3194,
        {34552, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3194},
        {34552}
    },
    {
        3195,
        {21482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3195},
        {21482}
    },
    {
        3196,
        {21481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3196},
        {21481}
    },
    {
        3197,
        {20294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3197},
        {20294}
    },
    {
        3198,
        {36948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3198},
        {36948}
    },
    {
        3199,
        {36784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3199},
        {36784}
    },
    {
        3200,
        {22890, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3200},
        {22890}
    },
    {
        3201,
        {33073, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3201},
        {33073}
    },
    {
        3202,
        {24061, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3202},
        {24061}
    },
    {
        3203,
        {31466, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3203},
        {31466}
    },
    {
        3204,
        {36799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3204},
        {36799}
    },
    {
        3205,
        {26842, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3205},
        {26842}
    },
    {
        3206,
        {35895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3206},
        {35895}
    },
    {
        3207,
        {29432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3207},
        {29432}
    },
    {
        3208,
        {40008, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3208},
        {40008}
    },
    {
        3209,
        {27197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3209},
        {27197}
    },
    {
        3210,
        {35504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3210},
        {35504}
    },
    {
        3211,
        {20025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3211},
        {20025}
    },
    {
        3212,
        {21336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3212},
        {21336}
    },
    {
        3213,
        {22022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3213},
        {22022}
    },
    {
        3214,
        {22374, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3214},
        {22374}
    },
    {
        3215,
        {25285, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3215},
        {25285}
    },
    {
        3216,
        {25506, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3216},
        {25506}
    },
    {
        3217,
        {26086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3217},
        {26086}
    },
    {
        3218,
        {27470, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3218},
        {27470}
    },
    {
        3219,
        {28129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3219},
        {28129}
    },
    {
        3220,
        {28251, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3220},
        {28251}
    },
    {
        3221,
        {28845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3221},
        {28845}
    },
    {
        3222,
        {30701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3222},
        {30701}
    },
    {
        3223,
        {31471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3223},
        {31471}
    },
    {
        3224,
        {31658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3224},
        {31658}
    },
    {
        3225,
        {32187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3225},
        {32187}
    },
    {
        3226,
        {32829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3226},
        {32829}
    },
    {
        3227,
        {32966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3227},
        {32966}
    },
    {
        3228,
        {34507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3228},
        {34507}
    },
    {
        3229,
        {35477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3229},
        {35477}
    },
    {
        3230,
        {37723, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3230},
        {37723}
    },
    {
        3231,
        {22243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3231},
        {22243}
    },
    {
        3232,
        {22727, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3232},
        {22727}
    },
    {
        3233,
        {24382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3233},
        {24382}
    },
    {
        3234,
        {26029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3234},
        {26029}
    },
    {
        3235,
        {26262, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3235},
        {26262}
    },
    {
        3236,
        {27264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3236},
        {27264}
    },
    {
        3237,
        {27573, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3237},
        {27573}
    },
    {
        3238,
        {30007, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3238},
        {30007}
    },
    {
        3239,
        {35527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3239},
        {35527}
    },
    {
        3240,
        {20516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3240},
        {20516}
    },
    {
        3241,
        {30693, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3241},
        {30693}
    },
    {
        3242,
        {22320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3242},
        {22320}
    },
    {
        3243,
        {24347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3243},
        {24347}
    },
    {
        3244,
        {24677, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3244},
        {24677}
    },
    {
        3245,
        {26234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3245},
        {26234}
    },
    {
        3246,
        {27744, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3246},
        {27744}
    },
    {
        3247,
        {30196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3247},
        {30196}
    },
    {
        3248,
        {31258, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3248},
        {31258}
    },
    {
        3249,
        {32622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3249},
        {32622}
    },
    {
        3250,
        {33268, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3250},
        {33268}
    },
    {
        3251,
        {34584, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3251},
        {34584}
    },
    {
        3252,
        {36933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3252},
        {36933}
    },
    {
        3253,
        {39347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3253},
        {39347}
    },
    {
        3254,
        {31689, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3254},
        {31689}
    },
    {
        3255,
        {30044, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3255},
        {30044}
    },
    {
        3256,
        {31481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3256},
        {31481}
    },
    {
        3257,
        {31569, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3257},
        {31569}
    },
    {
        3258,
        {33988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3258},
        {33988}
    },
    {
        3259,
        {36880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3259},
        {36880}
    },
    {
        3260,
        {31209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3260},
        {31209}
    },
    {
        3261,
        {31378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3261},
        {31378}
    },
    {
        3262,
        {33590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3262},
        {33590}
    },
    {
        3263,
        {23265, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3263},
        {23265}
    },
    {
        3264,
        {30528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3264},
        {30528}
    },
    {
        3265,
        {20013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3265},
        {20013}
    },
    {
        3266,
        {20210, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3266},
        {20210}
    },
    {
        3267,
        {23449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3267},
        {23449}
    },
    {
        3268,
        {24544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3268},
        {24544}
    },
    {
        3269,
        {25277, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3269},
        {25277}
    },
    {
        3270,
        {26172, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3270},
        {26172}
    },
    {
        3271,
        {26609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3271},
        {26609}
    },
    {
        3272,
        {27880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3272},
        {27880}
    },
    {
        3273,
        {34411, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3273},
        {34411}
    },
    {
        3274,
        {34935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3274},
        {34935}
    },
    {
        3275,
        {35387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3275},
        {35387}
    },
    {
        3276,
        {37198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3276},
        {37198}
    },
    {
        3277,
        {37619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3277},
        {37619}
    },
    {
        3278,
        {39376, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3278},
        {39376}
    },
    {
        3279,
        {27159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3279},
        {27159}
    },
    {
        3280,
        {28710, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3280},
        {28710}
    },
    {
        3281,
        {29482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3281},
        {29482}
    },
    {
        3282,
        {33511, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3282},
        {33511}
    },
    {
        3283,
        {33879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3283},
        {33879}
    },
    {
        3284,
        {36015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3284},
        {36015}
    },
    {
        3285,
        {19969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3285},
        {19969}
    },
    {
        3286,
        {20806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3286},
        {20806}
    },
    {
        3287,
        {20939, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3287},
        {20939}
    },
    {
        3288,
        {21899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3288},
        {21899}
    },
    {
        3289,
        {23541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3289},
        {23541}
    },
    {
        3290,
        {24086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3290},
        {24086}
    },
    {
        3291,
        {24115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3291},
        {24115}
    },
    {
        3292,
        {24193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3292},
        {24193}
    },
    {
        3293,
        {24340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3293},
        {24340}
    },
    {
        3294,
        {24373, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3294},
        {24373}
    },
    {
        3295,
        {24427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3295},
        {24427}
    },
    {
        3296,
        {24500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3296},
        {24500}
    },
    {
        3297,
        {25074, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3297},
        {25074}
    },
    {
        3298,
        {25361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3298},
        {25361}
    },
    {
        3299,
        {26274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3299},
        {26274}
    },
    {
        3300,
        {26397, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3300},
        {26397}
    },
    {
        3301,
        {28526, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3301},
        {28526}
    },
    {
        3302,
        {29266, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3302},
        {29266}
    },
    {
        3303,
        {30010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3303},
        {30010}
    },
    {
        3304,
        {30522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3304},
        {30522}
    },
    {
        3305,
        {32884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3305},
        {32884}
    },
    {
        3306,
        {33081, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3306},
        {33081}
    },
    {
        3307,
        {33144, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3307},
        {33144}
    },
    {
        3308,
        {34678, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3308},
        {34678}
    },
    {
        3309,
        {35519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3309},
        {35519}
    },
    {
        3310,
        {35548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3310},
        {35548}
    },
    {
        3311,
        {36229, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3311},
        {36229}
    },
    {
        3312,
        {36339, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3312},
        {36339}
    },
    {
        3313,
        {37530, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3313},
        {37530}
    },
    {
        3314,
        {38263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3314},
        {38263}
    },
    {
        3315,
        {38914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3315},
        {38914}
    },
    {
        3316,
        {40165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3316},
        {40165}
    },
    {
        3317,
        {21189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3317},
        {21189}
    },
    {
        3318,
        {25431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3318},
        {25431}
    },
    {
        3319,
        {30452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3319},
        {30452}
    },
    {
        3320,
        {26389, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3320},
        {26389}
    },
    {
        3321,
        {27784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3321},
        {27784}
    },
    {
        3322,
        {29645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3322},
        {29645}
    },
    {
        3323,
        {36035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3323},
        {36035}
    },
    {
        3324,
        {37806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3324},
        {37806}
    },
    {
        3325,
        {38515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3325},
        {38515}
    },
    {
        3326,
        {27941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3326},
        {27941}
    },
    {
        3327,
        {22684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3327},
        {22684}
    },
    {
        3328,
        {26894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3328},
        {26894}
    },
    {
        3329,
        {27084, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3329},
        {27084}
    },
    {
        3330,
        {36861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3330},
        {36861}
    },
    {
        3331,
        {37786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3331},
        {37786}
    },
    {
        3332,
        {30171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3332},
        {30171}
    },
    {
        3333,
        {36890, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3333},
        {36890}
    },
    {
        3334,
        {22618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3334},
        {22618}
    },
    {
        3335,
        {26626, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3335},
        {26626}
    },
    {
        3336,
        {25524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3336},
        {25524}
    },
    {
        3337,
        {27131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3337},
        {27131}
    },
    {
        3338,
        {20291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3338},
        {20291}
    },
    {
        3339,
        {28460, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3339},
        {28460}
    },
    {
        3340,
        {26584, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3340},
        {26584}
    },
    {
        3341,
        {36795, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3341},
        {36795}
    },
    {
        3342,
        {34086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3342},
        {34086}
    },
    {
        3343,
        {32180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3343},
        {32180}
    },
    {
        3344,
        {37716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3344},
        {37716}
    },
    {
        3345,
        {26943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3345},
        {26943}
    },
    {
        3346,
        {28528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3346},
        {28528}
    },
    {
        3347,
        {22378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3347},
        {22378}
    },
    {
        3348,
        {22775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3348},
        {22775}
    },
    {
        3349,
        {23340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3349},
        {23340}
    },
    {
        3350,
        {32044, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3350},
        {32044}
    },
    {
        3351,
        {29226, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3351},
        {29226}
    },
    {
        3352,
        {21514, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3352},
        {21514}
    },
    {
        3353,
        {37347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3353},
        {37347}
    },
    {
        3354,
        {40372, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3354},
        {40372}
    },
    {
        3355,
        {20141, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3355},
        {20141}
    },
    {
        3356,
        {20302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3356},
        {20302}
    },
    {
        3357,
        {20572, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3357},
        {20572}
    },
    {
        3358,
        {20597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3358},
        {20597}
    },
    {
        3359,
        {21059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3359},
        {21059}
    },
    {
        3360,
        {35998, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3360},
        {35998}
    },
    {
        3361,
        {21576, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3361},
        {21576}
    },
    {
        3362,
        {22564, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3362},
        {22564}
    },
    {
        3363,
        {23450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3363},
        {23450}
    },
    {
        3364,
        {24093, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3364},
        {24093}
    },
    {
        3365,
        {24213, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3365},
        {24213}
    },
    {
        3366,
        {24237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3366},
        {24237}
    },
    {
        3367,
        {24311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3367},
        {24311}
    },
    {
        3368,
        {24351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3368},
        {24351}
    },
    {
        3369,
        {24716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3369},
        {24716}
    },
    {
        3370,
        {25269, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3370},
        {25269}
    },
    {
        3371,
        {25402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3371},
        {25402}
    },
    {
        3372,
        {25552, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3372},
        {25552}
    },
    {
        3373,
        {26799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3373},
        {26799}
    },
    {
        3374,
        {27712, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3374},
        {27712}
    },
    {
        3375,
        {30855, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3375},
        {30855}
    },
    {
        3376,
        {31118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3376},
        {31118}
    },
    {
        3377,
        {31243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3377},
        {31243}
    },
    {
        3378,
        {32224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3378},
        {32224}
    },
    {
        3379,
        {33351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3379},
        {33351}
    },
    {
        3380,
        {35330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3380},
        {35330}
    },
    {
        3381,
        {35558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3381},
        {35558}
    },
    {
        3382,
        {36420, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3382},
        {36420}
    },
    {
        3383,
        {36883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3383},
        {36883}
    },
    {
        3384,
        {37048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3384},
        {37048}
    },
    {
        3385,
        {37165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3385},
        {37165}
    },
    {
        3386,
        {37336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3386},
        {37336}
    },
    {
        3387,
        {40718, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3387},
        {40718}
    },
    {
        3388,
        {27877, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3388},
        {27877}
    },
    {
        3389,
        {25688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3389},
        {25688}
    },
    {
        3390,
        {25826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3390},
        {25826}
    },
    {
        3391,
        {25973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3391},
        {25973}
    },
    {
        3392,
        {28404, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3392},
        {28404}
    },
    {
        3393,
        {30340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3393},
        {30340}
    },
    {
        3394,
        {31515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3394},
        {31515}
    },
    {
        3395,
        {36969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3395},
        {36969}
    },
    {
        3396,
        {37841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3396},
        {37841}
    },
    {
        3397,
        {28346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3397},
        {28346}
    },
    {
        3398,
        {21746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3398},
        {21746}
    },
    {
        3399,
        {24505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3399},
        {24505}
    },
    {
        3400,
        {25764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3400},
        {25764}
    },
    {
        3401,
        {36685, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3401},
        {36685}
    },
    {
        3402,
        {36845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3402},
        {36845}
    },
    {
        3403,
        {37444, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3403},
        {37444}
    },
    {
        3404,
        {20856, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3404},
        {20856}
    },
    {
        3405,
        {22635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3405},
        {22635}
    },
    {
        3406,
        {22825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3406},
        {22825}
    },
    {
        3407,
        {23637, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3407},
        {23637}
    },
    {
        3408,
        {24215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3408},
        {24215}
    },
    {
        3409,
        {28155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3409},
        {28155}
    },
    {
        3410,
        {32399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3410},
        {32399}
    },
    {
        3411,
        {29980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3411},
        {29980}
    },
    {
        3412,
        {36028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3412},
        {36028}
    },
    {
        3413,
        {36578, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3413},
        {36578}
    },
    {
        3414,
        {39003, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3414},
        {39003}
    },
    {
        3415,
        {28857, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3415},
        {28857}
    },
    {
        3416,
        {20253, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3416},
        {20253}
    },
    {
        3417,
        {27583, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3417},
        {27583}
    },
    {
        3418,
        {28593, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3418},
        {28593}
    },
    {
        3419,
        {30000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3419},
        {30000}
    },
    {
        3420,
        {38651, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3420},
        {38651}
    },
    {
        3421,
        {20814, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3421},
        {20814}
    },
    {
        3422,
        {21520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3422},
        {21520}
    },
    {
        3423,
        {22581, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3423},
        {22581}
    },
    {
        3424,
        {22615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3424},
        {22615}
    },
    {
        3425,
        {22956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3425},
        {22956}
    },
    {
        3426,
        {23648, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3426},
        {23648}
    },
    {
        3427,
        {24466, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3427},
        {24466}
    },
    {
        3428,
        {26007, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3428},
        {26007}
    },
    {
        3429,
        {26460, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3429},
        {26460}
    },
    {
        3430,
        {28193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3430},
        {28193}
    },
    {
        3431,
        {30331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3431},
        {30331}
    },
    {
        3432,
        {33759, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3432},
        {33759}
    },
    {
        3433,
        {36077, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3433},
        {36077}
    },
    {
        3434,
        {36884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3434},
        {36884}
    },
    {
        3435,
        {37117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3435},
        {37117}
    },
    {
        3436,
        {37709, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3436},
        {37709}
    },
    {
        3437,
        {30757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3437},
        {30757}
    },
    {
        3438,
        {30778, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3438},
        {30778}
    },
    {
        3439,
        {21162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3439},
        {21162}
    },
    {
        3440,
        {24230, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3440},
        {24230}
    },
    {
        3441,
        {22303, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3441},
        {22303}
    },
    {
        3442,
        {22900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3442},
        {22900}
    },
    {
        3443,
        {24594, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3443},
        {24594}
    },
    {
        3444,
        {20498, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3444},
        {20498}
    },
    {
        3445,
        {20826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3445},
        {20826}
    },
    {
        3446,
        {20908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3446},
        {20908}
    },
    {
        3447,
        {20941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3447},
        {20941}
    },
    {
        3448,
        {20992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3448},
        {20992}
    },
    {
        3449,
        {21776, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3449},
        {21776}
    },
    {
        3450,
        {22612, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3450},
        {22612}
    },
    {
        3451,
        {22616, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3451},
        {22616}
    },
    {
        3452,
        {22871, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3452},
        {22871}
    },
    {
        3453,
        {23445, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3453},
        {23445}
    },
    {
        3454,
        {23798, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3454},
        {23798}
    },
    {
        3455,
        {23947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3455},
        {23947}
    },
    {
        3456,
        {24764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3456},
        {24764}
    },
    {
        3457,
        {25237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3457},
        {25237}
    },
    {
        3458,
        {25645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3458},
        {25645}
    },
    {
        3459,
        {26481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3459},
        {26481}
    },
    {
        3460,
        {26691, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3460},
        {26691}
    },
    {
        3461,
        {26812, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3461},
        {26812}
    },
    {
        3462,
        {26847, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3462},
        {26847}
    },
    {
        3463,
        {30423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3463},
        {30423}
    },
    {
        3464,
        {28120, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3464},
        {28120}
    },
    {
        3465,
        {28271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3465},
        {28271}
    },
    {
        3466,
        {28059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3466},
        {28059}
    },
    {
        3467,
        {28783, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3467},
        {28783}
    },
    {
        3468,
        {29128, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3468},
        {29128}
    },
    {
        3469,
        {24403, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3469},
        {24403}
    },
    {
        3470,
        {30168, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3470},
        {30168}
    },
    {
        3471,
        {31095, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3471},
        {31095}
    },
    {
        3472,
        {31561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3472},
        {31561}
    },
    {
        3473,
        {31572, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3473},
        {31572}
    },
    {
        3474,
        {31570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3474},
        {31570}
    },
    {
        3475,
        {31958, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3475},
        {31958}
    },
    {
        3476,
        {32113, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3476},
        {32113}
    },
    {
        3477,
        {21040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3477},
        {21040}
    },
    {
        3478,
        {33891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3478},
        {33891}
    },
    {
        3479,
        {34153, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3479},
        {34153}
    },
    {
        3480,
        {34276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3480},
        {34276}
    },
    {
        3481,
        {35342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3481},
        {35342}
    },
    {
        3482,
        {35588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3482},
        {35588}
    },
    {
        3483,
        {35910, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3483},
        {35910}
    },
    {
        3484,
        {36367, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3484},
        {36367}
    },
    {
        3485,
        {36867, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3485},
        {36867}
    },
    {
        3486,
        {36879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3486},
        {36879}
    },
    {
        3487,
        {37913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3487},
        {37913}
    },
    {
        3488,
        {38518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3488},
        {38518}
    },
    {
        3489,
        {38957, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3489},
        {38957}
    },
    {
        3490,
        {39472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3490},
        {39472}
    },
    {
        3491,
        {38360, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3491},
        {38360}
    },
    {
        3492,
        {20685, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3492},
        {20685}
    },
    {
        3493,
        {21205, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3493},
        {21205}
    },
    {
        3494,
        {21516, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3494},
        {21516}
    },
    {
        3495,
        {22530, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3495},
        {22530}
    },
    {
        3496,
        {23566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3496},
        {23566}
    },
    {
        3497,
        {24999, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3497},
        {24999}
    },
    {
        3498,
        {25758, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3498},
        {25758}
    },
    {
        3499,
        {27934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3499},
        {27934}
    },
    {
        3500,
        {30643, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3500},
        {30643}
    },
    {
        3501,
        {31461, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3501},
        {31461}
    },
    {
        3502,
        {33012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3502},
        {33012}
    },
    {
        3503,
        {33796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3503},
        {33796}
    },
    {
        3504,
        {36947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3504},
        {36947}
    },
    {
        3505,
        {37509, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3505},
        {37509}
    },
    {
        3506,
        {23776, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3506},
        {23776}
    },
    {
        3507,
        {40199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3507},
        {40199}
    },
    {
        3508,
        {21311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3508},
        {21311}
    },
    {
        3509,
        {24471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3509},
        {24471}
    },
    {
        3510,
        {24499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3510},
        {24499}
    },
    {
        3511,
        {28060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3511},
        {28060}
    },
    {
        3512,
        {29305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3512},
        {29305}
    },
    {
        3513,
        {30563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3513},
        {30563}
    },
    {
        3514,
        {31167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3514},
        {31167}
    },
    {
        3515,
        {31716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3515},
        {31716}
    },
    {
        3516,
        {27602, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3516},
        {27602}
    },
    {
        3517,
        {29420, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3517},
        {29420}
    },
    {
        3518,
        {35501, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3518},
        {35501}
    },
    {
        3519,
        {26627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3519},
        {26627}
    },
    {
        3520,
        {27233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3520},
        {27233}
    },
    {
        3521,
        {20984, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3521},
        {20984}
    },
    {
        3522,
        {31361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3522},
        {31361}
    },
    {
        3523,
        {26932, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3523},
        {26932}
    },
    {
        3524,
        {23626, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3524},
        {23626}
    },
    {
        3525,
        {40182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3525},
        {40182}
    },
    {
        3526,
        {33515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3526},
        {33515}
    },
    {
        3527,
        {23493, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3527},
        {23493}
    },
    {
        3528,
        {37193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3528},
        {37193}
    },
    {
        3529,
        {28702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3529},
        {28702}
    },
    {
        3530,
        {22136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3530},
        {22136}
    },
    {
        3531,
        {23663, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3531},
        {23663}
    },
    {
        3532,
        {24775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3532},
        {24775}
    },
    {
        3533,
        {25958, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3533},
        {25958}
    },
    {
        3534,
        {27788, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3534},
        {27788}
    },
    {
        3535,
        {35930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3535},
        {35930}
    },
    {
        3536,
        {36929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3536},
        {36929}
    },
    {
        3537,
        {38931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3537},
        {38931}
    },
    {
        3538,
        {21585, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3538},
        {21585}
    },
    {
        3539,
        {26311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3539},
        {26311}
    },
    {
        3540,
        {37389, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3540},
        {37389}
    },
    {
        3541,
        {22856, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3541},
        {22856}
    },
    {
        3542,
        {37027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3542},
        {37027}
    },
    {
        3543,
        {20869, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3543},
        {20869}
    },
    {
        3544,
        {20045, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3544},
        {20045}
    },
    {
        3545,
        {20970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3545},
        {20970}
    },
    {
        3546,
        {34201, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3546},
        {34201}
    },
    {
        3547,
        {35598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3547},
        {35598}
    },
    {
        3548,
        {28760, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3548},
        {28760}
    },
    {
        3549,
        {25466, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3549},
        {25466}
    },
    {
        3550,
        {37707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3550},
        {37707}
    },
    {
        3551,
        {26978, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3551},
        {26978}
    },
    {
        3552,
        {39348, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3552},
        {39348}
    },
    {
        3553,
        {32260, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3553},
        {32260}
    },
    {
        3554,
        {30071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3554},
        {30071}
    },
    {
        3555,
        {21335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3555},
        {21335}
    },
    {
        3556,
        {26976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3556},
        {26976}
    },
    {
        3557,
        {36575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3557},
        {36575}
    },
    {
        3558,
        {38627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3558},
        {38627}
    },
    {
        3559,
        {27741, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3559},
        {27741}
    },
    {
        3560,
        {20108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3560},
        {20108}
    },
    {
        3561,
        {23612, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3561},
        {23612}
    },
    {
        3562,
        {24336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3562},
        {24336}
    },
    {
        3563,
        {36841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3563},
        {36841}
    },
    {
        3564,
        {21250, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3564},
        {21250}
    },
    {
        3565,
        {36049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3565},
        {36049}
    },
    {
        3566,
        {32905, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3566},
        {32905}
    },
    {
        3567,
        {34425, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3567},
        {34425}
    },
    {
        3568,
        {24319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3568},
        {24319}
    },
    {
        3569,
        {26085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3569},
        {26085}
    },
    {
        3570,
        {20083, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3570},
        {20083}
    },
    {
        3571,
        {20837, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3571},
        {20837}
    },
    {
        3572,
        {22914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3572},
        {22914}
    },
    {
        3573,
        {23615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3573},
        {23615}
    },
    {
        3574,
        {38894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3574},
        {38894}
    },
    {
        3575,
        {20219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3575},
        {20219}
    },
    {
        3576,
        {22922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3576},
        {22922}
    },
    {
        3577,
        {24525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3577},
        {24525}
    },
    {
        3578,
        {35469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3578},
        {35469}
    },
    {
        3579,
        {28641, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3579},
        {28641}
    },
    {
        3580,
        {31152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3580},
        {31152}
    },
    {
        3581,
        {31074, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3581},
        {31074}
    },
    {
        3582,
        {23527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3582},
        {23527}
    },
    {
        3583,
        {33905, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3583},
        {33905}
    },
    {
        3584,
        {29483, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3584},
        {29483}
    },
    {
        3585,
        {29105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3585},
        {29105}
    },
    {
        3586,
        {24180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3586},
        {24180}
    },
    {
        3587,
        {24565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3587},
        {24565}
    },
    {
        3588,
        {25467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3588},
        {25467}
    },
    {
        3589,
        {25754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3589},
        {25754}
    },
    {
        3590,
        {29123, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3590},
        {29123}
    },
    {
        3591,
        {31896, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3591},
        {31896}
    },
    {
        3592,
        {20035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3592},
        {20035}
    },
    {
        3593,
        {24316, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3593},
        {24316}
    },
    {
        3594,
        {20043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3594},
        {20043}
    },
    {
        3595,
        {22492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3595},
        {22492}
    },
    {
        3596,
        {22178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3596},
        {22178}
    },
    {
        3597,
        {24745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3597},
        {24745}
    },
    {
        3598,
        {28611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3598},
        {28611}
    },
    {
        3599,
        {32013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3599},
        {32013}
    },
    {
        3600,
        {33021, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3600},
        {33021}
    },
    {
        3601,
        {33075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3601},
        {33075}
    },
    {
        3602,
        {33215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3602},
        {33215}
    },
    {
        3603,
        {36786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3603},
        {36786}
    },
    {
        3604,
        {35223, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3604},
        {35223}
    },
    {
        3605,
        {34468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3605},
        {34468}
    },
    {
        3606,
        {24052, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3606},
        {24052}
    },
    {
        3607,
        {25226, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3607},
        {25226}
    },
    {
        3608,
        {25773, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3608},
        {25773}
    },
    {
        3609,
        {35207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3609},
        {35207}
    },
    {
        3610,
        {26487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3610},
        {26487}
    },
    {
        3611,
        {27874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3611},
        {27874}
    },
    {
        3612,
        {27966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3612},
        {27966}
    },
    {
        3613,
        {29750, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3613},
        {29750}
    },
    {
        3614,
        {30772, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3614},
        {30772}
    },
    {
        3615,
        {23110, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3615},
        {23110}
    },
    {
        3616,
        {32629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3616},
        {32629}
    },
    {
        3617,
        {33453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3617},
        {33453}
    },
    {
        3618,
        {39340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3618},
        {39340}
    },
    {
        3619,
        {20467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3619},
        {20467}
    },
    {
        3620,
        {24259, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3620},
        {24259}
    },
    {
        3621,
        {25309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3621},
        {25309}
    },
    {
        3622,
        {25490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3622},
        {25490}
    },
    {
        3623,
        {25943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3623},
        {25943}
    },
    {
        3624,
        {26479, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3624},
        {26479}
    },
    {
        3625,
        {30403, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3625},
        {30403}
    },
    {
        3626,
        {29260, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3626},
        {29260}
    },
    {
        3627,
        {32972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3627},
        {32972}
    },
    {
        3628,
        {32954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3628},
        {32954}
    },
    {
        3629,
        {36649, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3629},
        {36649}
    },
    {
        3630,
        {37197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3630},
        {37197}
    },
    {
        3631,
        {20493, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3631},
        {20493}
    },
    {
        3632,
        {22521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3632},
        {22521}
    },
    {
        3633,
        {23186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3633},
        {23186}
    },
    {
        3634,
        {26757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3634},
        {26757}
    },
    {
        3635,
        {26995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3635},
        {26995}
    },
    {
        3636,
        {29028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3636},
        {29028}
    },
    {
        3637,
        {29437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3637},
        {29437}
    },
    {
        3638,
        {36023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3638},
        {36023}
    },
    {
        3639,
        {22770, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3639},
        {22770}
    },
    {
        3640,
        {36064, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3640},
        {36064}
    },
    {
        3641,
        {38506, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3641},
        {38506}
    },
    {
        3642,
        {36889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3642},
        {36889}
    },
    {
        3643,
        {34687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3643},
        {34687}
    },
    {
        3644,
        {31204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3644},
        {31204}
    },
    {
        3645,
        {30695, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3645},
        {30695}
    },
    {
        3646,
        {33833, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3646},
        {33833}
    },
    {
        3647,
        {20271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3647},
        {20271}
    },
    {
        3648,
        {21093, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3648},
        {21093}
    },
    {
        3649,
        {21338, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3649},
        {21338}
    },
    {
        3650,
        {25293, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3650},
        {25293}
    },
    {
        3651,
        {26575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3651},
        {26575}
    },
    {
        3652,
        {27850, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3652},
        {27850}
    },
    {
        3653,
        {30333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3653},
        {30333}
    },
    {
        3654,
        {31636, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3654},
        {31636}
    },
    {
        3655,
        {31893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3655},
        {31893}
    },
    {
        3656,
        {33334, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3656},
        {33334}
    },
    {
        3657,
        {34180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3657},
        {34180}
    },
    {
        3658,
        {36843, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3658},
        {36843}
    },
    {
        3659,
        {26333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3659},
        {26333}
    },
    {
        3660,
        {28448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3660},
        {28448}
    },
    {
        3661,
        {29190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3661},
        {29190}
    },
    {
        3662,
        {32283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3662},
        {32283}
    },
    {
        3663,
        {33707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3663},
        {33707}
    },
    {
        3664,
        {39361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3664},
        {39361}
    },
    {
        3665,
        {40614, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3665},
        {40614}
    },
    {
        3666,
        {20989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3666},
        {20989}
    },
    {
        3667,
        {31665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3667},
        {31665}
    },
    {
        3668,
        {30834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3668},
        {30834}
    },
    {
        3669,
        {31672, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3669},
        {31672}
    },
    {
        3670,
        {32903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3670},
        {32903}
    },
    {
        3671,
        {31560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3671},
        {31560}
    },
    {
        3672,
        {27368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3672},
        {27368}
    },
    {
        3673,
        {24161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3673},
        {24161}
    },
    {
        3674,
        {32908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3674},
        {32908}
    },
    {
        3675,
        {30033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3675},
        {30033}
    },
    {
        3676,
        {30048, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3676},
        {30048}
    },
    {
        3677,
        {20843, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3677},
        {20843}
    },
    {
        3678,
        {37474, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3678},
        {37474}
    },
    {
        3679,
        {28300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3679},
        {28300}
    },
    {
        3680,
        {30330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3680},
        {30330}
    },
    {
        3681,
        {37271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3681},
        {37271}
    },
    {
        3682,
        {39658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3682},
        {39658}
    },
    {
        3683,
        {20240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3683},
        {20240}
    },
    {
        3684,
        {32624, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3684},
        {32624}
    },
    {
        3685,
        {25244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3685},
        {25244}
    },
    {
        3686,
        {31567, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3686},
        {31567}
    },
    {
        3687,
        {38309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3687},
        {38309}
    },
    {
        3688,
        {40169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3688},
        {40169}
    },
    {
        3689,
        {22138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3689},
        {22138}
    },
    {
        3690,
        {22617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3690},
        {22617}
    },
    {
        3691,
        {34532, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3691},
        {34532}
    },
    {
        3692,
        {38588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3692},
        {38588}
    },
    {
        3693,
        {20276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3693},
        {20276}
    },
    {
        3694,
        {21028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3694},
        {21028}
    },
    {
        3695,
        {21322, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3695},
        {21322}
    },
    {
        3696,
        {21453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3696},
        {21453}
    },
    {
        3697,
        {21467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3697},
        {21467}
    },
    {
        3698,
        {24070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3698},
        {24070}
    },
    {
        3699,
        {25644, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3699},
        {25644}
    },
    {
        3700,
        {26001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3700},
        {26001}
    },
    {
        3701,
        {26495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3701},
        {26495}
    },
    {
        3702,
        {27710, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3702},
        {27710}
    },
    {
        3703,
        {27726, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3703},
        {27726}
    },
    {
        3704,
        {29256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3704},
        {29256}
    },
    {
        3705,
        {29359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3705},
        {29359}
    },
    {
        3706,
        {29677, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3706},
        {29677}
    },
    {
        3707,
        {30036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3707},
        {30036}
    },
    {
        3708,
        {32321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3708},
        {32321}
    },
    {
        3709,
        {33324, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3709},
        {33324}
    },
    {
        3710,
        {34281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3710},
        {34281}
    },
    {
        3711,
        {36009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3711},
        {36009}
    },
    {
        3712,
        {31684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3712},
        {31684}
    },
    {
        3713,
        {37318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3713},
        {37318}
    },
    {
        3714,
        {29033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3714},
        {29033}
    },
    {
        3715,
        {38930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3715},
        {38930}
    },
    {
        3716,
        {39151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3716},
        {39151}
    },
    {
        3717,
        {25405, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3717},
        {25405}
    },
    {
        3718,
        {26217, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3718},
        {26217}
    },
    {
        3719,
        {30058, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3719},
        {30058}
    },
    {
        3720,
        {30436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3720},
        {30436}
    },
    {
        3721,
        {30928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3721},
        {30928}
    },
    {
        3722,
        {34115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3722},
        {34115}
    },
    {
        3723,
        {34542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3723},
        {34542}
    },
    {
        3724,
        {21290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3724},
        {21290}
    },
    {
        3725,
        {21329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3725},
        {21329}
    },
    {
        3726,
        {21542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3726},
        {21542}
    },
    {
        3727,
        {22915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3727},
        {22915}
    },
    {
        3728,
        {24199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3728},
        {24199}
    },
    {
        3729,
        {24444, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3729},
        {24444}
    },
    {
        3730,
        {24754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3730},
        {24754}
    },
    {
        3731,
        {25161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3731},
        {25161}
    },
    {
        3732,
        {25209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3732},
        {25209}
    },
    {
        3733,
        {25259, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3733},
        {25259}
    },
    {
        3734,
        {26000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3734},
        {26000}
    },
    {
        3735,
        {27604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3735},
        {27604}
    },
    {
        3736,
        {27852, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3736},
        {27852}
    },
    {
        3737,
        {30130, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3737},
        {30130}
    },
    {
        3738,
        {30382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3738},
        {30382}
    },
    {
        3739,
        {30865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3739},
        {30865}
    },
    {
        3740,
        {31192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3740},
        {31192}
    },
    {
        3741,
        {32203, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3741},
        {32203}
    },
    {
        3742,
        {32631, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3742},
        {32631}
    },
    {
        3743,
        {32933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3743},
        {32933}
    },
    {
        3744,
        {34987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3744},
        {34987}
    },
    {
        3745,
        {35513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3745},
        {35513}
    },
    {
        3746,
        {36027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3746},
        {36027}
    },
    {
        3747,
        {36991, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3747},
        {36991}
    },
    {
        3748,
        {38750, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3748},
        {38750}
    },
    {
        3749,
        {39131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3749},
        {39131}
    },
    {
        3750,
        {27147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3750},
        {27147}
    },
    {
        3751,
        {31800, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3751},
        {31800}
    },
    {
        3752,
        {20633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3752},
        {20633}
    },
    {
        3753,
        {23614, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3753},
        {23614}
    },
    {
        3754,
        {24494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3754},
        {24494}
    },
    {
        3755,
        {26503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3755},
        {26503}
    },
    {
        3756,
        {27608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3756},
        {27608}
    },
    {
        3757,
        {29749, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3757},
        {29749}
    },
    {
        3758,
        {30473, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3758},
        {30473}
    },
    {
        3759,
        {32654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3759},
        {32654}
    },
    {
        3760,
        {40763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3760},
        {40763}
    },
    {
        3761,
        {26570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3761},
        {26570}
    },
    {
        3762,
        {31255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3762},
        {31255}
    },
    {
        3763,
        {21305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3763},
        {21305}
    },
    {
        3764,
        {30091, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3764},
        {30091}
    },
    {
        3765,
        {39661, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3765},
        {39661}
    },
    {
        3766,
        {24422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3766},
        {24422}
    },
    {
        3767,
        {33181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3767},
        {33181}
    },
    {
        3768,
        {33777, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3768},
        {33777}
    },
    {
        3769,
        {32920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3769},
        {32920}
    },
    {
        3770,
        {24380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3770},
        {24380}
    },
    {
        3771,
        {24517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3771},
        {24517}
    },
    {
        3772,
        {30050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3772},
        {30050}
    },
    {
        3773,
        {31558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3773},
        {31558}
    },
    {
        3774,
        {36924, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3774},
        {36924}
    },
    {
        3775,
        {26727, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3775},
        {26727}
    },
    {
        3776,
        {23019, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3776},
        {23019}
    },
    {
        3777,
        {23195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3777},
        {23195}
    },
    {
        3778,
        {32016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3778},
        {32016}
    },
    {
        3779,
        {30334, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3779},
        {30334}
    },
    {
        3780,
        {35628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3780},
        {35628}
    },
    {
        3781,
        {20469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3781},
        {20469}
    },
    {
        3782,
        {24426, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3782},
        {24426}
    },
    {
        3783,
        {27161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3783},
        {27161}
    },
    {
        3784,
        {27703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3784},
        {27703}
    },
    {
        3785,
        {28418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3785},
        {28418}
    },
    {
        3786,
        {29922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3786},
        {29922}
    },
    {
        3787,
        {31080, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3787},
        {31080}
    },
    {
        3788,
        {34920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3788},
        {34920}
    },
    {
        3789,
        {35413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3789},
        {35413}
    },
    {
        3790,
        {35961, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3790},
        {35961}
    },
    {
        3791,
        {24287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3791},
        {24287}
    },
    {
        3792,
        {25551, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3792},
        {25551}
    },
    {
        3793,
        {30149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3793},
        {30149}
    },
    {
        3794,
        {31186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3794},
        {31186}
    },
    {
        3795,
        {33495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3795},
        {33495}
    },
    {
        3796,
        {37672, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3796},
        {37672}
    },
    {
        3797,
        {37618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3797},
        {37618}
    },
    {
        3798,
        {33948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3798},
        {33948}
    },
    {
        3799,
        {34541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3799},
        {34541}
    },
    {
        3800,
        {39981, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3800},
        {39981}
    },
    {
        3801,
        {21697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3801},
        {21697}
    },
    {
        3802,
        {24428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3802},
        {24428}
    },
    {
        3803,
        {25996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3803},
        {25996}
    },
    {
        3804,
        {27996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3804},
        {27996}
    },
    {
        3805,
        {28693, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3805},
        {28693}
    },
    {
        3806,
        {36007, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3806},
        {36007}
    },
    {
        3807,
        {36051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3807},
        {36051}
    },
    {
        3808,
        {38971, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3808},
        {38971}
    },
    {
        3809,
        {25935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3809},
        {25935}
    },
    {
        3810,
        {29942, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3810},
        {29942}
    },
    {
        3811,
        {19981, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3811},
        {19981}
    },
    {
        3812,
        {20184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3812},
        {20184}
    },
    {
        3813,
        {22496, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3813},
        {22496}
    },
    {
        3814,
        {22827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3814},
        {22827}
    },
    {
        3815,
        {23142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3815},
        {23142}
    },
    {
        3816,
        {23500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3816},
        {23500}
    },
    {
        3817,
        {20904, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3817},
        {20904}
    },
    {
        3818,
        {24067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3818},
        {24067}
    },
    {
        3819,
        {24220, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3819},
        {24220}
    },
    {
        3820,
        {24598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3820},
        {24598}
    },
    {
        3821,
        {25206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3821},
        {25206}
    },
    {
        3822,
        {25975, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3822},
        {25975}
    },
    {
        3823,
        {26023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3823},
        {26023}
    },
    {
        3824,
        {26222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3824},
        {26222}
    },
    {
        3825,
        {28014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3825},
        {28014}
    },
    {
        3826,
        {29238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3826},
        {29238}
    },
    {
        3827,
        {31526, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3827},
        {31526}
    },
    {
        3828,
        {33104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3828},
        {33104}
    },
    {
        3829,
        {33178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3829},
        {33178}
    },
    {
        3830,
        {33433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3830},
        {33433}
    },
    {
        3831,
        {35676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3831},
        {35676}
    },
    {
        3832,
        {36000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3832},
        {36000}
    },
    {
        3833,
        {36070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3833},
        {36070}
    },
    {
        3834,
        {36212, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3834},
        {36212}
    },
    {
        3835,
        {38428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3835},
        {38428}
    },
    {
        3836,
        {38468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3836},
        {38468}
    },
    {
        3837,
        {20398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3837},
        {20398}
    },
    {
        3838,
        {25771, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3838},
        {25771}
    },
    {
        3839,
        {27494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3839},
        {27494}
    },
    {
        3840,
        {33310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3840},
        {33310}
    },
    {
        3841,
        {33889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3841},
        {33889}
    },
    {
        3842,
        {34154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3842},
        {34154}
    },
    {
        3843,
        {37096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3843},
        {37096}
    },
    {
        3844,
        {23553, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3844},
        {23553}
    },
    {
        3845,
        {26963, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3845},
        {26963}
    },
    {
        3846,
        {39080, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3846},
        {39080}
    },
    {
        3847,
        {33914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3847},
        {33914}
    },
    {
        3848,
        {34135, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3848},
        {34135}
    },
    {
        3849,
        {20239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3849},
        {20239}
    },
    {
        3850,
        {21103, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3850},
        {21103}
    },
    {
        3851,
        {24489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3851},
        {24489}
    },
    {
        3852,
        {24133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3852},
        {24133}
    },
    {
        3853,
        {26381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3853},
        {26381}
    },
    {
        3854,
        {31119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3854},
        {31119}
    },
    {
        3855,
        {33145, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3855},
        {33145}
    },
    {
        3856,
        {35079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3856},
        {35079}
    },
    {
        3857,
        {35206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3857},
        {35206}
    },
    {
        3858,
        {28149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3858},
        {28149}
    },
    {
        3859,
        {24343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3859},
        {24343}
    },
    {
        3860,
        {25173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3860},
        {25173}
    },
    {
        3861,
        {27832, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3861},
        {27832}
    },
    {
        3862,
        {20175, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3862},
        {20175}
    },
    {
        3863,
        {29289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3863},
        {29289}
    },
    {
        3864,
        {39826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3864},
        {39826}
    },
    {
        3865,
        {20998, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3865},
        {20998}
    },
    {
        3866,
        {21563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3866},
        {21563}
    },
    {
        3867,
        {22132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3867},
        {22132}
    },
    {
        3868,
        {22707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3868},
        {22707}
    },
    {
        3869,
        {24996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3869},
        {24996}
    },
    {
        3870,
        {25198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3870},
        {25198}
    },
    {
        3871,
        {28954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3871},
        {28954}
    },
    {
        3872,
        {22894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3872},
        {22894}
    },
    {
        3873,
        {31881, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3873},
        {31881}
    },
    {
        3874,
        {31966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3874},
        {31966}
    },
    {
        3875,
        {32027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3875},
        {32027}
    },
    {
        3876,
        {38640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3876},
        {38640}
    },
    {
        3877,
        {25991, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3877},
        {25991}
    },
    {
        3878,
        {32862, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3878},
        {32862}
    },
    {
        3879,
        {19993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3879},
        {19993}
    },
    {
        3880,
        {20341, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3880},
        {20341}
    },
    {
        3881,
        {20853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3881},
        {20853}
    },
    {
        3882,
        {22592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3882},
        {22592}
    },
    {
        3883,
        {24163, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3883},
        {24163}
    },
    {
        3884,
        {24179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3884},
        {24179}
    },
    {
        3885,
        {24330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3885},
        {24330}
    },
    {
        3886,
        {26564, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3886},
        {26564}
    },
    {
        3887,
        {20006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3887},
        {20006}
    },
    {
        3888,
        {34109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3888},
        {34109}
    },
    {
        3889,
        {38281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3889},
        {38281}
    },
    {
        3890,
        {38491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3890},
        {38491}
    },
    {
        3891,
        {31859, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3891},
        {31859}
    },
    {
        3892,
        {38913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3892},
        {38913}
    },
    {
        3893,
        {20731, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3893},
        {20731}
    },
    {
        3894,
        {22721, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3894},
        {22721}
    },
    {
        3895,
        {30294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3895},
        {30294}
    },
    {
        3896,
        {30887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3896},
        {30887}
    },
    {
        3897,
        {21029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3897},
        {21029}
    },
    {
        3898,
        {30629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3898},
        {30629}
    },
    {
        3899,
        {34065, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3899},
        {34065}
    },
    {
        3900,
        {31622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3900},
        {31622}
    },
    {
        3901,
        {20559, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3901},
        {20559}
    },
    {
        3902,
        {22793, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3902},
        {22793}
    },
    {
        3903,
        {29255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3903},
        {29255}
    },
    {
        3904,
        {31687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3904},
        {31687}
    },
    {
        3905,
        {32232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3905},
        {32232}
    },
    {
        3906,
        {36794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3906},
        {36794}
    },
    {
        3907,
        {36820, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3907},
        {36820}
    },
    {
        3908,
        {36941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3908},
        {36941}
    },
    {
        3909,
        {20415, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3909},
        {20415}
    },
    {
        3910,
        {21193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3910},
        {21193}
    },
    {
        3911,
        {23081, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3911},
        {23081}
    },
    {
        3912,
        {24321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3912},
        {24321}
    },
    {
        3913,
        {38829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3913},
        {38829}
    },
    {
        3914,
        {20445, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3914},
        {20445}
    },
    {
        3915,
        {33303, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3915},
        {33303}
    },
    {
        3916,
        {37610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3916},
        {37610}
    },
    {
        3917,
        {22275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3917},
        {22275}
    },
    {
        3918,
        {25429, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3918},
        {25429}
    },
    {
        3919,
        {27497, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3919},
        {27497}
    },
    {
        3920,
        {29995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3920},
        {29995}
    },
    {
        3921,
        {35036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3921},
        {35036}
    },
    {
        3922,
        {36628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3922},
        {36628}
    },
    {
        3923,
        {31298, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3923},
        {31298}
    },
    {
        3924,
        {21215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3924},
        {21215}
    },
    {
        3925,
        {22675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3925},
        {22675}
    },
    {
        3926,
        {24917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3926},
        {24917}
    },
    {
        3927,
        {25098, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3927},
        {25098}
    },
    {
        3928,
        {26286, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3928},
        {26286}
    },
    {
        3929,
        {27597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3929},
        {27597}
    },
    {
        3930,
        {31807, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3930},
        {31807}
    },
    {
        3931,
        {33769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3931},
        {33769}
    },
    {
        3932,
        {20515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3932},
        {20515}
    },
    {
        3933,
        {20472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3933},
        {20472}
    },
    {
        3934,
        {21253, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3934},
        {21253}
    },
    {
        3935,
        {21574, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3935},
        {21574}
    },
    {
        3936,
        {22577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3936},
        {22577}
    },
    {
        3937,
        {22857, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3937},
        {22857}
    },
    {
        3938,
        {23453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3938},
        {23453}
    },
    {
        3939,
        {23792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3939},
        {23792}
    },
    {
        3940,
        {23791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3940},
        {23791}
    },
    {
        3941,
        {23849, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3941},
        {23849}
    },
    {
        3942,
        {24214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3942},
        {24214}
    },
    {
        3943,
        {25265, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3943},
        {25265}
    },
    {
        3944,
        {25447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3944},
        {25447}
    },
    {
        3945,
        {25918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3945},
        {25918}
    },
    {
        3946,
        {26041, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3946},
        {26041}
    },
    {
        3947,
        {26379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3947},
        {26379}
    },
    {
        3948,
        {27861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3948},
        {27861}
    },
    {
        3949,
        {27873, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3949},
        {27873}
    },
    {
        3950,
        {28921, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3950},
        {28921}
    },
    {
        3951,
        {30770, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3951},
        {30770}
    },
    {
        3952,
        {32299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3952},
        {32299}
    },
    {
        3953,
        {32990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3953},
        {32990}
    },
    {
        3954,
        {33459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3954},
        {33459}
    },
    {
        3955,
        {33804, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3955},
        {33804}
    },
    {
        3956,
        {34028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3956},
        {34028}
    },
    {
        3957,
        {34562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3957},
        {34562}
    },
    {
        3958,
        {35090, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3958},
        {35090}
    },
    {
        3959,
        {35370, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3959},
        {35370}
    },
    {
        3960,
        {35914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3960},
        {35914}
    },
    {
        3961,
        {37030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3961},
        {37030}
    },
    {
        3962,
        {37586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3962},
        {37586}
    },
    {
        3963,
        {39165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3963},
        {39165}
    },
    {
        3964,
        {40179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3964},
        {40179}
    },
    {
        3965,
        {40300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3965},
        {40300}
    },
    {
        3966,
        {20047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3966},
        {20047}
    },
    {
        3967,
        {20129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3967},
        {20129}
    },
    {
        3968,
        {20621, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3968},
        {20621}
    },
    {
        3969,
        {21078, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3969},
        {21078}
    },
    {
        3970,
        {22346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3970},
        {22346}
    },
    {
        3971,
        {22952, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3971},
        {22952}
    },
    {
        3972,
        {24125, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3972},
        {24125}
    },
    {
        3973,
        {24536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3973},
        {24536}
    },
    {
        3974,
        {24537, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3974},
        {24537}
    },
    {
        3975,
        {25151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3975},
        {25151}
    },
    {
        3976,
        {26292, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3976},
        {26292}
    },
    {
        3977,
        {26395, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3977},
        {26395}
    },
    {
        3978,
        {26576, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3978},
        {26576}
    },
    {
        3979,
        {26834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3979},
        {26834}
    },
    {
        3980,
        {20882, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3980},
        {20882}
    },
    {
        3981,
        {32033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3981},
        {32033}
    },
    {
        3982,
        {32938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3982},
        {32938}
    },
    {
        3983,
        {33192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3983},
        {33192}
    },
    {
        3984,
        {35584, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3984},
        {35584}
    },
    {
        3985,
        {35980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3985},
        {35980}
    },
    {
        3986,
        {36031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3986},
        {36031}
    },
    {
        3987,
        {37502, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3987},
        {37502}
    },
    {
        3988,
        {38450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3988},
        {38450}
    },
    {
        3989,
        {21536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3989},
        {21536}
    },
    {
        3990,
        {38956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3990},
        {38956}
    },
    {
        3991,
        {21271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3991},
        {21271}
    },
    {
        3992,
        {20693, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3992},
        {20693}
    },
    {
        3993,
        {21340, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3993},
        {21340}
    },
    {
        3994,
        {22696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3994},
        {22696}
    },
    {
        3995,
        {25778, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3995},
        {25778}
    },
    {
        3996,
        {26420, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3996},
        {26420}
    },
    {
        3997,
        {29287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3997},
        {29287}
    },
    {
        3998,
        {30566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3998},
        {30566}
    },
    {
        3999,
        {31302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {3999},
        {31302}
    },
    {
        4000,
        {37350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4000},
        {37350}
    },
    {
        4001,
        {21187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4001},
        {21187}
    },
    {
        4002,
        {27809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4002},
        {27809}
    },
    {
        4003,
        {27526, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4003},
        {27526}
    },
    {
        4004,
        {22528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4004},
        {22528}
    },
    {
        4005,
        {24140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4005},
        {24140}
    },
    {
        4006,
        {22868, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4006},
        {22868}
    },
    {
        4007,
        {26412, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4007},
        {26412}
    },
    {
        4008,
        {32763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4008},
        {32763}
    },
    {
        4009,
        {20961, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4009},
        {20961}
    },
    {
        4010,
        {30406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4010},
        {30406}
    },
    {
        4011,
        {25705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4011},
        {25705}
    },
    {
        4012,
        {30952, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4012},
        {30952}
    },
    {
        4013,
        {39764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4013},
        {39764}
    },
    {
        4014,
        {40635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4014},
        {40635}
    },
    {
        4015,
        {22475, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4015},
        {22475}
    },
    {
        4016,
        {22969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4016},
        {22969}
    },
    {
        4017,
        {26151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4017},
        {26151}
    },
    {
        4018,
        {26522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4018},
        {26522}
    },
    {
        4019,
        {27598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4019},
        {27598}
    },
    {
        4020,
        {21737, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4020},
        {21737}
    },
    {
        4021,
        {27097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4021},
        {27097}
    },
    {
        4022,
        {24149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4022},
        {24149}
    },
    {
        4023,
        {33180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4023},
        {33180}
    },
    {
        4024,
        {26517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4024},
        {26517}
    },
    {
        4025,
        {39850, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4025},
        {39850}
    },
    {
        4026,
        {26622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4026},
        {26622}
    },
    {
        4027,
        {40018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4027},
        {40018}
    },
    {
        4028,
        {26717, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4028},
        {26717}
    },
    {
        4029,
        {20134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4029},
        {20134}
    },
    {
        4030,
        {20451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4030},
        {20451}
    },
    {
        4031,
        {21448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4031},
        {21448}
    },
    {
        4032,
        {25273, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4032},
        {25273}
    },
    {
        4033,
        {26411, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4033},
        {26411}
    },
    {
        4034,
        {27819, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4034},
        {27819}
    },
    {
        4035,
        {36804, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4035},
        {36804}
    },
    {
        4036,
        {20397, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4036},
        {20397}
    },
    {
        4037,
        {32365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4037},
        {32365}
    },
    {
        4038,
        {40639, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4038},
        {40639}
    },
    {
        4039,
        {19975, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4039},
        {19975}
    },
    {
        4040,
        {24930, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4040},
        {24930}
    },
    {
        4041,
        {28288, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4041},
        {28288}
    },
    {
        4042,
        {28459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4042},
        {28459}
    },
    {
        4043,
        {34067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4043},
        {34067}
    },
    {
        4044,
        {21619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4044},
        {21619}
    },
    {
        4045,
        {26410, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4045},
        {26410}
    },
    {
        4046,
        {39749, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4046},
        {39749}
    },
    {
        4047,
        {24051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4047},
        {24051}
    },
    {
        4048,
        {31637, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4048},
        {31637}
    },
    {
        4049,
        {23724, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4049},
        {23724}
    },
    {
        4050,
        {23494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4050},
        {23494}
    },
    {
        4051,
        {34588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4051},
        {34588}
    },
    {
        4052,
        {28234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4052},
        {28234}
    },
    {
        4053,
        {34001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4053},
        {34001}
    },
    {
        4054,
        {31252, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4054},
        {31252}
    },
    {
        4055,
        {33032, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4055},
        {33032}
    },
    {
        4056,
        {22937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4056},
        {22937}
    },
    {
        4057,
        {31885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4057},
        {31885}
    },
    {
        4058,
        {27665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4058},
        {27665}
    },
    {
        4059,
        {30496, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4059},
        {30496}
    },
    {
        4060,
        {21209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4060},
        {21209}
    },
    {
        4061,
        {22818, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4061},
        {22818}
    },
    {
        4062,
        {28961, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4062},
        {28961}
    },
    {
        4063,
        {29279, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4063},
        {29279}
    },
    {
        4064,
        {30683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4064},
        {30683}
    },
    {
        4065,
        {38695, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4065},
        {38695}
    },
    {
        4066,
        {40289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4066},
        {40289}
    },
    {
        4067,
        {26891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4067},
        {26891}
    },
    {
        4068,
        {23167, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4068},
        {23167}
    },
    {
        4069,
        {23064, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4069},
        {23064}
    },
    {
        4070,
        {20901, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4070},
        {20901}
    },
    {
        4071,
        {21517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4071},
        {21517}
    },
    {
        4072,
        {21629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4072},
        {21629}
    },
    {
        4073,
        {26126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4073},
        {26126}
    },
    {
        4074,
        {30431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4074},
        {30431}
    },
    {
        4075,
        {36855, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4075},
        {36855}
    },
    {
        4076,
        {37528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4076},
        {37528}
    },
    {
        4077,
        {40180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4077},
        {40180}
    },
    {
        4078,
        {23018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4078},
        {23018}
    },
    {
        4079,
        {29277, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4079},
        {29277}
    },
    {
        4080,
        {28357, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4080},
        {28357}
    },
    {
        4081,
        {20813, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4081},
        {20813}
    },
    {
        4082,
        {26825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4082},
        {26825}
    },
    {
        4083,
        {32191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4083},
        {32191}
    },
    {
        4084,
        {32236, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4084},
        {32236}
    },
    {
        4085,
        {38754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4085},
        {38754}
    },
    {
        4086,
        {40634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4086},
        {40634}
    },
    {
        4087,
        {25720, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4087},
        {25720}
    },
    {
        4088,
        {27169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4088},
        {27169}
    },
    {
        4089,
        {33538, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4089},
        {33538}
    },
    {
        4090,
        {22916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4090},
        {22916}
    },
    {
        4091,
        {23391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4091},
        {23391}
    },
    {
        4092,
        {27611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4092},
        {27611}
    },
    {
        4093,
        {29467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4093},
        {29467}
    },
    {
        4094,
        {30450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4094},
        {30450}
    },
    {
        4095,
        {32178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4095},
        {32178}
    },
    {
        4096,
        {32791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4096},
        {32791}
    },
    {
        4097,
        {33945, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4097},
        {33945}
    },
    {
        4098,
        {20786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4098},
        {20786}
    },
    {
        4099,
        {26408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4099},
        {26408}
    },
    {
        4100,
        {40665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4100},
        {40665}
    },
    {
        4101,
        {30446, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4101},
        {30446}
    },
    {
        4102,
        {26466, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4102},
        {26466}
    },
    {
        4103,
        {21247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4103},
        {21247}
    },
    {
        4104,
        {39173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4104},
        {39173}
    },
    {
        4105,
        {23588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4105},
        {23588}
    },
    {
        4106,
        {25147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4106},
        {25147}
    },
    {
        4107,
        {31870, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4107},
        {31870}
    },
    {
        4108,
        {36016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4108},
        {36016}
    },
    {
        4109,
        {21839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4109},
        {21839}
    },
    {
        4110,
        {24758, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4110},
        {24758}
    },
    {
        4111,
        {32011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4111},
        {32011}
    },
    {
        4112,
        {38272, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4112},
        {38272}
    },
    {
        4113,
        {21249, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4113},
        {21249}
    },
    {
        4114,
        {20063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4114},
        {20063}
    },
    {
        4115,
        {20918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4115},
        {20918}
    },
    {
        4116,
        {22812, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4116},
        {22812}
    },
    {
        4117,
        {29242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4117},
        {29242}
    },
    {
        4118,
        {32822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4118},
        {32822}
    },
    {
        4119,
        {37326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4119},
        {37326}
    },
    {
        4120,
        {24357, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4120},
        {24357}
    },
    {
        4121,
        {30690, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4121},
        {30690}
    },
    {
        4122,
        {21380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4122},
        {21380}
    },
    {
        4123,
        {24441, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4123},
        {24441}
    },
    {
        4124,
        {32004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4124},
        {32004}
    },
    {
        4125,
        {34220, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4125},
        {34220}
    },
    {
        4126,
        {35379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4126},
        {35379}
    },
    {
        4127,
        {36493, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4127},
        {36493}
    },
    {
        4128,
        {38742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4128},
        {38742}
    },
    {
        4129,
        {26611, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4129},
        {26611}
    },
    {
        4130,
        {34222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4130},
        {34222}
    },
    {
        4131,
        {37971, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4131},
        {37971}
    },
    {
        4132,
        {24841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4132},
        {24841}
    },
    {
        4133,
        {24840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4133},
        {24840}
    },
    {
        4134,
        {27833, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4134},
        {27833}
    },
    {
        4135,
        {30290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4135},
        {30290}
    },
    {
        4136,
        {35565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4136},
        {35565}
    },
    {
        4137,
        {36664, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4137},
        {36664}
    },
    {
        4138,
        {21807, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4138},
        {21807}
    },
    {
        4139,
        {20305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4139},
        {20305}
    },
    {
        4140,
        {20778, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4140},
        {20778}
    },
    {
        4141,
        {21191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4141},
        {21191}
    },
    {
        4142,
        {21451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4142},
        {21451}
    },
    {
        4143,
        {23461, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4143},
        {23461}
    },
    {
        4144,
        {24189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4144},
        {24189}
    },
    {
        4145,
        {24736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4145},
        {24736}
    },
    {
        4146,
        {24962, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4146},
        {24962}
    },
    {
        4147,
        {25558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4147},
        {25558}
    },
    {
        4148,
        {26377, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4148},
        {26377}
    },
    {
        4149,
        {26586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4149},
        {26586}
    },
    {
        4150,
        {28263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4150},
        {28263}
    },
    {
        4151,
        {28044, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4151},
        {28044}
    },
    {
        4152,
        {29494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4152},
        {29494}
    },
    {
        4153,
        {29495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4153},
        {29495}
    },
    {
        4154,
        {30001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4154},
        {30001}
    },
    {
        4155,
        {31056, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4155},
        {31056}
    },
    {
        4156,
        {35029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4156},
        {35029}
    },
    {
        4157,
        {35480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4157},
        {35480}
    },
    {
        4158,
        {36938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4158},
        {36938}
    },
    {
        4159,
        {37009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4159},
        {37009}
    },
    {
        4160,
        {37109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4160},
        {37109}
    },
    {
        4161,
        {38596, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4161},
        {38596}
    },
    {
        4162,
        {34701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4162},
        {34701}
    },
    {
        4163,
        {22805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4163},
        {22805}
    },
    {
        4164,
        {20104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4164},
        {20104}
    },
    {
        4165,
        {20313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4165},
        {20313}
    },
    {
        4166,
        {19982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4166},
        {19982}
    },
    {
        4167,
        {35465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4167},
        {35465}
    },
    {
        4168,
        {36671, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4168},
        {36671}
    },
    {
        4169,
        {38928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4169},
        {38928}
    },
    {
        4170,
        {20653, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4170},
        {20653}
    },
    {
        4171,
        {24188, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4171},
        {24188}
    },
    {
        4172,
        {22934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4172},
        {22934}
    },
    {
        4173,
        {23481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4173},
        {23481}
    },
    {
        4174,
        {24248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4174},
        {24248}
    },
    {
        4175,
        {25562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4175},
        {25562}
    },
    {
        4176,
        {25594, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4176},
        {25594}
    },
    {
        4177,
        {25793, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4177},
        {25793}
    },
    {
        4178,
        {26332, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4178},
        {26332}
    },
    {
        4179,
        {26954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4179},
        {26954}
    },
    {
        4180,
        {27096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4180},
        {27096}
    },
    {
        4181,
        {27915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4181},
        {27915}
    },
    {
        4182,
        {28342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4182},
        {28342}
    },
    {
        4183,
        {29076, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4183},
        {29076}
    },
    {
        4184,
        {29992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4184},
        {29992}
    },
    {
        4185,
        {31407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4185},
        {31407}
    },
    {
        4186,
        {32650, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4186},
        {32650}
    },
    {
        4187,
        {32768, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4187},
        {32768}
    },
    {
        4188,
        {33865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4188},
        {33865}
    },
    {
        4189,
        {33993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4189},
        {33993}
    },
    {
        4190,
        {35201, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4190},
        {35201}
    },
    {
        4191,
        {35617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4191},
        {35617}
    },
    {
        4192,
        {36362, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4192},
        {36362}
    },
    {
        4193,
        {36965, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4193},
        {36965}
    },
    {
        4194,
        {38525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4194},
        {38525}
    },
    {
        4195,
        {39178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4195},
        {39178}
    },
    {
        4196,
        {24958, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4196},
        {24958}
    },
    {
        4197,
        {25233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4197},
        {25233}
    },
    {
        4198,
        {27442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4198},
        {27442}
    },
    {
        4199,
        {27779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4199},
        {27779}
    },
    {
        4200,
        {28020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4200},
        {28020}
    },
    {
        4201,
        {32716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4201},
        {32716}
    },
    {
        4202,
        {32764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4202},
        {32764}
    },
    {
        4203,
        {28096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4203},
        {28096}
    },
    {
        4204,
        {32645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4204},
        {32645}
    },
    {
        4205,
        {34746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4205},
        {34746}
    },
    {
        4206,
        {35064, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4206},
        {35064}
    },
    {
        4207,
        {26469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4207},
        {26469}
    },
    {
        4208,
        {33713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4208},
        {33713}
    },
    {
        4209,
        {38972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4209},
        {38972}
    },
    {
        4210,
        {38647, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4210},
        {38647}
    },
    {
        4211,
        {27931, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4211},
        {27931}
    },
    {
        4212,
        {32097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4212},
        {32097}
    },
    {
        4213,
        {33853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4213},
        {33853}
    },
    {
        4214,
        {37226, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4214},
        {37226}
    },
    {
        4215,
        {20081, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4215},
        {20081}
    },
    {
        4216,
        {21365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4216},
        {21365}
    },
    {
        4217,
        {23888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4217},
        {23888}
    },
    {
        4218,
        {27396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4218},
        {27396}
    },
    {
        4219,
        {28651, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4219},
        {28651}
    },
    {
        4220,
        {34253, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4220},
        {34253}
    },
    {
        4221,
        {34349, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4221},
        {34349}
    },
    {
        4222,
        {35239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4222},
        {35239}
    },
    {
        4223,
        {21033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4223},
        {21033}
    },
    {
        4224,
        {21519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4224},
        {21519}
    },
    {
        4225,
        {23653, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4225},
        {23653}
    },
    {
        4226,
        {26446, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4226},
        {26446}
    },
    {
        4227,
        {26792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4227},
        {26792}
    },
    {
        4228,
        {29702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4228},
        {29702}
    },
    {
        4229,
        {29827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4229},
        {29827}
    },
    {
        4230,
        {30178, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4230},
        {30178}
    },
    {
        4231,
        {35023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4231},
        {35023}
    },
    {
        4232,
        {35041, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4232},
        {35041}
    },
    {
        4233,
        {37324, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4233},
        {37324}
    },
    {
        4234,
        {38626, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4234},
        {38626}
    },
    {
        4235,
        {38520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4235},
        {38520}
    },
    {
        4236,
        {24459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4236},
        {24459}
    },
    {
        4237,
        {29575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4237},
        {29575}
    },
    {
        4238,
        {31435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4238},
        {31435}
    },
    {
        4239,
        {33870, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4239},
        {33870}
    },
    {
        4240,
        {25504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4240},
        {25504}
    },
    {
        4241,
        {30053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4241},
        {30053}
    },
    {
        4242,
        {21129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4242},
        {21129}
    },
    {
        4243,
        {27969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4243},
        {27969}
    },
    {
        4244,
        {28316, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4244},
        {28316}
    },
    {
        4245,
        {29705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4245},
        {29705}
    },
    {
        4246,
        {30041, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4246},
        {30041}
    },
    {
        4247,
        {30827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4247},
        {30827}
    },
    {
        4248,
        {31890, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4248},
        {31890}
    },
    {
        4249,
        {38534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4249},
        {38534}
    },
    {
        4250,
        {31452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4250},
        {31452}
    },
    {
        4251,
        {40845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4251},
        {40845}
    },
    {
        4252,
        {20406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4252},
        {20406}
    },
    {
        4253,
        {24942, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4253},
        {24942}
    },
    {
        4254,
        {26053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4254},
        {26053}
    },
    {
        4255,
        {34396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4255},
        {34396}
    },
    {
        4256,
        {20102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4256},
        {20102}
    },
    {
        4257,
        {20142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4257},
        {20142}
    },
    {
        4258,
        {20698, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4258},
        {20698}
    },
    {
        4259,
        {20001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4259},
        {20001}
    },
    {
        4260,
        {20940, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4260},
        {20940}
    },
    {
        4261,
        {23534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4261},
        {23534}
    },
    {
        4262,
        {26009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4262},
        {26009}
    },
    {
        4263,
        {26753, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4263},
        {26753}
    },
    {
        4264,
        {28092, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4264},
        {28092}
    },
    {
        4265,
        {29471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4265},
        {29471}
    },
    {
        4266,
        {30274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4266},
        {30274}
    },
    {
        4267,
        {30637, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4267},
        {30637}
    },
    {
        4268,
        {31260, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4268},
        {31260}
    },
    {
        4269,
        {31975, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4269},
        {31975}
    },
    {
        4270,
        {33391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4270},
        {33391}
    },
    {
        4271,
        {35538, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4271},
        {35538}
    },
    {
        4272,
        {36988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4272},
        {36988}
    },
    {
        4273,
        {37327, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4273},
        {37327}
    },
    {
        4274,
        {38517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4274},
        {38517}
    },
    {
        4275,
        {38936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4275},
        {38936}
    },
    {
        4276,
        {21147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4276},
        {21147}
    },
    {
        4277,
        {32209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4277},
        {32209}
    },
    {
        4278,
        {20523, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4278},
        {20523}
    },
    {
        4279,
        {21400, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4279},
        {21400}
    },
    {
        4280,
        {26519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4280},
        {26519}
    },
    {
        4281,
        {28107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4281},
        {28107}
    },
    {
        4282,
        {29136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4282},
        {29136}
    },
    {
        4283,
        {29747, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4283},
        {29747}
    },
    {
        4284,
        {33256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4284},
        {33256}
    },
    {
        4285,
        {36650, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4285},
        {36650}
    },
    {
        4286,
        {38563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4286},
        {38563}
    },
    {
        4287,
        {40023, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4287},
        {40023}
    },
    {
        4288,
        {40607, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4288},
        {40607}
    },
    {
        4289,
        {29792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4289},
        {29792}
    },
    {
        4290,
        {22593, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4290},
        {22593}
    },
    {
        4291,
        {28057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4291},
        {28057}
    },
    {
        4292,
        {32047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4292},
        {32047}
    },
    {
        4293,
        {39006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4293},
        {39006}
    },
    {
        4294,
        {20196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4294},
        {20196}
    },
    {
        4295,
        {20278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4295},
        {20278}
    },
    {
        4296,
        {20363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4296},
        {20363}
    },
    {
        4297,
        {20919, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4297},
        {20919}
    },
    {
        4298,
        {21169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4298},
        {21169}
    },
    {
        4299,
        {23994, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4299},
        {23994}
    },
    {
        4300,
        {24604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4300},
        {24604}
    },
    {
        4301,
        {29618, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4301},
        {29618}
    },
    {
        4302,
        {31036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4302},
        {31036}
    },
    {
        4303,
        {33491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4303},
        {33491}
    },
    {
        4304,
        {37428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4304},
        {37428}
    },
    {
        4305,
        {38583, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4305},
        {38583}
    },
    {
        4306,
        {38646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4306},
        {38646}
    },
    {
        4307,
        {38666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4307},
        {38666}
    },
    {
        4308,
        {40599, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4308},
        {40599}
    },
    {
        4309,
        {40802, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4309},
        {40802}
    },
    {
        4310,
        {26278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4310},
        {26278}
    },
    {
        4311,
        {27508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4311},
        {27508}
    },
    {
        4312,
        {21015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4312},
        {21015}
    },
    {
        4313,
        {21155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4313},
        {21155}
    },
    {
        4314,
        {28872, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4314},
        {28872}
    },
    {
        4315,
        {35010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4315},
        {35010}
    },
    {
        4316,
        {24265, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4316},
        {24265}
    },
    {
        4317,
        {24651, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4317},
        {24651}
    },
    {
        4318,
        {24976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4318},
        {24976}
    },
    {
        4319,
        {28451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4319},
        {28451}
    },
    {
        4320,
        {29001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4320},
        {29001}
    },
    {
        4321,
        {31806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4321},
        {31806}
    },
    {
        4322,
        {32244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4322},
        {32244}
    },
    {
        4323,
        {32879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4323},
        {32879}
    },
    {
        4324,
        {34030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4324},
        {34030}
    },
    {
        4325,
        {36899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4325},
        {36899}
    },
    {
        4326,
        {37676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4326},
        {37676}
    },
    {
        4327,
        {21570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4327},
        {21570}
    },
    {
        4328,
        {39791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4328},
        {39791}
    },
    {
        4329,
        {27347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4329},
        {27347}
    },
    {
        4330,
        {28809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4330},
        {28809}
    },
    {
        4331,
        {36034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4331},
        {36034}
    },
    {
        4332,
        {36335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4332},
        {36335}
    },
    {
        4333,
        {38706, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4333},
        {38706}
    },
    {
        4334,
        {21172, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4334},
        {21172}
    },
    {
        4335,
        {23105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4335},
        {23105}
    },
    {
        4336,
        {24266, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4336},
        {24266}
    },
    {
        4337,
        {24324, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4337},
        {24324}
    },
    {
        4338,
        {26391, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4338},
        {26391}
    },
    {
        4339,
        {27004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4339},
        {27004}
    },
    {
        4340,
        {27028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4340},
        {27028}
    },
    {
        4341,
        {28010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4341},
        {28010}
    },
    {
        4342,
        {28431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4342},
        {28431}
    },
    {
        4343,
        {29282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4343},
        {29282}
    },
    {
        4344,
        {29436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4344},
        {29436}
    },
    {
        4345,
        {31725, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4345},
        {31725}
    },
    {
        4346,
        {32769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4346},
        {32769}
    },
    {
        4347,
        {32894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4347},
        {32894}
    },
    {
        4348,
        {34635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4348},
        {34635}
    },
    {
        4349,
        {37070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4349},
        {37070}
    },
    {
        4350,
        {20845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4350},
        {20845}
    },
    {
        4351,
        {40595, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4351},
        {40595}
    },
    {
        4352,
        {31108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4352},
        {31108}
    },
    {
        4353,
        {32907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4353},
        {32907}
    },
    {
        4354,
        {37682, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4354},
        {37682}
    },
    {
        4355,
        {35542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4355},
        {35542}
    },
    {
        4356,
        {20525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4356},
        {20525}
    },
    {
        4357,
        {21644, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4357},
        {21644}
    },
    {
        4358,
        {35441, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4358},
        {35441}
    },
    {
        4359,
        {27498, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4359},
        {27498}
    },
    {
        4360,
        {36036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4360},
        {36036}
    },
    {
        4361,
        {33031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4361},
        {33031}
    },
    {
        4362,
        {24785, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4362},
        {24785}
    },
    {
        4363,
        {26528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4363},
        {26528}
    },
    {
        4364,
        {40434, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4364},
        {40434}
    },
    {
        4365,
        {20121, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4365},
        {20121}
    },
    {
        4366,
        {20120, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4366},
        {20120}
    },
    {
        4367,
        {39952, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4367},
        {39952}
    },
    {
        4368,
        {35435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4368},
        {35435}
    },
    {
        4369,
        {34241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4369},
        {34241}
    },
    {
        4370,
        {34152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4370},
        {34152}
    },
    {
        4371,
        {26880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4371},
        {26880}
    },
    {
        4372,
        {28286, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4372},
        {28286}
    },
    {
        4373,
        {30871, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4373},
        {30871}
    },
    {
        4374,
        {33109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_1,
        1,
        {4374},
        {33109}
    },
    {
        4375,
        {134047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2561},
        {21489}
    },
    {
        4376,
        {23361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4377,
        {23382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4378,
        {23421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4379,
        {23443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4380,
        {23512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4381,
        {23532, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {1803},
        {23515}
    },
    {
        4382,
        {23570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4972},
        {23571}
    },
    {
        4383,
        {23582, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5916},
        {29134}
    },
    {
        4384,
        {23587, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4974},
        {23586}
    },
    {
        4385,
        {23595, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4386,
        {14221, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2831},
        {23611}
    },
    {
        4387,
        {23650, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2577},
        {23649}
    },
    {
        4388,
        {64059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3063},
        {23652}
    },
    {
        4389,
        {64060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4986},
        {23662}
    },
    {
        4390,
        {136884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {4993},
        {22939}
    },
    {
        4391,
        {23674, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4392,
        {23695, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4393,
        {23711, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4394,
        {23715, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4395,
        {23722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4396,
        {23738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4397,
        {23755, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4398,
        {23760, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4399,
        {23762, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4400,
        {23796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4401,
        {138804, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5034},
        {23982}
    },
    {
        4402,
        {14306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5012},
        {23900}
    },
    {
        4403,
        {23821, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4404,
        {23847, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2902},
        {23913}
    },
    {
        4405,
        {64017, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {2423},
        {23822}
    },
    {
        4406,
        {23878, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4407,
        {23879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4408,
        {23891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5022},
        {23890}
    },
    {
        4409,
        {23882, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4410,
        {23917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4411,
        {23937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4412,
        {23968, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4413,
        {23972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {5031},
        {23970}
    },
    {
        4414,
        {23975, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4415,
        {23992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4416,
        {24011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        0,
        {0},
        {0}
    },
    {
        4417,
        {21534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_3,
        1,
        {3538},
        {21585}
    },
    {
        4418,
        {24332, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4418},
        {24332}
    },
    {
        4419,
        {19984, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4419},
        {19984}
    },
    {
        4420,
        {19989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4420},
        {19989}
    },
    {
        4421,
        {20010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4421},
        {20010}
    },
    {
        4422,
        {20017, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4422},
        {20017}
    },
    {
        4423,
        {20022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4423},
        {20022}
    },
    {
        4424,
        {20028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4424},
        {20028}
    },
    {
        4425,
        {20031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4425},
        {20031}
    },
    {
        4426,
        {20034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4426},
        {20034}
    },
    {
        4427,
        {20054, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4427},
        {20054}
    },
    {
        4428,
        {20056, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4428},
        {20056}
    },
    {
        4429,
        {20098, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4429},
        {20098}
    },
    {
        4430,
        {20101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4430},
        {20101}
    },
    {
        4431,
        {35947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4431},
        {35947}
    },
    {
        4432,
        {20106, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4432},
        {20106}
    },
    {
        4433,
        {33298, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4433},
        {33298}
    },
    {
        4434,
        {24333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4434},
        {24333}
    },
    {
        4435,
        {20110, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4435},
        {20110}
    },
    {
        4436,
        {20126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4436},
        {20126}
    },
    {
        4437,
        {20127, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4437},
        {20127}
    },
    {
        4438,
        {20128, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4438},
        {20128}
    },
    {
        4439,
        {20130, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4439},
        {20130}
    },
    {
        4440,
        {20144, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4440},
        {20144}
    },
    {
        4441,
        {20147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4441},
        {20147}
    },
    {
        4442,
        {20150, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4442},
        {20150}
    },
    {
        4443,
        {20174, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4443},
        {20174}
    },
    {
        4444,
        {20173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4444},
        {20173}
    },
    {
        4445,
        {20164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4445},
        {20164}
    },
    {
        4446,
        {20166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4446},
        {20166}
    },
    {
        4447,
        {20162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4447},
        {20162}
    },
    {
        4448,
        {20183, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4448},
        {20183}
    },
    {
        4449,
        {20190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4449},
        {20190}
    },
    {
        4450,
        {20205, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4450},
        {20205}
    },
    {
        4451,
        {20191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4451},
        {20191}
    },
    {
        4452,
        {20215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4452},
        {20215}
    },
    {
        4453,
        {20233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4453},
        {20233}
    },
    {
        4454,
        {20314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4454},
        {20314}
    },
    {
        4455,
        {20272, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4455},
        {20272}
    },
    {
        4456,
        {20315, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4456},
        {20315}
    },
    {
        4457,
        {20317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4457},
        {20317}
    },
    {
        4458,
        {20311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4458},
        {20311}
    },
    {
        4459,
        {20295, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4459},
        {20295}
    },
    {
        4460,
        {20342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4460},
        {20342}
    },
    {
        4461,
        {20360, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4461},
        {20360}
    },
    {
        4462,
        {20367, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4462},
        {20367}
    },
    {
        4463,
        {20376, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4463},
        {20376}
    },
    {
        4464,
        {20347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4464},
        {20347}
    },
    {
        4465,
        {20329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4465},
        {20329}
    },
    {
        4466,
        {20336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4466},
        {20336}
    },
    {
        4467,
        {20369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4467},
        {20369}
    },
    {
        4468,
        {20335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4468},
        {20335}
    },
    {
        4469,
        {20358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4469},
        {20358}
    },
    {
        4470,
        {20374, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4470},
        {20374}
    },
    {
        4471,
        {20760, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4471},
        {20760}
    },
    {
        4472,
        {20436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4472},
        {20436}
    },
    {
        4473,
        {20447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4473},
        {20447}
    },
    {
        4474,
        {20430, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4474},
        {20430}
    },
    {
        4475,
        {20440, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4475},
        {20440}
    },
    {
        4476,
        {20443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4476},
        {20443}
    },
    {
        4477,
        {20433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4477},
        {20433}
    },
    {
        4478,
        {20442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4478},
        {20442}
    },
    {
        4479,
        {20432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4479},
        {20432}
    },
    {
        4480,
        {20452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4480},
        {20452}
    },
    {
        4481,
        {20453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4481},
        {20453}
    },
    {
        4482,
        {20506, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4482},
        {20506}
    },
    {
        4483,
        {20520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4483},
        {20520}
    },
    {
        4484,
        {20500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4484},
        {20500}
    },
    {
        4485,
        {20522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4485},
        {20522}
    },
    {
        4486,
        {20517, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4486},
        {20517}
    },
    {
        4487,
        {20485, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4487},
        {20485}
    },
    {
        4488,
        {20252, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4488},
        {20252}
    },
    {
        4489,
        {20470, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4489},
        {20470}
    },
    {
        4490,
        {20513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4490},
        {20513}
    },
    {
        4491,
        {20521, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4491},
        {20521}
    },
    {
        4492,
        {20524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4492},
        {20524}
    },
    {
        4493,
        {20478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4493},
        {20478}
    },
    {
        4494,
        {20463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4494},
        {20463}
    },
    {
        4495,
        {20497, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4495},
        {20497}
    },
    {
        4496,
        {20486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4496},
        {20486}
    },
    {
        4497,
        {20547, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4497},
        {20547}
    },
    {
        4498,
        {20551, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4498},
        {20551}
    },
    {
        4499,
        {26371, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4499},
        {26371}
    },
    {
        4500,
        {20565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4500},
        {20565}
    },
    {
        4501,
        {20560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4501},
        {20560}
    },
    {
        4502,
        {20552, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4502},
        {20552}
    },
    {
        4503,
        {20570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4503},
        {20570}
    },
    {
        4504,
        {20566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4504},
        {20566}
    },
    {
        4505,
        {20588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4505},
        {20588}
    },
    {
        4506,
        {20600, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4506},
        {20600}
    },
    {
        4507,
        {20608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4507},
        {20608}
    },
    {
        4508,
        {20634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4508},
        {20634}
    },
    {
        4509,
        {20613, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4509},
        {20613}
    },
    {
        4510,
        {20660, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4510},
        {20660}
    },
    {
        4511,
        {20658, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4511},
        {20658}
    },
    {
        4512,
        {20681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4512},
        {20681}
    },
    {
        4513,
        {20682, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4513},
        {20682}
    },
    {
        4514,
        {20659, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4514},
        {20659}
    },
    {
        4515,
        {20674, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4515},
        {20674}
    },
    {
        4516,
        {20694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4516},
        {20694}
    },
    {
        4517,
        {20702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4517},
        {20702}
    },
    {
        4518,
        {20709, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4518},
        {20709}
    },
    {
        4519,
        {20717, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4519},
        {20717}
    },
    {
        4520,
        {20707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4520},
        {20707}
    },
    {
        4521,
        {20718, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4521},
        {20718}
    },
    {
        4522,
        {20729, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4522},
        {20729}
    },
    {
        4523,
        {20725, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4523},
        {20725}
    },
    {
        4524,
        {20745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4524},
        {20745}
    },
    {
        4525,
        {20737, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4525},
        {20737}
    },
    {
        4526,
        {20738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4526},
        {20738}
    },
    {
        4527,
        {20758, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4527},
        {20758}
    },
    {
        4528,
        {20757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4528},
        {20757}
    },
    {
        4529,
        {20756, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4529},
        {20756}
    },
    {
        4530,
        {20762, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4530},
        {20762}
    },
    {
        4531,
        {20769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4531},
        {20769}
    },
    {
        4532,
        {20794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4532},
        {20794}
    },
    {
        4533,
        {20791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4533},
        {20791}
    },
    {
        4534,
        {20796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4534},
        {20796}
    },
    {
        4535,
        {20795, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4535},
        {20795}
    },
    {
        4536,
        {20799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4536},
        {20799}
    },
    {
        4537,
        {20800, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4537},
        {20800}
    },
    {
        4538,
        {20818, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4538},
        {20818}
    },
    {
        4539,
        {20812, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4539},
        {20812}
    },
    {
        4540,
        {20820, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4540},
        {20820}
    },
    {
        4541,
        {20834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4541},
        {20834}
    },
    {
        4542,
        {31480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4542},
        {31480}
    },
    {
        4543,
        {20841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4543},
        {20841}
    },
    {
        4544,
        {20842, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4544},
        {20842}
    },
    {
        4545,
        {20846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4545},
        {20846}
    },
    {
        4546,
        {20864, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4546},
        {20864}
    },
    {
        4547,
        {20866, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4547},
        {20866}
    },
    {
        4548,
        {22232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4548},
        {22232}
    },
    {
        4549,
        {20876, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4549},
        {20876}
    },
    {
        4550,
        {20873, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4550},
        {20873}
    },
    {
        4551,
        {20879, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4551},
        {20879}
    },
    {
        4552,
        {20881, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4552},
        {20881}
    },
    {
        4553,
        {20883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4553},
        {20883}
    },
    {
        4554,
        {20885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4554},
        {20885}
    },
    {
        4555,
        {20886, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4555},
        {20886}
    },
    {
        4556,
        {20900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4556},
        {20900}
    },
    {
        4557,
        {20902, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4557},
        {20902}
    },
    {
        4558,
        {20898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4558},
        {20898}
    },
    {
        4559,
        {20905, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4559},
        {20905}
    },
    {
        4560,
        {20906, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4560},
        {20906}
    },
    {
        4561,
        {20907, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4561},
        {20907}
    },
    {
        4562,
        {20915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4562},
        {20915}
    },
    {
        4563,
        {20913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4563},
        {20913}
    },
    {
        4564,
        {20914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4564},
        {20914}
    },
    {
        4565,
        {20912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4565},
        {20912}
    },
    {
        4566,
        {20917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4566},
        {20917}
    },
    {
        4567,
        {20925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4567},
        {20925}
    },
    {
        4568,
        {20933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4568},
        {20933}
    },
    {
        4569,
        {20937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4569},
        {20937}
    },
    {
        4570,
        {20955, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4570},
        {20955}
    },
    {
        4571,
        {20960, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4571},
        {20960}
    },
    {
        4572,
        {34389, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4572},
        {34389}
    },
    {
        4573,
        {20969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4573},
        {20969}
    },
    {
        4574,
        {20973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4574},
        {20973}
    },
    {
        4575,
        {20976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4575},
        {20976}
    },
    {
        4576,
        {20981, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4576},
        {20981}
    },
    {
        4577,
        {20990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4577},
        {20990}
    },
    {
        4578,
        {20996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4578},
        {20996}
    },
    {
        4579,
        {21003, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4579},
        {21003}
    },
    {
        4580,
        {21012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4580},
        {21012}
    },
    {
        4581,
        {21006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4581},
        {21006}
    },
    {
        4582,
        {21031, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4582},
        {21031}
    },
    {
        4583,
        {21034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4583},
        {21034}
    },
    {
        4584,
        {21038, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4584},
        {21038}
    },
    {
        4585,
        {21043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4585},
        {21043}
    },
    {
        4586,
        {21049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4586},
        {21049}
    },
    {
        4587,
        {21071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4587},
        {21071}
    },
    {
        4588,
        {21060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4588},
        {21060}
    },
    {
        4589,
        {21067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4589},
        {21067}
    },
    {
        4590,
        {21068, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4590},
        {21068}
    },
    {
        4591,
        {21086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4591},
        {21086}
    },
    {
        4592,
        {21076, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4592},
        {21076}
    },
    {
        4593,
        {21098, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4593},
        {21098}
    },
    {
        4594,
        {21108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4594},
        {21108}
    },
    {
        4595,
        {21097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4595},
        {21097}
    },
    {
        4596,
        {21107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4596},
        {21107}
    },
    {
        4597,
        {21119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4597},
        {21119}
    },
    {
        4598,
        {21117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4598},
        {21117}
    },
    {
        4599,
        {21133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4599},
        {21133}
    },
    {
        4600,
        {21140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4600},
        {21140}
    },
    {
        4601,
        {21138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4601},
        {21138}
    },
    {
        4602,
        {21105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4602},
        {21105}
    },
    {
        4603,
        {21128, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4603},
        {21128}
    },
    {
        4604,
        {21137, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4604},
        {21137}
    },
    {
        4605,
        {36776, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4605},
        {36776}
    },
    {
        4606,
        {36775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4606},
        {36775}
    },
    {
        4607,
        {21164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4607},
        {21164}
    },
    {
        4608,
        {21165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4608},
        {21165}
    },
    {
        4609,
        {21180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4609},
        {21180}
    },
    {
        4610,
        {21173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4610},
        {21173}
    },
    {
        4611,
        {21185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4611},
        {21185}
    },
    {
        4612,
        {21197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4612},
        {21197}
    },
    {
        4613,
        {21207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4613},
        {21207}
    },
    {
        4614,
        {21214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4614},
        {21214}
    },
    {
        4615,
        {21219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4615},
        {21219}
    },
    {
        4616,
        {21222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4616},
        {21222}
    },
    {
        4617,
        {39149, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4617},
        {39149}
    },
    {
        4618,
        {21216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4618},
        {21216}
    },
    {
        4619,
        {21235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4619},
        {21235}
    },
    {
        4620,
        {21237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4620},
        {21237}
    },
    {
        4621,
        {21240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4621},
        {21240}
    },
    {
        4622,
        {21241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4622},
        {21241}
    },
    {
        4623,
        {21254, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4623},
        {21254}
    },
    {
        4624,
        {21256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4624},
        {21256}
    },
    {
        4625,
        {30008, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4625},
        {30008}
    },
    {
        4626,
        {21261, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4626},
        {21261}
    },
    {
        4627,
        {21264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4627},
        {21264}
    },
    {
        4628,
        {21263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4628},
        {21263}
    },
    {
        4629,
        {21269, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4629},
        {21269}
    },
    {
        4630,
        {21274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4630},
        {21274}
    },
    {
        4631,
        {21283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4631},
        {21283}
    },
    {
        4632,
        {21295, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4632},
        {21295}
    },
    {
        4633,
        {21297, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4633},
        {21297}
    },
    {
        4634,
        {21299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4634},
        {21299}
    },
    {
        4635,
        {21304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4635},
        {21304}
    },
    {
        4636,
        {21312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4636},
        {21312}
    },
    {
        4637,
        {21318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4637},
        {21318}
    },
    {
        4638,
        {21317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4638},
        {21317}
    },
    {
        4639,
        {19991, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4639},
        {19991}
    },
    {
        4640,
        {21321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4640},
        {21321}
    },
    {
        4641,
        {21325, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4641},
        {21325}
    },
    {
        4642,
        {20950, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4642},
        {20950}
    },
    {
        4643,
        {21342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4643},
        {21342}
    },
    {
        4644,
        {21353, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4644},
        {21353}
    },
    {
        4645,
        {21358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4645},
        {21358}
    },
    {
        4646,
        {22808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4646},
        {22808}
    },
    {
        4647,
        {21371, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4647},
        {21371}
    },
    {
        4648,
        {21367, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4648},
        {21367}
    },
    {
        4649,
        {21378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4649},
        {21378}
    },
    {
        4650,
        {21398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4650},
        {21398}
    },
    {
        4651,
        {21408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4651},
        {21408}
    },
    {
        4652,
        {21414, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4652},
        {21414}
    },
    {
        4653,
        {21413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4653},
        {21413}
    },
    {
        4654,
        {21422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4654},
        {21422}
    },
    {
        4655,
        {21424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4655},
        {21424}
    },
    {
        4656,
        {21430, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4656},
        {21430}
    },
    {
        4657,
        {21443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4657},
        {21443}
    },
    {
        4658,
        {31762, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4658},
        {31762}
    },
    {
        4659,
        {38617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4659},
        {38617}
    },
    {
        4660,
        {21471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4660},
        {21471}
    },
    {
        4661,
        {26364, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4661},
        {26364}
    },
    {
        4662,
        {29166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4662},
        {29166}
    },
    {
        4663,
        {21486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4663},
        {21486}
    },
    {
        4664,
        {21480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4664},
        {21480}
    },
    {
        4665,
        {21485, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4665},
        {21485}
    },
    {
        4666,
        {21498, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4666},
        {21498}
    },
    {
        4667,
        {21505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4667},
        {21505}
    },
    {
        4668,
        {21565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4668},
        {21565}
    },
    {
        4669,
        {21568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4669},
        {21568}
    },
    {
        4670,
        {21548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4670},
        {21548}
    },
    {
        4671,
        {21549, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4671},
        {21549}
    },
    {
        4672,
        {21564, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4672},
        {21564}
    },
    {
        4673,
        {21550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4673},
        {21550}
    },
    {
        4674,
        {21558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4674},
        {21558}
    },
    {
        4675,
        {21545, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4675},
        {21545}
    },
    {
        4676,
        {21533, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4676},
        {21533}
    },
    {
        4677,
        {21582, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4677},
        {21582}
    },
    {
        4678,
        {21647, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4678},
        {21647}
    },
    {
        4679,
        {21621, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4679},
        {21621}
    },
    {
        4680,
        {21646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4680},
        {21646}
    },
    {
        4681,
        {21599, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4681},
        {21599}
    },
    {
        4682,
        {21617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4682},
        {21617}
    },
    {
        4683,
        {21623, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4683},
        {21623}
    },
    {
        4684,
        {21616, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4684},
        {21616}
    },
    {
        4685,
        {21650, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4685},
        {21650}
    },
    {
        4686,
        {21627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4686},
        {21627}
    },
    {
        4687,
        {21632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4687},
        {21632}
    },
    {
        4688,
        {21622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4688},
        {21622}
    },
    {
        4689,
        {21636, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4689},
        {21636}
    },
    {
        4690,
        {21648, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4690},
        {21648}
    },
    {
        4691,
        {21638, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4691},
        {21638}
    },
    {
        4692,
        {21703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4692},
        {21703}
    },
    {
        4693,
        {21666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4693},
        {21666}
    },
    {
        4694,
        {21688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4694},
        {21688}
    },
    {
        4695,
        {21669, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4695},
        {21669}
    },
    {
        4696,
        {21676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4696},
        {21676}
    },
    {
        4697,
        {21700, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4697},
        {21700}
    },
    {
        4698,
        {21704, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4698},
        {21704}
    },
    {
        4699,
        {21672, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4699},
        {21672}
    },
    {
        4700,
        {21675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4700},
        {21675}
    },
    {
        4701,
        {21698, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4701},
        {21698}
    },
    {
        4702,
        {21668, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4702},
        {21668}
    },
    {
        4703,
        {21694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4703},
        {21694}
    },
    {
        4704,
        {21692, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4704},
        {21692}
    },
    {
        4705,
        {21720, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4705},
        {21720}
    },
    {
        4706,
        {21733, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4706},
        {21733}
    },
    {
        4707,
        {21734, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4707},
        {21734}
    },
    {
        4708,
        {21775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4708},
        {21775}
    },
    {
        4709,
        {21780, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4709},
        {21780}
    },
    {
        4710,
        {21757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4710},
        {21757}
    },
    {
        4711,
        {21742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4711},
        {21742}
    },
    {
        4712,
        {21741, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4712},
        {21741}
    },
    {
        4713,
        {21754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4713},
        {21754}
    },
    {
        4714,
        {21730, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4714},
        {21730}
    },
    {
        4715,
        {21817, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4715},
        {21817}
    },
    {
        4716,
        {21824, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4716},
        {21824}
    },
    {
        4717,
        {21859, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4717},
        {21859}
    },
    {
        4718,
        {21836, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4718},
        {21836}
    },
    {
        4719,
        {21806, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4719},
        {21806}
    },
    {
        4720,
        {21852, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4720},
        {21852}
    },
    {
        4721,
        {21829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4721},
        {21829}
    },
    {
        4722,
        {21846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4722},
        {21846}
    },
    {
        4723,
        {21847, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4723},
        {21847}
    },
    {
        4724,
        {21816, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4724},
        {21816}
    },
    {
        4725,
        {21811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4725},
        {21811}
    },
    {
        4726,
        {21853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4726},
        {21853}
    },
    {
        4727,
        {21913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4727},
        {21913}
    },
    {
        4728,
        {21888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4728},
        {21888}
    },
    {
        4729,
        {21679, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4729},
        {21679}
    },
    {
        4730,
        {21898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4730},
        {21898}
    },
    {
        4731,
        {21919, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4731},
        {21919}
    },
    {
        4732,
        {21883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4732},
        {21883}
    },
    {
        4733,
        {21886, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4733},
        {21886}
    },
    {
        4734,
        {21912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4734},
        {21912}
    },
    {
        4735,
        {21918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4735},
        {21918}
    },
    {
        4736,
        {21934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4736},
        {21934}
    },
    {
        4737,
        {21884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4737},
        {21884}
    },
    {
        4738,
        {21891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4738},
        {21891}
    },
    {
        4739,
        {21929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4739},
        {21929}
    },
    {
        4740,
        {21895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4740},
        {21895}
    },
    {
        4741,
        {21928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4741},
        {21928}
    },
    {
        4742,
        {21978, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4742},
        {21978}
    },
    {
        4743,
        {21957, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4743},
        {21957}
    },
    {
        4744,
        {21983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4744},
        {21983}
    },
    {
        4745,
        {21956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4745},
        {21956}
    },
    {
        4746,
        {21980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4746},
        {21980}
    },
    {
        4747,
        {21988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4747},
        {21988}
    },
    {
        4748,
        {21972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4748},
        {21972}
    },
    {
        4749,
        {22036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4749},
        {22036}
    },
    {
        4750,
        {22007, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4750},
        {22007}
    },
    {
        4751,
        {22038, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4751},
        {22038}
    },
    {
        4752,
        {22014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4752},
        {22014}
    },
    {
        4753,
        {22013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4753},
        {22013}
    },
    {
        4754,
        {22043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4754},
        {22043}
    },
    {
        4755,
        {22009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4755},
        {22009}
    },
    {
        4756,
        {22094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4756},
        {22094}
    },
    {
        4757,
        {22096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4757},
        {22096}
    },
    {
        4758,
        {29151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4758},
        {29151}
    },
    {
        4759,
        {22068, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4759},
        {22068}
    },
    {
        4760,
        {22070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4760},
        {22070}
    },
    {
        4761,
        {22066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4761},
        {22066}
    },
    {
        4762,
        {22072, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4762},
        {22072}
    },
    {
        4763,
        {22123, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4763},
        {22123}
    },
    {
        4764,
        {22116, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4764},
        {22116}
    },
    {
        4765,
        {22063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4765},
        {22063}
    },
    {
        4766,
        {22124, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4766},
        {22124}
    },
    {
        4767,
        {22122, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4767},
        {22122}
    },
    {
        4768,
        {22150, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4768},
        {22150}
    },
    {
        4769,
        {22144, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4769},
        {22144}
    },
    {
        4770,
        {22154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4770},
        {22154}
    },
    {
        4771,
        {22176, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4771},
        {22176}
    },
    {
        4772,
        {22164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4772},
        {22164}
    },
    {
        4773,
        {22159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4773},
        {22159}
    },
    {
        4774,
        {22181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4774},
        {22181}
    },
    {
        4775,
        {22190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4775},
        {22190}
    },
    {
        4776,
        {22198, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4776},
        {22198}
    },
    {
        4777,
        {22196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4777},
        {22196}
    },
    {
        4778,
        {22210, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4778},
        {22210}
    },
    {
        4779,
        {22204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4779},
        {22204}
    },
    {
        4780,
        {22209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4780},
        {22209}
    },
    {
        4781,
        {22211, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4781},
        {22211}
    },
    {
        4782,
        {22208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4782},
        {22208}
    },
    {
        4783,
        {22216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4783},
        {22216}
    },
    {
        4784,
        {22222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4784},
        {22222}
    },
    {
        4785,
        {22225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4785},
        {22225}
    },
    {
        4786,
        {22227, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4786},
        {22227}
    },
    {
        4787,
        {22231, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4787},
        {22231}
    },
    {
        4788,
        {22254, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4788},
        {22254}
    },
    {
        4789,
        {22265, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4789},
        {22265}
    },
    {
        4790,
        {22272, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4790},
        {22272}
    },
    {
        4791,
        {22271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4791},
        {22271}
    },
    {
        4792,
        {22276, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4792},
        {22276}
    },
    {
        4793,
        {22281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4793},
        {22281}
    },
    {
        4794,
        {22280, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4794},
        {22280}
    },
    {
        4795,
        {22283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4795},
        {22283}
    },
    {
        4796,
        {22285, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4796},
        {22285}
    },
    {
        4797,
        {22291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4797},
        {22291}
    },
    {
        4798,
        {22296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4798},
        {22296}
    },
    {
        4799,
        {22294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4799},
        {22294}
    },
    {
        4800,
        {21959, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4800},
        {21959}
    },
    {
        4801,
        {22300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4801},
        {22300}
    },
    {
        4802,
        {22310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4802},
        {22310}
    },
    {
        4803,
        {22327, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4803},
        {22327}
    },
    {
        4804,
        {22328, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4804},
        {22328}
    },
    {
        4805,
        {22350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4805},
        {22350}
    },
    {
        4806,
        {22331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4806},
        {22331}
    },
    {
        4807,
        {22336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4807},
        {22336}
    },
    {
        4808,
        {22351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4808},
        {22351}
    },
    {
        4809,
        {22377, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4809},
        {22377}
    },
    {
        4810,
        {22464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4810},
        {22464}
    },
    {
        4811,
        {22408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4811},
        {22408}
    },
    {
        4812,
        {22369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4812},
        {22369}
    },
    {
        4813,
        {22399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4813},
        {22399}
    },
    {
        4814,
        {22409, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4814},
        {22409}
    },
    {
        4815,
        {22419, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4815},
        {22419}
    },
    {
        4816,
        {22432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4816},
        {22432}
    },
    {
        4817,
        {22451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4817},
        {22451}
    },
    {
        4818,
        {22436, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4818},
        {22436}
    },
    {
        4819,
        {22442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4819},
        {22442}
    },
    {
        4820,
        {22448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4820},
        {22448}
    },
    {
        4821,
        {22467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4821},
        {22467}
    },
    {
        4822,
        {22470, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4822},
        {22470}
    },
    {
        4823,
        {22484, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4823},
        {22484}
    },
    {
        4824,
        {22482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4824},
        {22482}
    },
    {
        4825,
        {22483, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4825},
        {22483}
    },
    {
        4826,
        {22538, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4826},
        {22538}
    },
    {
        4827,
        {22486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4827},
        {22486}
    },
    {
        4828,
        {22499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4828},
        {22499}
    },
    {
        4829,
        {22539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4829},
        {22539}
    },
    {
        4830,
        {22553, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4830},
        {22553}
    },
    {
        4831,
        {22557, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4831},
        {22557}
    },
    {
        4832,
        {22642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4832},
        {22642}
    },
    {
        4833,
        {22561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4833},
        {22561}
    },
    {
        4834,
        {22626, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4834},
        {22626}
    },
    {
        4835,
        {22603, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4835},
        {22603}
    },
    {
        4836,
        {22640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4836},
        {22640}
    },
    {
        4837,
        {27584, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4837},
        {27584}
    },
    {
        4838,
        {22610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4838},
        {22610}
    },
    {
        4839,
        {22589, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4839},
        {22589}
    },
    {
        4840,
        {22649, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4840},
        {22649}
    },
    {
        4841,
        {22661, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4841},
        {22661}
    },
    {
        4842,
        {22713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4842},
        {22713}
    },
    {
        4843,
        {22687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4843},
        {22687}
    },
    {
        4844,
        {22699, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4844},
        {22699}
    },
    {
        4845,
        {22714, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4845},
        {22714}
    },
    {
        4846,
        {22750, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4846},
        {22750}
    },
    {
        4847,
        {22715, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4847},
        {22715}
    },
    {
        4848,
        {22712, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4848},
        {22712}
    },
    {
        4849,
        {22702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4849},
        {22702}
    },
    {
        4850,
        {22725, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4850},
        {22725}
    },
    {
        4851,
        {22739, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4851},
        {22739}
    },
    {
        4852,
        {22737, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4852},
        {22737}
    },
    {
        4853,
        {22743, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4853},
        {22743}
    },
    {
        4854,
        {22745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4854},
        {22745}
    },
    {
        4855,
        {22744, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4855},
        {22744}
    },
    {
        4856,
        {22757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4856},
        {22757}
    },
    {
        4857,
        {22748, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4857},
        {22748}
    },
    {
        4858,
        {22756, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4858},
        {22756}
    },
    {
        4859,
        {22751, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4859},
        {22751}
    },
    {
        4860,
        {22767, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4860},
        {22767}
    },
    {
        4861,
        {22778, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4861},
        {22778}
    },
    {
        4862,
        {22777, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4862},
        {22777}
    },
    {
        4863,
        {22779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4863},
        {22779}
    },
    {
        4864,
        {22780, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4864},
        {22780}
    },
    {
        4865,
        {22781, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4865},
        {22781}
    },
    {
        4866,
        {22786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4866},
        {22786}
    },
    {
        4867,
        {22794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4867},
        {22794}
    },
    {
        4868,
        {22800, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4868},
        {22800}
    },
    {
        4869,
        {22811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4869},
        {22811}
    },
    {
        4870,
        {26790, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4870},
        {26790}
    },
    {
        4871,
        {22821, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4871},
        {22821}
    },
    {
        4872,
        {22828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4872},
        {22828}
    },
    {
        4873,
        {22829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4873},
        {22829}
    },
    {
        4874,
        {22834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4874},
        {22834}
    },
    {
        4875,
        {22840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4875},
        {22840}
    },
    {
        4876,
        {22846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4876},
        {22846}
    },
    {
        4877,
        {31442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4877},
        {31442}
    },
    {
        4878,
        {22869, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4878},
        {22869}
    },
    {
        4879,
        {22864, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4879},
        {22864}
    },
    {
        4880,
        {22862, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4880},
        {22862}
    },
    {
        4881,
        {22874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4881},
        {22874}
    },
    {
        4882,
        {22872, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4882},
        {22872}
    },
    {
        4883,
        {22882, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4883},
        {22882}
    },
    {
        4884,
        {22880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4884},
        {22880}
    },
    {
        4885,
        {22887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4885},
        {22887}
    },
    {
        4886,
        {22892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4886},
        {22892}
    },
    {
        4887,
        {22889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4887},
        {22889}
    },
    {
        4888,
        {22904, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4888},
        {22904}
    },
    {
        4889,
        {22913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4889},
        {22913}
    },
    {
        4890,
        {22941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4890},
        {22941}
    },
    {
        4891,
        {20318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4891},
        {20318}
    },
    {
        4892,
        {20395, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4892},
        {20395}
    },
    {
        4893,
        {22947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4893},
        {22947}
    },
    {
        4894,
        {22962, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4894},
        {22962}
    },
    {
        4895,
        {22982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4895},
        {22982}
    },
    {
        4896,
        {23016, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4896},
        {23016}
    },
    {
        4897,
        {23004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4897},
        {23004}
    },
    {
        4898,
        {22925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4898},
        {22925}
    },
    {
        4899,
        {23001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4899},
        {23001}
    },
    {
        4900,
        {23002, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4900},
        {23002}
    },
    {
        4901,
        {23077, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4901},
        {23077}
    },
    {
        4902,
        {23071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4902},
        {23071}
    },
    {
        4903,
        {23057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4903},
        {23057}
    },
    {
        4904,
        {23068, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4904},
        {23068}
    },
    {
        4905,
        {23049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4905},
        {23049}
    },
    {
        4906,
        {23066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4906},
        {23066}
    },
    {
        4907,
        {23104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4907},
        {23104}
    },
    {
        4908,
        {23148, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4908},
        {23148}
    },
    {
        4909,
        {23113, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4909},
        {23113}
    },
    {
        4910,
        {23093, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4910},
        {23093}
    },
    {
        4911,
        {23094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4911},
        {23094}
    },
    {
        4912,
        {23138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4912},
        {23138}
    },
    {
        4913,
        {23146, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4913},
        {23146}
    },
    {
        4914,
        {23194, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4914},
        {23194}
    },
    {
        4915,
        {23228, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4915},
        {23228}
    },
    {
        4916,
        {23230, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4916},
        {23230}
    },
    {
        4917,
        {23243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4917},
        {23243}
    },
    {
        4918,
        {23234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4918},
        {23234}
    },
    {
        4919,
        {23229, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4919},
        {23229}
    },
    {
        4920,
        {23267, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4920},
        {23267}
    },
    {
        4921,
        {23255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4921},
        {23255}
    },
    {
        4922,
        {23270, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4922},
        {23270}
    },
    {
        4923,
        {23273, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4923},
        {23273}
    },
    {
        4924,
        {23254, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4924},
        {23254}
    },
    {
        4925,
        {23290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4925},
        {23290}
    },
    {
        4926,
        {23291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4926},
        {23291}
    },
    {
        4927,
        {23308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4927},
        {23308}
    },
    {
        4928,
        {23307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4928},
        {23307}
    },
    {
        4929,
        {23318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4929},
        {23318}
    },
    {
        4930,
        {23346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4930},
        {23346}
    },
    {
        4931,
        {23248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4931},
        {23248}
    },
    {
        4932,
        {23338, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4932},
        {23338}
    },
    {
        4933,
        {23350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4933},
        {23350}
    },
    {
        4934,
        {23358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4934},
        {23358}
    },
    {
        4935,
        {23363, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4935},
        {23363}
    },
    {
        4936,
        {23365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4936},
        {23365}
    },
    {
        4937,
        {23360, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4937},
        {23360}
    },
    {
        4938,
        {23377, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4938},
        {23377}
    },
    {
        4939,
        {23381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4939},
        {23381}
    },
    {
        4940,
        {23386, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4940},
        {23386}
    },
    {
        4941,
        {23387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4941},
        {23387}
    },
    {
        4942,
        {23397, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4942},
        {23397}
    },
    {
        4943,
        {23401, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4943},
        {23401}
    },
    {
        4944,
        {23408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4944},
        {23408}
    },
    {
        4945,
        {23411, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4945},
        {23411}
    },
    {
        4946,
        {23413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4946},
        {23413}
    },
    {
        4947,
        {23416, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4947},
        {23416}
    },
    {
        4948,
        {25992, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4948},
        {25992}
    },
    {
        4949,
        {23418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4949},
        {23418}
    },
    {
        4950,
        {23424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4950},
        {23424}
    },
    {
        4951,
        {23427, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4951},
        {23427}
    },
    {
        4952,
        {23462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4952},
        {23462}
    },
    {
        4953,
        {23480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4953},
        {23480}
    },
    {
        4954,
        {23491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4954},
        {23491}
    },
    {
        4955,
        {23495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4955},
        {23495}
    },
    {
        4956,
        {23497, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4956},
        {23497}
    },
    {
        4957,
        {23508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4957},
        {23508}
    },
    {
        4958,
        {23504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4958},
        {23504}
    },
    {
        4959,
        {23524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4959},
        {23524}
    },
    {
        4960,
        {23526, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4960},
        {23526}
    },
    {
        4961,
        {23522, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4961},
        {23522}
    },
    {
        4962,
        {23518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4962},
        {23518}
    },
    {
        4963,
        {23525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4963},
        {23525}
    },
    {
        4964,
        {23531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4964},
        {23531}
    },
    {
        4965,
        {23536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4965},
        {23536}
    },
    {
        4966,
        {23542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4966},
        {23542}
    },
    {
        4967,
        {23539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4967},
        {23539}
    },
    {
        4968,
        {23557, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4968},
        {23557}
    },
    {
        4969,
        {23559, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4969},
        {23559}
    },
    {
        4970,
        {23560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4970},
        {23560}
    },
    {
        4971,
        {23565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4971},
        {23565}
    },
    {
        4972,
        {23571, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4972},
        {23571}
    },
    {
        4973,
        {23584, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4973},
        {23584}
    },
    {
        4974,
        {23586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4974},
        {23586}
    },
    {
        4975,
        {23592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4975},
        {23592}
    },
    {
        4976,
        {23608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4976},
        {23608}
    },
    {
        4977,
        {23609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4977},
        {23609}
    },
    {
        4978,
        {23617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4978},
        {23617}
    },
    {
        4979,
        {23622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4979},
        {23622}
    },
    {
        4980,
        {23630, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4980},
        {23630}
    },
    {
        4981,
        {23635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4981},
        {23635}
    },
    {
        4982,
        {23632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4982},
        {23632}
    },
    {
        4983,
        {23631, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4983},
        {23631}
    },
    {
        4984,
        {23409, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4984},
        {23409}
    },
    {
        4985,
        {23660, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4985},
        {23660}
    },
    {
        4986,
        {23662, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4986},
        {23662}
    },
    {
        4987,
        {20066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4987},
        {20066}
    },
    {
        4988,
        {23670, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4988},
        {23670}
    },
    {
        4989,
        {23673, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4989},
        {23673}
    },
    {
        4990,
        {23692, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4990},
        {23692}
    },
    {
        4991,
        {23697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4991},
        {23697}
    },
    {
        4992,
        {23700, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4992},
        {23700}
    },
    {
        4993,
        {22939, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4993},
        {22939}
    },
    {
        4994,
        {23723, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4994},
        {23723}
    },
    {
        4995,
        {23739, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4995},
        {23739}
    },
    {
        4996,
        {23734, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4996},
        {23734}
    },
    {
        4997,
        {23740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4997},
        {23740}
    },
    {
        4998,
        {23735, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4998},
        {23735}
    },
    {
        4999,
        {23749, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {4999},
        {23749}
    },
    {
        5000,
        {23742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5000},
        {23742}
    },
    {
        5001,
        {23751, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5001},
        {23751}
    },
    {
        5002,
        {23769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5002},
        {23769}
    },
    {
        5003,
        {23785, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5003},
        {23785}
    },
    {
        5004,
        {23805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5004},
        {23805}
    },
    {
        5005,
        {23802, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5005},
        {23802}
    },
    {
        5006,
        {23789, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5006},
        {23789}
    },
    {
        5007,
        {23948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5007},
        {23948}
    },
    {
        5008,
        {23786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5008},
        {23786}
    },
    {
        5009,
        {23819, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5009},
        {23819}
    },
    {
        5010,
        {23829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5010},
        {23829}
    },
    {
        5011,
        {23831, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5011},
        {23831}
    },
    {
        5012,
        {23900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5012},
        {23900}
    },
    {
        5013,
        {23839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5013},
        {23839}
    },
    {
        5014,
        {23835, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5014},
        {23835}
    },
    {
        5015,
        {23825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5015},
        {23825}
    },
    {
        5016,
        {23828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5016},
        {23828}
    },
    {
        5017,
        {23842, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5017},
        {23842}
    },
    {
        5018,
        {23834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5018},
        {23834}
    },
    {
        5019,
        {23833, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5019},
        {23833}
    },
    {
        5020,
        {23832, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5020},
        {23832}
    },
    {
        5021,
        {23884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5021},
        {23884}
    },
    {
        5022,
        {23890, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5022},
        {23890}
    },
    {
        5023,
        {23886, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5023},
        {23886}
    },
    {
        5024,
        {23883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5024},
        {23883}
    },
    {
        5025,
        {23916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5025},
        {23916}
    },
    {
        5026,
        {23923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5026},
        {23923}
    },
    {
        5027,
        {23926, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5027},
        {23926}
    },
    {
        5028,
        {23943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5028},
        {23943}
    },
    {
        5029,
        {23940, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5029},
        {23940}
    },
    {
        5030,
        {23938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5030},
        {23938}
    },
    {
        5031,
        {23970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5031},
        {23970}
    },
    {
        5032,
        {23965, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5032},
        {23965}
    },
    {
        5033,
        {23980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5033},
        {23980}
    },
    {
        5034,
        {23982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5034},
        {23982}
    },
    {
        5035,
        {23997, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5035},
        {23997}
    },
    {
        5036,
        {23952, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5036},
        {23952}
    },
    {
        5037,
        {23991, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5037},
        {23991}
    },
    {
        5038,
        {23996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5038},
        {23996}
    },
    {
        5039,
        {24009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5039},
        {24009}
    },
    {
        5040,
        {24013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5040},
        {24013}
    },
    {
        5041,
        {24019, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5041},
        {24019}
    },
    {
        5042,
        {24018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5042},
        {24018}
    },
    {
        5043,
        {24022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5043},
        {24022}
    },
    {
        5044,
        {24027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5044},
        {24027}
    },
    {
        5045,
        {24043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5045},
        {24043}
    },
    {
        5046,
        {24050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5046},
        {24050}
    },
    {
        5047,
        {24053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5047},
        {24053}
    },
    {
        5048,
        {24075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5048},
        {24075}
    },
    {
        5049,
        {24090, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5049},
        {24090}
    },
    {
        5050,
        {24089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5050},
        {24089}
    },
    {
        5051,
        {24081, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5051},
        {24081}
    },
    {
        5052,
        {24091, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5052},
        {24091}
    },
    {
        5053,
        {24118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5053},
        {24118}
    },
    {
        5054,
        {24119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5054},
        {24119}
    },
    {
        5055,
        {24132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5055},
        {24132}
    },
    {
        5056,
        {24131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5056},
        {24131}
    },
    {
        5057,
        {24128, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5057},
        {24128}
    },
    {
        5058,
        {24142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5058},
        {24142}
    },
    {
        5059,
        {24151, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5059},
        {24151}
    },
    {
        5060,
        {24148, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5060},
        {24148}
    },
    {
        5061,
        {24159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5061},
        {24159}
    },
    {
        5062,
        {24162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5062},
        {24162}
    },
    {
        5063,
        {24164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5063},
        {24164}
    },
    {
        5064,
        {24135, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5064},
        {24135}
    },
    {
        5065,
        {24181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5065},
        {24181}
    },
    {
        5066,
        {24182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5066},
        {24182}
    },
    {
        5067,
        {24186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5067},
        {24186}
    },
    {
        5068,
        {40636, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5068},
        {40636}
    },
    {
        5069,
        {24191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5069},
        {24191}
    },
    {
        5070,
        {24224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5070},
        {24224}
    },
    {
        5071,
        {24257, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5071},
        {24257}
    },
    {
        5072,
        {24258, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5072},
        {24258}
    },
    {
        5073,
        {24264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5073},
        {24264}
    },
    {
        5074,
        {24272, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5074},
        {24272}
    },
    {
        5075,
        {24271, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5075},
        {24271}
    },
    {
        5076,
        {24278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5076},
        {24278}
    },
    {
        5077,
        {24291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5077},
        {24291}
    },
    {
        5078,
        {24285, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5078},
        {24285}
    },
    {
        5079,
        {24282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5079},
        {24282}
    },
    {
        5080,
        {24283, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5080},
        {24283}
    },
    {
        5081,
        {24290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5081},
        {24290}
    },
    {
        5082,
        {24289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5082},
        {24289}
    },
    {
        5083,
        {24296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5083},
        {24296}
    },
    {
        5084,
        {24297, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5084},
        {24297}
    },
    {
        5085,
        {24300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5085},
        {24300}
    },
    {
        5086,
        {24305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5086},
        {24305}
    },
    {
        5087,
        {24307, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5087},
        {24307}
    },
    {
        5088,
        {24304, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5088},
        {24304}
    },
    {
        5089,
        {24308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5089},
        {24308}
    },
    {
        5090,
        {24312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5090},
        {24312}
    },
    {
        5091,
        {24318, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5091},
        {24318}
    },
    {
        5092,
        {24323, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5092},
        {24323}
    },
    {
        5093,
        {24329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5093},
        {24329}
    },
    {
        5094,
        {24413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5094},
        {24413}
    },
    {
        5095,
        {24412, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5095},
        {24412}
    },
    {
        5096,
        {24331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5096},
        {24331}
    },
    {
        5097,
        {24337, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5097},
        {24337}
    },
    {
        5098,
        {24342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5098},
        {24342}
    },
    {
        5099,
        {24361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5099},
        {24361}
    },
    {
        5100,
        {24365, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5100},
        {24365}
    },
    {
        5101,
        {24376, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5101},
        {24376}
    },
    {
        5102,
        {24385, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5102},
        {24385}
    },
    {
        5103,
        {24392, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5103},
        {24392}
    },
    {
        5104,
        {24396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5104},
        {24396}
    },
    {
        5105,
        {24398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5105},
        {24398}
    },
    {
        5106,
        {24367, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5106},
        {24367}
    },
    {
        5107,
        {24401, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5107},
        {24401}
    },
    {
        5108,
        {24406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5108},
        {24406}
    },
    {
        5109,
        {24407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5109},
        {24407}
    },
    {
        5110,
        {24409, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5110},
        {24409}
    },
    {
        5111,
        {24417, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5111},
        {24417}
    },
    {
        5112,
        {24429, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5112},
        {24429}
    },
    {
        5113,
        {24435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5113},
        {24435}
    },
    {
        5114,
        {24439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5114},
        {24439}
    },
    {
        5115,
        {24451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5115},
        {24451}
    },
    {
        5116,
        {24450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5116},
        {24450}
    },
    {
        5117,
        {24447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5117},
        {24447}
    },
    {
        5118,
        {24458, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5118},
        {24458}
    },
    {
        5119,
        {24456, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5119},
        {24456}
    },
    {
        5120,
        {24465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5120},
        {24465}
    },
    {
        5121,
        {24455, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5121},
        {24455}
    },
    {
        5122,
        {24478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5122},
        {24478}
    },
    {
        5123,
        {24473, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5123},
        {24473}
    },
    {
        5124,
        {24472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5124},
        {24472}
    },
    {
        5125,
        {24480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5125},
        {24480}
    },
    {
        5126,
        {24488, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5126},
        {24488}
    },
    {
        5127,
        {24493, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5127},
        {24493}
    },
    {
        5128,
        {24508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5128},
        {24508}
    },
    {
        5129,
        {24534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5129},
        {24534}
    },
    {
        5130,
        {24571, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5130},
        {24571}
    },
    {
        5131,
        {24548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5131},
        {24548}
    },
    {
        5132,
        {24568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5132},
        {24568}
    },
    {
        5133,
        {24561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5133},
        {24561}
    },
    {
        5134,
        {24541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5134},
        {24541}
    },
    {
        5135,
        {24755, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5135},
        {24755}
    },
    {
        5136,
        {24575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5136},
        {24575}
    },
    {
        5137,
        {24609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5137},
        {24609}
    },
    {
        5138,
        {24672, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5138},
        {24672}
    },
    {
        5139,
        {24601, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5139},
        {24601}
    },
    {
        5140,
        {24592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5140},
        {24592}
    },
    {
        5141,
        {24617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5141},
        {24617}
    },
    {
        5142,
        {24590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5142},
        {24590}
    },
    {
        5143,
        {24625, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5143},
        {24625}
    },
    {
        5144,
        {24603, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5144},
        {24603}
    },
    {
        5145,
        {24597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5145},
        {24597}
    },
    {
        5146,
        {24619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5146},
        {24619}
    },
    {
        5147,
        {24614, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5147},
        {24614}
    },
    {
        5148,
        {24591, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5148},
        {24591}
    },
    {
        5149,
        {24634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5149},
        {24634}
    },
    {
        5150,
        {24666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5150},
        {24666}
    },
    {
        5151,
        {24641, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5151},
        {24641}
    },
    {
        5152,
        {24682, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5152},
        {24682}
    },
    {
        5153,
        {24695, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5153},
        {24695}
    },
    {
        5154,
        {24671, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5154},
        {24671}
    },
    {
        5155,
        {24650, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5155},
        {24650}
    },
    {
        5156,
        {24646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5156},
        {24646}
    },
    {
        5157,
        {24653, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5157},
        {24653}
    },
    {
        5158,
        {24675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5158},
        {24675}
    },
    {
        5159,
        {24643, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5159},
        {24643}
    },
    {
        5160,
        {24676, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5160},
        {24676}
    },
    {
        5161,
        {24642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5161},
        {24642}
    },
    {
        5162,
        {24684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5162},
        {24684}
    },
    {
        5163,
        {24683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5163},
        {24683}
    },
    {
        5164,
        {24665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5164},
        {24665}
    },
    {
        5165,
        {24705, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5165},
        {24705}
    },
    {
        5166,
        {24717, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5166},
        {24717}
    },
    {
        5167,
        {24807, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5167},
        {24807}
    },
    {
        5168,
        {24707, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5168},
        {24707}
    },
    {
        5169,
        {24730, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5169},
        {24730}
    },
    {
        5170,
        {24708, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5170},
        {24708}
    },
    {
        5171,
        {24731, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5171},
        {24731}
    },
    {
        5172,
        {24726, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5172},
        {24726}
    },
    {
        5173,
        {24727, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5173},
        {24727}
    },
    {
        5174,
        {24722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5174},
        {24722}
    },
    {
        5175,
        {24743, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5175},
        {24743}
    },
    {
        5176,
        {24715, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5176},
        {24715}
    },
    {
        5177,
        {24801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5177},
        {24801}
    },
    {
        5178,
        {24760, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5178},
        {24760}
    },
    {
        5179,
        {24800, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5179},
        {24800}
    },
    {
        5180,
        {24787, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5180},
        {24787}
    },
    {
        5181,
        {24756, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5181},
        {24756}
    },
    {
        5182,
        {24560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5182},
        {24560}
    },
    {
        5183,
        {24765, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5183},
        {24765}
    },
    {
        5184,
        {24774, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5184},
        {24774}
    },
    {
        5185,
        {24757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5185},
        {24757}
    },
    {
        5186,
        {24792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5186},
        {24792}
    },
    {
        5187,
        {24909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5187},
        {24909}
    },
    {
        5188,
        {24853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5188},
        {24853}
    },
    {
        5189,
        {24838, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5189},
        {24838}
    },
    {
        5190,
        {24822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5190},
        {24822}
    },
    {
        5191,
        {24823, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5191},
        {24823}
    },
    {
        5192,
        {24832, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5192},
        {24832}
    },
    {
        5193,
        {24820, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5193},
        {24820}
    },
    {
        5194,
        {24826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5194},
        {24826}
    },
    {
        5195,
        {24835, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5195},
        {24835}
    },
    {
        5196,
        {24865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5196},
        {24865}
    },
    {
        5197,
        {24827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5197},
        {24827}
    },
    {
        5198,
        {24817, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5198},
        {24817}
    },
    {
        5199,
        {24845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5199},
        {24845}
    },
    {
        5200,
        {24846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5200},
        {24846}
    },
    {
        5201,
        {24903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5201},
        {24903}
    },
    {
        5202,
        {24894, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5202},
        {24894}
    },
    {
        5203,
        {24872, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5203},
        {24872}
    },
    {
        5204,
        {24871, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5204},
        {24871}
    },
    {
        5205,
        {24906, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5205},
        {24906}
    },
    {
        5206,
        {24895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5206},
        {24895}
    },
    {
        5207,
        {24892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5207},
        {24892}
    },
    {
        5208,
        {24876, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5208},
        {24876}
    },
    {
        5209,
        {24884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5209},
        {24884}
    },
    {
        5210,
        {24893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5210},
        {24893}
    },
    {
        5211,
        {24898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5211},
        {24898}
    },
    {
        5212,
        {24900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5212},
        {24900}
    },
    {
        5213,
        {24947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5213},
        {24947}
    },
    {
        5214,
        {24951, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5214},
        {24951}
    },
    {
        5215,
        {24920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5215},
        {24920}
    },
    {
        5216,
        {24921, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5216},
        {24921}
    },
    {
        5217,
        {24922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5217},
        {24922}
    },
    {
        5218,
        {24939, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5218},
        {24939}
    },
    {
        5219,
        {24948, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5219},
        {24948}
    },
    {
        5220,
        {24943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5220},
        {24943}
    },
    {
        5221,
        {24933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5221},
        {24933}
    },
    {
        5222,
        {24945, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5222},
        {24945}
    },
    {
        5223,
        {24927, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5223},
        {24927}
    },
    {
        5224,
        {24925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5224},
        {24925}
    },
    {
        5225,
        {24915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5225},
        {24915}
    },
    {
        5226,
        {24949, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5226},
        {24949}
    },
    {
        5227,
        {24985, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5227},
        {24985}
    },
    {
        5228,
        {24982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5228},
        {24982}
    },
    {
        5229,
        {24967, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5229},
        {24967}
    },
    {
        5230,
        {25004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5230},
        {25004}
    },
    {
        5231,
        {24980, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5231},
        {24980}
    },
    {
        5232,
        {24986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5232},
        {24986}
    },
    {
        5233,
        {24970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5233},
        {24970}
    },
    {
        5234,
        {24977, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5234},
        {24977}
    },
    {
        5235,
        {25003, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5235},
        {25003}
    },
    {
        5236,
        {25006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5236},
        {25006}
    },
    {
        5237,
        {25036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5237},
        {25036}
    },
    {
        5238,
        {25034, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5238},
        {25034}
    },
    {
        5239,
        {25033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5239},
        {25033}
    },
    {
        5240,
        {25079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5240},
        {25079}
    },
    {
        5241,
        {25032, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5241},
        {25032}
    },
    {
        5242,
        {25027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5242},
        {25027}
    },
    {
        5243,
        {25030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5243},
        {25030}
    },
    {
        5244,
        {25018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5244},
        {25018}
    },
    {
        5245,
        {25035, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5245},
        {25035}
    },
    {
        5246,
        {32633, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5246},
        {32633}
    },
    {
        5247,
        {25037, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5247},
        {25037}
    },
    {
        5248,
        {25062, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5248},
        {25062}
    },
    {
        5249,
        {25059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5249},
        {25059}
    },
    {
        5250,
        {25078, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5250},
        {25078}
    },
    {
        5251,
        {25082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5251},
        {25082}
    },
    {
        5252,
        {25076, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5252},
        {25076}
    },
    {
        5253,
        {25087, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5253},
        {25087}
    },
    {
        5254,
        {25085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5254},
        {25085}
    },
    {
        5255,
        {25084, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5255},
        {25084}
    },
    {
        5256,
        {25086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5256},
        {25086}
    },
    {
        5257,
        {25088, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5257},
        {25088}
    },
    {
        5258,
        {25096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5258},
        {25096}
    },
    {
        5259,
        {25097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5259},
        {25097}
    },
    {
        5260,
        {25101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5260},
        {25101}
    },
    {
        5261,
        {25100, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5261},
        {25100}
    },
    {
        5262,
        {25108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5262},
        {25108}
    },
    {
        5263,
        {25115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5263},
        {25115}
    },
    {
        5264,
        {25118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5264},
        {25118}
    },
    {
        5265,
        {25121, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5265},
        {25121}
    },
    {
        5266,
        {25130, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5266},
        {25130}
    },
    {
        5267,
        {25134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5267},
        {25134}
    },
    {
        5268,
        {25136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5268},
        {25136}
    },
    {
        5269,
        {25138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5269},
        {25138}
    },
    {
        5270,
        {25139, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5270},
        {25139}
    },
    {
        5271,
        {25153, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5271},
        {25153}
    },
    {
        5272,
        {25166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5272},
        {25166}
    },
    {
        5273,
        {25182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5273},
        {25182}
    },
    {
        5274,
        {25187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5274},
        {25187}
    },
    {
        5275,
        {25179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5275},
        {25179}
    },
    {
        5276,
        {25184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5276},
        {25184}
    },
    {
        5277,
        {25192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5277},
        {25192}
    },
    {
        5278,
        {25212, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5278},
        {25212}
    },
    {
        5279,
        {25218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5279},
        {25218}
    },
    {
        5280,
        {25225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5280},
        {25225}
    },
    {
        5281,
        {25214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5281},
        {25214}
    },
    {
        5282,
        {25234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5282},
        {25234}
    },
    {
        5283,
        {25235, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5283},
        {25235}
    },
    {
        5284,
        {25238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5284},
        {25238}
    },
    {
        5285,
        {25300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5285},
        {25300}
    },
    {
        5286,
        {25219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5286},
        {25219}
    },
    {
        5287,
        {25236, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5287},
        {25236}
    },
    {
        5288,
        {25303, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5288},
        {25303}
    },
    {
        5289,
        {25297, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5289},
        {25297}
    },
    {
        5290,
        {25275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5290},
        {25275}
    },
    {
        5291,
        {25295, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5291},
        {25295}
    },
    {
        5292,
        {25343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5292},
        {25343}
    },
    {
        5293,
        {25286, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5293},
        {25286}
    },
    {
        5294,
        {25812, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5294},
        {25812}
    },
    {
        5295,
        {25288, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5295},
        {25288}
    },
    {
        5296,
        {25308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5296},
        {25308}
    },
    {
        5297,
        {25292, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5297},
        {25292}
    },
    {
        5298,
        {25290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5298},
        {25290}
    },
    {
        5299,
        {25282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5299},
        {25282}
    },
    {
        5300,
        {25287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5300},
        {25287}
    },
    {
        5301,
        {25243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5301},
        {25243}
    },
    {
        5302,
        {25289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5302},
        {25289}
    },
    {
        5303,
        {25356, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5303},
        {25356}
    },
    {
        5304,
        {25326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5304},
        {25326}
    },
    {
        5305,
        {25329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5305},
        {25329}
    },
    {
        5306,
        {25383, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5306},
        {25383}
    },
    {
        5307,
        {25346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5307},
        {25346}
    },
    {
        5308,
        {25352, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5308},
        {25352}
    },
    {
        5309,
        {25327, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5309},
        {25327}
    },
    {
        5310,
        {25333, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5310},
        {25333}
    },
    {
        5311,
        {25424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5311},
        {25424}
    },
    {
        5312,
        {25406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5312},
        {25406}
    },
    {
        5313,
        {25421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5313},
        {25421}
    },
    {
        5314,
        {25628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5314},
        {25628}
    },
    {
        5315,
        {25423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5315},
        {25423}
    },
    {
        5316,
        {25494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5316},
        {25494}
    },
    {
        5317,
        {25486, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5317},
        {25486}
    },
    {
        5318,
        {25472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5318},
        {25472}
    },
    {
        5319,
        {25515, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5319},
        {25515}
    },
    {
        5320,
        {25462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5320},
        {25462}
    },
    {
        5321,
        {25507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5321},
        {25507}
    },
    {
        5322,
        {25487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5322},
        {25487}
    },
    {
        5323,
        {25481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5323},
        {25481}
    },
    {
        5324,
        {25503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5324},
        {25503}
    },
    {
        5325,
        {25525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5325},
        {25525}
    },
    {
        5326,
        {25451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5326},
        {25451}
    },
    {
        5327,
        {25449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5327},
        {25449}
    },
    {
        5328,
        {25534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5328},
        {25534}
    },
    {
        5329,
        {25577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5329},
        {25577}
    },
    {
        5330,
        {25536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5330},
        {25536}
    },
    {
        5331,
        {25542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5331},
        {25542}
    },
    {
        5332,
        {25571, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5332},
        {25571}
    },
    {
        5333,
        {25545, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5333},
        {25545}
    },
    {
        5334,
        {25554, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5334},
        {25554}
    },
    {
        5335,
        {25590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5335},
        {25590}
    },
    {
        5336,
        {25540, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5336},
        {25540}
    },
    {
        5337,
        {25622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5337},
        {25622}
    },
    {
        5338,
        {25652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5338},
        {25652}
    },
    {
        5339,
        {25606, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5339},
        {25606}
    },
    {
        5340,
        {25619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5340},
        {25619}
    },
    {
        5341,
        {25638, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5341},
        {25638}
    },
    {
        5342,
        {25654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5342},
        {25654}
    },
    {
        5343,
        {25885, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5343},
        {25885}
    },
    {
        5344,
        {25623, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5344},
        {25623}
    },
    {
        5345,
        {25640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5345},
        {25640}
    },
    {
        5346,
        {25615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5346},
        {25615}
    },
    {
        5347,
        {25703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5347},
        {25703}
    },
    {
        5348,
        {25711, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5348},
        {25711}
    },
    {
        5349,
        {25718, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5349},
        {25718}
    },
    {
        5350,
        {25678, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5350},
        {25678}
    },
    {
        5351,
        {25898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5351},
        {25898}
    },
    {
        5352,
        {25749, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5352},
        {25749}
    },
    {
        5353,
        {25747, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5353},
        {25747}
    },
    {
        5354,
        {25765, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5354},
        {25765}
    },
    {
        5355,
        {25769, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5355},
        {25769}
    },
    {
        5356,
        {25736, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5356},
        {25736}
    },
    {
        5357,
        {25788, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5357},
        {25788}
    },
    {
        5358,
        {25818, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5358},
        {25818}
    },
    {
        5359,
        {25810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5359},
        {25810}
    },
    {
        5360,
        {25797, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5360},
        {25797}
    },
    {
        5361,
        {25799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5361},
        {25799}
    },
    {
        5362,
        {25787, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5362},
        {25787}
    },
    {
        5363,
        {25816, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5363},
        {25816}
    },
    {
        5364,
        {25794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5364},
        {25794}
    },
    {
        5365,
        {25841, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5365},
        {25841}
    },
    {
        5366,
        {25831, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5366},
        {25831}
    },
    {
        5367,
        {33289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5367},
        {33289}
    },
    {
        5368,
        {25824, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5368},
        {25824}
    },
    {
        5369,
        {25825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5369},
        {25825}
    },
    {
        5370,
        {25260, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5370},
        {25260}
    },
    {
        5371,
        {25827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5371},
        {25827}
    },
    {
        5372,
        {25839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5372},
        {25839}
    },
    {
        5373,
        {25900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5373},
        {25900}
    },
    {
        5374,
        {25846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5374},
        {25846}
    },
    {
        5375,
        {25844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5375},
        {25844}
    },
    {
        5376,
        {25842, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5376},
        {25842}
    },
    {
        5377,
        {25850, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5377},
        {25850}
    },
    {
        5378,
        {25856, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5378},
        {25856}
    },
    {
        5379,
        {25853, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5379},
        {25853}
    },
    {
        5380,
        {25880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5380},
        {25880}
    },
    {
        5381,
        {25884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5381},
        {25884}
    },
    {
        5382,
        {25861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5382},
        {25861}
    },
    {
        5383,
        {25892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5383},
        {25892}
    },
    {
        5384,
        {25891, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5384},
        {25891}
    },
    {
        5385,
        {25899, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5385},
        {25899}
    },
    {
        5386,
        {25908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5386},
        {25908}
    },
    {
        5387,
        {25909, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5387},
        {25909}
    },
    {
        5388,
        {25911, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5388},
        {25911}
    },
    {
        5389,
        {25910, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5389},
        {25910}
    },
    {
        5390,
        {25912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5390},
        {25912}
    },
    {
        5391,
        {30027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5391},
        {30027}
    },
    {
        5392,
        {25928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5392},
        {25928}
    },
    {
        5393,
        {25942, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5393},
        {25942}
    },
    {
        5394,
        {25941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5394},
        {25941}
    },
    {
        5395,
        {25933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5395},
        {25933}
    },
    {
        5396,
        {25944, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5396},
        {25944}
    },
    {
        5397,
        {25950, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5397},
        {25950}
    },
    {
        5398,
        {25949, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5398},
        {25949}
    },
    {
        5399,
        {25970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5399},
        {25970}
    },
    {
        5400,
        {25976, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5400},
        {25976}
    },
    {
        5401,
        {25986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5401},
        {25986}
    },
    {
        5402,
        {25987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5402},
        {25987}
    },
    {
        5403,
        {35722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5403},
        {35722}
    },
    {
        5404,
        {26011, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5404},
        {26011}
    },
    {
        5405,
        {26015, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5405},
        {26015}
    },
    {
        5406,
        {26027, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5406},
        {26027}
    },
    {
        5407,
        {26039, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5407},
        {26039}
    },
    {
        5408,
        {26051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5408},
        {26051}
    },
    {
        5409,
        {26054, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5409},
        {26054}
    },
    {
        5410,
        {26049, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5410},
        {26049}
    },
    {
        5411,
        {26052, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5411},
        {26052}
    },
    {
        5412,
        {26060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5412},
        {26060}
    },
    {
        5413,
        {26066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5413},
        {26066}
    },
    {
        5414,
        {26075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5414},
        {26075}
    },
    {
        5415,
        {26073, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5415},
        {26073}
    },
    {
        5416,
        {26080, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5416},
        {26080}
    },
    {
        5417,
        {26081, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5417},
        {26081}
    },
    {
        5418,
        {26097, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5418},
        {26097}
    },
    {
        5419,
        {26482, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5419},
        {26482}
    },
    {
        5420,
        {26122, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5420},
        {26122}
    },
    {
        5421,
        {26115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5421},
        {26115}
    },
    {
        5422,
        {26107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5422},
        {26107}
    },
    {
        5423,
        {26483, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5423},
        {26483}
    },
    {
        5424,
        {26165, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5424},
        {26165}
    },
    {
        5425,
        {26166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5425},
        {26166}
    },
    {
        5426,
        {26164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5426},
        {26164}
    },
    {
        5427,
        {26140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5427},
        {26140}
    },
    {
        5428,
        {26191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5428},
        {26191}
    },
    {
        5429,
        {26180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5429},
        {26180}
    },
    {
        5430,
        {26185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5430},
        {26185}
    },
    {
        5431,
        {26177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5431},
        {26177}
    },
    {
        5432,
        {26206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5432},
        {26206}
    },
    {
        5433,
        {26205, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5433},
        {26205}
    },
    {
        5434,
        {26212, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5434},
        {26212}
    },
    {
        5435,
        {26215, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5435},
        {26215}
    },
    {
        5436,
        {26216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5436},
        {26216}
    },
    {
        5437,
        {26207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5437},
        {26207}
    },
    {
        5438,
        {26210, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5438},
        {26210}
    },
    {
        5439,
        {26224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5439},
        {26224}
    },
    {
        5440,
        {26243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5440},
        {26243}
    },
    {
        5441,
        {26248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5441},
        {26248}
    },
    {
        5442,
        {26254, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5442},
        {26254}
    },
    {
        5443,
        {26249, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5443},
        {26249}
    },
    {
        5444,
        {26244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5444},
        {26244}
    },
    {
        5445,
        {26264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5445},
        {26264}
    },
    {
        5446,
        {26269, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5446},
        {26269}
    },
    {
        5447,
        {26305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5447},
        {26305}
    },
    {
        5448,
        {26297, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5448},
        {26297}
    },
    {
        5449,
        {26313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5449},
        {26313}
    },
    {
        5450,
        {26302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5450},
        {26302}
    },
    {
        5451,
        {26300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5451},
        {26300}
    },
    {
        5452,
        {26308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5452},
        {26308}
    },
    {
        5453,
        {26296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5453},
        {26296}
    },
    {
        5454,
        {26326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5454},
        {26326}
    },
    {
        5455,
        {26330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5455},
        {26330}
    },
    {
        5456,
        {26336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5456},
        {26336}
    },
    {
        5457,
        {26175, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5457},
        {26175}
    },
    {
        5458,
        {26342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5458},
        {26342}
    },
    {
        5459,
        {26345, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5459},
        {26345}
    },
    {
        5460,
        {26352, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5460},
        {26352}
    },
    {
        5461,
        {26357, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5461},
        {26357}
    },
    {
        5462,
        {26359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5462},
        {26359}
    },
    {
        5463,
        {26383, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5463},
        {26383}
    },
    {
        5464,
        {26390, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5464},
        {26390}
    },
    {
        5465,
        {26398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5465},
        {26398}
    },
    {
        5466,
        {26406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5466},
        {26406}
    },
    {
        5467,
        {26407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5467},
        {26407}
    },
    {
        5468,
        {38712, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5468},
        {38712}
    },
    {
        5469,
        {26414, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5469},
        {26414}
    },
    {
        5470,
        {26431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5470},
        {26431}
    },
    {
        5471,
        {26422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5471},
        {26422}
    },
    {
        5472,
        {26433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5472},
        {26433}
    },
    {
        5473,
        {26424, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5473},
        {26424}
    },
    {
        5474,
        {26423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5474},
        {26423}
    },
    {
        5475,
        {26438, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5475},
        {26438}
    },
    {
        5476,
        {26462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5476},
        {26462}
    },
    {
        5477,
        {26464, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5477},
        {26464}
    },
    {
        5478,
        {26457, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5478},
        {26457}
    },
    {
        5479,
        {26467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5479},
        {26467}
    },
    {
        5480,
        {26468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5480},
        {26468}
    },
    {
        5481,
        {26505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5481},
        {26505}
    },
    {
        5482,
        {26480, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5482},
        {26480}
    },
    {
        5483,
        {26537, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5483},
        {26537}
    },
    {
        5484,
        {26492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5484},
        {26492}
    },
    {
        5485,
        {26474, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5485},
        {26474}
    },
    {
        5486,
        {26508, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5486},
        {26508}
    },
    {
        5487,
        {26507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5487},
        {26507}
    },
    {
        5488,
        {26534, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5488},
        {26534}
    },
    {
        5489,
        {26529, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5489},
        {26529}
    },
    {
        5490,
        {26501, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5490},
        {26501}
    },
    {
        5491,
        {26551, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5491},
        {26551}
    },
    {
        5492,
        {26607, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5492},
        {26607}
    },
    {
        5493,
        {26548, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5493},
        {26548}
    },
    {
        5494,
        {26604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5494},
        {26604}
    },
    {
        5495,
        {26547, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5495},
        {26547}
    },
    {
        5496,
        {26601, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5496},
        {26601}
    },
    {
        5497,
        {26552, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5497},
        {26552}
    },
    {
        5498,
        {26596, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5498},
        {26596}
    },
    {
        5499,
        {26590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5499},
        {26590}
    },
    {
        5500,
        {26589, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5500},
        {26589}
    },
    {
        5501,
        {26594, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5501},
        {26594}
    },
    {
        5502,
        {26606, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5502},
        {26606}
    },
    {
        5503,
        {26553, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5503},
        {26553}
    },
    {
        5504,
        {26574, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5504},
        {26574}
    },
    {
        5505,
        {26566, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5505},
        {26566}
    },
    {
        5506,
        {26599, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5506},
        {26599}
    },
    {
        5507,
        {27292, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5507},
        {27292}
    },
    {
        5508,
        {26654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5508},
        {26654}
    },
    {
        5509,
        {26694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5509},
        {26694}
    },
    {
        5510,
        {26665, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5510},
        {26665}
    },
    {
        5511,
        {26688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5511},
        {26688}
    },
    {
        5512,
        {26701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5512},
        {26701}
    },
    {
        5513,
        {26674, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5513},
        {26674}
    },
    {
        5514,
        {26702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5514},
        {26702}
    },
    {
        5515,
        {26803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5515},
        {26803}
    },
    {
        5516,
        {26667, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5516},
        {26667}
    },
    {
        5517,
        {26713, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5517},
        {26713}
    },
    {
        5518,
        {26723, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5518},
        {26723}
    },
    {
        5519,
        {26743, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5519},
        {26743}
    },
    {
        5520,
        {26751, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5520},
        {26751}
    },
    {
        5521,
        {26783, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5521},
        {26783}
    },
    {
        5522,
        {26767, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5522},
        {26767}
    },
    {
        5523,
        {26797, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5523},
        {26797}
    },
    {
        5524,
        {26772, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5524},
        {26772}
    },
    {
        5525,
        {26781, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5525},
        {26781}
    },
    {
        5526,
        {26779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5526},
        {26779}
    },
    {
        5527,
        {26755, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5527},
        {26755}
    },
    {
        5528,
        {27310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5528},
        {27310}
    },
    {
        5529,
        {26809, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5529},
        {26809}
    },
    {
        5530,
        {26740, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5530},
        {26740}
    },
    {
        5531,
        {26805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5531},
        {26805}
    },
    {
        5532,
        {26784, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5532},
        {26784}
    },
    {
        5533,
        {26810, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5533},
        {26810}
    },
    {
        5534,
        {26895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5534},
        {26895}
    },
    {
        5535,
        {26765, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5535},
        {26765}
    },
    {
        5536,
        {26750, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5536},
        {26750}
    },
    {
        5537,
        {26881, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5537},
        {26881}
    },
    {
        5538,
        {26826, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5538},
        {26826}
    },
    {
        5539,
        {26888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5539},
        {26888}
    },
    {
        5540,
        {26840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5540},
        {26840}
    },
    {
        5541,
        {26914, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5541},
        {26914}
    },
    {
        5542,
        {26918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5542},
        {26918}
    },
    {
        5543,
        {26849, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5543},
        {26849}
    },
    {
        5544,
        {26892, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5544},
        {26892}
    },
    {
        5545,
        {26829, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5545},
        {26829}
    },
    {
        5546,
        {26836, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5546},
        {26836}
    },
    {
        5547,
        {26855, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5547},
        {26855}
    },
    {
        5548,
        {26837, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5548},
        {26837}
    },
    {
        5549,
        {26934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5549},
        {26934}
    },
    {
        5550,
        {26898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5550},
        {26898}
    },
    {
        5551,
        {26884, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5551},
        {26884}
    },
    {
        5552,
        {26839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5552},
        {26839}
    },
    {
        5553,
        {26851, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5553},
        {26851}
    },
    {
        5554,
        {26917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5554},
        {26917}
    },
    {
        5555,
        {26873, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5555},
        {26873}
    },
    {
        5556,
        {26848, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5556},
        {26848}
    },
    {
        5557,
        {26863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5557},
        {26863}
    },
    {
        5558,
        {26920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5558},
        {26920}
    },
    {
        5559,
        {26922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5559},
        {26922}
    },
    {
        5560,
        {26906, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5560},
        {26906}
    },
    {
        5561,
        {26915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5561},
        {26915}
    },
    {
        5562,
        {26913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5562},
        {26913}
    },
    {
        5563,
        {26822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5563},
        {26822}
    },
    {
        5564,
        {27001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5564},
        {27001}
    },
    {
        5565,
        {26999, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5565},
        {26999}
    },
    {
        5566,
        {26972, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5566},
        {26972}
    },
    {
        5567,
        {27000, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5567},
        {27000}
    },
    {
        5568,
        {26987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5568},
        {26987}
    },
    {
        5569,
        {26964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5569},
        {26964}
    },
    {
        5570,
        {27006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5570},
        {27006}
    },
    {
        5571,
        {26990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5571},
        {26990}
    },
    {
        5572,
        {26937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5572},
        {26937}
    },
    {
        5573,
        {26996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5573},
        {26996}
    },
    {
        5574,
        {26941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5574},
        {26941}
    },
    {
        5575,
        {26969, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5575},
        {26969}
    },
    {
        5576,
        {26928, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5576},
        {26928}
    },
    {
        5577,
        {26977, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5577},
        {26977}
    },
    {
        5578,
        {26974, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5578},
        {26974}
    },
    {
        5579,
        {26973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5579},
        {26973}
    },
    {
        5580,
        {27009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5580},
        {27009}
    },
    {
        5581,
        {26986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5581},
        {26986}
    },
    {
        5582,
        {27058, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5582},
        {27058}
    },
    {
        5583,
        {27054, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5583},
        {27054}
    },
    {
        5584,
        {27088, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5584},
        {27088}
    },
    {
        5585,
        {27071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5585},
        {27071}
    },
    {
        5586,
        {27073, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5586},
        {27073}
    },
    {
        5587,
        {27091, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5587},
        {27091}
    },
    {
        5588,
        {27070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5588},
        {27070}
    },
    {
        5589,
        {27086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5589},
        {27086}
    },
    {
        5590,
        {23528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5590},
        {23528}
    },
    {
        5591,
        {27082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5591},
        {27082}
    },
    {
        5592,
        {27101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5592},
        {27101}
    },
    {
        5593,
        {27067, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5593},
        {27067}
    },
    {
        5594,
        {27075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5594},
        {27075}
    },
    {
        5595,
        {27047, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5595},
        {27047}
    },
    {
        5596,
        {27182, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5596},
        {27182}
    },
    {
        5597,
        {27025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5597},
        {27025}
    },
    {
        5598,
        {27040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5598},
        {27040}
    },
    {
        5599,
        {27036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5599},
        {27036}
    },
    {
        5600,
        {27029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5600},
        {27029}
    },
    {
        5601,
        {27060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5601},
        {27060}
    },
    {
        5602,
        {27102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5602},
        {27102}
    },
    {
        5603,
        {27112, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5603},
        {27112}
    },
    {
        5604,
        {27138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5604},
        {27138}
    },
    {
        5605,
        {27163, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5605},
        {27163}
    },
    {
        5606,
        {27135, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5606},
        {27135}
    },
    {
        5607,
        {27402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5607},
        {27402}
    },
    {
        5608,
        {27129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5608},
        {27129}
    },
    {
        5609,
        {27122, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5609},
        {27122}
    },
    {
        5610,
        {27111, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5610},
        {27111}
    },
    {
        5611,
        {27141, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5611},
        {27141}
    },
    {
        5612,
        {27057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5612},
        {27057}
    },
    {
        5613,
        {27166, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5613},
        {27166}
    },
    {
        5614,
        {27117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5614},
        {27117}
    },
    {
        5615,
        {27156, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5615},
        {27156}
    },
    {
        5616,
        {27115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5616},
        {27115}
    },
    {
        5617,
        {27146, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5617},
        {27146}
    },
    {
        5618,
        {27154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5618},
        {27154}
    },
    {
        5619,
        {27329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5619},
        {27329}
    },
    {
        5620,
        {27171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5620},
        {27171}
    },
    {
        5621,
        {27155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5621},
        {27155}
    },
    {
        5622,
        {27204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5622},
        {27204}
    },
    {
        5623,
        {27148, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5623},
        {27148}
    },
    {
        5624,
        {27250, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5624},
        {27250}
    },
    {
        5625,
        {27190, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5625},
        {27190}
    },
    {
        5626,
        {27256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5626},
        {27256}
    },
    {
        5627,
        {27207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5627},
        {27207}
    },
    {
        5628,
        {27234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5628},
        {27234}
    },
    {
        5629,
        {27225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5629},
        {27225}
    },
    {
        5630,
        {27238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5630},
        {27238}
    },
    {
        5631,
        {27208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5631},
        {27208}
    },
    {
        5632,
        {27192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5632},
        {27192}
    },
    {
        5633,
        {27170, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5633},
        {27170}
    },
    {
        5634,
        {27280, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5634},
        {27280}
    },
    {
        5635,
        {27277, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5635},
        {27277}
    },
    {
        5636,
        {27296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5636},
        {27296}
    },
    {
        5637,
        {27268, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5637},
        {27268}
    },
    {
        5638,
        {27298, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5638},
        {27298}
    },
    {
        5639,
        {27299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5639},
        {27299}
    },
    {
        5640,
        {27287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5640},
        {27287}
    },
    {
        5641,
        {34327, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5641},
        {34327}
    },
    {
        5642,
        {27323, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5642},
        {27323}
    },
    {
        5643,
        {27331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5643},
        {27331}
    },
    {
        5644,
        {27330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5644},
        {27330}
    },
    {
        5645,
        {27320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5645},
        {27320}
    },
    {
        5646,
        {27315, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5646},
        {27315}
    },
    {
        5647,
        {27308, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5647},
        {27308}
    },
    {
        5648,
        {27358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5648},
        {27358}
    },
    {
        5649,
        {27345, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5649},
        {27345}
    },
    {
        5650,
        {27359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5650},
        {27359}
    },
    {
        5651,
        {27306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5651},
        {27306}
    },
    {
        5652,
        {27354, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5652},
        {27354}
    },
    {
        5653,
        {27370, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5653},
        {27370}
    },
    {
        5654,
        {27387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5654},
        {27387}
    },
    {
        5655,
        {27397, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5655},
        {27397}
    },
    {
        5656,
        {34326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5656},
        {34326}
    },
    {
        5657,
        {27386, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5657},
        {27386}
    },
    {
        5658,
        {27410, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5658},
        {27410}
    },
    {
        5659,
        {27414, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5659},
        {27414}
    },
    {
        5660,
        {39729, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5660},
        {39729}
    },
    {
        5661,
        {27423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5661},
        {27423}
    },
    {
        5662,
        {27448, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5662},
        {27448}
    },
    {
        5663,
        {27447, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5663},
        {27447}
    },
    {
        5664,
        {30428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5664},
        {30428}
    },
    {
        5665,
        {27449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5665},
        {27449}
    },
    {
        5666,
        {39150, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5666},
        {39150}
    },
    {
        5667,
        {27463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5667},
        {27463}
    },
    {
        5668,
        {27459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5668},
        {27459}
    },
    {
        5669,
        {27465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5669},
        {27465}
    },
    {
        5670,
        {27472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5670},
        {27472}
    },
    {
        5671,
        {27481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5671},
        {27481}
    },
    {
        5672,
        {27476, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5672},
        {27476}
    },
    {
        5673,
        {27483, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5673},
        {27483}
    },
    {
        5674,
        {27487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5674},
        {27487}
    },
    {
        5675,
        {27489, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5675},
        {27489}
    },
    {
        5676,
        {27512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5676},
        {27512}
    },
    {
        5677,
        {27513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5677},
        {27513}
    },
    {
        5678,
        {27519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5678},
        {27519}
    },
    {
        5679,
        {27520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5679},
        {27520}
    },
    {
        5680,
        {27524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5680},
        {27524}
    },
    {
        5681,
        {27523, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5681},
        {27523}
    },
    {
        5682,
        {27533, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5682},
        {27533}
    },
    {
        5683,
        {27544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5683},
        {27544}
    },
    {
        5684,
        {27541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5684},
        {27541}
    },
    {
        5685,
        {27550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5685},
        {27550}
    },
    {
        5686,
        {27556, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5686},
        {27556}
    },
    {
        5687,
        {27562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5687},
        {27562}
    },
    {
        5688,
        {27563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5688},
        {27563}
    },
    {
        5689,
        {27567, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5689},
        {27567}
    },
    {
        5690,
        {27570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5690},
        {27570}
    },
    {
        5691,
        {27569, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5691},
        {27569}
    },
    {
        5692,
        {27571, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5692},
        {27571}
    },
    {
        5693,
        {27575, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5693},
        {27575}
    },
    {
        5694,
        {27580, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5694},
        {27580}
    },
    {
        5695,
        {27590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5695},
        {27590}
    },
    {
        5696,
        {27595, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5696},
        {27595}
    },
    {
        5697,
        {27603, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5697},
        {27603}
    },
    {
        5698,
        {27615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5698},
        {27615}
    },
    {
        5699,
        {27628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5699},
        {27628}
    },
    {
        5700,
        {27627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5700},
        {27627}
    },
    {
        5701,
        {27635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5701},
        {27635}
    },
    {
        5702,
        {27631, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5702},
        {27631}
    },
    {
        5703,
        {40638, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5703},
        {40638}
    },
    {
        5704,
        {27656, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5704},
        {27656}
    },
    {
        5705,
        {27667, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5705},
        {27667}
    },
    {
        5706,
        {27668, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5706},
        {27668}
    },
    {
        5707,
        {27675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5707},
        {27675}
    },
    {
        5708,
        {27684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5708},
        {27684}
    },
    {
        5709,
        {27683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5709},
        {27683}
    },
    {
        5710,
        {27742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5710},
        {27742}
    },
    {
        5711,
        {27733, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5711},
        {27733}
    },
    {
        5712,
        {27746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5712},
        {27746}
    },
    {
        5713,
        {27754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5713},
        {27754}
    },
    {
        5714,
        {27778, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5714},
        {27778}
    },
    {
        5715,
        {27789, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5715},
        {27789}
    },
    {
        5716,
        {27802, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5716},
        {27802}
    },
    {
        5717,
        {27777, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5717},
        {27777}
    },
    {
        5718,
        {27803, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5718},
        {27803}
    },
    {
        5719,
        {27774, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5719},
        {27774}
    },
    {
        5720,
        {27752, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5720},
        {27752}
    },
    {
        5721,
        {27763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5721},
        {27763}
    },
    {
        5722,
        {27794, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5722},
        {27794}
    },
    {
        5723,
        {27792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5723},
        {27792}
    },
    {
        5724,
        {27844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5724},
        {27844}
    },
    {
        5725,
        {27889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5725},
        {27889}
    },
    {
        5726,
        {27859, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5726},
        {27859}
    },
    {
        5727,
        {27837, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5727},
        {27837}
    },
    {
        5728,
        {27863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5728},
        {27863}
    },
    {
        5729,
        {27845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5729},
        {27845}
    },
    {
        5730,
        {27869, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5730},
        {27869}
    },
    {
        5731,
        {27822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5731},
        {27822}
    },
    {
        5732,
        {27825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5732},
        {27825}
    },
    {
        5733,
        {27838, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5733},
        {27838}
    },
    {
        5734,
        {27834, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5734},
        {27834}
    },
    {
        5735,
        {27867, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5735},
        {27867}
    },
    {
        5736,
        {27887, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5736},
        {27887}
    },
    {
        5737,
        {27865, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5737},
        {27865}
    },
    {
        5738,
        {27882, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5738},
        {27882}
    },
    {
        5739,
        {27935, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5739},
        {27935}
    },
    {
        5740,
        {34893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5740},
        {34893}
    },
    {
        5741,
        {27958, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5741},
        {27958}
    },
    {
        5742,
        {27947, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5742},
        {27947}
    },
    {
        5743,
        {27965, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5743},
        {27965}
    },
    {
        5744,
        {27960, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5744},
        {27960}
    },
    {
        5745,
        {27929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5745},
        {27929}
    },
    {
        5746,
        {27957, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5746},
        {27957}
    },
    {
        5747,
        {27955, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5747},
        {27955}
    },
    {
        5748,
        {27922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5748},
        {27922}
    },
    {
        5749,
        {27916, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5749},
        {27916}
    },
    {
        5750,
        {28003, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5750},
        {28003}
    },
    {
        5751,
        {28051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5751},
        {28051}
    },
    {
        5752,
        {28004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5752},
        {28004}
    },
    {
        5753,
        {27994, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5753},
        {27994}
    },
    {
        5754,
        {28025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5754},
        {28025}
    },
    {
        5755,
        {27993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5755},
        {27993}
    },
    {
        5756,
        {28046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5756},
        {28046}
    },
    {
        5757,
        {28053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5757},
        {28053}
    },
    {
        5758,
        {28644, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5758},
        {28644}
    },
    {
        5759,
        {28037, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5759},
        {28037}
    },
    {
        5760,
        {28153, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5760},
        {28153}
    },
    {
        5761,
        {28181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5761},
        {28181}
    },
    {
        5762,
        {28170, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5762},
        {28170}
    },
    {
        5763,
        {28085, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5763},
        {28085}
    },
    {
        5764,
        {28103, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5764},
        {28103}
    },
    {
        5765,
        {28134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5765},
        {28134}
    },
    {
        5766,
        {28088, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5766},
        {28088}
    },
    {
        5767,
        {28102, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5767},
        {28102}
    },
    {
        5768,
        {28140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5768},
        {28140}
    },
    {
        5769,
        {28126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5769},
        {28126}
    },
    {
        5770,
        {28108, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5770},
        {28108}
    },
    {
        5771,
        {28136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5771},
        {28136}
    },
    {
        5772,
        {28114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5772},
        {28114}
    },
    {
        5773,
        {28101, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5773},
        {28101}
    },
    {
        5774,
        {28154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5774},
        {28154}
    },
    {
        5775,
        {28121, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5775},
        {28121}
    },
    {
        5776,
        {28132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5776},
        {28132}
    },
    {
        5777,
        {28117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5777},
        {28117}
    },
    {
        5778,
        {28138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5778},
        {28138}
    },
    {
        5779,
        {28142, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5779},
        {28142}
    },
    {
        5780,
        {28205, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5780},
        {28205}
    },
    {
        5781,
        {28270, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5781},
        {28270}
    },
    {
        5782,
        {28206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5782},
        {28206}
    },
    {
        5783,
        {28185, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5783},
        {28185}
    },
    {
        5784,
        {28274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5784},
        {28274}
    },
    {
        5785,
        {28255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5785},
        {28255}
    },
    {
        5786,
        {28222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5786},
        {28222}
    },
    {
        5787,
        {28195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5787},
        {28195}
    },
    {
        5788,
        {28267, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5788},
        {28267}
    },
    {
        5789,
        {28203, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5789},
        {28203}
    },
    {
        5790,
        {28278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5790},
        {28278}
    },
    {
        5791,
        {28237, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5791},
        {28237}
    },
    {
        5792,
        {28191, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5792},
        {28191}
    },
    {
        5793,
        {28227, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5793},
        {28227}
    },
    {
        5794,
        {28218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5794},
        {28218}
    },
    {
        5795,
        {28238, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5795},
        {28238}
    },
    {
        5796,
        {28196, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5796},
        {28196}
    },
    {
        5797,
        {28415, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5797},
        {28415}
    },
    {
        5798,
        {28189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5798},
        {28189}
    },
    {
        5799,
        {28216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5799},
        {28216}
    },
    {
        5800,
        {28290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5800},
        {28290}
    },
    {
        5801,
        {28330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5801},
        {28330}
    },
    {
        5802,
        {28312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5802},
        {28312}
    },
    {
        5803,
        {28361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5803},
        {28361}
    },
    {
        5804,
        {28343, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5804},
        {28343}
    },
    {
        5805,
        {28371, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5805},
        {28371}
    },
    {
        5806,
        {28349, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5806},
        {28349}
    },
    {
        5807,
        {28335, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5807},
        {28335}
    },
    {
        5808,
        {28356, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5808},
        {28356}
    },
    {
        5809,
        {28338, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5809},
        {28338}
    },
    {
        5810,
        {28372, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5810},
        {28372}
    },
    {
        5811,
        {28373, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5811},
        {28373}
    },
    {
        5812,
        {28303, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5812},
        {28303}
    },
    {
        5813,
        {28325, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5813},
        {28325}
    },
    {
        5814,
        {28354, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5814},
        {28354}
    },
    {
        5815,
        {28319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5815},
        {28319}
    },
    {
        5816,
        {28481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5816},
        {28481}
    },
    {
        5817,
        {28433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5817},
        {28433}
    },
    {
        5818,
        {28748, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5818},
        {28748}
    },
    {
        5819,
        {28396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5819},
        {28396}
    },
    {
        5820,
        {28408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5820},
        {28408}
    },
    {
        5821,
        {28414, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5821},
        {28414}
    },
    {
        5822,
        {28479, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5822},
        {28479}
    },
    {
        5823,
        {28402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5823},
        {28402}
    },
    {
        5824,
        {28465, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5824},
        {28465}
    },
    {
        5825,
        {28399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5825},
        {28399}
    },
    {
        5826,
        {28466, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5826},
        {28466}
    },
    {
        5827,
        {28364, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5827},
        {28364}
    },
    {
        5828,
        {28478, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5828},
        {28478}
    },
    {
        5829,
        {28435, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5829},
        {28435}
    },
    {
        5830,
        {28407, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5830},
        {28407}
    },
    {
        5831,
        {28550, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5831},
        {28550}
    },
    {
        5832,
        {28538, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5832},
        {28538}
    },
    {
        5833,
        {28536, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5833},
        {28536}
    },
    {
        5834,
        {28545, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5834},
        {28545}
    },
    {
        5835,
        {28544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5835},
        {28544}
    },
    {
        5836,
        {28527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5836},
        {28527}
    },
    {
        5837,
        {28507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5837},
        {28507}
    },
    {
        5838,
        {28659, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5838},
        {28659}
    },
    {
        5839,
        {28525, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5839},
        {28525}
    },
    {
        5840,
        {28546, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5840},
        {28546}
    },
    {
        5841,
        {28540, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5841},
        {28540}
    },
    {
        5842,
        {28504, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5842},
        {28504}
    },
    {
        5843,
        {28558, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5843},
        {28558}
    },
    {
        5844,
        {28561, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5844},
        {28561}
    },
    {
        5845,
        {28610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5845},
        {28610}
    },
    {
        5846,
        {28518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5846},
        {28518}
    },
    {
        5847,
        {28595, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5847},
        {28595}
    },
    {
        5848,
        {28579, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5848},
        {28579}
    },
    {
        5849,
        {28577, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5849},
        {28577}
    },
    {
        5850,
        {28580, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5850},
        {28580}
    },
    {
        5851,
        {28601, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5851},
        {28601}
    },
    {
        5852,
        {28614, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5852},
        {28614}
    },
    {
        5853,
        {28586, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5853},
        {28586}
    },
    {
        5854,
        {28639, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5854},
        {28639}
    },
    {
        5855,
        {28629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5855},
        {28629}
    },
    {
        5856,
        {28652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5856},
        {28652}
    },
    {
        5857,
        {28628, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5857},
        {28628}
    },
    {
        5858,
        {28632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5858},
        {28632}
    },
    {
        5859,
        {28657, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5859},
        {28657}
    },
    {
        5860,
        {28654, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5860},
        {28654}
    },
    {
        5861,
        {28635, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5861},
        {28635}
    },
    {
        5862,
        {28681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5862},
        {28681}
    },
    {
        5863,
        {28683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5863},
        {28683}
    },
    {
        5864,
        {28666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5864},
        {28666}
    },
    {
        5865,
        {28689, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5865},
        {28689}
    },
    {
        5866,
        {28673, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5866},
        {28673}
    },
    {
        5867,
        {28687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5867},
        {28687}
    },
    {
        5868,
        {28670, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5868},
        {28670}
    },
    {
        5869,
        {28699, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5869},
        {28699}
    },
    {
        5870,
        {28698, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5870},
        {28698}
    },
    {
        5871,
        {28532, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5871},
        {28532}
    },
    {
        5872,
        {28701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5872},
        {28701}
    },
    {
        5873,
        {28696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5873},
        {28696}
    },
    {
        5874,
        {28703, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5874},
        {28703}
    },
    {
        5875,
        {28720, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5875},
        {28720}
    },
    {
        5876,
        {28734, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5876},
        {28734}
    },
    {
        5877,
        {28722, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5877},
        {28722}
    },
    {
        5878,
        {28753, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5878},
        {28753}
    },
    {
        5879,
        {28771, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5879},
        {28771}
    },
    {
        5880,
        {28825, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5880},
        {28825}
    },
    {
        5881,
        {28818, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5881},
        {28818}
    },
    {
        5882,
        {28847, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5882},
        {28847}
    },
    {
        5883,
        {28913, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5883},
        {28913}
    },
    {
        5884,
        {28844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5884},
        {28844}
    },
    {
        5885,
        {28856, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5885},
        {28856}
    },
    {
        5886,
        {28851, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5886},
        {28851}
    },
    {
        5887,
        {28846, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5887},
        {28846}
    },
    {
        5888,
        {28895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5888},
        {28895}
    },
    {
        5889,
        {28875, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5889},
        {28875}
    },
    {
        5890,
        {28893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5890},
        {28893}
    },
    {
        5891,
        {28889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5891},
        {28889}
    },
    {
        5892,
        {28937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5892},
        {28937}
    },
    {
        5893,
        {28925, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5893},
        {28925}
    },
    {
        5894,
        {28956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5894},
        {28956}
    },
    {
        5895,
        {28953, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5895},
        {28953}
    },
    {
        5896,
        {29029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5896},
        {29029}
    },
    {
        5897,
        {29013, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5897},
        {29013}
    },
    {
        5898,
        {29064, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5898},
        {29064}
    },
    {
        5899,
        {29030, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5899},
        {29030}
    },
    {
        5900,
        {29026, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5900},
        {29026}
    },
    {
        5901,
        {29004, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5901},
        {29004}
    },
    {
        5902,
        {29014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5902},
        {29014}
    },
    {
        5903,
        {29036, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5903},
        {29036}
    },
    {
        5904,
        {29071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5904},
        {29071}
    },
    {
        5905,
        {29179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5905},
        {29179}
    },
    {
        5906,
        {29060, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5906},
        {29060}
    },
    {
        5907,
        {29077, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5907},
        {29077}
    },
    {
        5908,
        {29096, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5908},
        {29096}
    },
    {
        5909,
        {29100, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5909},
        {29100}
    },
    {
        5910,
        {29143, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5910},
        {29143}
    },
    {
        5911,
        {29113, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5911},
        {29113}
    },
    {
        5912,
        {29118, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5912},
        {29118}
    },
    {
        5913,
        {29138, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5913},
        {29138}
    },
    {
        5914,
        {29129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5914},
        {29129}
    },
    {
        5915,
        {29140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5915},
        {29140}
    },
    {
        5916,
        {29134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5916},
        {29134}
    },
    {
        5917,
        {29152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5917},
        {29152}
    },
    {
        5918,
        {29164, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5918},
        {29164}
    },
    {
        5919,
        {29159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5919},
        {29159}
    },
    {
        5920,
        {29173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5920},
        {29173}
    },
    {
        5921,
        {29180, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5921},
        {29180}
    },
    {
        5922,
        {29177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5922},
        {29177}
    },
    {
        5923,
        {29183, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5923},
        {29183}
    },
    {
        5924,
        {29197, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5924},
        {29197}
    },
    {
        5925,
        {29200, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5925},
        {29200}
    },
    {
        5926,
        {29211, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5926},
        {29211}
    },
    {
        5927,
        {29224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5927},
        {29224}
    },
    {
        5928,
        {29229, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5928},
        {29229}
    },
    {
        5929,
        {29228, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5929},
        {29228}
    },
    {
        5930,
        {29232, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5930},
        {29232}
    },
    {
        5931,
        {29234, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5931},
        {29234}
    },
    {
        5932,
        {29243, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5932},
        {29243}
    },
    {
        5933,
        {29244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5933},
        {29244}
    },
    {
        5934,
        {29247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5934},
        {29247}
    },
    {
        5935,
        {29248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5935},
        {29248}
    },
    {
        5936,
        {29254, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5936},
        {29254}
    },
    {
        5937,
        {29259, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5937},
        {29259}
    },
    {
        5938,
        {29272, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5938},
        {29272}
    },
    {
        5939,
        {29300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5939},
        {29300}
    },
    {
        5940,
        {29310, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5940},
        {29310}
    },
    {
        5941,
        {29314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5941},
        {29314}
    },
    {
        5942,
        {29313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5942},
        {29313}
    },
    {
        5943,
        {29319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5943},
        {29319}
    },
    {
        5944,
        {29330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5944},
        {29330}
    },
    {
        5945,
        {29334, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5945},
        {29334}
    },
    {
        5946,
        {29346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5946},
        {29346}
    },
    {
        5947,
        {29351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5947},
        {29351}
    },
    {
        5948,
        {29369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5948},
        {29369}
    },
    {
        5949,
        {29362, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5949},
        {29362}
    },
    {
        5950,
        {29379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5950},
        {29379}
    },
    {
        5951,
        {29382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5951},
        {29382}
    },
    {
        5952,
        {29380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5952},
        {29380}
    },
    {
        5953,
        {29390, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5953},
        {29390}
    },
    {
        5954,
        {29394, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5954},
        {29394}
    },
    {
        5955,
        {29410, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5955},
        {29410}
    },
    {
        5956,
        {29408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5956},
        {29408}
    },
    {
        5957,
        {29409, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5957},
        {29409}
    },
    {
        5958,
        {29433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5958},
        {29433}
    },
    {
        5959,
        {29431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5959},
        {29431}
    },
    {
        5960,
        {20495, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5960},
        {20495}
    },
    {
        5961,
        {29463, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5961},
        {29463}
    },
    {
        5962,
        {29450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5962},
        {29450}
    },
    {
        5963,
        {29468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5963},
        {29468}
    },
    {
        5964,
        {29462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5964},
        {29462}
    },
    {
        5965,
        {29469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5965},
        {29469}
    },
    {
        5966,
        {29492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5966},
        {29492}
    },
    {
        5967,
        {29487, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5967},
        {29487}
    },
    {
        5968,
        {29481, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5968},
        {29481}
    },
    {
        5969,
        {29477, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5969},
        {29477}
    },
    {
        5970,
        {29502, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5970},
        {29502}
    },
    {
        5971,
        {29518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5971},
        {29518}
    },
    {
        5972,
        {29519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5972},
        {29519}
    },
    {
        5973,
        {40664, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5973},
        {40664}
    },
    {
        5974,
        {29527, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5974},
        {29527}
    },
    {
        5975,
        {29546, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5975},
        {29546}
    },
    {
        5976,
        {29544, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5976},
        {29544}
    },
    {
        5977,
        {29552, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5977},
        {29552}
    },
    {
        5978,
        {29560, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5978},
        {29560}
    },
    {
        5979,
        {29557, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5979},
        {29557}
    },
    {
        5980,
        {29563, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5980},
        {29563}
    },
    {
        5981,
        {29562, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5981},
        {29562}
    },
    {
        5982,
        {29640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5982},
        {29640}
    },
    {
        5983,
        {29619, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5983},
        {29619}
    },
    {
        5984,
        {29646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5984},
        {29646}
    },
    {
        5985,
        {29627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5985},
        {29627}
    },
    {
        5986,
        {29632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5986},
        {29632}
    },
    {
        5987,
        {29669, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5987},
        {29669}
    },
    {
        5988,
        {29678, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5988},
        {29678}
    },
    {
        5989,
        {29662, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5989},
        {29662}
    },
    {
        5990,
        {29858, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5990},
        {29858}
    },
    {
        5991,
        {29701, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5991},
        {29701}
    },
    {
        5992,
        {29807, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5992},
        {29807}
    },
    {
        5993,
        {29733, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5993},
        {29733}
    },
    {
        5994,
        {29688, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5994},
        {29688}
    },
    {
        5995,
        {29746, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5995},
        {29746}
    },
    {
        5996,
        {29754, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5996},
        {29754}
    },
    {
        5997,
        {29781, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5997},
        {29781}
    },
    {
        5998,
        {29759, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5998},
        {29759}
    },
    {
        5999,
        {29791, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {5999},
        {29791}
    },
    {
        6000,
        {29785, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6000},
        {29785}
    },
    {
        6001,
        {29761, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6001},
        {29761}
    },
    {
        6002,
        {29788, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6002},
        {29788}
    },
    {
        6003,
        {29801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6003},
        {29801}
    },
    {
        6004,
        {29808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6004},
        {29808}
    },
    {
        6005,
        {29795, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6005},
        {29795}
    },
    {
        6006,
        {29802, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6006},
        {29802}
    },
    {
        6007,
        {29814, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6007},
        {29814}
    },
    {
        6008,
        {29822, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6008},
        {29822}
    },
    {
        6009,
        {29835, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6009},
        {29835}
    },
    {
        6010,
        {29854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6010},
        {29854}
    },
    {
        6011,
        {29863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6011},
        {29863}
    },
    {
        6012,
        {29898, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6012},
        {29898}
    },
    {
        6013,
        {29903, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6013},
        {29903}
    },
    {
        6014,
        {29908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6014},
        {29908}
    },
    {
        6015,
        {29681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6015},
        {29681}
    },
    {
        6016,
        {29920, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6016},
        {29920}
    },
    {
        6017,
        {29923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6017},
        {29923}
    },
    {
        6018,
        {29927, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6018},
        {29927}
    },
    {
        6019,
        {29929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6019},
        {29929}
    },
    {
        6020,
        {29934, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6020},
        {29934}
    },
    {
        6021,
        {29938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6021},
        {29938}
    },
    {
        6022,
        {29936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6022},
        {29936}
    },
    {
        6023,
        {29937, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6023},
        {29937}
    },
    {
        6024,
        {29944, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6024},
        {29944}
    },
    {
        6025,
        {29943, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6025},
        {29943}
    },
    {
        6026,
        {29956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6026},
        {29956}
    },
    {
        6027,
        {29955, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6027},
        {29955}
    },
    {
        6028,
        {29957, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6028},
        {29957}
    },
    {
        6029,
        {29964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6029},
        {29964}
    },
    {
        6030,
        {29966, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6030},
        {29966}
    },
    {
        6031,
        {29965, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6031},
        {29965}
    },
    {
        6032,
        {29973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6032},
        {29973}
    },
    {
        6033,
        {29971, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6033},
        {29971}
    },
    {
        6034,
        {29982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6034},
        {29982}
    },
    {
        6035,
        {29990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6035},
        {29990}
    },
    {
        6036,
        {29996, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6036},
        {29996}
    },
    {
        6037,
        {30012, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6037},
        {30012}
    },
    {
        6038,
        {30020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6038},
        {30020}
    },
    {
        6039,
        {30029, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6039},
        {30029}
    },
    {
        6040,
        {30026, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6040},
        {30026}
    },
    {
        6041,
        {30025, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6041},
        {30025}
    },
    {
        6042,
        {30043, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6042},
        {30043}
    },
    {
        6043,
        {30022, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6043},
        {30022}
    },
    {
        6044,
        {30042, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6044},
        {30042}
    },
    {
        6045,
        {30057, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6045},
        {30057}
    },
    {
        6046,
        {30052, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6046},
        {30052}
    },
    {
        6047,
        {30055, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6047},
        {30055}
    },
    {
        6048,
        {30059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6048},
        {30059}
    },
    {
        6049,
        {30061, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6049},
        {30061}
    },
    {
        6050,
        {30072, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6050},
        {30072}
    },
    {
        6051,
        {30070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6051},
        {30070}
    },
    {
        6052,
        {30086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6052},
        {30086}
    },
    {
        6053,
        {30087, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6053},
        {30087}
    },
    {
        6054,
        {30068, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6054},
        {30068}
    },
    {
        6055,
        {30090, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6055},
        {30090}
    },
    {
        6056,
        {30089, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6056},
        {30089}
    },
    {
        6057,
        {30082, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6057},
        {30082}
    },
    {
        6058,
        {30100, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6058},
        {30100}
    },
    {
        6059,
        {30106, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6059},
        {30106}
    },
    {
        6060,
        {30109, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6060},
        {30109}
    },
    {
        6061,
        {30117, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6061},
        {30117}
    },
    {
        6062,
        {30115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6062},
        {30115}
    },
    {
        6063,
        {30146, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6063},
        {30146}
    },
    {
        6064,
        {30131, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6064},
        {30131}
    },
    {
        6065,
        {30147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6065},
        {30147}
    },
    {
        6066,
        {30133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6066},
        {30133}
    },
    {
        6067,
        {30141, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6067},
        {30141}
    },
    {
        6068,
        {30136, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6068},
        {30136}
    },
    {
        6069,
        {30140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6069},
        {30140}
    },
    {
        6070,
        {30129, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6070},
        {30129}
    },
    {
        6071,
        {30157, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6071},
        {30157}
    },
    {
        6072,
        {30154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6072},
        {30154}
    },
    {
        6073,
        {30162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6073},
        {30162}
    },
    {
        6074,
        {30169, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6074},
        {30169}
    },
    {
        6075,
        {30179, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6075},
        {30179}
    },
    {
        6076,
        {30174, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6076},
        {30174}
    },
    {
        6077,
        {30206, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6077},
        {30206}
    },
    {
        6078,
        {30207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6078},
        {30207}
    },
    {
        6079,
        {30204, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6079},
        {30204}
    },
    {
        6080,
        {30209, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6080},
        {30209}
    },
    {
        6081,
        {30192, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6081},
        {30192}
    },
    {
        6082,
        {30202, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6082},
        {30202}
    },
    {
        6083,
        {30194, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6083},
        {30194}
    },
    {
        6084,
        {30195, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6084},
        {30195}
    },
    {
        6085,
        {30219, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6085},
        {30219}
    },
    {
        6086,
        {30221, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6086},
        {30221}
    },
    {
        6087,
        {30217, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6087},
        {30217}
    },
    {
        6088,
        {30239, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6088},
        {30239}
    },
    {
        6089,
        {30247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6089},
        {30247}
    },
    {
        6090,
        {30240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6090},
        {30240}
    },
    {
        6091,
        {30241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6091},
        {30241}
    },
    {
        6092,
        {30242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6092},
        {30242}
    },
    {
        6093,
        {30244, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6093},
        {30244}
    },
    {
        6094,
        {30260, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6094},
        {30260}
    },
    {
        6095,
        {30256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6095},
        {30256}
    },
    {
        6096,
        {30267, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6096},
        {30267}
    },
    {
        6097,
        {30279, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6097},
        {30279}
    },
    {
        6098,
        {30280, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6098},
        {30280}
    },
    {
        6099,
        {30278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6099},
        {30278}
    },
    {
        6100,
        {30300, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6100},
        {30300}
    },
    {
        6101,
        {30296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6101},
        {30296}
    },
    {
        6102,
        {30305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6102},
        {30305}
    },
    {
        6103,
        {30306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6103},
        {30306}
    },
    {
        6104,
        {30312, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6104},
        {30312}
    },
    {
        6105,
        {30313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6105},
        {30313}
    },
    {
        6106,
        {30314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6106},
        {30314}
    },
    {
        6107,
        {30311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6107},
        {30311}
    },
    {
        6108,
        {30316, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6108},
        {30316}
    },
    {
        6109,
        {30320, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6109},
        {30320}
    },
    {
        6110,
        {30322, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6110},
        {30322}
    },
    {
        6111,
        {30326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6111},
        {30326}
    },
    {
        6112,
        {30328, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6112},
        {30328}
    },
    {
        6113,
        {30332, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6113},
        {30332}
    },
    {
        6114,
        {30336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6114},
        {30336}
    },
    {
        6115,
        {30339, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6115},
        {30339}
    },
    {
        6116,
        {30344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6116},
        {30344}
    },
    {
        6117,
        {30347, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6117},
        {30347}
    },
    {
        6118,
        {30350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6118},
        {30350}
    },
    {
        6119,
        {30358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6119},
        {30358}
    },
    {
        6120,
        {30355, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6120},
        {30355}
    },
    {
        6121,
        {30361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6121},
        {30361}
    },
    {
        6122,
        {30362, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6122},
        {30362}
    },
    {
        6123,
        {30384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6123},
        {30384}
    },
    {
        6124,
        {30388, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6124},
        {30388}
    },
    {
        6125,
        {30392, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6125},
        {30392}
    },
    {
        6126,
        {30393, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6126},
        {30393}
    },
    {
        6127,
        {30394, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6127},
        {30394}
    },
    {
        6128,
        {30402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6128},
        {30402}
    },
    {
        6129,
        {30413, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6129},
        {30413}
    },
    {
        6130,
        {30422, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6130},
        {30422}
    },
    {
        6131,
        {30418, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6131},
        {30418}
    },
    {
        6132,
        {30430, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6132},
        {30430}
    },
    {
        6133,
        {30433, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6133},
        {30433}
    },
    {
        6134,
        {30437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6134},
        {30437}
    },
    {
        6135,
        {30439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6135},
        {30439}
    },
    {
        6136,
        {30442, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6136},
        {30442}
    },
    {
        6137,
        {34351, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6137},
        {34351}
    },
    {
        6138,
        {30459, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6138},
        {30459}
    },
    {
        6139,
        {30472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6139},
        {30472}
    },
    {
        6140,
        {30471, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6140},
        {30471}
    },
    {
        6141,
        {30468, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6141},
        {30468}
    },
    {
        6142,
        {30505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6142},
        {30505}
    },
    {
        6143,
        {30500, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6143},
        {30500}
    },
    {
        6144,
        {30494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6144},
        {30494}
    },
    {
        6145,
        {30501, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6145},
        {30501}
    },
    {
        6146,
        {30502, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6146},
        {30502}
    },
    {
        6147,
        {30491, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6147},
        {30491}
    },
    {
        6148,
        {30519, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6148},
        {30519}
    },
    {
        6149,
        {30520, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6149},
        {30520}
    },
    {
        6150,
        {30535, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6150},
        {30535}
    },
    {
        6151,
        {30554, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6151},
        {30554}
    },
    {
        6152,
        {30568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6152},
        {30568}
    },
    {
        6153,
        {30571, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6153},
        {30571}
    },
    {
        6154,
        {30555, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6154},
        {30555}
    },
    {
        6155,
        {30565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6155},
        {30565}
    },
    {
        6156,
        {30591, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6156},
        {30591}
    },
    {
        6157,
        {30590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6157},
        {30590}
    },
    {
        6158,
        {30585, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6158},
        {30585}
    },
    {
        6159,
        {30606, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6159},
        {30606}
    },
    {
        6160,
        {30603, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6160},
        {30603}
    },
    {
        6161,
        {30609, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6161},
        {30609}
    },
    {
        6162,
        {30624, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6162},
        {30624}
    },
    {
        6163,
        {30622, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6163},
        {30622}
    },
    {
        6164,
        {30640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6164},
        {30640}
    },
    {
        6165,
        {30646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6165},
        {30646}
    },
    {
        6166,
        {30649, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6166},
        {30649}
    },
    {
        6167,
        {30655, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6167},
        {30655}
    },
    {
        6168,
        {30652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6168},
        {30652}
    },
    {
        6169,
        {30653, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6169},
        {30653}
    },
    {
        6170,
        {30651, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6170},
        {30651}
    },
    {
        6171,
        {30663, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6171},
        {30663}
    },
    {
        6172,
        {30669, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6172},
        {30669}
    },
    {
        6173,
        {30679, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6173},
        {30679}
    },
    {
        6174,
        {30682, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6174},
        {30682}
    },
    {
        6175,
        {30684, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6175},
        {30684}
    },
    {
        6176,
        {30691, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6176},
        {30691}
    },
    {
        6177,
        {30702, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6177},
        {30702}
    },
    {
        6178,
        {30716, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6178},
        {30716}
    },
    {
        6179,
        {30732, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6179},
        {30732}
    },
    {
        6180,
        {30738, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6180},
        {30738}
    },
    {
        6181,
        {31014, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6181},
        {31014}
    },
    {
        6182,
        {30752, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6182},
        {30752}
    },
    {
        6183,
        {31018, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6183},
        {31018}
    },
    {
        6184,
        {30789, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6184},
        {30789}
    },
    {
        6185,
        {30862, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6185},
        {30862}
    },
    {
        6186,
        {30836, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6186},
        {30836}
    },
    {
        6187,
        {30854, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6187},
        {30854}
    },
    {
        6188,
        {30844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6188},
        {30844}
    },
    {
        6189,
        {30874, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6189},
        {30874}
    },
    {
        6190,
        {30860, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6190},
        {30860}
    },
    {
        6191,
        {30883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6191},
        {30883}
    },
    {
        6192,
        {30901, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6192},
        {30901}
    },
    {
        6193,
        {30890, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6193},
        {30890}
    },
    {
        6194,
        {30895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6194},
        {30895}
    },
    {
        6195,
        {30929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6195},
        {30929}
    },
    {
        6196,
        {30918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6196},
        {30918}
    },
    {
        6197,
        {30923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6197},
        {30923}
    },
    {
        6198,
        {30932, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6198},
        {30932}
    },
    {
        6199,
        {30910, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6199},
        {30910}
    },
    {
        6200,
        {30908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6200},
        {30908}
    },
    {
        6201,
        {30917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6201},
        {30917}
    },
    {
        6202,
        {30922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6202},
        {30922}
    },
    {
        6203,
        {30956, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6203},
        {30956}
    },
    {
        6204,
        {30951, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6204},
        {30951}
    },
    {
        6205,
        {30938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6205},
        {30938}
    },
    {
        6206,
        {30973, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6206},
        {30973}
    },
    {
        6207,
        {30964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6207},
        {30964}
    },
    {
        6208,
        {30983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6208},
        {30983}
    },
    {
        6209,
        {30994, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6209},
        {30994}
    },
    {
        6210,
        {30993, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6210},
        {30993}
    },
    {
        6211,
        {31001, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6211},
        {31001}
    },
    {
        6212,
        {31020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6212},
        {31020}
    },
    {
        6213,
        {31019, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6213},
        {31019}
    },
    {
        6214,
        {31040, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6214},
        {31040}
    },
    {
        6215,
        {31072, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6215},
        {31072}
    },
    {
        6216,
        {31063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6216},
        {31063}
    },
    {
        6217,
        {31071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6217},
        {31071}
    },
    {
        6218,
        {31066, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6218},
        {31066}
    },
    {
        6219,
        {31061, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6219},
        {31061}
    },
    {
        6220,
        {31059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6220},
        {31059}
    },
    {
        6221,
        {31098, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6221},
        {31098}
    },
    {
        6222,
        {31103, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6222},
        {31103}
    },
    {
        6223,
        {31114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6223},
        {31114}
    },
    {
        6224,
        {31133, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6224},
        {31133}
    },
    {
        6225,
        {31143, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6225},
        {31143}
    },
    {
        6226,
        {40779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6226},
        {40779}
    },
    {
        6227,
        {31146, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6227},
        {31146}
    },
    {
        6228,
        {31150, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6228},
        {31150}
    },
    {
        6229,
        {31155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6229},
        {31155}
    },
    {
        6230,
        {31161, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6230},
        {31161}
    },
    {
        6231,
        {31162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6231},
        {31162}
    },
    {
        6232,
        {31177, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6232},
        {31177}
    },
    {
        6233,
        {31189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6233},
        {31189}
    },
    {
        6234,
        {31207, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6234},
        {31207}
    },
    {
        6235,
        {31212, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6235},
        {31212}
    },
    {
        6236,
        {31201, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6236},
        {31201}
    },
    {
        6237,
        {31203, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6237},
        {31203}
    },
    {
        6238,
        {31240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6238},
        {31240}
    },
    {
        6239,
        {31245, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6239},
        {31245}
    },
    {
        6240,
        {31256, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6240},
        {31256}
    },
    {
        6241,
        {31257, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6241},
        {31257}
    },
    {
        6242,
        {31264, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6242},
        {31264}
    },
    {
        6243,
        {31263, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6243},
        {31263}
    },
    {
        6244,
        {31104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6244},
        {31104}
    },
    {
        6245,
        {31281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6245},
        {31281}
    },
    {
        6246,
        {31291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6246},
        {31291}
    },
    {
        6247,
        {31294, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6247},
        {31294}
    },
    {
        6248,
        {31287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6248},
        {31287}
    },
    {
        6249,
        {31299, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6249},
        {31299}
    },
    {
        6250,
        {31319, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6250},
        {31319}
    },
    {
        6251,
        {31305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6251},
        {31305}
    },
    {
        6252,
        {31329, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6252},
        {31329}
    },
    {
        6253,
        {31330, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6253},
        {31330}
    },
    {
        6254,
        {31337, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6254},
        {31337}
    },
    {
        6255,
        {40861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6255},
        {40861}
    },
    {
        6256,
        {31344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6256},
        {31344}
    },
    {
        6257,
        {31353, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6257},
        {31353}
    },
    {
        6258,
        {31357, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6258},
        {31357}
    },
    {
        6259,
        {31368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6259},
        {31368}
    },
    {
        6260,
        {31383, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6260},
        {31383}
    },
    {
        6261,
        {31381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6261},
        {31381}
    },
    {
        6262,
        {31384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6262},
        {31384}
    },
    {
        6263,
        {31382, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6263},
        {31382}
    },
    {
        6264,
        {31401, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6264},
        {31401}
    },
    {
        6265,
        {31432, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6265},
        {31432}
    },
    {
        6266,
        {31408, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6266},
        {31408}
    },
    {
        6267,
        {31414, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6267},
        {31414}
    },
    {
        6268,
        {31429, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6268},
        {31429}
    },
    {
        6269,
        {31428, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6269},
        {31428}
    },
    {
        6270,
        {31423, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6270},
        {31423}
    },
    {
        6271,
        {36995, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6271},
        {36995}
    },
    {
        6272,
        {31431, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6272},
        {31431}
    },
    {
        6273,
        {31434, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6273},
        {31434}
    },
    {
        6274,
        {31437, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6274},
        {31437}
    },
    {
        6275,
        {31439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6275},
        {31439}
    },
    {
        6276,
        {31445, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6276},
        {31445}
    },
    {
        6277,
        {31443, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6277},
        {31443}
    },
    {
        6278,
        {31449, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6278},
        {31449}
    },
    {
        6279,
        {31450, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6279},
        {31450}
    },
    {
        6280,
        {31453, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6280},
        {31453}
    },
    {
        6281,
        {31457, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6281},
        {31457}
    },
    {
        6282,
        {31458, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6282},
        {31458}
    },
    {
        6283,
        {31462, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6283},
        {31462}
    },
    {
        6284,
        {31469, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6284},
        {31469}
    },
    {
        6285,
        {31472, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6285},
        {31472}
    },
    {
        6286,
        {31490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6286},
        {31490}
    },
    {
        6287,
        {31503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6287},
        {31503}
    },
    {
        6288,
        {31498, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6288},
        {31498}
    },
    {
        6289,
        {31494, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6289},
        {31494}
    },
    {
        6290,
        {31539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6290},
        {31539}
    },
    {
        6291,
        {31512, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6291},
        {31512}
    },
    {
        6292,
        {31513, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6292},
        {31513}
    },
    {
        6293,
        {31518, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6293},
        {31518}
    },
    {
        6294,
        {31541, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6294},
        {31541}
    },
    {
        6295,
        {31528, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6295},
        {31528}
    },
    {
        6296,
        {31542, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6296},
        {31542}
    },
    {
        6297,
        {31568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6297},
        {31568}
    },
    {
        6298,
        {31610, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6298},
        {31610}
    },
    {
        6299,
        {31492, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6299},
        {31492}
    },
    {
        6300,
        {31565, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6300},
        {31565}
    },
    {
        6301,
        {31499, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6301},
        {31499}
    },
    {
        6302,
        {31564, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6302},
        {31564}
    },
    {
        6303,
        {31557, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6303},
        {31557}
    },
    {
        6304,
        {31605, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6304},
        {31605}
    },
    {
        6305,
        {31589, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6305},
        {31589}
    },
    {
        6306,
        {31604, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6306},
        {31604}
    },
    {
        6307,
        {31591, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6307},
        {31591}
    },
    {
        6308,
        {31600, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6308},
        {31600}
    },
    {
        6309,
        {31601, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6309},
        {31601}
    },
    {
        6310,
        {31596, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6310},
        {31596}
    },
    {
        6311,
        {31598, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6311},
        {31598}
    },
    {
        6312,
        {31645, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6312},
        {31645}
    },
    {
        6313,
        {31640, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6313},
        {31640}
    },
    {
        6314,
        {31647, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6314},
        {31647}
    },
    {
        6315,
        {31629, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6315},
        {31629}
    },
    {
        6316,
        {31644, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6316},
        {31644}
    },
    {
        6317,
        {31642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6317},
        {31642}
    },
    {
        6318,
        {31627, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6318},
        {31627}
    },
    {
        6319,
        {31634, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6319},
        {31634}
    },
    {
        6320,
        {31631, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6320},
        {31631}
    },
    {
        6321,
        {31581, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6321},
        {31581}
    },
    {
        6322,
        {31641, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6322},
        {31641}
    },
    {
        6323,
        {31691, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6323},
        {31691}
    },
    {
        6324,
        {31681, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6324},
        {31681}
    },
    {
        6325,
        {31692, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6325},
        {31692}
    },
    {
        6326,
        {31695, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6326},
        {31695}
    },
    {
        6327,
        {31668, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6327},
        {31668}
    },
    {
        6328,
        {31686, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6328},
        {31686}
    },
    {
        6329,
        {31709, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6329},
        {31709}
    },
    {
        6330,
        {31721, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6330},
        {31721}
    },
    {
        6331,
        {31761, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6331},
        {31761}
    },
    {
        6332,
        {31764, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6332},
        {31764}
    },
    {
        6333,
        {31718, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6333},
        {31718}
    },
    {
        6334,
        {31717, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6334},
        {31717}
    },
    {
        6335,
        {31840, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6335},
        {31840}
    },
    {
        6336,
        {31744, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6336},
        {31744}
    },
    {
        6337,
        {31751, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6337},
        {31751}
    },
    {
        6338,
        {31763, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6338},
        {31763}
    },
    {
        6339,
        {31731, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6339},
        {31731}
    },
    {
        6340,
        {31735, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6340},
        {31735}
    },
    {
        6341,
        {31767, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6341},
        {31767}
    },
    {
        6342,
        {31757, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6342},
        {31757}
    },
    {
        6343,
        {31734, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6343},
        {31734}
    },
    {
        6344,
        {31779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6344},
        {31779}
    },
    {
        6345,
        {31783, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6345},
        {31783}
    },
    {
        6346,
        {31786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6346},
        {31786}
    },
    {
        6347,
        {31775, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6347},
        {31775}
    },
    {
        6348,
        {31799, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6348},
        {31799}
    },
    {
        6349,
        {31787, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6349},
        {31787}
    },
    {
        6350,
        {31805, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6350},
        {31805}
    },
    {
        6351,
        {31820, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6351},
        {31820}
    },
    {
        6352,
        {31811, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6352},
        {31811}
    },
    {
        6353,
        {31828, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6353},
        {31828}
    },
    {
        6354,
        {31823, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6354},
        {31823}
    },
    {
        6355,
        {31808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6355},
        {31808}
    },
    {
        6356,
        {31824, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6356},
        {31824}
    },
    {
        6357,
        {31832, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6357},
        {31832}
    },
    {
        6358,
        {31839, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6358},
        {31839}
    },
    {
        6359,
        {31844, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6359},
        {31844}
    },
    {
        6360,
        {31830, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6360},
        {31830}
    },
    {
        6361,
        {31845, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6361},
        {31845}
    },
    {
        6362,
        {31852, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6362},
        {31852}
    },
    {
        6363,
        {31861, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6363},
        {31861}
    },
    {
        6364,
        {31875, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6364},
        {31875}
    },
    {
        6365,
        {31888, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6365},
        {31888}
    },
    {
        6366,
        {31908, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6366},
        {31908}
    },
    {
        6367,
        {31917, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6367},
        {31917}
    },
    {
        6368,
        {31906, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6368},
        {31906}
    },
    {
        6369,
        {31915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6369},
        {31915}
    },
    {
        6370,
        {31905, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6370},
        {31905}
    },
    {
        6371,
        {31912, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6371},
        {31912}
    },
    {
        6372,
        {31923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6372},
        {31923}
    },
    {
        6373,
        {31922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6373},
        {31922}
    },
    {
        6374,
        {31921, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6374},
        {31921}
    },
    {
        6375,
        {31918, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6375},
        {31918}
    },
    {
        6376,
        {31929, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6376},
        {31929}
    },
    {
        6377,
        {31933, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6377},
        {31933}
    },
    {
        6378,
        {31936, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6378},
        {31936}
    },
    {
        6379,
        {31941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6379},
        {31941}
    },
    {
        6380,
        {31938, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6380},
        {31938}
    },
    {
        6381,
        {31960, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6381},
        {31960}
    },
    {
        6382,
        {31954, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6382},
        {31954}
    },
    {
        6383,
        {31964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6383},
        {31964}
    },
    {
        6384,
        {31970, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6384},
        {31970}
    },
    {
        6385,
        {39739, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6385},
        {39739}
    },
    {
        6386,
        {31983, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6386},
        {31983}
    },
    {
        6387,
        {31986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6387},
        {31986}
    },
    {
        6388,
        {31988, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6388},
        {31988}
    },
    {
        6389,
        {31990, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6389},
        {31990}
    },
    {
        6390,
        {31994, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6390},
        {31994}
    },
    {
        6391,
        {32006, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6391},
        {32006}
    },
    {
        6392,
        {32002, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6392},
        {32002}
    },
    {
        6393,
        {32028, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6393},
        {32028}
    },
    {
        6394,
        {32021, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6394},
        {32021}
    },
    {
        6395,
        {32010, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6395},
        {32010}
    },
    {
        6396,
        {32069, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6396},
        {32069}
    },
    {
        6397,
        {32075, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6397},
        {32075}
    },
    {
        6398,
        {32046, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6398},
        {32046}
    },
    {
        6399,
        {32050, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6399},
        {32050}
    },
    {
        6400,
        {32063, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6400},
        {32063}
    },
    {
        6401,
        {32053, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6401},
        {32053}
    },
    {
        6402,
        {32070, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6402},
        {32070}
    },
    {
        6403,
        {32115, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6403},
        {32115}
    },
    {
        6404,
        {32086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6404},
        {32086}
    },
    {
        6405,
        {32078, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6405},
        {32078}
    },
    {
        6406,
        {32114, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6406},
        {32114}
    },
    {
        6407,
        {32104, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6407},
        {32104}
    },
    {
        6408,
        {32110, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6408},
        {32110}
    },
    {
        6409,
        {32079, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6409},
        {32079}
    },
    {
        6410,
        {32099, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6410},
        {32099}
    },
    {
        6411,
        {32147, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6411},
        {32147}
    },
    {
        6412,
        {32137, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6412},
        {32137}
    },
    {
        6413,
        {32091, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6413},
        {32091}
    },
    {
        6414,
        {32143, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6414},
        {32143}
    },
    {
        6415,
        {32125, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6415},
        {32125}
    },
    {
        6416,
        {32155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6416},
        {32155}
    },
    {
        6417,
        {32186, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6417},
        {32186}
    },
    {
        6418,
        {32174, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6418},
        {32174}
    },
    {
        6419,
        {32163, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6419},
        {32163}
    },
    {
        6420,
        {32181, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6420},
        {32181}
    },
    {
        6421,
        {32199, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6421},
        {32199}
    },
    {
        6422,
        {32189, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6422},
        {32189}
    },
    {
        6423,
        {32171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6423},
        {32171}
    },
    {
        6424,
        {32317, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6424},
        {32317}
    },
    {
        6425,
        {32162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6425},
        {32162}
    },
    {
        6426,
        {32175, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6426},
        {32175}
    },
    {
        6427,
        {32220, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6427},
        {32220}
    },
    {
        6428,
        {32184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6428},
        {32184}
    },
    {
        6429,
        {32159, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6429},
        {32159}
    },
    {
        6430,
        {32176, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6430},
        {32176}
    },
    {
        6431,
        {32216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6431},
        {32216}
    },
    {
        6432,
        {32221, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6432},
        {32221}
    },
    {
        6433,
        {32228, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6433},
        {32228}
    },
    {
        6434,
        {32222, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6434},
        {32222}
    },
    {
        6435,
        {32251, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6435},
        {32251}
    },
    {
        6436,
        {32242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6436},
        {32242}
    },
    {
        6437,
        {32225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6437},
        {32225}
    },
    {
        6438,
        {32261, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6438},
        {32261}
    },
    {
        6439,
        {32266, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6439},
        {32266}
    },
    {
        6440,
        {32291, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6440},
        {32291}
    },
    {
        6441,
        {32289, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6441},
        {32289}
    },
    {
        6442,
        {32274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6442},
        {32274}
    },
    {
        6443,
        {32305, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6443},
        {32305}
    },
    {
        6444,
        {32287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6444},
        {32287}
    },
    {
        6445,
        {32265, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6445},
        {32265}
    },
    {
        6446,
        {32267, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6446},
        {32267}
    },
    {
        6447,
        {32290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6447},
        {32290}
    },
    {
        6448,
        {32326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6448},
        {32326}
    },
    {
        6449,
        {32358, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6449},
        {32358}
    },
    {
        6450,
        {32315, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6450},
        {32315}
    },
    {
        6451,
        {32309, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6451},
        {32309}
    },
    {
        6452,
        {32313, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6452},
        {32313}
    },
    {
        6453,
        {32323, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6453},
        {32323}
    },
    {
        6454,
        {32311, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6454},
        {32311}
    },
    {
        6455,
        {32306, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6455},
        {32306}
    },
    {
        6456,
        {32314, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6456},
        {32314}
    },
    {
        6457,
        {32359, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6457},
        {32359}
    },
    {
        6458,
        {32349, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6458},
        {32349}
    },
    {
        6459,
        {32342, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6459},
        {32342}
    },
    {
        6460,
        {32350, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6460},
        {32350}
    },
    {
        6461,
        {32345, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6461},
        {32345}
    },
    {
        6462,
        {32346, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6462},
        {32346}
    },
    {
        6463,
        {32377, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6463},
        {32377}
    },
    {
        6464,
        {32362, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6464},
        {32362}
    },
    {
        6465,
        {32361, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6465},
        {32361}
    },
    {
        6466,
        {32380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6466},
        {32380}
    },
    {
        6467,
        {32379, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6467},
        {32379}
    },
    {
        6468,
        {32387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6468},
        {32387}
    },
    {
        6469,
        {32213, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6469},
        {32213}
    },
    {
        6470,
        {32381, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6470},
        {32381}
    },
    {
        6471,
        {36782, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6471},
        {36782}
    },
    {
        6472,
        {32383, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6472},
        {32383}
    },
    {
        6473,
        {32392, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6473},
        {32392}
    },
    {
        6474,
        {32393, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6474},
        {32393}
    },
    {
        6475,
        {32396, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6475},
        {32396}
    },
    {
        6476,
        {32402, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6476},
        {32402}
    },
    {
        6477,
        {32400, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6477},
        {32400}
    },
    {
        6478,
        {32403, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6478},
        {32403}
    },
    {
        6479,
        {32404, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6479},
        {32404}
    },
    {
        6480,
        {32406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6480},
        {32406}
    },
    {
        6481,
        {32398, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6481},
        {32398}
    },
    {
        6482,
        {32411, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6482},
        {32411}
    },
    {
        6483,
        {32412, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6483},
        {32412}
    },
    {
        6484,
        {32568, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6484},
        {32568}
    },
    {
        6485,
        {32570, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6485},
        {32570}
    },
    {
        6486,
        {32581, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6486},
        {32581}
    },
    {
        6487,
        {32588, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6487},
        {32588}
    },
    {
        6488,
        {32589, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6488},
        {32589}
    },
    {
        6489,
        {32590, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6489},
        {32590}
    },
    {
        6490,
        {32592, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6490},
        {32592}
    },
    {
        6491,
        {32593, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6491},
        {32593}
    },
    {
        6492,
        {32597, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6492},
        {32597}
    },
    {
        6493,
        {32596, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6493},
        {32596}
    },
    {
        6494,
        {32600, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6494},
        {32600}
    },
    {
        6495,
        {32607, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6495},
        {32607}
    },
    {
        6496,
        {32608, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6496},
        {32608}
    },
    {
        6497,
        {32616, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6497},
        {32616}
    },
    {
        6498,
        {32617, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6498},
        {32617}
    },
    {
        6499,
        {32615, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6499},
        {32615}
    },
    {
        6500,
        {32632, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6500},
        {32632}
    },
    {
        6501,
        {32642, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6501},
        {32642}
    },
    {
        6502,
        {32646, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6502},
        {32646}
    },
    {
        6503,
        {32643, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6503},
        {32643}
    },
    {
        6504,
        {32648, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6504},
        {32648}
    },
    {
        6505,
        {32647, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6505},
        {32647}
    },
    {
        6506,
        {32652, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6506},
        {32652}
    },
    {
        6507,
        {32660, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6507},
        {32660}
    },
    {
        6508,
        {32670, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6508},
        {32670}
    },
    {
        6509,
        {32669, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6509},
        {32669}
    },
    {
        6510,
        {32666, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6510},
        {32666}
    },
    {
        6511,
        {32675, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6511},
        {32675}
    },
    {
        6512,
        {32687, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6512},
        {32687}
    },
    {
        6513,
        {32690, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6513},
        {32690}
    },
    {
        6514,
        {32697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6514},
        {32697}
    },
    {
        6515,
        {32686, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6515},
        {32686}
    },
    {
        6516,
        {32694, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6516},
        {32694}
    },
    {
        6517,
        {32696, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6517},
        {32696}
    },
    {
        6518,
        {35697, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6518},
        {35697}
    },
    {
        6519,
        {32709, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6519},
        {32709}
    },
    {
        6520,
        {32710, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6520},
        {32710}
    },
    {
        6521,
        {32714, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6521},
        {32714}
    },
    {
        6522,
        {32725, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6522},
        {32725}
    },
    {
        6523,
        {32724, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6523},
        {32724}
    },
    {
        6524,
        {32737, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6524},
        {32737}
    },
    {
        6525,
        {32742, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6525},
        {32742}
    },
    {
        6526,
        {32745, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6526},
        {32745}
    },
    {
        6527,
        {32755, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6527},
        {32755}
    },
    {
        6528,
        {32761, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6528},
        {32761}
    },
    {
        6529,
        {39132, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6529},
        {39132}
    },
    {
        6530,
        {32774, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6530},
        {32774}
    },
    {
        6531,
        {32772, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6531},
        {32772}
    },
    {
        6532,
        {32779, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6532},
        {32779}
    },
    {
        6533,
        {32786, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6533},
        {32786}
    },
    {
        6534,
        {32792, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6534},
        {32792}
    },
    {
        6535,
        {32793, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6535},
        {32793}
    },
    {
        6536,
        {32796, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6536},
        {32796}
    },
    {
        6537,
        {32801, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6537},
        {32801}
    },
    {
        6538,
        {32808, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6538},
        {32808}
    },
    {
        6539,
        {32831, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6539},
        {32831}
    },
    {
        6540,
        {32827, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6540},
        {32827}
    },
    {
        6541,
        {32842, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6541},
        {32842}
    },
    {
        6542,
        {32838, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6542},
        {32838}
    },
    {
        6543,
        {32850, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6543},
        {32850}
    },
    {
        6544,
        {32856, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6544},
        {32856}
    },
    {
        6545,
        {32858, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6545},
        {32858}
    },
    {
        6546,
        {32863, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6546},
        {32863}
    },
    {
        6547,
        {32866, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6547},
        {32866}
    },
    {
        6548,
        {32872, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6548},
        {32872}
    },
    {
        6549,
        {32883, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6549},
        {32883}
    },
    {
        6550,
        {32882, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6550},
        {32882}
    },
    {
        6551,
        {32880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6551},
        {32880}
    },
    {
        6552,
        {32886, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6552},
        {32886}
    },
    {
        6553,
        {32889, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6553},
        {32889}
    },
    {
        6554,
        {32893, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6554},
        {32893}
    },
    {
        6555,
        {32895, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6555},
        {32895}
    },
    {
        6556,
        {32900, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6556},
        {32900}
    },
    {
        6557,
        {32902, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6557},
        {32902}
    },
    {
        6558,
        {32901, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6558},
        {32901}
    },
    {
        6559,
        {32923, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6559},
        {32923}
    },
    {
        6560,
        {32915, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6560},
        {32915}
    },
    {
        6561,
        {32922, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6561},
        {32922}
    },
    {
        6562,
        {32941, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6562},
        {32941}
    },
    {
        6563,
        {20880, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6563},
        {20880}
    },
    {
        6564,
        {32940, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6564},
        {32940}
    },
    {
        6565,
        {32987, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6565},
        {32987}
    },
    {
        6566,
        {32997, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6566},
        {32997}
    },
    {
        6567,
        {32985, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6567},
        {32985}
    },
    {
        6568,
        {32989, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6568},
        {32989}
    },
    {
        6569,
        {32964, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6569},
        {32964}
    },
    {
        6570,
        {32986, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6570},
        {32986}
    },
    {
        6571,
        {32982, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6571},
        {32982}
    },
    {
        6572,
        {33033, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6572},
        {33033}
    },
    {
        6573,
        {33007, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6573},
        {33007}
    },
    {
        6574,
        {33009, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6574},
        {33009}
    },
    {
        6575,
        {33051, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6575},
        {33051}
    },
    {
        6576,
        {33065, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6576},
        {33065}
    },
    {
        6577,
        {33059, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6577},
        {33059}
    },
    {
        6578,
        {33071, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6578},
        {33071}
    },
    {
        6579,
        {33099, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6579},
        {33099}
    },
    {
        6580,
        {38539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6580},
        {38539}
    },
    {
        6581,
        {33094, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6581},
        {33094}
    },
    {
        6582,
        {33086, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6582},
        {33086}
    },
    {
        6583,
        {33107, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6583},
        {33107}
    },
    {
        6584,
        {33105, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6584},
        {33105}
    },
    {
        6585,
        {33020, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6585},
        {33020}
    },
    {
        6586,
        {33137, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6586},
        {33137}
    },
    {
        6587,
        {33134, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6587},
        {33134}
    },
    {
        6588,
        {33125, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6588},
        {33125}
    },
    {
        6589,
        {33126, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6589},
        {33126}
    },
    {
        6590,
        {33140, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6590},
        {33140}
    },
    {
        6591,
        {33155, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6591},
        {33155}
    },
    {
        6592,
        {33160, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6592},
        {33160}
    },
    {
        6593,
        {33162, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6593},
        {33162}
    },
    {
        6594,
        {33152, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6594},
        {33152}
    },
    {
        6595,
        {33154, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6595},
        {33154}
    },
    {
        6596,
        {33184, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6596},
        {33184}
    },
    {
        6597,
        {33173, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6597},
        {33173}
    },
    {
        6598,
        {33188, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6598},
        {33188}
    },
    {
        6599,
        {33187, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6599},
        {33187}
    },
    {
        6600,
        {33119, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6600},
        {33119}
    },
    {
        6601,
        {33171, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6601},
        {33171}
    },
    {
        6602,
        {33193, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6602},
        {33193}
    },
    {
        6603,
        {33200, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6603},
        {33200}
    },
    {
        6604,
        {33205, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6604},
        {33205}
    },
    {
        6605,
        {33214, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6605},
        {33214}
    },
    {
        6606,
        {33208, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6606},
        {33208}
    },
    {
        6607,
        {33213, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6607},
        {33213}
    },
    {
        6608,
        {33216, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6608},
        {33216}
    },
    {
        6609,
        {33218, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6609},
        {33218}
    },
    {
        6610,
        {33210, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6610},
        {33210}
    },
    {
        6611,
        {33225, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6611},
        {33225}
    },
    {
        6612,
        {33229, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6612},
        {33229}
    },
    {
        6613,
        {33233, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6613},
        {33233}
    },
    {
        6614,
        {33241, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6614},
        {33241}
    },
    {
        6615,
        {33240, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6615},
        {33240}
    },
    {
        6616,
        {33224, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6616},
        {33224}
    },
    {
        6617,
        {33242, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6617},
        {33242}
    },
    {
        6618,
        {33247, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6618},
        {33247}
    },
    {
        6619,
        {33248, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6619},
        {33248}
    },
    {
        6620,
        {33255, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6620},
        {33255}
    },
    {
        6621,
        {33274, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6621},
        {33274}
    },
    {
        6622,
        {33275, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6622},
        {33275}
    },
    {
        6623,
        {33278, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6623},
        {33278}
    },
    {
        6624,
        {33281, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6624},
        {33281}
    },
    {
        6625,
        {33282, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6625},
        {33282}
    },
    {
        6626,
        {33285, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6626},
        {33285}
    },
    {
        6627,
        {33287, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6627},
        {33287}
    },
    {
        6628,
        {33290, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6628},
        {33290}
    },
    {
        6629,
        {33293, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6629},
        {33293}
    },
    {
        6630,
        {33296, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6630},
        {33296}
    },
    {
        6631,
        {33302, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6631},
        {33302}
    },
    {
        6632,
        {33321, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6632},
        {33321}
    },
    {
        6633,
        {33323, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6633},
        {33323}
    },
    {
        6634,
        {33336, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6634},
        {33336}
    },
    {
        6635,
        {33331, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6635},
        {33331}
    },
    {
        6636,
        {33344, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6636},
        {33344}
    },
    {
        6637,
        {33369, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6637},
        {33369}
    },
    {
        6638,
        {33368, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6638},
        {33368}
    },
    {
        6639,
        {33373, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6639},
        {33373}
    },
    {
        6640,
        {33370, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6640},
        {33370}
    },
    {
        6641,
        {33375, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6641},
        {33375}
    },
    {
        6642,
        {33380, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6642},
        {33380}
    },
    {
        6643,
        {33378, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6643},
        {33378}
    },
    {
        6644,
        {33384, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6644},
        {33384}
    },
    {
        6645,
        {33386, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6645},
        {33386}
    },
    {
        6646,
        {33387, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6646},
        {33387}
    },
    {
        6647,
        {33326, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6647},
        {33326}
    },
    {
        6648,
        {33393, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6648},
        {33393}
    },
    {
        6649,
        {33399, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6649},
        {33399}
    },
    {
        6650,
        {33400, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6650},
        {33400}
    },
    {
        6651,
        {33406, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6651},
        {33406}
    },
    {
        6652,
        {33421, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6652},
        {33421}
    },
    {
        6653,
        {33426, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6653},
        {33426}
    },
    {
        6654,
        {33451, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6654},
        {33451}
    },
    {
        6655,
        {33439, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6655},
        {33439}
    },
    {
        6656,
        {33467, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6656},
        {33467}
    },
    {
        6657,
        {33452, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6657},
        {33452}
    },
    {
        6658,
        {33505, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6658},
        {33505}
    },
    {
        6659,
        {33507, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6659},
        {33507}
    },
    {
        6660,
        {33503, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6660},
        {33503}
    },
    {
        6661,
        {33490, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6661},
        {33490}
    },
    {
        6662,
        {33524, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6662},
        {33524}
    },
    {
        6663,
        {33523, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6663},
        {33523}
    },
    {
        6664,
        {33530, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6664},
        {33530}
    },
    {
        6665,
        {33683, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6665},
        {33683}
    },
    {
        6666,
        {33539, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6666},
        {33539}
    },
    {
        6667,
        {33531, -1},
        {-1, -1},
        JISCharacterClass_KANJI_LEVEL_2,
        1,
        {6667},
        {33531}
    },
    {
        6