# Generated by Django 3.2.12 on 2022-03-24 17:07

from django.db import migrations, models
import django.utils.timezone
import medialogue.models
import sortedm2m.fields
import video_encoding.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250)),
                ('slug', models.SlugField(help_text='A "slug" is a unique URL-friendly title for an object.', max_length=250, unique=True)),
                ('caption', models.TextField(blank=True)),
                ('is_public', models.BooleanField(default=True)),
                ('date_added', models.DateTimeField(default=django.utils.timezone.now)),
                ('thumbnail', models.ImageField(blank=True, upload_to='')),
                ('width', models.PositiveIntegerField(editable=False, null=True)),
                ('height', models.PositiveIntegerField(editable=False, null=True)),
                ('duration', models.FloatField(editable=False, null=True)),
                ('file', video_encoding.fields.VideoField(height_field='height', upload_to='', width_field='width')),
                ('sites', models.ManyToManyField(blank=True, to='sites.Site', verbose_name='sites')),
            ],
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('src', models.ImageField(upload_to=medialogue.models.get_storage_path, verbose_name='src')),
                ('date_taken', models.DateTimeField(blank=True, help_text='Date image was taken; is obtained from the image EXIF data.', null=True, verbose_name='date taken')),
                ('title', models.CharField(max_length=250, unique=True, verbose_name='title')),
                ('slug', models.SlugField(help_text='A "slug" is a unique URL-friendly title for an object.', max_length=250, unique=True, verbose_name='slug')),
                ('caption', models.TextField(blank=True, verbose_name='caption')),
                ('date_added', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date added')),
                ('is_public', models.BooleanField(default=True, help_text='Public photographs will be displayed in the default views.', verbose_name='is public')),
                ('sites', models.ManyToManyField(blank=True, to='sites.Site', verbose_name='sites')),
            ],
        ),
        migrations.CreateModel(
            name='Album',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_added', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date published')),
                ('title', models.CharField(max_length=250, unique=True, verbose_name='title')),
                ('slug', models.SlugField(help_text='A "slug" is a unique URL-friendly title for an object.', max_length=250, unique=True, verbose_name='title slug')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True, help_text='Public galleries will be displayed in the default views.', verbose_name='is public')),
                ('photos', sortedm2m.fields.SortedManyToManyField(blank=True, help_text=None, related_name='albums', to='medialogue.Photo', verbose_name='photos')),
                ('sites', models.ManyToManyField(blank=True, to='sites.Site', verbose_name='sites')),
                ('videos', sortedm2m.fields.SortedManyToManyField(blank=True, help_text=None, related_name='albums', to='medialogue.Video', verbose_name='videos')),
            ],
            options={
                'verbose_name': 'Album',
                'verbose_name_plural': 'Albums',
                'ordering': ['-date_added'],
                'get_latest_by': 'date_added',
            },
        ),
    ]
