"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
class Schema {
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType) {
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType, valueType) {
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
_a = JSII_RTTI_SYMBOL_1;
Schema[_a] = { fqn: "@aws-cdk/aws-glue.Schema", version: "1.95.1" };
/**
 * @experimental
 */
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
/**
 * @experimental
 */
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 *
 * @experimental
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
/**
 * @experimental
 */
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
/**
 * @experimental
 */
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 *
 * @experimental
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 *
 * @experimental
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
 *
 * @experimental
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * (experimental) Date type.
 *
 * @experimental
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * (experimental) Timestamp type (date and time).
 *
 * @experimental
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * (experimental) Arbitrary-length string type.
 *
 * @experimental
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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