"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = exports.ConnectionType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const glue_generated_1 = require("./glue.generated");
/**
 * The type of the glue connection
 *
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a `ConnectionType` object, e.g: `new ConnectionType('NEW_TYPE')`.
 */
class ConnectionType {
    constructor(name) {
        this.name = name;
    }
    /**
     * The connection type name as expected by Connection resource.
     */
    toString() {
        return this.name;
    }
}
exports.ConnectionType = ConnectionType;
_a = JSII_RTTI_SYMBOL_1;
ConnectionType[_a] = { fqn: "@aws-cdk/aws-glue.ConnectionType", version: "1.181.1" };
/**
 * Designates a connection to a database through Java Database Connectivity (JDBC).
 */
ConnectionType.JDBC = new ConnectionType('JDBC');
/**
 * Designates a connection to an Apache Kafka streaming platform.
 */
ConnectionType.KAFKA = new ConnectionType('KAFKA');
/**
 * Designates a connection to a MongoDB document database.
 */
ConnectionType.MONGODB = new ConnectionType('MONGODB');
/**
 * Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
 */
ConnectionType.NETWORK = new ConnectionType('NETWORK');
/**
 * An AWS Glue connection to a data source.
 */
class Connection extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.connectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_ConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Connection);
            }
            throw error;
        }
        this.properties = props.properties || {};
        const physicalConnectionRequirements = props.subnet || props.securityGroups ? {
            availabilityZone: props.subnet ? props.subnet.availabilityZone : undefined,
            subnetId: props.subnet ? props.subnet.subnetId : undefined,
            securityGroupIdList: props.securityGroups ? props.securityGroups.map(sg => sg.securityGroupId) : undefined,
        } : undefined;
        const connectionResource = new glue_generated_1.CfnConnection(this, 'Resource', {
            catalogId: cdk.Stack.of(this).account,
            connectionInput: {
                connectionProperties: cdk.Lazy.any({ produce: () => Object.keys(this.properties).length > 0 ? this.properties : undefined }),
                connectionType: props.type.name,
                description: props.description,
                matchCriteria: props.matchCriteria,
                name: props.connectionName,
                physicalConnectionRequirements,
            },
        });
        const resourceName = this.getResourceNameAttribute(connectionResource.ref);
        this.connectionArn = Connection.buildConnectionArn(this, resourceName);
        this.connectionName = resourceName;
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionArn arn of external connection.
     */
    static fromConnectionArn(scope, id, connectionArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = cdk.Arn.extractResourceName(connectionArn, 'connection');
                this.connectionArn = connectionArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionName name of external connection.
     */
    static fromConnectionName(scope, id, connectionName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = connectionName;
                this.connectionArn = Connection.buildConnectionArn(scope, connectionName);
            }
        }
        return new Import(scope, id);
    }
    static buildConnectionArn(scope, connectionName) {
        return cdk.Stack.of(scope).formatArn({
            service: 'glue',
            resource: 'connection',
            resourceName: connectionName,
        });
    }
    /**
     * Add additional connection parameters
     * @param key parameter key
     * @param value parameter value
     */
    addProperty(key, value) {
        this.properties[key] = value;
    }
}
exports.Connection = Connection;
_b = JSII_RTTI_SYMBOL_1;
Connection[_b] = { fqn: "@aws-cdk/aws-glue.Connection", version: "1.181.1" };
//# sourceMappingURL=data:application/json;base64,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