"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
const util_1 = require("./private/util");
/**
 * Represents the Product Provisioning Artifact Template.
 */
class CloudFormationTemplate {
    /**
     * Template from URL
     * @param url The url that points to the provisioning artifacts template
     */
    static fromUrl(url) {
        return new CloudFormationUrlTemplate(url);
    }
    /**
     * Loads the provisioning artifacts template from a local disk path.
     *
     * @param path A file containing the provisioning artifacts
     */
    static fromAsset(path, options) {
        return new CloudFormationAssetTemplate(path, options);
    }
    /**
     * Creates a product with the resources defined in the given product stack.
     */
    static fromProductStack(productStack) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_alpha_ProductStack(productStack);
        return new CloudFormationProductStackTemplate(productStack);
    }
}
exports.CloudFormationTemplate = CloudFormationTemplate;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationTemplate[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.CloudFormationTemplate", version: "2.20.0-alpha.0" };
/**
 * Template code from a Url.
 */
class CloudFormationUrlTemplate extends CloudFormationTemplate {
    constructor(url) {
        super();
        this.url = url;
    }
    bind(_scope) {
        return {
            httpUrl: this.url,
        };
    }
}
/**
 * Template from a local file.
 */
class CloudFormationAssetTemplate extends CloudFormationTemplate {
    /**
     * @param path The path to the asset file.
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new s3_assets.Asset(scope, `Template${util_1.hashValues(this.path)}`, {
                path: this.path,
                ...this.options,
            });
        }
        return {
            httpUrl: this.asset.httpUrl,
        };
    }
}
/**
 * Template from a CDK defined product stack.
 */
class CloudFormationProductStackTemplate extends CloudFormationTemplate {
    /**
     * @param stack A service catalog product stack.
    */
    constructor(productStack) {
        super();
        this.productStack = productStack;
    }
    bind(_scope) {
        return {
            httpUrl: this.productStack._getTemplateUrl(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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