import { ResourceDefaultNaming, ResourceNamingType } from '@gammarers/aws-resource-naming';
import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
export interface ResourceCustomNaming {
    readonly type: ResourceNamingType.CUSTOM;
    readonly functionName: string;
    readonly functionRoleName: string;
}
export type ResourceNamingOption = ResourceDefaultNaming | ResourceCustomNaming;
export interface SNSSlackMessageLambdaSubscriptionProps {
    readonly topic: sns.ITopic;
    readonly slackWebhookSecretName: string;
    readonly resourceNamingOption?: ResourceNamingOption;
}
export declare class SNSSlackMessageLambdaSubscription extends Construct {
    constructor(scope: Construct, id: string, props: SNSSlackMessageLambdaSubscriptionProps);
}
