"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const webhook_1 = require("@slack/webhook");
const axios_1 = require("axios");
const SECRET_MANAGER_GET_URL = 'http://localhost:2773/secretsmanager/get';
const AWS_SESSION_TOKEN = process.env.AWS_SESSION_TOKEN || '';
class NotSetSecretStringError extends Error {
    constructor() {
        super('get object is empty');
        this.name = 'NotSetSecretStringError';
    }
}
const handler = async (event, context) => {
    console.log({ event, context });
    const axiosRequestConfig = {
        params: {
            secretId: encodeURIComponent(process.env.SLACK_WEBOOK_SECRET_NAME), // require URI Encord "/"
            // withDecryption: true,
        },
        headers: {
            'X-Aws-Parameters-Secrets-Token': AWS_SESSION_TOKEN,
        },
    };
    let slackWebhookSecrets = null;
    return axios_1.default.get(SECRET_MANAGER_GET_URL, axiosRequestConfig)
        .then((value) => {
        slackWebhookSecrets = JSON.parse(value.data.SecretString);
        if (!slackWebhookSecrets) {
            throw new NotSetSecretStringError();
        }
        const webhook = new webhook_1.IncomingWebhook(`https://hooks.slack.com/services/${slackWebhookSecrets.Workspace}/${slackWebhookSecrets.Channel}/${slackWebhookSecrets.Webhook}`);
        const promises = event.Records.map((record) => {
            const id = record.Sns.MessageId;
            console.log({ MessageId: id });
            //const subject = record.Sns.Subject;
            const message = record.Sns.Message;
            const jsonMessage = JSON.parse(message);
            return webhook.send(jsonMessage);
        });
        return Promise.all(promises);
    })
        .then((results) => {
        console.info({ Succeed: 'Webhook Sent', results });
    })
        .catch((error) => {
        throw error;
    });
};
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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