from setuptools import setup, find_packages
import build_utils as _bu
VERSION = '2.10.68'
DESCRIPTION = 'Colemen Utils'
LONG_DESCRIPTION = 'Colemen Utils is a composite library of shit I find useful.'


_bu.purge_dist()

# Setting up
setup(
    # the name must match the folder name 'verysimplemodule'
    name="colemen_utils",
    version=VERSION,
    author="Colemen Atwood",
    author_email="<atwoodcolemen@gmail.com>",
    description=DESCRIPTION,
    long_description=LONG_DESCRIPTION,
    packages=find_packages(),
    py_modules=[
        'colemen_utils',
        'colemen_config',
        'colemen_utilities.console_utils',
        'colemen_utilities.console_utils.print',
        'colemen_utilities.database_utils',
        'colemen_utilities.database_utils.DatabaseManager',
        'colemen_utilities.database_utils.MySQL',
        'colemen_utilities.database_utils.MySQL.CacheFile',
        'colemen_utilities.database_utils.MySQL.Column',
        'colemen_utilities.database_utils.MySQL.Column.Column',
        'colemen_utilities.database_utils.MySQL.Column.column_utils',
        'colemen_utilities.database_utils.MySQL.MySQLDatabase',
        'colemen_utilities.database_utils.MySQL.Table',
        'colemen_utilities.database_utils.MySQL.Table.Table',
        'colemen_utilities.database_utils.MySQL.InsertQuery',
        'colemen_utilities.database_utils.MySQL.SelectQuery',
        'colemen_utilities.database_utils.MySQL.UpdateQuery',
        'colemen_utilities.database_utils.MySQL.DeleteQuery',
        'colemen_utilities.database_utils.MySQL.QueryBase',
        'colemen_utilities.database_utils.TableDataManager',
        'colemen_utilities.database_utils.TableManager',
        'colemen_utilities.database_utils.drawio',
        'colemen_utilities.database_utils.drawio.ForeignKey',
        'colemen_utilities.database_utils.drawio.Parser',
        'colemen_utilities.database_utils.drawio.Row',
        'colemen_utilities.database_utils.drawio.Schema',
        'colemen_utilities.database_utils.drawio.Table',
        'colemen_utilities.database_utils.drawio.entity_utils',
        'colemen_utilities.dict_utils',
        'colemen_utilities.dict_utils.dict_utils',
        'colemen_utilities.directory_utils',
        'colemen_utilities.directory_utils.dir',
        'colemen_utilities.directory_utils.dir_compression',
        'colemen_utilities.directory_utils.dir_create',
        'colemen_utilities.directory_utils.dir_delete',
        'colemen_utilities.directory_utils.dir_read',
        'colemen_utilities.directory_utils.dir_search',
        'colemen_utilities.drawio',
        'colemen_utilities.drawio.Connector',
        'colemen_utilities.drawio.Diagram',
        'colemen_utilities.drawio.Drawing',
        'colemen_utilities.drawio.Mxcell',
        'colemen_utilities.drawio.NodeBase',
        'colemen_utilities.drawio.Onode',
        'colemen_utilities.drawio.diagram_utils',
        'colemen_utilities.drawio.nodes',
        'colemen_utilities.file_utils',
        'colemen_utilities.file_utils.File',
        'colemen_utilities.file_utils.exiftool',
        'colemen_utilities.file_utils.file_compression',
        'colemen_utilities.file_utils.file_convert',
        'colemen_utilities.file_utils.file_image',
        'colemen_utilities.file_utils.file_read',
        'colemen_utilities.file_utils.file_search',
        'colemen_utilities.file_utils.file_string_facade',
        'colemen_utilities.file_utils.file_utils',
        'colemen_utilities.file_utils.file_write',
        'colemen_utilities.file_utils.resources',
        'colemen_utilities.list_utils',
        'colemen_utilities.list_utils.list_utils',
        'colemen_utilities.parse_sql',
        'colemen_utilities.parse_utils',
        'colemen_utilities.random_utils',
        'colemen_utilities.random_utils.rand_generation',
        'colemen_utilities.random_utils.rand_utils',
        'colemen_utilities.sql_utils',
        'colemen_utilities.sql_utils.sql_format',
        'colemen_utilities.sql_utils.sql_parse',
        'colemen_utilities.sql_utils.sql_utils',
        'colemen_utilities.string_utils',
        'colemen_utilities.string_utils.string_conversion',
        'colemen_utilities.string_utils.string_escaping',
        'colemen_utilities.string_utils.string_format',
        'colemen_utilities.string_utils.string_generation',
        'colemen_utilities.string_utils.string_parsing',
        'colemen_utilities.string_utils.string_strip',
        'colemen_utilities.string_utils.Name',
        'colemen_utilities.type_utils',
        'colemen_utilities.type_utils.type_utils',
        'colemen_utilities.validate_utils',
        'colemen_utilities.validate_utils.cerberus',
        'colemen_utilities.validate_utils.general',
    ],
    # add any additional packages that
    # need to be installed along with your package. Eg: 'caer'
    install_requires=[
        'secure_delete',
        'ftputil',
        'ffmpeg-python',
        'pillow',
        'faker',
        'iptcinfo3',
        'patool',
        'pyparsing',
        'sqlparse',
        'colorama',
        'lxml',
        'mysql-connector-python',
        'exrex',
        'pyyaml',
        'inflect',
        'cerberus',
    ],

    keywords=['python'],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Education",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)

