# 3D Point Cloud Kernels
Pytorch CPU and CUDA kernels for spatial search and interpolation for 3D point clouds.

## Installation
Requires torch version 1.0 or higher. To install a specific version replace the version number with a given tag.
```
pip install git+https://github.com/nicolas-chaulet/torch-points-kernels.git#v0.5.0
```
or with poetry:
```
poetry add git+https://github.com/nicolas-chaulet/torch-points.git#v0.5.0
```

## Usage
```
import torch
import torch_points_kernels.points_cuda
```

## Build and test
```
python setup.py build_ext --inplace
python -m unittest
```

## Projects using those kernels.

[```Pytorch Point Cloud Benchmark```](https://github.com/nicolas-chaulet/deeppointcloud-benchmarks)

## Credit

* [```Pointnet2_Tensorflow```](https://github.com/charlesq34/pointnet2) by [Charles R. Qi](https://github.com/charlesq34)

* [```Pointnet2_PyTorch```](https://github.com/erikwijmans/Pointnet2_PyTorch) by [Erik Wijmans](https://github.com/erikwijmans)
