#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['hue', 'hue.api', 'hue.cli']

package_data = \
{'': ['*']}

install_requires = \
['httpx ~=0.18.2', 'typer[all] ~=0.3.2', 'rich ~=10.4.0']

extras_require = \
{'dev': ['black', 'coverage', 'flake8', 'pre-commit', 'tox'],
 'doc': ['mkdocs', 'mkdocs-material', 'mkdocstrings'],
 'test': ['pytest ~=6.2.4',
          'pytest-asyncio',
          'pytest-mock',
          'pytest-cov',
          'Faker']}

entry_points = \
{'console_scripts': ['hue = hue.cli:app']}

setup(name='hue-api',
      version='0.4.1',
      description='Async API for controlling Hue Lights',
      author='Nirantak Raghav',
      author_email='hey@nirantak.com',
      url='https://github.com/nirantak/hue-api',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.8',
     )
