# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import os
import sys
import unittest

import mparticle
from mparticle.rest import ApiException
from mparticle.models.device_information import DeviceInformation


class TestDeviceInformation(unittest.TestCase):
    """ DeviceInformation unit test stubs """

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testValidateUUID(self):
        model = mparticle.models.device_information.DeviceInformation()
        self.assertIsNotNone(model.validateUUID(""))
        self.assertIsNotNone(model.validateUUID("this is not valid"))
        self.assertIsNotNone(model.validateUUID("a8098c1z-f86e-11da-bd1a-00112444be1e"))

        self.assertIsNone(None)
        self.assertIsNone(model.validateUUID("a8098c1a-f86e-11da-bd1a-00112444be1e"))
        self.assertIsNone(model.validateUUID("a8098c1a-f86e-11da-bd1a-00112444be1e".upper()))
        self.assertIsNone(model.validateUUID("a8098c1af86e11dabd1a00112444be1e"))

    def testInvalidIDFA(self):
        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation(ios_advertising_id="anything")

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation()
            model.ios_advertising_id = "anything"

    def testInvalidIDFV(self):

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation(ios_idfv="anything")

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation()
            model.ios_idfv = "anything"

    def testInvalidAAID(self):

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation(android_advertising_id="anything")

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation()
            model.android_advertising_id = "anything"

    def testInvalidFireID(self):

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation(fire_advertising_id="anything")

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation()
            model.fire_advertising_id = "anything"

    def testRokuAdID(self):

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation(roku_advertising_id="anything")

        with self.assertRaises(ValueError):
            model = mparticle.models.device_information.DeviceInformation()
            model.roku_advertising_id = "anything"



if __name__ == '__main__':
    unittest.main()
