# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class SourceInformation(object):

    def __init__(self, channel=None, partner=None, replay_request_id=None, replay_job_id=None):
        """
        SourceInformation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'channel': 'str',
            'partner': 'str',
            'replay_request_id': 'str',
            'replay_job_id': 'str'
        }

        self.attribute_map = {
            'channel': 'channel',
            'partner': 'partner',
            'replay_request_id': 'replay_request_id',
            'replay_job_id': 'replay_job_id'
        }

        self._channel = channel
        self._partner = partner
        self._replay_request_id = replay_request_id
        self._replay_job_id = replay_job_id

    @property
    def channel(self):
        """
        Gets the channel of this SourceInformation.


        :return: The channel of this SourceInformation.
        :rtype: str
        """
        return self._channel

    @channel.setter
    def channel(self, channel):
        """
        Sets the channel of this SourceInformation.


        :param channel: The channel of this SourceInformation.
        :type: str
        """
        allowed_values = ["unknown", "native", "javascript", "pixel", "desktop", "partner", "server_to_server", "All"]
        if channel not in allowed_values:
            raise ValueError(
                "Invalid value for `channel` ({0}), must be one of {1}"
                .format(channel, allowed_values)
            )

        self._channel = channel

    @property
    def partner(self):
        """
        Gets the partner of this SourceInformation.


        :return: The partner of this SourceInformation.
        :rtype: str
        """
        return self._partner

    @partner.setter
    def partner(self, partner):
        """
        Sets the partner of this SourceInformation.


        :param partner: The partner of this SourceInformation.
        :type: str
        """

        self._partner = partner

    @property
    def replay_request_id(self):
        """
        Gets the replay_request_id of this SourceInformation.


        :return: The replay_request_id of this SourceInformation.
        :rtype: str
        """
        return self._replay_request_id

    @replay_request_id.setter
    def replay_request_id(self, replay_request_id):
        """
        Sets the replay_request_id of this SourceInformation.


        :param replay_request_id: The replay_request_id of this SourceInformation.
        :type: str
        """

        self._replay_request_id = replay_request_id

    @property
    def replay_job_id(self):
        """
        Gets the replay_job_id of this SourceInformation.


        :return: The replay_job_id of this SourceInformation.
        :rtype: str
        """
        return self._replay_job_id

    @replay_job_id.setter
    def replay_job_id(self, replay_job_id):
        """
        Sets the replay_job_id of this SourceInformation.


        :param replay_job_id: The replay_job_id of this SourceInformation.
        :type: str
        """

        self._replay_job_id = replay_job_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
