# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class NetworkPerformanceEvent(object):

    def __init__(self, timestamp_unixtime_ms=None, event_id=None, source_message_id=None, session_id=None, session_uuid=None, custom_attributes=None, location=None, device_current_state=None, http_verb=None, url=None, time_elapsed=None, bytes_in=None, bytes_out=None, response_code=None, data=None):
        """
        NetworkPerformanceEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp_unixtime_ms': 'int',
            'event_id': 'int',
            'source_message_id': 'str',
            'session_id': 'int',
            'session_uuid': 'str',
            'custom_attributes': 'dict(str, str)',
            'location': 'GeoLocation',
            'device_current_state': 'DeviceCurrentState',
            'http_verb': 'str',
            'url': 'str',
            'time_elapsed': 'int',
            'bytes_in': 'int',
            'bytes_out': 'int',
            'response_code': 'int',
            'data': 'str'
        }

        self.attribute_map = {
            'timestamp_unixtime_ms': 'timestamp_unixtime_ms',
            'event_id': 'event_id',
            'source_message_id': 'source_message_id',
            'session_id': 'session_id',
            'session_uuid': 'session_uuid',
            'custom_attributes': 'custom_attributes',
            'location': 'location',
            'device_current_state': 'device_current_state',
            'http_verb': 'http_verb',
            'url': 'url',
            'time_elapsed': 'time_elapsed',
            'bytes_in': 'bytes_in',
            'bytes_out': 'bytes_out',
            'response_code': 'response_code',
            'data': 'data'
        }

        self._timestamp_unixtime_ms = timestamp_unixtime_ms
        self._event_id = event_id
        self._source_message_id = source_message_id
        self._session_id = session_id
        self._session_uuid = session_uuid
        self._custom_attributes = custom_attributes
        self._location = location
        self._device_current_state = device_current_state
        self._http_verb = http_verb
        self._url = url
        self._time_elapsed = time_elapsed
        self._bytes_in = bytes_in
        self._bytes_out = bytes_out
        self._response_code = response_code
        self._data = data

    @property
    def timestamp_unixtime_ms(self):
        """
        Gets the timestamp_unixtime_ms of this NetworkPerformanceEvent.


        :return: The timestamp_unixtime_ms of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._timestamp_unixtime_ms

    @timestamp_unixtime_ms.setter
    def timestamp_unixtime_ms(self, timestamp_unixtime_ms):
        """
        Sets the timestamp_unixtime_ms of this NetworkPerformanceEvent.


        :param timestamp_unixtime_ms: The timestamp_unixtime_ms of this NetworkPerformanceEvent.
        :type: int
        """

        self._timestamp_unixtime_ms = timestamp_unixtime_ms

    @property
    def event_id(self):
        """
        Gets the event_id of this NetworkPerformanceEvent.


        :return: The event_id of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this NetworkPerformanceEvent.


        :param event_id: The event_id of this NetworkPerformanceEvent.
        :type: int
        """

        self._event_id = event_id

    @property
    def source_message_id(self):
        """
        Gets the source_message_id of this NetworkPerformanceEvent.


        :return: The source_message_id of this NetworkPerformanceEvent.
        :rtype: str
        """
        return self._source_message_id

    @source_message_id.setter
    def source_message_id(self, source_message_id):
        """
        Sets the source_message_id of this NetworkPerformanceEvent.


        :param source_message_id: The source_message_id of this NetworkPerformanceEvent.
        :type: str
        """

        self._source_message_id = source_message_id

    @property
    def session_id(self):
        """
        Gets the session_id of this NetworkPerformanceEvent.


        :return: The session_id of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this NetworkPerformanceEvent.


        :param session_id: The session_id of this NetworkPerformanceEvent.
        :type: int
        """

        self._session_id = session_id

    @property
    def session_uuid(self):
        """
        Gets the session_uuid of this NetworkPerformanceEvent.


        :return: The session_uuid of this NetworkPerformanceEvent.
        :rtype: str
        """
        return self._session_uuid

    @session_uuid.setter
    def session_uuid(self, session_uuid):
        """
        Sets the session_uuid of this NetworkPerformanceEvent.


        :param session_uuid: The session_uuid of this NetworkPerformanceEvent.
        :type: str
        """

        self._session_uuid = session_uuid

    @property
    def custom_attributes(self):
        """
        Gets the custom_attributes of this NetworkPerformanceEvent.


        :return: The custom_attributes of this NetworkPerformanceEvent.
        :rtype: dict(str, str)
        """
        return self._custom_attributes

    @custom_attributes.setter
    def custom_attributes(self, custom_attributes):
        """
        Sets the custom_attributes of this NetworkPerformanceEvent.


        :param custom_attributes: The custom_attributes of this NetworkPerformanceEvent.
        :type: dict(str, str)
        """

        self._custom_attributes = custom_attributes

    @property
    def location(self):
        """
        Gets the location of this NetworkPerformanceEvent.


        :return: The location of this NetworkPerformanceEvent.
        :rtype: GeoLocation
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this NetworkPerformanceEvent.


        :param location: The location of this NetworkPerformanceEvent.
        :type: GeoLocation
        """

        self._location = location

    @property
    def device_current_state(self):
        """
        Gets the device_current_state of this NetworkPerformanceEvent.


        :return: The device_current_state of this NetworkPerformanceEvent.
        :rtype: DeviceCurrentState
        """
        return self._device_current_state

    @device_current_state.setter
    def device_current_state(self, device_current_state):
        """
        Sets the device_current_state of this NetworkPerformanceEvent.


        :param device_current_state: The device_current_state of this NetworkPerformanceEvent.
        :type: DeviceCurrentState
        """

        self._device_current_state = device_current_state

    @property
    def http_verb(self):
        """
        Gets the http_verb of this NetworkPerformanceEvent.


        :return: The http_verb of this NetworkPerformanceEvent.
        :rtype: str
        """
        return self._http_verb

    @http_verb.setter
    def http_verb(self, http_verb):
        """
        Sets the http_verb of this NetworkPerformanceEvent.


        :param http_verb: The http_verb of this NetworkPerformanceEvent.
        :type: str
        """

        self._http_verb = http_verb

    @property
    def url(self):
        """
        Gets the url of this NetworkPerformanceEvent.


        :return: The url of this NetworkPerformanceEvent.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this NetworkPerformanceEvent.


        :param url: The url of this NetworkPerformanceEvent.
        :type: str
        """

        self._url = url

    @property
    def time_elapsed(self):
        """
        Gets the time_elapsed of this NetworkPerformanceEvent.


        :return: The time_elapsed of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._time_elapsed

    @time_elapsed.setter
    def time_elapsed(self, time_elapsed):
        """
        Sets the time_elapsed of this NetworkPerformanceEvent.


        :param time_elapsed: The time_elapsed of this NetworkPerformanceEvent.
        :type: int
        """

        self._time_elapsed = time_elapsed

    @property
    def bytes_in(self):
        """
        Gets the bytes_in of this NetworkPerformanceEvent.


        :return: The bytes_in of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._bytes_in

    @bytes_in.setter
    def bytes_in(self, bytes_in):
        """
        Sets the bytes_in of this NetworkPerformanceEvent.


        :param bytes_in: The bytes_in of this NetworkPerformanceEvent.
        :type: int
        """

        self._bytes_in = bytes_in

    @property
    def bytes_out(self):
        """
        Gets the bytes_out of this NetworkPerformanceEvent.


        :return: The bytes_out of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._bytes_out

    @bytes_out.setter
    def bytes_out(self, bytes_out):
        """
        Sets the bytes_out of this NetworkPerformanceEvent.


        :param bytes_out: The bytes_out of this NetworkPerformanceEvent.
        :type: int
        """

        self._bytes_out = bytes_out

    @property
    def response_code(self):
        """
        Gets the response_code of this NetworkPerformanceEvent.


        :return: The response_code of this NetworkPerformanceEvent.
        :rtype: int
        """
        return self._response_code

    @response_code.setter
    def response_code(self, response_code):
        """
        Sets the response_code of this NetworkPerformanceEvent.


        :param response_code: The response_code of this NetworkPerformanceEvent.
        :type: int
        """

        self._response_code = response_code

    @property
    def data(self):
        """
        Gets the data of this NetworkPerformanceEvent.


        :return: The data of this NetworkPerformanceEvent.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this NetworkPerformanceEvent.


        :param data: The data of this NetworkPerformanceEvent.
        :type: str
        """

        self._data = data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
