# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class CCPAConsentState(object):
    def __init__(self, document=None, consented=None, timestamp_unixtime_ms=None, location=None, hardware_id=None):
        """
        CCPAConsentState - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document': 'str',
            'consented': 'bool',
            'timestamp_unixtime_ms': 'int',
            'location': 'str',
            'hardware_id': 'str'
        }

        self.attribute_map = {
            'document': 'document',
            'consented': 'consented',
            'timestamp_unixtime_ms': 'timestamp_unixtime_ms',
            'location': 'location',
            'hardware_id': 'hardware_id'
        }

        self.document = document
        self.consented = consented
        self.timestamp_unixtime_ms = timestamp_unixtime_ms
        self.location = location
        self.hardware_id = hardware_id

    @property
    def document(self):
        """
        Gets the document of this CCPAConsentState

        :return The document of this CCPAConsentState
        :rtype str
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this CCPA Consent State.


        :param document: The document of this CCPA Consent State.
        :type: str
        """

        self._document = document

    @property
    def consented(self):
        """
        Gets the consented of this CCPAConsentState

        :return The consented of this CCPAConsentState
        :rtype str
        """
        return self._consented

    @consented.setter
    def consented(self, consented):
        """
        Sets the consented of this CCPA Consent State.


        :param consented: The consented of this CCPA Consent State.
        :type: str
        """

        self._consented = consented

    @property
    def timestamp_unixtime_ms(self):
        """
        Gets the timestamp_unixtime_ms of this CCPAConsentState

        :return The timestamp_unixtime_ms of this CCPAConsentState
        :rtype str
        """
        return self._timestamp_unixtime_ms

    @timestamp_unixtime_ms.setter
    def timestamp_unixtime_ms(self, timestamp_unixtime_ms):
        """
        Sets the timestamp_unixtime_ms of this CCPA Consent State.


        :param timestamp_unixtime_ms: The timestamp_unixtime_ms of this CCPA Consent State.
        :type: str
        """

        self._timestamp_unixtime_ms = timestamp_unixtime_ms

    @property
    def location(self):
        """
        Gets the location of this CCPAConsentState

        :return The location of this CCPAConsentState
        :rtype str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this CCPA Consent State.


        :param location: The location of this CCPA Consent State.
        :type: str
        """

        self._location = location

    @property
    def hardware_id(self):
        """
        Gets the hardware_id of this CCPAConsentState

        :return The hardware_id of this CCPAConsentState
        :rtype str
        """
        return self._hardware_id

    @hardware_id.setter
    def hardware_id(self, hardware_id):
        """
        Sets the hardware_id of this CCPA Consent State.


        :param hardware_id: The hardware_id of this CCPA Consent State.
        :type: str
        """

        self._hardware_id = hardware_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
