"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultOrigin = exports.TestOrigin = void 0;
const lib_1 = require("../lib");
/** Used for testing common Origin functionality */
class TestOrigin extends lib_1.OriginBase {
    constructor(domainName, props = {}) { super(domainName, props); }
    renderCustomOriginConfig() {
        return { originProtocolPolicy: lib_1.OriginProtocolPolicy.HTTPS_ONLY };
    }
}
exports.TestOrigin = TestOrigin;
function defaultOrigin(domainName) {
    return new TestOrigin(domainName !== null && domainName !== void 0 ? domainName : 'www.example.com');
}
exports.defaultOrigin = defaultOrigin;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxnQ0FBaUc7QUFFakcsbURBQW1EO0FBQ25ELE1BQWEsVUFBVyxTQUFRLGdCQUFVO0lBQ3hDLFlBQVksVUFBa0IsRUFBRSxRQUFxQixFQUFFLElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUUsd0JBQXdCO1FBQ2hDLE9BQU8sRUFBRSxvQkFBb0IsRUFBRSwwQkFBb0IsQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUNuRSxDQUFDO0NBQ0Y7QUFMRCxnQ0FLQztBQUVELFNBQWdCLGFBQWEsQ0FBQyxVQUFtQjtJQUMvQyxPQUFPLElBQUksVUFBVSxDQUFDLFVBQVUsYUFBVixVQUFVLGNBQVYsVUFBVSxHQUFJLGlCQUFpQixDQUFDLENBQUM7QUFDekQsQ0FBQztBQUZELHNDQUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2ZuRGlzdHJpYnV0aW9uLCBJT3JpZ2luLCBPcmlnaW5CYXNlLCBPcmlnaW5Qcm9wcywgT3JpZ2luUHJvdG9jb2xQb2xpY3kgfSBmcm9tICcuLi9saWInO1xuXG4vKiogVXNlZCBmb3IgdGVzdGluZyBjb21tb24gT3JpZ2luIGZ1bmN0aW9uYWxpdHkgKi9cbmV4cG9ydCBjbGFzcyBUZXN0T3JpZ2luIGV4dGVuZHMgT3JpZ2luQmFzZSB7XG4gIGNvbnN0cnVjdG9yKGRvbWFpbk5hbWU6IHN0cmluZywgcHJvcHM6IE9yaWdpblByb3BzID0ge30pIHsgc3VwZXIoZG9tYWluTmFtZSwgcHJvcHMpOyB9XG4gIHByb3RlY3RlZCByZW5kZXJDdXN0b21PcmlnaW5Db25maWcoKTogQ2ZuRGlzdHJpYnV0aW9uLkN1c3RvbU9yaWdpbkNvbmZpZ1Byb3BlcnR5IHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4geyBvcmlnaW5Qcm90b2NvbFBvbGljeTogT3JpZ2luUHJvdG9jb2xQb2xpY3kuSFRUUFNfT05MWSB9O1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBkZWZhdWx0T3JpZ2luKGRvbWFpbk5hbWU/OiBzdHJpbmcpOiBJT3JpZ2luIHtcbiAgcmV0dXJuIG5ldyBUZXN0T3JpZ2luKGRvbWFpbk5hbWUgPz8gJ3d3dy5leGFtcGxlLmNvbScpO1xufVxuIl19