# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Version(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, thumbnail_image=None, details_image=None, banner_image=None, description=None, rating_avg=None, rating_count=None, slug=None, account=None, name=None, type=None, title=None, pk=None, package=None, label=None, modified_date=None, created_date=None, user=None, validatorplan=None, is_set_canonical=None, canonical=None, validation_status=None):
        """
        Version - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'thumbnail_image': 'str',
            'details_image': 'str',
            'banner_image': 'str',
            'description': 'str',
            'rating_avg': 'float',
            'rating_count': 'float',
            'slug': 'str',
            'account': 'str',
            'name': 'str',
            'type': 'str',
            'title': 'str',
            'pk': 'int',
            'package': 'int',
            'label': 'str',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'user': 'str',
            'validatorplan': 'object',
            'is_set_canonical': 'int',
            'canonical': 'bool',
            'validation_status': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'thumbnail_image': 'thumbnail_image',
            'details_image': 'details_image',
            'banner_image': 'banner_image',
            'description': 'description',
            'rating_avg': 'rating_avg',
            'rating_count': 'rating_count',
            'slug': 'slug',
            'account': 'account',
            'name': 'name',
            'type': 'type',
            'title': 'title',
            'pk': 'pk',
            'package': 'package',
            'label': 'label',
            'modified_date': 'modified_date',
            'created_date': 'created_date',
            'user': 'user',
            'validatorplan': 'validatorplan',
            'is_set_canonical': 'is_set_canonical',
            'canonical': 'canonical',
            'validation_status': 'validation_status'
        }

        self._href = href
        self._thumbnail_image = thumbnail_image
        self._details_image = details_image
        self._banner_image = banner_image
        self._description = description
        self._rating_avg = rating_avg
        self._rating_count = rating_count
        self._slug = slug
        self._account = account
        self._name = name
        self._type = type
        self._title = title
        self._pk = pk
        self._package = package
        self._label = label
        self._modified_date = modified_date
        self._created_date = created_date
        self._user = user
        self._validatorplan = validatorplan
        self._is_set_canonical = is_set_canonical
        self._canonical = canonical
        self._validation_status = validation_status

    @property
    def href(self):
        """
        Gets the href of this Version.
        current object reference url

        :return: The href of this Version.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this Version.
        current object reference url

        :param href: The href of this Version.
        :type: str
        """

        self._href = href

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this Version.
        

        :return: The thumbnail_image of this Version.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this Version.
        

        :param thumbnail_image: The thumbnail_image of this Version.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def details_image(self):
        """
        Gets the details_image of this Version.
        

        :return: The details_image of this Version.
        :rtype: str
        """
        return self._details_image

    @details_image.setter
    def details_image(self, details_image):
        """
        Sets the details_image of this Version.
        

        :param details_image: The details_image of this Version.
        :type: str
        """

        self._details_image = details_image

    @property
    def banner_image(self):
        """
        Gets the banner_image of this Version.
        Banner image of package

        :return: The banner_image of this Version.
        :rtype: str
        """
        return self._banner_image

    @banner_image.setter
    def banner_image(self, banner_image):
        """
        Sets the banner_image of this Version.
        Banner image of package

        :param banner_image: The banner_image of this Version.
        :type: str
        """

        self._banner_image = banner_image

    @property
    def description(self):
        """
        Gets the description of this Version.
        package description.

        :return: The description of this Version.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Version.
        package description.

        :param description: The description of this Version.
        :type: str
        """

        self._description = description

    @property
    def rating_avg(self):
        """
        Gets the rating_avg of this Version.
        average rating of package.

        :return: The rating_avg of this Version.
        :rtype: float
        """
        return self._rating_avg

    @rating_avg.setter
    def rating_avg(self, rating_avg):
        """
        Sets the rating_avg of this Version.
        average rating of package.

        :param rating_avg: The rating_avg of this Version.
        :type: float
        """

        self._rating_avg = rating_avg

    @property
    def rating_count(self):
        """
        Gets the rating_count of this Version.
        package total rating submitted.

        :return: The rating_count of this Version.
        :rtype: float
        """
        return self._rating_count

    @rating_count.setter
    def rating_count(self, rating_count):
        """
        Sets the rating_count of this Version.
        package total rating submitted.

        :param rating_count: The rating_count of this Version.
        :type: float
        """

        self._rating_count = rating_count

    @property
    def slug(self):
        """
        Gets the slug of this Version.
        value used to uniquely identify package.

        :return: The slug of this Version.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this Version.
        value used to uniquely identify package.

        :param slug: The slug of this Version.
        :type: str
        """

        self._slug = slug

    @property
    def account(self):
        """
        Gets the account of this Version.
        value used to uniquely identify account.

        :return: The account of this Version.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Version.
        value used to uniquely identify account.

        :param account: The account of this Version.
        :type: str
        """

        self._account = account

    @property
    def name(self):
        """
        Gets the name of this Version.
        package name.

        :return: The name of this Version.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Version.
        package name.

        :param name: The name of this Version.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this Version.
        package type

        :return: The type of this Version.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Version.
        package type

        :param type: The type of this Version.
        :type: str
        """

        self._type = type

    @property
    def title(self):
        """
        Gets the title of this Version.
        package title.

        :return: The title of this Version.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Version.
        package title.

        :param title: The title of this Version.
        :type: str
        """

        self._title = title

    @property
    def pk(self):
        """
        Gets the pk of this Version.
        unique identifier of version.

        :return: The pk of this Version.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this Version.
        unique identifier of version.

        :param pk: The pk of this Version.
        :type: int
        """

        self._pk = pk

    @property
    def package(self):
        """
        Gets the package of this Version.
        package pk.

        :return: The package of this Version.
        :rtype: int
        """
        return self._package

    @package.setter
    def package(self, package):
        """
        Sets the package of this Version.
        package pk.

        :param package: The package of this Version.
        :type: int
        """

        self._package = package

    @property
    def label(self):
        """
        Gets the label of this Version.
        version label.

        :return: The label of this Version.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Version.
        version label.

        :param label: The label of this Version.
        :type: str
        """

        self._label = label

    @property
    def modified_date(self):
        """
        Gets the modified_date of this Version.
        last modified date.

        :return: The modified_date of this Version.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this Version.
        last modified date.

        :param modified_date: The modified_date of this Version.
        :type: datetime
        """

        self._modified_date = modified_date

    @property
    def created_date(self):
        """
        Gets the created_date of this Version.
        package version creation date.

        :return: The created_date of this Version.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this Version.
        package version creation date.

        :param created_date: The created_date of this Version.
        :type: datetime
        """

        self._created_date = created_date

    @property
    def user(self):
        """
        Gets the user of this Version.
        package creator name.

        :return: The user of this Version.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this Version.
        package creator name.

        :param user: The user of this Version.
        :type: str
        """

        self._user = user

    @property
    def validatorplan(self):
        """
        Gets the validatorplan of this Version.
        Detail view of Validatorplan of package.

        :return: The validatorplan of this Version.
        :rtype: object
        """
        return self._validatorplan

    @validatorplan.setter
    def validatorplan(self, validatorplan):
        """
        Sets the validatorplan of this Version.
        Detail view of Validatorplan of package.

        :param validatorplan: The validatorplan of this Version.
        :type: object
        """

        self._validatorplan = validatorplan

    @property
    def is_set_canonical(self):
        """
        Gets the is_set_canonical of this Version.
        flag to know if canonical version was set by user

        :return: The is_set_canonical of this Version.
        :rtype: int
        """
        return self._is_set_canonical

    @is_set_canonical.setter
    def is_set_canonical(self, is_set_canonical):
        """
        Sets the is_set_canonical of this Version.
        flag to know if canonical version was set by user

        :param is_set_canonical: The is_set_canonical of this Version.
        :type: int
        """

        self._is_set_canonical = is_set_canonical

    @property
    def canonical(self):
        """
        Gets the canonical of this Version.
        canonical boolean value

        :return: The canonical of this Version.
        :rtype: bool
        """
        return self._canonical

    @canonical.setter
    def canonical(self, canonical):
        """
        Sets the canonical of this Version.
        canonical boolean value

        :param canonical: The canonical of this Version.
        :type: bool
        """

        self._canonical = canonical

    @property
    def validation_status(self):
        """
        Gets the validation_status of this Version.
        current validation status based on badge results and validation plans passing level

        :return: The validation_status of this Version.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this Version.
        current validation status based on badge results and validation plans passing level

        :param validation_status: The validation_status of this Version.
        :type: str
        """

        self._validation_status = validation_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
