# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ValidatorSetsInBadge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, badge_name=None, badge_slug=None, description=None, mandatory_for=None, message=None, modified_date=None, created_date=None, list_of_validator_sets=None):
        """
        ValidatorSetsInBadge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'badge_name': 'str',
            'badge_slug': 'str',
            'description': 'str',
            'mandatory_for': 'list[str]',
            'message': 'str',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'list_of_validator_sets': 'list[list[ValidatorDetail]]'
        }

        self.attribute_map = {
            'badge_name': 'badge_name',
            'badge_slug': 'badge_slug',
            'description': 'description',
            'mandatory_for': 'mandatory_for',
            'message': 'message',
            'modified_date': 'modified_date',
            'created_date': 'created_date',
            'list_of_validator_sets': 'list_of_validator_sets'
        }

        self._badge_name = badge_name
        self._badge_slug = badge_slug
        self._description = description
        self._mandatory_for = mandatory_for
        self._message = message
        self._modified_date = modified_date
        self._created_date = created_date
        self._list_of_validator_sets = list_of_validator_sets

    @property
    def badge_name(self):
        """
        Gets the badge_name of this ValidatorSetsInBadge.
        badge name/title

        :return: The badge_name of this ValidatorSetsInBadge.
        :rtype: str
        """
        return self._badge_name

    @badge_name.setter
    def badge_name(self, badge_name):
        """
        Sets the badge_name of this ValidatorSetsInBadge.
        badge name/title

        :param badge_name: The badge_name of this ValidatorSetsInBadge.
        :type: str
        """

        self._badge_name = badge_name

    @property
    def badge_slug(self):
        """
        Gets the badge_slug of this ValidatorSetsInBadge.
        badge slug

        :return: The badge_slug of this ValidatorSetsInBadge.
        :rtype: str
        """
        return self._badge_slug

    @badge_slug.setter
    def badge_slug(self, badge_slug):
        """
        Sets the badge_slug of this ValidatorSetsInBadge.
        badge slug

        :param badge_slug: The badge_slug of this ValidatorSetsInBadge.
        :type: str
        """

        self._badge_slug = badge_slug

    @property
    def description(self):
        """
        Gets the description of this ValidatorSetsInBadge.
        description representing the badge

        :return: The description of this ValidatorSetsInBadge.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ValidatorSetsInBadge.
        description representing the badge

        :param description: The description of this ValidatorSetsInBadge.
        :type: str
        """

        self._description = description

    @property
    def mandatory_for(self):
        """
        Gets the mandatory_for of this ValidatorSetsInBadge.
        Actions for which badge is mandatory

        :return: The mandatory_for of this ValidatorSetsInBadge.
        :rtype: list[str]
        """
        return self._mandatory_for

    @mandatory_for.setter
    def mandatory_for(self, mandatory_for):
        """
        Sets the mandatory_for of this ValidatorSetsInBadge.
        Actions for which badge is mandatory

        :param mandatory_for: The mandatory_for of this ValidatorSetsInBadge.
        :type: list[str]
        """

        self._mandatory_for = mandatory_for

    @property
    def message(self):
        """
        Gets the message of this ValidatorSetsInBadge.
        message regarding badge

        :return: The message of this ValidatorSetsInBadge.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ValidatorSetsInBadge.
        message regarding badge

        :param message: The message of this ValidatorSetsInBadge.
        :type: str
        """

        self._message = message

    @property
    def modified_date(self):
        """
        Gets the modified_date of this ValidatorSetsInBadge.
        last modified date.

        :return: The modified_date of this ValidatorSetsInBadge.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this ValidatorSetsInBadge.
        last modified date.

        :param modified_date: The modified_date of this ValidatorSetsInBadge.
        :type: datetime
        """

        self._modified_date = modified_date

    @property
    def created_date(self):
        """
        Gets the created_date of this ValidatorSetsInBadge.
        package draft creation date.

        :return: The created_date of this ValidatorSetsInBadge.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this ValidatorSetsInBadge.
        package draft creation date.

        :param created_date: The created_date of this ValidatorSetsInBadge.
        :type: datetime
        """

        self._created_date = created_date

    @property
    def list_of_validator_sets(self):
        """
        Gets the list_of_validator_sets of this ValidatorSetsInBadge.
        List of validator sets

        :return: The list_of_validator_sets of this ValidatorSetsInBadge.
        :rtype: list[list[ValidatorDetail]]
        """
        return self._list_of_validator_sets

    @list_of_validator_sets.setter
    def list_of_validator_sets(self, list_of_validator_sets):
        """
        Sets the list_of_validator_sets of this ValidatorSetsInBadge.
        List of validator sets

        :param list_of_validator_sets: The list_of_validator_sets of this ValidatorSetsInBadge.
        :type: list[list[ValidatorDetail]]
        """

        self._list_of_validator_sets = list_of_validator_sets

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
