# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ValidatorPlan(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, validations_completed=None, request_date=None, validators=None):
        """
        ValidatorPlan - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'validations_completed': 'bool',
            'request_date': 'datetime',
            'validators': 'object'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'validations_completed': 'validations_completed',
            'request_date': 'request_date',
            'validators': 'validators'
        }

        self._href = href
        self._pk = pk
        self._validations_completed = validations_completed
        self._request_date = request_date
        self._validators = validators

    @property
    def href(self):
        """
        Gets the href of this ValidatorPlan.
        current object reference url

        :return: The href of this ValidatorPlan.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this ValidatorPlan.
        current object reference url

        :param href: The href of this ValidatorPlan.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this ValidatorPlan.
        value used to uniquely identify validatorplan.

        :return: The pk of this ValidatorPlan.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this ValidatorPlan.
        value used to uniquely identify validatorplan.

        :param pk: The pk of this ValidatorPlan.
        :type: int
        """

        self._pk = pk

    @property
    def validations_completed(self):
        """
        Gets the validations_completed of this ValidatorPlan.
        validation is completed or not.

        :return: The validations_completed of this ValidatorPlan.
        :rtype: bool
        """
        return self._validations_completed

    @validations_completed.setter
    def validations_completed(self, validations_completed):
        """
        Sets the validations_completed of this ValidatorPlan.
        validation is completed or not.

        :param validations_completed: The validations_completed of this ValidatorPlan.
        :type: bool
        """

        self._validations_completed = validations_completed

    @property
    def request_date(self):
        """
        Gets the request_date of this ValidatorPlan.
        request date for validator plan.

        :return: The request_date of this ValidatorPlan.
        :rtype: datetime
        """
        return self._request_date

    @request_date.setter
    def request_date(self, request_date):
        """
        Sets the request_date of this ValidatorPlan.
        request date for validator plan.

        :param request_date: The request_date of this ValidatorPlan.
        :type: datetime
        """

        self._request_date = request_date

    @property
    def validators(self):
        """
        Gets the validators of this ValidatorPlan.
        validators attached with validatorplan.

        :return: The validators of this ValidatorPlan.
        :rtype: object
        """
        return self._validators

    @validators.setter
    def validators(self, validators):
        """
        Sets the validators of this ValidatorPlan.
        validators attached with validatorplan.

        :param validators: The validators of this ValidatorPlan.
        :type: object
        """

        self._validators = validators

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
