# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Validator(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, status=None, description=None, framework=None, name=None, passed=None, score=None, error_messages=None, warning_messages=None):
        """
        Validator - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'status': 'str',
            'description': 'str',
            'framework': 'str',
            'name': 'str',
            'passed': 'bool',
            'score': 'int',
            'error_messages': 'str',
            'warning_messages': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'status': 'status',
            'description': 'description',
            'framework': 'framework',
            'name': 'name',
            'passed': 'passed',
            'score': 'score',
            'error_messages': 'error_messages',
            'warning_messages': 'warning_messages'
        }

        self._href = href
        self._status = status
        self._description = description
        self._framework = framework
        self._name = name
        self._passed = passed
        self._score = score
        self._error_messages = error_messages
        self._warning_messages = warning_messages

    @property
    def href(self):
        """
        Gets the href of this Validator.
        current object reference url

        :return: The href of this Validator.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this Validator.
        current object reference url

        :param href: The href of this Validator.
        :type: str
        """

        self._href = href

    @property
    def status(self):
        """
        Gets the status of this Validator.
        validator status.

        :return: The status of this Validator.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Validator.
        validator status.

        :param status: The status of this Validator.
        :type: str
        """

        self._status = status

    @property
    def description(self):
        """
        Gets the description of this Validator.
        validator description.

        :return: The description of this Validator.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Validator.
        validator description.

        :param description: The description of this Validator.
        :type: str
        """

        self._description = description

    @property
    def framework(self):
        """
        Gets the framework of this Validator.
        validator framework.

        :return: The framework of this Validator.
        :rtype: str
        """
        return self._framework

    @framework.setter
    def framework(self, framework):
        """
        Sets the framework of this Validator.
        validator framework.

        :param framework: The framework of this Validator.
        :type: str
        """

        self._framework = framework

    @property
    def name(self):
        """
        Gets the name of this Validator.
        validator name.

        :return: The name of this Validator.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Validator.
        validator name.

        :param name: The name of this Validator.
        :type: str
        """

        self._name = name

    @property
    def passed(self):
        """
        Gets the passed of this Validator.
        validator is passed or not.

        :return: The passed of this Validator.
        :rtype: bool
        """
        return self._passed

    @passed.setter
    def passed(self, passed):
        """
        Sets the passed of this Validator.
        validator is passed or not.

        :param passed: The passed of this Validator.
        :type: bool
        """

        self._passed = passed

    @property
    def score(self):
        """
        Gets the score of this Validator.
        validator score after validation.

        :return: The score of this Validator.
        :rtype: int
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this Validator.
        validator score after validation.

        :param score: The score of this Validator.
        :type: int
        """

        self._score = score

    @property
    def error_messages(self):
        """
        Gets the error_messages of this Validator.
        Error messages after validator run.

        :return: The error_messages of this Validator.
        :rtype: str
        """
        return self._error_messages

    @error_messages.setter
    def error_messages(self, error_messages):
        """
        Sets the error_messages of this Validator.
        Error messages after validator run.

        :param error_messages: The error_messages of this Validator.
        :type: str
        """

        self._error_messages = error_messages

    @property
    def warning_messages(self):
        """
        Gets the warning_messages of this Validator.
        warning messages after validator run.

        :return: The warning_messages of this Validator.
        :rtype: str
        """
        return self._warning_messages

    @warning_messages.setter
    def warning_messages(self, warning_messages):
        """
        Sets the warning_messages of this Validator.
        warning messages after validator run.

        :param warning_messages: The warning_messages of this Validator.
        :type: str
        """

        self._warning_messages = warning_messages

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
