# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class User(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, status=None, name=None, registered_date=None, user_name=None, slug=None, email=None, accounts=None, currentaccount=None, activationchallenge=None, verified=None, profile_picture=None, subscription=None):
        """
        User - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'status': 'str',
            'name': 'str',
            'registered_date': 'datetime',
            'user_name': 'str',
            'slug': 'str',
            'email': 'str',
            'accounts': 'object',
            'currentaccount': 'object',
            'activationchallenge': 'object',
            'verified': 'bool',
            'profile_picture': 'str',
            'subscription': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'status': 'status',
            'name': 'name',
            'registered_date': 'registered_date',
            'user_name': 'user_name',
            'slug': 'slug',
            'email': 'email',
            'accounts': 'accounts',
            'currentaccount': 'currentaccount',
            'activationchallenge': 'activationchallenge',
            'verified': 'verified',
            'profile_picture': 'profile_picture',
            'subscription': 'subscription'
        }

        self._href = href
        self._pk = pk
        self._status = status
        self._name = name
        self._registered_date = registered_date
        self._user_name = user_name
        self._slug = slug
        self._email = email
        self._accounts = accounts
        self._currentaccount = currentaccount
        self._activationchallenge = activationchallenge
        self._verified = verified
        self._profile_picture = profile_picture
        self._subscription = subscription

    @property
    def href(self):
        """
        Gets the href of this User.
        current object reference url

        :return: The href of this User.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this User.
        current object reference url

        :param href: The href of this User.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this User.
        unique id of user account.

        :return: The pk of this User.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this User.
        unique id of user account.

        :param pk: The pk of this User.
        :type: int
        """

        self._pk = pk

    @property
    def status(self):
        """
        Gets the status of this User.
        user account status.

        :return: The status of this User.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this User.
        user account status.

        :param status: The status of this User.
        :type: str
        """

        self._status = status

    @property
    def name(self):
        """
        Gets the name of this User.
        name of the user.

        :return: The name of this User.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this User.
        name of the user.

        :param name: The name of this User.
        :type: str
        """

        self._name = name

    @property
    def registered_date(self):
        """
        Gets the registered_date of this User.
        account creation date.

        :return: The registered_date of this User.
        :rtype: datetime
        """
        return self._registered_date

    @registered_date.setter
    def registered_date(self, registered_date):
        """
        Sets the registered_date of this User.
        account creation date.

        :param registered_date: The registered_date of this User.
        :type: datetime
        """

        self._registered_date = registered_date

    @property
    def user_name(self):
        """
        Gets the user_name of this User.
        unique value of the user account.

        :return: The user_name of this User.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this User.
        unique value of the user account.

        :param user_name: The user_name of this User.
        :type: str
        """

        self._user_name = user_name

    @property
    def slug(self):
        """
        Gets the slug of this User.
        slug of the user account.

        :return: The slug of this User.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this User.
        slug of the user account.

        :param slug: The slug of this User.
        :type: str
        """

        self._slug = slug

    @property
    def email(self):
        """
        Gets the email of this User.
        email id of user.

        :return: The email of this User.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this User.
        email id of user.

        :param email: The email of this User.
        :type: str
        """

        self._email = email

    @property
    def accounts(self):
        """
        Gets the accounts of this User.
        user accounts.

        :return: The accounts of this User.
        :rtype: object
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """
        Sets the accounts of this User.
        user accounts.

        :param accounts: The accounts of this User.
        :type: object
        """

        self._accounts = accounts

    @property
    def currentaccount(self):
        """
        Gets the currentaccount of this User.
        user's active account.

        :return: The currentaccount of this User.
        :rtype: object
        """
        return self._currentaccount

    @currentaccount.setter
    def currentaccount(self, currentaccount):
        """
        Sets the currentaccount of this User.
        user's active account.

        :param currentaccount: The currentaccount of this User.
        :type: object
        """

        self._currentaccount = currentaccount

    @property
    def activationchallenge(self):
        """
        Gets the activationchallenge of this User.
        proof of work challenge

        :return: The activationchallenge of this User.
        :rtype: object
        """
        return self._activationchallenge

    @activationchallenge.setter
    def activationchallenge(self, activationchallenge):
        """
        Sets the activationchallenge of this User.
        proof of work challenge

        :param activationchallenge: The activationchallenge of this User.
        :type: object
        """

        self._activationchallenge = activationchallenge

    @property
    def verified(self):
        """
        Gets the verified of this User.
        whether email is verified or not

        :return: The verified of this User.
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """
        Sets the verified of this User.
        whether email is verified or not

        :param verified: The verified of this User.
        :type: bool
        """

        self._verified = verified

    @property
    def profile_picture(self):
        """
        Gets the profile_picture of this User.
        if profile picture available it will have url else null

        :return: The profile_picture of this User.
        :rtype: str
        """
        return self._profile_picture

    @profile_picture.setter
    def profile_picture(self, profile_picture):
        """
        Sets the profile_picture of this User.
        if profile picture available it will have url else null

        :param profile_picture: The profile_picture of this User.
        :type: str
        """

        self._profile_picture = profile_picture

    @property
    def subscription(self):
        """
        Gets the subscription of this User.
        subscription type of account. Ex: Free, Paid, Verified or organization

        :return: The subscription of this User.
        :rtype: str
        """
        return self._subscription

    @subscription.setter
    def subscription(self, subscription):
        """
        Sets the subscription of this User.
        subscription type of account. Ex: Free, Paid, Verified or organization

        :param subscription: The subscription of this User.
        :type: str
        """

        self._subscription = subscription

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
