# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class UpdatePackage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, type=None, description=None, package_images=None, publish=None):
        """
        UpdatePackage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'description': 'str',
            'package_images': 'object',
            'publish': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'description': 'description',
            'package_images': 'package_images',
            'publish': 'publish'
        }

        self._name = name
        self._type = type
        self._description = description
        self._package_images = package_images
        self._publish = publish

    @property
    def name(self):
        """
        Gets the name of this UpdatePackage.
        name of the package.

        :return: The name of this UpdatePackage.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UpdatePackage.
        name of the package.

        :param name: The name of this UpdatePackage.
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """
        Gets the type of this UpdatePackage.
        type of package.

        :return: The type of this UpdatePackage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this UpdatePackage.
        type of package.

        :param type: The type of this UpdatePackage.
        :type: str
        """

        self._type = type

    @property
    def description(self):
        """
        Gets the description of this UpdatePackage.
        Package description.

        :return: The description of this UpdatePackage.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdatePackage.
        Package description.

        :param description: The description of this UpdatePackage.
        :type: str
        """

        self._description = description

    @property
    def package_images(self):
        """
        Gets the package_images of this UpdatePackage.
        upload images used to display package details.

        :return: The package_images of this UpdatePackage.
        :rtype: object
        """
        return self._package_images

    @package_images.setter
    def package_images(self, package_images):
        """
        Sets the package_images of this UpdatePackage.
        upload images used to display package details.

        :param package_images: The package_images of this UpdatePackage.
        :type: object
        """

        self._package_images = package_images

    @property
    def publish(self):
        """
        Gets the publish of this UpdatePackage.
        Send true to publish a package.

        :return: The publish of this UpdatePackage.
        :rtype: bool
        """
        return self._publish

    @publish.setter
    def publish(self, publish):
        """
        Sets the publish of this UpdatePackage.
        Send true to publish a package.

        :param publish: The publish of this UpdatePackage.
        :type: bool
        """

        self._publish = publish

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
