# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class UpdateDraft(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, package_hash=None, documents=None):
        """
        UpdateDraft - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'package_hash': 'str',
            'documents': 'list[object]'
        }

        self.attribute_map = {
            'name': 'name',
            'package_hash': 'packageHash',
            'documents': 'documents'
        }

        self._name = name
        self._package_hash = package_hash
        self._documents = documents

    @property
    def name(self):
        """
        Gets the name of this UpdateDraft.
        Name of the draft.

        :return: The name of this UpdateDraft.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UpdateDraft.
        Name of the draft.

        :param name: The name of this UpdateDraft.
        :type: str
        """

        self._name = name

    @property
    def package_hash(self):
        """
        Gets the package_hash of this UpdateDraft.
        use as token for push

        :return: The package_hash of this UpdateDraft.
        :rtype: str
        """
        return self._package_hash

    @package_hash.setter
    def package_hash(self, package_hash):
        """
        Sets the package_hash of this UpdateDraft.
        use as token for push

        :param package_hash: The package_hash of this UpdateDraft.
        :type: str
        """

        self._package_hash = package_hash

    @property
    def documents(self):
        """
        Gets the documents of this UpdateDraft.
        jptf.

        :return: The documents of this UpdateDraft.
        :rtype: list[object]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this UpdateDraft.
        jptf.

        :param documents: The documents of this UpdateDraft.
        :type: list[object]
        """

        self._documents = documents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
