# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class UpdateAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, old_password=None, new_password=None, email=None, password=None, reset_token=None, activation_token=None, activation_solution=None, deactivate=None):
        """
        UpdateAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'old_password': 'str',
            'new_password': 'str',
            'email': 'str',
            'password': 'str',
            'reset_token': 'str',
            'activation_token': 'str',
            'activation_solution': 'str',
            'deactivate': 'bool'
        }

        self.attribute_map = {
            'old_password': 'old_password',
            'new_password': 'new_password',
            'email': 'email',
            'password': 'password',
            'reset_token': 'reset_token',
            'activation_token': 'activation_token',
            'activation_solution': 'activation_solution',
            'deactivate': 'deactivate'
        }

        self._old_password = old_password
        self._new_password = new_password
        self._email = email
        self._password = password
        self._reset_token = reset_token
        self._activation_token = activation_token
        self._activation_solution = activation_solution
        self._deactivate = deactivate

    @property
    def old_password(self):
        """
        Gets the old_password of this UpdateAccount.
        user current password for change password.

        :return: The old_password of this UpdateAccount.
        :rtype: str
        """
        return self._old_password

    @old_password.setter
    def old_password(self, old_password):
        """
        Sets the old_password of this UpdateAccount.
        user current password for change password.

        :param old_password: The old_password of this UpdateAccount.
        :type: str
        """

        self._old_password = old_password

    @property
    def new_password(self):
        """
        Gets the new_password of this UpdateAccount.
        user account new password for change password.

        :return: The new_password of this UpdateAccount.
        :rtype: str
        """
        return self._new_password

    @new_password.setter
    def new_password(self, new_password):
        """
        Sets the new_password of this UpdateAccount.
        user account new password for change password.

        :param new_password: The new_password of this UpdateAccount.
        :type: str
        """

        self._new_password = new_password

    @property
    def email(self):
        """
        Gets the email of this UpdateAccount.
        user Email ID.

        :return: The email of this UpdateAccount.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this UpdateAccount.
        user Email ID.

        :param email: The email of this UpdateAccount.
        :type: str
        """

        self._email = email

    @property
    def password(self):
        """
        Gets the password of this UpdateAccount.
        new password of user for reset password.

        :return: The password of this UpdateAccount.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this UpdateAccount.
        new password of user for reset password.

        :param password: The password of this UpdateAccount.
        :type: str
        """

        self._password = password

    @property
    def reset_token(self):
        """
        Gets the reset_token of this UpdateAccount.
        token used to reset user password.

        :return: The reset_token of this UpdateAccount.
        :rtype: str
        """
        return self._reset_token

    @reset_token.setter
    def reset_token(self, reset_token):
        """
        Sets the reset_token of this UpdateAccount.
        token used to reset user password.

        :param reset_token: The reset_token of this UpdateAccount.
        :type: str
        """

        self._reset_token = reset_token

    @property
    def activation_token(self):
        """
        Gets the activation_token of this UpdateAccount.
        token used to activate user account.

        :return: The activation_token of this UpdateAccount.
        :rtype: str
        """
        return self._activation_token

    @activation_token.setter
    def activation_token(self, activation_token):
        """
        Sets the activation_token of this UpdateAccount.
        token used to activate user account.

        :param activation_token: The activation_token of this UpdateAccount.
        :type: str
        """

        self._activation_token = activation_token

    @property
    def activation_solution(self):
        """
        Gets the activation_solution of this UpdateAccount.
        activation proof of work solution

        :return: The activation_solution of this UpdateAccount.
        :rtype: str
        """
        return self._activation_solution

    @activation_solution.setter
    def activation_solution(self, activation_solution):
        """
        Sets the activation_solution of this UpdateAccount.
        activation proof of work solution

        :param activation_solution: The activation_solution of this UpdateAccount.
        :type: str
        """

        self._activation_solution = activation_solution

    @property
    def deactivate(self):
        """
        Gets the deactivate of this UpdateAccount.
        boolean value to deactivate user account.

        :return: The deactivate of this UpdateAccount.
        :rtype: bool
        """
        return self._deactivate

    @deactivate.setter
    def deactivate(self, deactivate):
        """
        Sets the deactivate of this UpdateAccount.
        boolean value to deactivate user account.

        :param deactivate: The deactivate of this UpdateAccount.
        :type: bool
        """

        self._deactivate = deactivate

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
