# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class SharedPackageAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, shared_account=None, pending=None, email=None, share_via_email=None, subscription=None, profile_picture=None, created_date=None):
        """
        SharedPackageAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'shared_account': 'str',
            'pending': 'bool',
            'email': 'str',
            'share_via_email': 'bool',
            'subscription': 'str',
            'profile_picture': 'str',
            'created_date': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'shared_account': 'shared_account',
            'pending': 'pending',
            'email': 'email',
            'share_via_email': 'share_via_email',
            'subscription': 'subscription',
            'profile_picture': 'profile_picture',
            'created_date': 'created_date'
        }

        self._name = name
        self._shared_account = shared_account
        self._pending = pending
        self._email = email
        self._share_via_email = share_via_email
        self._subscription = subscription
        self._profile_picture = profile_picture
        self._created_date = created_date

    @property
    def name(self):
        """
        Gets the name of this SharedPackageAccount.
        Fully qualified name of the package which is shared.

        :return: The name of this SharedPackageAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SharedPackageAccount.
        Fully qualified name of the package which is shared.

        :param name: The name of this SharedPackageAccount.
        :type: str
        """

        self._name = name

    @property
    def shared_account(self):
        """
        Gets the shared_account of this SharedPackageAccount.
        Account name with which package is shared

        :return: The shared_account of this SharedPackageAccount.
        :rtype: str
        """
        return self._shared_account

    @shared_account.setter
    def shared_account(self, shared_account):
        """
        Sets the shared_account of this SharedPackageAccount.
        Account name with which package is shared

        :param shared_account: The shared_account of this SharedPackageAccount.
        :type: str
        """

        self._shared_account = shared_account

    @property
    def pending(self):
        """
        Gets the pending of this SharedPackageAccount.
        If account account doesn't accepted the package it's value will be True else false

        :return: The pending of this SharedPackageAccount.
        :rtype: bool
        """
        return self._pending

    @pending.setter
    def pending(self, pending):
        """
        Sets the pending of this SharedPackageAccount.
        If account account doesn't accepted the package it's value will be True else false

        :param pending: The pending of this SharedPackageAccount.
        :type: bool
        """

        self._pending = pending

    @property
    def email(self):
        """
        Gets the email of this SharedPackageAccount.
        email of account or the email address of those were invited via email for sharing the package.

        :return: The email of this SharedPackageAccount.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this SharedPackageAccount.
        email of account or the email address of those were invited via email for sharing the package.

        :param email: The email of this SharedPackageAccount.
        :type: str
        """

        self._email = email

    @property
    def share_via_email(self):
        """
        Gets the share_via_email of this SharedPackageAccount.
        If package has been shared via email

        :return: The share_via_email of this SharedPackageAccount.
        :rtype: bool
        """
        return self._share_via_email

    @share_via_email.setter
    def share_via_email(self, share_via_email):
        """
        Sets the share_via_email of this SharedPackageAccount.
        If package has been shared via email

        :param share_via_email: The share_via_email of this SharedPackageAccount.
        :type: bool
        """

        self._share_via_email = share_via_email

    @property
    def subscription(self):
        """
        Gets the subscription of this SharedPackageAccount.
        subscription type of recipient account

        :return: The subscription of this SharedPackageAccount.
        :rtype: str
        """
        return self._subscription

    @subscription.setter
    def subscription(self, subscription):
        """
        Sets the subscription of this SharedPackageAccount.
        subscription type of recipient account

        :param subscription: The subscription of this SharedPackageAccount.
        :type: str
        """

        self._subscription = subscription

    @property
    def profile_picture(self):
        """
        Gets the profile_picture of this SharedPackageAccount.
        profile_picture of recipient

        :return: The profile_picture of this SharedPackageAccount.
        :rtype: str
        """
        return self._profile_picture

    @profile_picture.setter
    def profile_picture(self, profile_picture):
        """
        Sets the profile_picture of this SharedPackageAccount.
        profile_picture of recipient

        :param profile_picture: The profile_picture of this SharedPackageAccount.
        :type: str
        """

        self._profile_picture = profile_picture

    @property
    def created_date(self):
        """
        Gets the created_date of this SharedPackageAccount.
        created date when the package was shared

        :return: The created_date of this SharedPackageAccount.
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this SharedPackageAccount.
        created date when the package was shared

        :param created_date: The created_date of this SharedPackageAccount.
        :type: str
        """

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
