# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class SessionData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, session_key=None, slug=None, active_account=None):
        """
        SessionData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'session_key': 'str',
            'slug': 'str',
            'active_account': 'str'
        }

        self.attribute_map = {
            'session_key': 'session_key',
            'slug': 'slug',
            'active_account': 'active_account'
        }

        self._session_key = session_key
        self._slug = slug
        self._active_account = active_account

    @property
    def session_key(self):
        """
        Gets the session_key of this SessionData.
        value used to manage user session.

        :return: The session_key of this SessionData.
        :rtype: str
        """
        return self._session_key

    @session_key.setter
    def session_key(self, session_key):
        """
        Sets the session_key of this SessionData.
        value used to manage user session.

        :param session_key: The session_key of this SessionData.
        :type: str
        """

        self._session_key = session_key

    @property
    def slug(self):
        """
        Gets the slug of this SessionData.
        unique identifier for the user.

        :return: The slug of this SessionData.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this SessionData.
        unique identifier for the user.

        :param slug: The slug of this SessionData.
        :type: str
        """

        self._slug = slug

    @property
    def active_account(self):
        """
        Gets the active_account of this SessionData.
        slug if you want to activate any of your organizations.

        :return: The active_account of this SessionData.
        :rtype: str
        """
        return self._active_account

    @active_account.setter
    def active_account(self, active_account):
        """
        Sets the active_account of this SessionData.
        slug if you want to activate any of your organizations.

        :param active_account: The active_account of this SessionData.
        :type: str
        """

        self._active_account = active_account

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
