# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class SearchResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, name=None, slug=None, account=None, type=None, is_liked=None, package_status=None, description=None, rating_avg=None, title=None, rating_count=None, modified_date=None, created_date=None, user=None, thumbnail_image=None, details_image=None, banner_image=None, all_licenses_price=None, ratings=None):
        """
        SearchResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'name': 'str',
            'slug': 'str',
            'account': 'str',
            'type': 'str',
            'is_liked': 'bool',
            'package_status': 'str',
            'description': 'str',
            'rating_avg': 'float',
            'title': 'str',
            'rating_count': 'float',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'user': 'str',
            'thumbnail_image': 'str',
            'details_image': 'str',
            'banner_image': 'str',
            'all_licenses_price': 'list[AllLicensePrice]',
            'ratings': 'object'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'name': 'name',
            'slug': 'slug',
            'account': 'account',
            'type': 'type',
            'is_liked': 'is_liked',
            'package_status': 'package_status',
            'description': 'description',
            'rating_avg': 'rating_avg',
            'title': 'title',
            'rating_count': 'rating_count',
            'modified_date': 'modified_date',
            'created_date': 'created_date',
            'user': 'user',
            'thumbnail_image': 'thumbnail_image',
            'details_image': 'details_image',
            'banner_image': 'banner_image',
            'all_licenses_price': 'all_licenses_price',
            'ratings': 'ratings'
        }

        self._href = href
        self._pk = pk
        self._name = name
        self._slug = slug
        self._account = account
        self._type = type
        self._is_liked = is_liked
        self._package_status = package_status
        self._description = description
        self._rating_avg = rating_avg
        self._title = title
        self._rating_count = rating_count
        self._modified_date = modified_date
        self._created_date = created_date
        self._user = user
        self._thumbnail_image = thumbnail_image
        self._details_image = details_image
        self._banner_image = banner_image
        self._all_licenses_price = all_licenses_price
        self._ratings = ratings

    @property
    def href(self):
        """
        Gets the href of this SearchResult.
        current object reference url

        :return: The href of this SearchResult.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this SearchResult.
        current object reference url

        :param href: The href of this SearchResult.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this SearchResult.
        unique identifier of package.

        :return: The pk of this SearchResult.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this SearchResult.
        unique identifier of package.

        :param pk: The pk of this SearchResult.
        :type: int
        """

        self._pk = pk

    @property
    def name(self):
        """
        Gets the name of this SearchResult.
        package name.

        :return: The name of this SearchResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SearchResult.
        package name.

        :param name: The name of this SearchResult.
        :type: str
        """

        self._name = name

    @property
    def slug(self):
        """
        Gets the slug of this SearchResult.
        value used to uniquely identify package.

        :return: The slug of this SearchResult.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this SearchResult.
        value used to uniquely identify package.

        :param slug: The slug of this SearchResult.
        :type: str
        """

        self._slug = slug

    @property
    def account(self):
        """
        Gets the account of this SearchResult.
        value used to uniquely identify account.

        :return: The account of this SearchResult.
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this SearchResult.
        value used to uniquely identify account.

        :param account: The account of this SearchResult.
        :type: str
        """

        self._account = account

    @property
    def type(self):
        """
        Gets the type of this SearchResult.
        package type

        :return: The type of this SearchResult.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SearchResult.
        package type

        :param type: The type of this SearchResult.
        :type: str
        """

        self._type = type

    @property
    def is_liked(self):
        """
        Gets the is_liked of this SearchResult.
        whether the package was liked or not

        :return: The is_liked of this SearchResult.
        :rtype: bool
        """
        return self._is_liked

    @is_liked.setter
    def is_liked(self, is_liked):
        """
        Sets the is_liked of this SearchResult.
        whether the package was liked or not

        :param is_liked: The is_liked of this SearchResult.
        :type: bool
        """

        self._is_liked = is_liked

    @property
    def package_status(self):
        """
        Gets the package_status of this SearchResult.
        package status

        :return: The package_status of this SearchResult.
        :rtype: str
        """
        return self._package_status

    @package_status.setter
    def package_status(self, package_status):
        """
        Sets the package_status of this SearchResult.
        package status

        :param package_status: The package_status of this SearchResult.
        :type: str
        """

        self._package_status = package_status

    @property
    def description(self):
        """
        Gets the description of this SearchResult.
        package description

        :return: The description of this SearchResult.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SearchResult.
        package description

        :param description: The description of this SearchResult.
        :type: str
        """

        self._description = description

    @property
    def rating_avg(self):
        """
        Gets the rating_avg of this SearchResult.
        average rating.

        :return: The rating_avg of this SearchResult.
        :rtype: float
        """
        return self._rating_avg

    @rating_avg.setter
    def rating_avg(self, rating_avg):
        """
        Sets the rating_avg of this SearchResult.
        average rating.

        :param rating_avg: The rating_avg of this SearchResult.
        :type: float
        """

        self._rating_avg = rating_avg

    @property
    def title(self):
        """
        Gets the title of this SearchResult.
        package title.

        :return: The title of this SearchResult.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this SearchResult.
        package title.

        :param title: The title of this SearchResult.
        :type: str
        """

        self._title = title

    @property
    def rating_count(self):
        """
        Gets the rating_count of this SearchResult.
        package total rating submitted.

        :return: The rating_count of this SearchResult.
        :rtype: float
        """
        return self._rating_count

    @rating_count.setter
    def rating_count(self, rating_count):
        """
        Sets the rating_count of this SearchResult.
        package total rating submitted.

        :param rating_count: The rating_count of this SearchResult.
        :type: float
        """

        self._rating_count = rating_count

    @property
    def modified_date(self):
        """
        Gets the modified_date of this SearchResult.
        last modified date.

        :return: The modified_date of this SearchResult.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this SearchResult.
        last modified date.

        :param modified_date: The modified_date of this SearchResult.
        :type: datetime
        """

        self._modified_date = modified_date

    @property
    def created_date(self):
        """
        Gets the created_date of this SearchResult.
        account creation date.

        :return: The created_date of this SearchResult.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this SearchResult.
        account creation date.

        :param created_date: The created_date of this SearchResult.
        :type: datetime
        """

        self._created_date = created_date

    @property
    def user(self):
        """
        Gets the user of this SearchResult.
        package creator name.

        :return: The user of this SearchResult.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this SearchResult.
        package creator name.

        :param user: The user of this SearchResult.
        :type: str
        """

        self._user = user

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this SearchResult.
        

        :return: The thumbnail_image of this SearchResult.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this SearchResult.
        

        :param thumbnail_image: The thumbnail_image of this SearchResult.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def details_image(self):
        """
        Gets the details_image of this SearchResult.
        

        :return: The details_image of this SearchResult.
        :rtype: str
        """
        return self._details_image

    @details_image.setter
    def details_image(self, details_image):
        """
        Sets the details_image of this SearchResult.
        

        :param details_image: The details_image of this SearchResult.
        :type: str
        """

        self._details_image = details_image

    @property
    def banner_image(self):
        """
        Gets the banner_image of this SearchResult.
        Banner image of the package.

        :return: The banner_image of this SearchResult.
        :rtype: str
        """
        return self._banner_image

    @banner_image.setter
    def banner_image(self, banner_image):
        """
        Sets the banner_image of this SearchResult.
        Banner image of the package.

        :param banner_image: The banner_image of this SearchResult.
        :type: str
        """

        self._banner_image = banner_image

    @property
    def all_licenses_price(self):
        """
        Gets the all_licenses_price of this SearchResult.
        detail view of each search result.

        :return: The all_licenses_price of this SearchResult.
        :rtype: list[AllLicensePrice]
        """
        return self._all_licenses_price

    @all_licenses_price.setter
    def all_licenses_price(self, all_licenses_price):
        """
        Sets the all_licenses_price of this SearchResult.
        detail view of each search result.

        :param all_licenses_price: The all_licenses_price of this SearchResult.
        :type: list[AllLicensePrice]
        """

        self._all_licenses_price = all_licenses_price

    @property
    def ratings(self):
        """
        Gets the ratings of this SearchResult.
        Package ratings.

        :return: The ratings of this SearchResult.
        :rtype: object
        """
        return self._ratings

    @ratings.setter
    def ratings(self, ratings):
        """
        Sets the ratings of this SearchResult.
        Package ratings.

        :param ratings: The ratings of this SearchResult.
        :type: object
        """

        self._ratings = ratings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
