# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ResendInvite(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, action=None, account_slug=None, email=None, message=None):
        """
        ResendInvite - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'account_slug': 'str',
            'email': 'str',
            'message': 'str'
        }

        self.attribute_map = {
            'action': 'action',
            'account_slug': 'account_slug',
            'email': 'email',
            'message': 'message'
        }

        self._action = action
        self._account_slug = account_slug
        self._email = email
        self._message = message

    @property
    def action(self):
        """
        Gets the action of this ResendInvite.
        Type of acquisition user is going to create.Example : share, get,buy,transfer,extend and clone.

        :return: The action of this ResendInvite.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ResendInvite.
        Type of acquisition user is going to create.Example : share, get,buy,transfer,extend and clone.

        :param action: The action of this ResendInvite.
        :type: str
        """

        self._action = action

    @property
    def account_slug(self):
        """
        Gets the account_slug of this ResendInvite.
        Name of the account where user wants to resend invite for share or transfer package.

        :return: The account_slug of this ResendInvite.
        :rtype: str
        """
        return self._account_slug

    @account_slug.setter
    def account_slug(self, account_slug):
        """
        Sets the account_slug of this ResendInvite.
        Name of the account where user wants to resend invite for share or transfer package.

        :param account_slug: The account_slug of this ResendInvite.
        :type: str
        """

        self._account_slug = account_slug

    @property
    def email(self):
        """
        Gets the email of this ResendInvite.
        Email address for Inviting user via email.

        :return: The email of this ResendInvite.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this ResendInvite.
        Email address for Inviting user via email.

        :param email: The email of this ResendInvite.
        :type: str
        """

        self._email = email

    @property
    def message(self):
        """
        Gets the message of this ResendInvite.
        Message will be send with the invite in the email.

        :return: The message of this ResendInvite.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ResendInvite.
        Message will be send with the invite in the email.

        :param message: The message of this ResendInvite.
        :type: str
        """

        self._message = message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
