# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class RejectAcquisitionPackage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, action=None, unknown_person=None, not_intended_for_me=None, do_not_want_it=None, derogatory_language=None, sexual_explicit=None, harassment=None, hateful_content=None, child_abuse=None, unwanted_commercial_or_spam=None, other=None):
        """
        RejectAcquisitionPackage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'unknown_person': 'bool',
            'not_intended_for_me': 'bool',
            'do_not_want_it': 'bool',
            'derogatory_language': 'bool',
            'sexual_explicit': 'bool',
            'harassment': 'bool',
            'hateful_content': 'bool',
            'child_abuse': 'bool',
            'unwanted_commercial_or_spam': 'bool',
            'other': 'str'
        }

        self.attribute_map = {
            'action': 'action',
            'unknown_person': 'unknown_person',
            'not_intended_for_me': 'not_intended_for_me',
            'do_not_want_it': 'do_not_want_it',
            'derogatory_language': 'derogatory_language',
            'sexual_explicit': 'sexual_explicit',
            'harassment': 'harassment',
            'hateful_content': 'hateful_content',
            'child_abuse': 'child_abuse',
            'unwanted_commercial_or_spam': 'unwanted_commercial_or_spam',
            'other': 'other'
        }

        self._action = action
        self._unknown_person = unknown_person
        self._not_intended_for_me = not_intended_for_me
        self._do_not_want_it = do_not_want_it
        self._derogatory_language = derogatory_language
        self._sexual_explicit = sexual_explicit
        self._harassment = harassment
        self._hateful_content = hateful_content
        self._child_abuse = child_abuse
        self._unwanted_commercial_or_spam = unwanted_commercial_or_spam
        self._other = other

    @property
    def action(self):
        """
        Gets the action of this RejectAcquisitionPackage.
        Type of acquisition user is going to reject.Example : share, get,buy,transfer,extend and clone.

        :return: The action of this RejectAcquisitionPackage.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this RejectAcquisitionPackage.
        Type of acquisition user is going to reject.Example : share, get,buy,transfer,extend and clone.

        :param action: The action of this RejectAcquisitionPackage.
        :type: str
        """

        self._action = action

    @property
    def unknown_person(self):
        """
        Gets the unknown_person of this RejectAcquisitionPackage.
        When reason to reject is 'I do not know the person who shared this with me'.

        :return: The unknown_person of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._unknown_person

    @unknown_person.setter
    def unknown_person(self, unknown_person):
        """
        Sets the unknown_person of this RejectAcquisitionPackage.
        When reason to reject is 'I do not know the person who shared this with me'.

        :param unknown_person: The unknown_person of this RejectAcquisitionPackage.
        :type: bool
        """

        self._unknown_person = unknown_person

    @property
    def not_intended_for_me(self):
        """
        Gets the not_intended_for_me of this RejectAcquisitionPackage.
        when the reason to reject is 'It was not intended for me'.

        :return: The not_intended_for_me of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._not_intended_for_me

    @not_intended_for_me.setter
    def not_intended_for_me(self, not_intended_for_me):
        """
        Sets the not_intended_for_me of this RejectAcquisitionPackage.
        when the reason to reject is 'It was not intended for me'.

        :param not_intended_for_me: The not_intended_for_me of this RejectAcquisitionPackage.
        :type: bool
        """

        self._not_intended_for_me = not_intended_for_me

    @property
    def do_not_want_it(self):
        """
        Gets the do_not_want_it of this RejectAcquisitionPackage.
        when the reason to reject is 'I do not want it; it is clogging up my list'.

        :return: The do_not_want_it of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._do_not_want_it

    @do_not_want_it.setter
    def do_not_want_it(self, do_not_want_it):
        """
        Sets the do_not_want_it of this RejectAcquisitionPackage.
        when the reason to reject is 'I do not want it; it is clogging up my list'.

        :param do_not_want_it: The do_not_want_it of this RejectAcquisitionPackage.
        :type: bool
        """

        self._do_not_want_it = do_not_want_it

    @property
    def derogatory_language(self):
        """
        Gets the derogatory_language of this RejectAcquisitionPackage.
        when the reason to reject is 'Derogatory Language'.

        :return: The derogatory_language of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._derogatory_language

    @derogatory_language.setter
    def derogatory_language(self, derogatory_language):
        """
        Sets the derogatory_language of this RejectAcquisitionPackage.
        when the reason to reject is 'Derogatory Language'.

        :param derogatory_language: The derogatory_language of this RejectAcquisitionPackage.
        :type: bool
        """

        self._derogatory_language = derogatory_language

    @property
    def sexual_explicit(self):
        """
        Gets the sexual_explicit of this RejectAcquisitionPackage.
        when the reason to reject is 'Sexual explicit or pornographic content'.

        :return: The sexual_explicit of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._sexual_explicit

    @sexual_explicit.setter
    def sexual_explicit(self, sexual_explicit):
        """
        Sets the sexual_explicit of this RejectAcquisitionPackage.
        when the reason to reject is 'Sexual explicit or pornographic content'.

        :param sexual_explicit: The sexual_explicit of this RejectAcquisitionPackage.
        :type: bool
        """

        self._sexual_explicit = sexual_explicit

    @property
    def harassment(self):
        """
        Gets the harassment of this RejectAcquisitionPackage.
        when the reason to reject is 'Harassment or bullying'.

        :return: The harassment of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._harassment

    @harassment.setter
    def harassment(self, harassment):
        """
        Sets the harassment of this RejectAcquisitionPackage.
        when the reason to reject is 'Harassment or bullying'.

        :param harassment: The harassment of this RejectAcquisitionPackage.
        :type: bool
        """

        self._harassment = harassment

    @property
    def hateful_content(self):
        """
        Gets the hateful_content of this RejectAcquisitionPackage.
        when the reason to reject is 'Hateful or violent content'.

        :return: The hateful_content of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._hateful_content

    @hateful_content.setter
    def hateful_content(self, hateful_content):
        """
        Sets the hateful_content of this RejectAcquisitionPackage.
        when the reason to reject is 'Hateful or violent content'.

        :param hateful_content: The hateful_content of this RejectAcquisitionPackage.
        :type: bool
        """

        self._hateful_content = hateful_content

    @property
    def child_abuse(self):
        """
        Gets the child_abuse of this RejectAcquisitionPackage.
        when the reason to reject is 'Child Abuse'.

        :return: The child_abuse of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._child_abuse

    @child_abuse.setter
    def child_abuse(self, child_abuse):
        """
        Sets the child_abuse of this RejectAcquisitionPackage.
        when the reason to reject is 'Child Abuse'.

        :param child_abuse: The child_abuse of this RejectAcquisitionPackage.
        :type: bool
        """

        self._child_abuse = child_abuse

    @property
    def unwanted_commercial_or_spam(self):
        """
        Gets the unwanted_commercial_or_spam of this RejectAcquisitionPackage.
        when the reason to reject is 'Unwanted Commercial content or spam'.

        :return: The unwanted_commercial_or_spam of this RejectAcquisitionPackage.
        :rtype: bool
        """
        return self._unwanted_commercial_or_spam

    @unwanted_commercial_or_spam.setter
    def unwanted_commercial_or_spam(self, unwanted_commercial_or_spam):
        """
        Sets the unwanted_commercial_or_spam of this RejectAcquisitionPackage.
        when the reason to reject is 'Unwanted Commercial content or spam'.

        :param unwanted_commercial_or_spam: The unwanted_commercial_or_spam of this RejectAcquisitionPackage.
        :type: bool
        """

        self._unwanted_commercial_or_spam = unwanted_commercial_or_spam

    @property
    def other(self):
        """
        Gets the other of this RejectAcquisitionPackage.
        When user is rejecting package with his/her own reason he/she will mention that message in other field.

        :return: The other of this RejectAcquisitionPackage.
        :rtype: str
        """
        return self._other

    @other.setter
    def other(self, other):
        """
        Sets the other of this RejectAcquisitionPackage.
        When user is rejecting package with his/her own reason he/she will mention that message in other field.

        :param other: The other of this RejectAcquisitionPackage.
        :type: str
        """

        self._other = other

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
