# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Rating(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, pk=None, rating=None, user=None):
        """
        Rating - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'pk': 'int',
            'rating': 'int',
            'user': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'pk': 'pk',
            'rating': 'rating',
            'user': 'user'
        }

        self._href = href
        self._pk = pk
        self._rating = rating
        self._user = user

    @property
    def href(self):
        """
        Gets the href of this Rating.
        current object reference url

        :return: The href of this Rating.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this Rating.
        current object reference url

        :param href: The href of this Rating.
        :type: str
        """

        self._href = href

    @property
    def pk(self):
        """
        Gets the pk of this Rating.
        value used to identify rating uniquely.

        :return: The pk of this Rating.
        :rtype: int
        """
        return self._pk

    @pk.setter
    def pk(self, pk):
        """
        Sets the pk of this Rating.
        value used to identify rating uniquely.

        :param pk: The pk of this Rating.
        :type: int
        """

        self._pk = pk

    @property
    def rating(self):
        """
        Gets the rating of this Rating.
        rating score.

        :return: The rating of this Rating.
        :rtype: int
        """
        return self._rating

    @rating.setter
    def rating(self, rating):
        """
        Sets the rating of this Rating.
        rating score.

        :param rating: The rating of this Rating.
        :type: int
        """

        self._rating = rating

    @property
    def user(self):
        """
        Gets the user of this Rating.
        user name.

        :return: The user of this Rating.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this Rating.
        user name.

        :param user: The user of this Rating.
        :type: str
        """

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
