# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Publications(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, href=None, publication=None, hash_value=None):
        """
        Publications - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'href': 'str',
            'publication': 'list[Publication]',
            'hash_value': 'str'
        }

        self.attribute_map = {
            'href': 'href',
            'publication': 'publication',
            'hash_value': 'hash_value'
        }

        self._href = href
        self._publication = publication
        self._hash_value = hash_value

    @property
    def href(self):
        """
        Gets the href of this Publications.
        current object reference url

        :return: The href of this Publications.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """
        Sets the href of this Publications.
        current object reference url

        :param href: The href of this Publications.
        :type: str
        """

        self._href = href

    @property
    def publication(self):
        """
        Gets the publication of this Publications.
        detail view of user.

        :return: The publication of this Publications.
        :rtype: list[Publication]
        """
        return self._publication

    @publication.setter
    def publication(self, publication):
        """
        Sets the publication of this Publications.
        detail view of user.

        :param publication: The publication of this Publications.
        :type: list[Publication]
        """

        self._publication = publication

    @property
    def hash_value(self):
        """
        Gets the hash_value of this Publications.
        hash value of publication.

        :return: The hash_value of this Publications.
        :rtype: str
        """
        return self._hash_value

    @hash_value.setter
    def hash_value(self, hash_value):
        """
        Sets the hash_value of this Publications.
        hash value of publication.

        :param hash_value: The hash_value of this Publications.
        :type: str
        """

        self._hash_value = hash_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
