# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PublicationVersionError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, canonical=None, bundle_packages=None, created_date=None, bundles_price=None, error=None, validation_status=None):
        """
        PublicationVersionError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'canonical': 'bool',
            'bundle_packages': 'list[BundledPackagesError]',
            'created_date': 'str',
            'bundles_price': 'float',
            'error': 'list[PublicationValidationError]',
            'validation_status': 'str'
        }

        self.attribute_map = {
            'label': 'label',
            'canonical': 'canonical',
            'bundle_packages': 'bundle_packages',
            'created_date': 'created_date',
            'bundles_price': 'bundles_price',
            'error': 'ERROR',
            'validation_status': 'validation_status'
        }

        self._label = label
        self._canonical = canonical
        self._bundle_packages = bundle_packages
        self._created_date = created_date
        self._bundles_price = bundles_price
        self._error = error
        self._validation_status = validation_status

    @property
    def label(self):
        """
        Gets the label of this PublicationVersionError.
        label of package version

        :return: The label of this PublicationVersionError.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this PublicationVersionError.
        label of package version

        :param label: The label of this PublicationVersionError.
        :type: str
        """

        self._label = label

    @property
    def canonical(self):
        """
        Gets the canonical of this PublicationVersionError.
        canonical boolean value

        :return: The canonical of this PublicationVersionError.
        :rtype: bool
        """
        return self._canonical

    @canonical.setter
    def canonical(self, canonical):
        """
        Sets the canonical of this PublicationVersionError.
        canonical boolean value

        :param canonical: The canonical of this PublicationVersionError.
        :type: bool
        """

        self._canonical = canonical

    @property
    def bundle_packages(self):
        """
        Gets the bundle_packages of this PublicationVersionError.
        bundle package of given version label

        :return: The bundle_packages of this PublicationVersionError.
        :rtype: list[BundledPackagesError]
        """
        return self._bundle_packages

    @bundle_packages.setter
    def bundle_packages(self, bundle_packages):
        """
        Sets the bundle_packages of this PublicationVersionError.
        bundle package of given version label

        :param bundle_packages: The bundle_packages of this PublicationVersionError.
        :type: list[BundledPackagesError]
        """

        self._bundle_packages = bundle_packages

    @property
    def created_date(self):
        """
        Gets the created_date of this PublicationVersionError.
        version create date

        :return: The created_date of this PublicationVersionError.
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this PublicationVersionError.
        version create date

        :param created_date: The created_date of this PublicationVersionError.
        :type: str
        """

        self._created_date = created_date

    @property
    def bundles_price(self):
        """
        Gets the bundles_price of this PublicationVersionError.
        total price of bundled packages

        :return: The bundles_price of this PublicationVersionError.
        :rtype: float
        """
        return self._bundles_price

    @bundles_price.setter
    def bundles_price(self, bundles_price):
        """
        Sets the bundles_price of this PublicationVersionError.
        total price of bundled packages

        :param bundles_price: The bundles_price of this PublicationVersionError.
        :type: float
        """

        self._bundles_price = bundles_price

    @property
    def error(self):
        """
        Gets the error of this PublicationVersionError.
        list of errors will be displayed here.

        :return: The error of this PublicationVersionError.
        :rtype: list[PublicationValidationError]
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this PublicationVersionError.
        list of errors will be displayed here.

        :param error: The error of this PublicationVersionError.
        :type: list[PublicationValidationError]
        """

        self._error = error

    @property
    def validation_status(self):
        """
        Gets the validation_status of this PublicationVersionError.
        validation_status of version

        :return: The validation_status of this PublicationVersionError.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this PublicationVersionError.
        validation_status of version

        :param validation_status: The validation_status of this PublicationVersionError.
        :type: str
        """

        self._validation_status = validation_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
