# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PublicationVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, canonical=None, bundle_packages=None, created_date=None, bundles_price=None, is_set_canonical=None, validation_status=None):
        """
        PublicationVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'canonical': 'bool',
            'bundle_packages': 'list[BundledPackages]',
            'created_date': 'str',
            'bundles_price': 'float',
            'is_set_canonical': 'int',
            'validation_status': 'str'
        }

        self.attribute_map = {
            'label': 'label',
            'canonical': 'canonical',
            'bundle_packages': 'bundle_packages',
            'created_date': 'created_date',
            'bundles_price': 'bundles_price',
            'is_set_canonical': 'is_set_canonical',
            'validation_status': 'validation_status'
        }

        self._label = label
        self._canonical = canonical
        self._bundle_packages = bundle_packages
        self._created_date = created_date
        self._bundles_price = bundles_price
        self._is_set_canonical = is_set_canonical
        self._validation_status = validation_status

    @property
    def label(self):
        """
        Gets the label of this PublicationVersion.
        label of package version

        :return: The label of this PublicationVersion.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this PublicationVersion.
        label of package version

        :param label: The label of this PublicationVersion.
        :type: str
        """

        self._label = label

    @property
    def canonical(self):
        """
        Gets the canonical of this PublicationVersion.
        canonical boolean value

        :return: The canonical of this PublicationVersion.
        :rtype: bool
        """
        return self._canonical

    @canonical.setter
    def canonical(self, canonical):
        """
        Sets the canonical of this PublicationVersion.
        canonical boolean value

        :param canonical: The canonical of this PublicationVersion.
        :type: bool
        """

        self._canonical = canonical

    @property
    def bundle_packages(self):
        """
        Gets the bundle_packages of this PublicationVersion.
        bundle package of given version label

        :return: The bundle_packages of this PublicationVersion.
        :rtype: list[BundledPackages]
        """
        return self._bundle_packages

    @bundle_packages.setter
    def bundle_packages(self, bundle_packages):
        """
        Sets the bundle_packages of this PublicationVersion.
        bundle package of given version label

        :param bundle_packages: The bundle_packages of this PublicationVersion.
        :type: list[BundledPackages]
        """

        self._bundle_packages = bundle_packages

    @property
    def created_date(self):
        """
        Gets the created_date of this PublicationVersion.
        version create date

        :return: The created_date of this PublicationVersion.
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this PublicationVersion.
        version create date

        :param created_date: The created_date of this PublicationVersion.
        :type: str
        """

        self._created_date = created_date

    @property
    def bundles_price(self):
        """
        Gets the bundles_price of this PublicationVersion.
        total price of bundled packages

        :return: The bundles_price of this PublicationVersion.
        :rtype: float
        """
        return self._bundles_price

    @bundles_price.setter
    def bundles_price(self, bundles_price):
        """
        Sets the bundles_price of this PublicationVersion.
        total price of bundled packages

        :param bundles_price: The bundles_price of this PublicationVersion.
        :type: float
        """

        self._bundles_price = bundles_price

    @property
    def is_set_canonical(self):
        """
        Gets the is_set_canonical of this PublicationVersion.
        flag to know if canonical version was set by user

        :return: The is_set_canonical of this PublicationVersion.
        :rtype: int
        """
        return self._is_set_canonical

    @is_set_canonical.setter
    def is_set_canonical(self, is_set_canonical):
        """
        Sets the is_set_canonical of this PublicationVersion.
        flag to know if canonical version was set by user

        :param is_set_canonical: The is_set_canonical of this PublicationVersion.
        :type: int
        """

        self._is_set_canonical = is_set_canonical

    @property
    def validation_status(self):
        """
        Gets the validation_status of this PublicationVersion.
        current validation status based on badge results and validation plans passing level

        :return: The validation_status of this PublicationVersion.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this PublicationVersion.
        current validation status based on badge results and validation plans passing level

        :param validation_status: The validation_status of this PublicationVersion.
        :type: str
        """

        self._validation_status = validation_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
