# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PublicationValidationError(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, license_name=None, license_type=None, allow_listed=None, price=None, allow_bundled=None, number_of_downstream_packages=None, upgrades=None, label=None, publication_error=None, publication_license_does_not_exist_error=None, not_allow_to_bundle_error=None, license_compatibility_error=None, draft_version_dependency_error=None, version_not_published_error=None, downstream_publication_license_error=None, version_validation_status_error=None):
        """
        PublicationValidationError - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'license_name': 'str',
            'license_type': 'str',
            'allow_listed': 'str',
            'price': 'str',
            'allow_bundled': 'str',
            'number_of_downstream_packages': 'int',
            'upgrades': 'str',
            'label': 'str',
            'publication_error': 'str',
            'publication_license_does_not_exist_error': 'str',
            'not_allow_to_bundle_error': 'str',
            'license_compatibility_error': 'str',
            'draft_version_dependency_error': 'str',
            'version_not_published_error': 'str',
            'downstream_publication_license_error': 'list[str]',
            'version_validation_status_error': 'str'
        }

        self.attribute_map = {
            'license_name': 'license_name',
            'license_type': 'license_type',
            'allow_listed': 'allow_listed',
            'price': 'price',
            'allow_bundled': 'allow_bundled',
            'number_of_downstream_packages': 'number_of_downstream_packages',
            'upgrades': 'upgrades',
            'label': 'label',
            'publication_error': 'publication_error',
            'publication_license_does_not_exist_error': 'publication_license_does_not_exist_error',
            'not_allow_to_bundle_error': 'not_allow_to_bundle_error',
            'license_compatibility_error': 'license_compatibility_error',
            'draft_version_dependency_error': 'draft_version_dependency_error',
            'version_not_published_error': 'version_not_published_error',
            'downstream_publication_license_error': 'downstream_publication_license_error',
            'version_validation_status_error': 'version_validation_status_error'
        }

        self._license_name = license_name
        self._license_type = license_type
        self._allow_listed = allow_listed
        self._price = price
        self._allow_bundled = allow_bundled
        self._number_of_downstream_packages = number_of_downstream_packages
        self._upgrades = upgrades
        self._label = label
        self._publication_error = publication_error
        self._publication_license_does_not_exist_error = publication_license_does_not_exist_error
        self._not_allow_to_bundle_error = not_allow_to_bundle_error
        self._license_compatibility_error = license_compatibility_error
        self._draft_version_dependency_error = draft_version_dependency_error
        self._version_not_published_error = version_not_published_error
        self._downstream_publication_license_error = downstream_publication_license_error
        self._version_validation_status_error = version_validation_status_error

    @property
    def license_name(self):
        """
        Gets the license_name of this PublicationValidationError.
        

        :return: The license_name of this PublicationValidationError.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this PublicationValidationError.
        

        :param license_name: The license_name of this PublicationValidationError.
        :type: str
        """

        self._license_name = license_name

    @property
    def license_type(self):
        """
        Gets the license_type of this PublicationValidationError.
        

        :return: The license_type of this PublicationValidationError.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this PublicationValidationError.
        

        :param license_type: The license_type of this PublicationValidationError.
        :type: str
        """

        self._license_type = license_type

    @property
    def allow_listed(self):
        """
        Gets the allow_listed of this PublicationValidationError.
        

        :return: The allow_listed of this PublicationValidationError.
        :rtype: str
        """
        return self._allow_listed

    @allow_listed.setter
    def allow_listed(self, allow_listed):
        """
        Sets the allow_listed of this PublicationValidationError.
        

        :param allow_listed: The allow_listed of this PublicationValidationError.
        :type: str
        """

        self._allow_listed = allow_listed

    @property
    def price(self):
        """
        Gets the price of this PublicationValidationError.
        

        :return: The price of this PublicationValidationError.
        :rtype: str
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this PublicationValidationError.
        

        :param price: The price of this PublicationValidationError.
        :type: str
        """

        self._price = price

    @property
    def allow_bundled(self):
        """
        Gets the allow_bundled of this PublicationValidationError.
        

        :return: The allow_bundled of this PublicationValidationError.
        :rtype: str
        """
        return self._allow_bundled

    @allow_bundled.setter
    def allow_bundled(self, allow_bundled):
        """
        Sets the allow_bundled of this PublicationValidationError.
        

        :param allow_bundled: The allow_bundled of this PublicationValidationError.
        :type: str
        """

        self._allow_bundled = allow_bundled

    @property
    def number_of_downstream_packages(self):
        """
        Gets the number_of_downstream_packages of this PublicationValidationError.


        :return: The number_of_downstream_packages of this PublicationValidationError.
        :rtype: int
        """
        return self._number_of_downstream_packages

    @number_of_downstream_packages.setter
    def number_of_downstream_packages(self, number_of_downstream_packages):
        """
        Sets the number_of_downstream_packages of this PublicationValidationError.


        :param number_of_downstream_packages: The number_of_downstream_packages of this PublicationValidationError.
        :type: int
        """

        self._number_of_downstream_packages = number_of_downstream_packages

    @property
    def upgrades(self):
        """
        Gets the upgrades of this PublicationValidationError.
        

        :return: The upgrades of this PublicationValidationError.
        :rtype: str
        """
        return self._upgrades

    @upgrades.setter
    def upgrades(self, upgrades):
        """
        Sets the upgrades of this PublicationValidationError.
        

        :param upgrades: The upgrades of this PublicationValidationError.
        :type: str
        """

        self._upgrades = upgrades

    @property
    def label(self):
        """
        Gets the label of this PublicationValidationError.
        

        :return: The label of this PublicationValidationError.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this PublicationValidationError.
        

        :param label: The label of this PublicationValidationError.
        :type: str
        """

        self._label = label

    @property
    def publication_error(self):
        """
        Gets the publication_error of this PublicationValidationError.
        

        :return: The publication_error of this PublicationValidationError.
        :rtype: str
        """
        return self._publication_error

    @publication_error.setter
    def publication_error(self, publication_error):
        """
        Sets the publication_error of this PublicationValidationError.
        

        :param publication_error: The publication_error of this PublicationValidationError.
        :type: str
        """

        self._publication_error = publication_error

    @property
    def publication_license_does_not_exist_error(self):
        """
        Gets the publication_license_does_not_exist_error of this PublicationValidationError.
        

        :return: The publication_license_does_not_exist_error of this PublicationValidationError.
        :rtype: str
        """
        return self._publication_license_does_not_exist_error

    @publication_license_does_not_exist_error.setter
    def publication_license_does_not_exist_error(self, publication_license_does_not_exist_error):
        """
        Sets the publication_license_does_not_exist_error of this PublicationValidationError.
        

        :param publication_license_does_not_exist_error: The publication_license_does_not_exist_error of this PublicationValidationError.
        :type: str
        """

        self._publication_license_does_not_exist_error = publication_license_does_not_exist_error

    @property
    def not_allow_to_bundle_error(self):
        """
        Gets the not_allow_to_bundle_error of this PublicationValidationError.
        

        :return: The not_allow_to_bundle_error of this PublicationValidationError.
        :rtype: str
        """
        return self._not_allow_to_bundle_error

    @not_allow_to_bundle_error.setter
    def not_allow_to_bundle_error(self, not_allow_to_bundle_error):
        """
        Sets the not_allow_to_bundle_error of this PublicationValidationError.
        

        :param not_allow_to_bundle_error: The not_allow_to_bundle_error of this PublicationValidationError.
        :type: str
        """

        self._not_allow_to_bundle_error = not_allow_to_bundle_error

    @property
    def license_compatibility_error(self):
        """
        Gets the license_compatibility_error of this PublicationValidationError.
        

        :return: The license_compatibility_error of this PublicationValidationError.
        :rtype: str
        """
        return self._license_compatibility_error

    @license_compatibility_error.setter
    def license_compatibility_error(self, license_compatibility_error):
        """
        Sets the license_compatibility_error of this PublicationValidationError.
        

        :param license_compatibility_error: The license_compatibility_error of this PublicationValidationError.
        :type: str
        """

        self._license_compatibility_error = license_compatibility_error

    @property
    def draft_version_dependency_error(self):
        """
        Gets the draft_version_dependency_error of this PublicationValidationError.
        

        :return: The draft_version_dependency_error of this PublicationValidationError.
        :rtype: str
        """
        return self._draft_version_dependency_error

    @draft_version_dependency_error.setter
    def draft_version_dependency_error(self, draft_version_dependency_error):
        """
        Sets the draft_version_dependency_error of this PublicationValidationError.
        

        :param draft_version_dependency_error: The draft_version_dependency_error of this PublicationValidationError.
        :type: str
        """

        self._draft_version_dependency_error = draft_version_dependency_error

    @property
    def version_not_published_error(self):
        """
        Gets the version_not_published_error of this PublicationValidationError.
        

        :return: The version_not_published_error of this PublicationValidationError.
        :rtype: str
        """
        return self._version_not_published_error

    @version_not_published_error.setter
    def version_not_published_error(self, version_not_published_error):
        """
        Sets the version_not_published_error of this PublicationValidationError.
        

        :param version_not_published_error: The version_not_published_error of this PublicationValidationError.
        :type: str
        """

        self._version_not_published_error = version_not_published_error

    @property
    def downstream_publication_license_error(self):
        """
        Gets the downstream_publication_license_error of this PublicationValidationError.
        

        :return: The downstream_publication_license_error of this PublicationValidationError.
        :rtype: list[str]
        """
        return self._downstream_publication_license_error

    @downstream_publication_license_error.setter
    def downstream_publication_license_error(self, downstream_publication_license_error):
        """
        Sets the downstream_publication_license_error of this PublicationValidationError.
        

        :param downstream_publication_license_error: The downstream_publication_license_error of this PublicationValidationError.
        :type: list[str]
        """

        self._downstream_publication_license_error = downstream_publication_license_error

    @property
    def version_validation_status_error(self):
        """
        Gets the version_validation_status_error of this PublicationValidationError.
        When version can not be published within a license due to its validation status

        :return: The version_validation_status_error of this PublicationValidationError.
        :rtype: str
        """
        return self._version_validation_status_error

    @version_validation_status_error.setter
    def version_validation_status_error(self, version_validation_status_error):
        """
        Sets the version_validation_status_error of this PublicationValidationError.
        When version can not be published within a license due to its validation status

        :param version_validation_status_error: The version_validation_status_error of this PublicationValidationError.
        :type: str
        """

        self._version_validation_status_error = version_validation_status_error

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
