# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class Publication(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, license_name=None, license_type=None, license_type_value=None, price=None, total_price=None, allow_listed=None, allow_bundled=None, allow_auto_add=None, upgrades=None, versions=None):
        """
        Publication - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'license_name': 'str',
            'license_type': 'str',
            'license_type_value': 'str',
            'price': 'float',
            'total_price': 'float',
            'allow_listed': 'bool',
            'allow_bundled': 'bool',
            'allow_auto_add': 'bool',
            'upgrades': 'str',
            'versions': 'list[PublicationVersion]'
        }

        self.attribute_map = {
            'license_name': 'license_name',
            'license_type': 'license_type',
            'license_type_value': 'license_type_value',
            'price': 'price',
            'total_price': 'total_price',
            'allow_listed': 'allow_listed',
            'allow_bundled': 'allow_bundled',
            'allow_auto_add': 'allow_auto_add',
            'upgrades': 'upgrades',
            'versions': 'versions'
        }

        self._license_name = license_name
        self._license_type = license_type
        self._license_type_value = license_type_value
        self._price = price
        self._total_price = total_price
        self._allow_listed = allow_listed
        self._allow_bundled = allow_bundled
        self._allow_auto_add = allow_auto_add
        self._upgrades = upgrades
        self._versions = versions

    @property
    def license_name(self):
        """
        Gets the license_name of this Publication.
        Name of User License

        :return: The license_name of this Publication.
        :rtype: str
        """
        return self._license_name

    @license_name.setter
    def license_name(self, license_name):
        """
        Sets the license_name of this Publication.
        Name of User License

        :param license_name: The license_name of this Publication.
        :type: str
        """

        self._license_name = license_name

    @property
    def license_type(self):
        """
        Gets the license_type of this Publication.
        type of license used in publication license

        :return: The license_type of this Publication.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this Publication.
        type of license used in publication license

        :param license_type: The license_type of this Publication.
        :type: str
        """

        self._license_type = license_type

    @property
    def license_type_value(self):
        """
        Gets the license_type_value of this Publication.
        Actual type of license used in publication license. ex. MIT/BSD, BCL or GPL.

        :return: The license_type_value of this Publication.
        :rtype: str
        """
        return self._license_type_value

    @license_type_value.setter
    def license_type_value(self, license_type_value):
        """
        Sets the license_type_value of this Publication.
        Actual type of license used in publication license. ex. MIT/BSD, BCL or GPL.

        :param license_type_value: The license_type_value of this Publication.
        :type: str
        """

        self._license_type_value = license_type_value

    @property
    def price(self):
        """
        Gets the price of this Publication.
        price of license

        :return: The price of this Publication.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this Publication.
        price of license

        :param price: The price of this Publication.
        :type: float
        """

        self._price = price

    @property
    def total_price(self):
        """
        Gets the total_price of this Publication.
        total price of license

        :return: The total_price of this Publication.
        :rtype: float
        """
        return self._total_price

    @total_price.setter
    def total_price(self, total_price):
        """
        Sets the total_price of this Publication.
        total price of license

        :param total_price: The total_price of this Publication.
        :type: float
        """

        self._total_price = total_price

    @property
    def allow_listed(self):
        """
        Gets the allow_listed of this Publication.
        to make license listed.

        :return: The allow_listed of this Publication.
        :rtype: bool
        """
        return self._allow_listed

    @allow_listed.setter
    def allow_listed(self, allow_listed):
        """
        Sets the allow_listed of this Publication.
        to make license listed.

        :param allow_listed: The allow_listed of this Publication.
        :type: bool
        """

        self._allow_listed = allow_listed

    @property
    def allow_bundled(self):
        """
        Gets the allow_bundled of this Publication.
        to make license allowed to bundled with other license.

        :return: The allow_bundled of this Publication.
        :rtype: bool
        """
        return self._allow_bundled

    @allow_bundled.setter
    def allow_bundled(self, allow_bundled):
        """
        Sets the allow_bundled of this Publication.
        to make license allowed to bundled with other license.

        :param allow_bundled: The allow_bundled of this Publication.
        :type: bool
        """

        self._allow_bundled = allow_bundled

    @property
    def allow_auto_add(self):
        """
        Gets the allow_auto_add of this Publication.
        to add new snapshot version automatically in license with this settings true.

        :return: The allow_auto_add of this Publication.
        :rtype: bool
        """
        return self._allow_auto_add

    @allow_auto_add.setter
    def allow_auto_add(self, allow_auto_add):
        """
        Sets the allow_auto_add of this Publication.
        to add new snapshot version automatically in license with this settings true.

        :param allow_auto_add: The allow_auto_add of this Publication.
        :type: bool
        """

        self._allow_auto_add = allow_auto_add

    @property
    def upgrades(self):
        """
        Gets the upgrades of this Publication.
        implementing license policy for upgrades.

        :return: The upgrades of this Publication.
        :rtype: str
        """
        return self._upgrades

    @upgrades.setter
    def upgrades(self, upgrades):
        """
        Sets the upgrades of this Publication.
        implementing license policy for upgrades.

        :param upgrades: The upgrades of this Publication.
        :type: str
        """

        self._upgrades = upgrades

    @property
    def versions(self):
        """
        Gets the versions of this Publication.
        version that will be published under this licenses.

        :return: The versions of this Publication.
        :rtype: list[PublicationVersion]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """
        Sets the versions of this Publication.
        version that will be published under this licenses.

        :param versions: The versions of this Publication.
        :type: list[PublicationVersion]
        """

        self._versions = versions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
