# coding: utf-8

"""
    Swagger Blended Hub API Explorer

    A collection of Swagger documentation for the Blended Hub APIs.

    OpenAPI spec version: 1.0.0
    Contact: api@blended.co
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class PendingUser(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, email=None, user=None, role=None, profile_picture=None):
        """
        PendingUser - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email': 'str',
            'user': 'str',
            'role': 'str',
            'profile_picture': 'str'
        }

        self.attribute_map = {
            'email': 'email',
            'user': 'user',
            'role': 'role',
            'profile_picture': 'profile_picture'
        }

        self._email = email
        self._user = user
        self._role = role
        self._profile_picture = profile_picture

    @property
    def email(self):
        """
        Gets the email of this PendingUser.
        email id of user.

        :return: The email of this PendingUser.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this PendingUser.
        email id of user.

        :param email: The email of this PendingUser.
        :type: str
        """

        self._email = email

    @property
    def user(self):
        """
        Gets the user of this PendingUser.
        user_name of user.

        :return: The user of this PendingUser.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this PendingUser.
        user_name of user.

        :param user: The user of this PendingUser.
        :type: str
        """

        self._user = user

    @property
    def role(self):
        """
        Gets the role of this PendingUser.
        user_name of user.

        :return: The role of this PendingUser.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this PendingUser.
        user_name of user.

        :param role: The role of this PendingUser.
        :type: str
        """

        self._role = role

    @property
    def profile_picture(self):
        """
        Gets the profile_picture of this PendingUser.
        if profile picture available it will have url else null

        :return: The profile_picture of this PendingUser.
        :rtype: str
        """
        return self._profile_picture

    @profile_picture.setter
    def profile_picture(self, profile_picture):
        """
        Sets the profile_picture of this PendingUser.
        if profile picture available it will have url else null

        :param profile_picture: The profile_picture of this PendingUser.
        :type: str
        """

        self._profile_picture = profile_picture

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
